/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql.pool;

import coldfusion.server.j2ee.pool.ObjectPool;
import coldfusion.server.j2ee.pool.PoolManager;
import coldfusion.server.j2ee.pool.PoolMetaData;
import coldfusion.server.j2ee.sql.JRunDataSource;
import coldfusion.server.j2ee.sql.pool.JDBCPool;
import coldfusion.util.RB;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;

public class JDBCManager
extends PoolManager {
    private static JDBCManager myself = new JDBCManager();

    public static JDBCManager getInstance() {
        return myself;
    }

    private JDBCManager() {
    }

    public JDBCPool createPool(PoolMetaData metad) {
        JDBCPool jpool = new JDBCPool(metad);
        this.addPool(metad.getName(), jpool);
        return jpool;
    }

    public ObjectPool getPoolByJNDIName(String name) {
        Enumeration enumeration = this.getPools();
        while (enumeration.hasMoreElements()) {
            JDBCPool jpool = (JDBCPool)enumeration.nextElement();
            try {
                JRunDataSource ds = (JRunDataSource)jpool.getDataSource();
                if (!ds.getJNDIName().equals(name)) continue;
                return jpool;
            }
            catch (Exception exception) {
            }
        }
        throw new NullPointerException(RB.getString(JDBCManager.class, "JDBCManager.jndiLookupError", (Object)name));
    }

    public void checkCredentials(String dbname, String user, String passwd) throws SQLException {
        JDBCPool pool = (JDBCPool)this.getPool(dbname);
    }

    public Connection requestConnection() throws SQLException {
        try {
            JDBCPool pool = (JDBCPool)this.getPool(null);
            return pool.requestConnection();
        }
        catch (NullPointerException ne) {
            throw new SQLException(RB.getString(JDBCManager.class, "JDBCManager.noDefaultPool"));
        }
    }

    public Connection requestConnection(String dbname, String username, String password) throws SQLException {
        JDBCPool pool;
        if (dbname == null || dbname.equals("")) {
            try {
                JDBCPool pool2 = (JDBCPool)this.getPool(null);
                return pool2.requestConnection(username, password);
            }
            catch (NullPointerException ne) {
                throw new SQLException(RB.getString(JDBCManager.class, "JDBCManager.noDefaultPool"));
            }
        }
        try {
            pool = (JDBCPool)this.getPool(dbname);
        }
        catch (NullPointerException nullPointerException) {
            throw new SQLException(RB.getString(JDBCManager.class, "JDBCManager.noSuchPool", (Object)dbname));
        }
        Connection conn = username == null || password == null ? pool.requestConnection() : pool.requestConnection(username, password);
        return conn;
    }

    public Connection requestConnection(String dbname) throws SQLException {
        return this.requestConnection(dbname, null, null);
    }

    public void returnConnection(Connection con) {
        try {
            con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void returnConnection(String dbname, Connection con) {
        this.returnConnection(con);
    }

    public static void closeResources(Statement statement, ResultSet resultSet) {
        JDBCManager.closeResultSet(resultSet);
        JDBCManager.closeStatement(statement);
    }

    public void collectResources(Statement s, ResultSet r) {
        JDBCManager.closeResources(s, r);
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            rs = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public Object removePool(String id) {
        JDBCPool pool = (JDBCPool)super.removePool(id);
        if (pool != null) {
            pool.destroy();
        }
        return pool;
    }

    public Object clearPools() {
        Enumeration e = super.getAllPoolnames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.removePool(key);
        }
        return null;
    }

    public Object closeConnections(String dbdriverType) throws SQLException {
        Enumeration e = super.getAllPoolnames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            JDBCPool pool = (JDBCPool)super.getPool(key);
            String url = pool.getJDBCPoolMetaData().getURL();
            if (!url.contains(dbdriverType)) continue;
            pool.closeAllResources();
        }
        return null;
    }
}

