/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.jrun4.metrics;

import coldfusion.CfmServlet;
import coldfusion.server.ConfigMap;
import coldfusion.server.Metric;
import coldfusion.server.MetricsService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.jrun4.metrics.CfstatServer;
import coldfusion.server.jrun4.metrics.PerfmonClientImpl;
import coldfusion.server.jrun4.metrics.SimpleLoadMetric;
import coldfusion.server.jrun4.metrics.TomcatMetricsImpl;
import coldfusion.server.tomcat.metrics.Metrics;
import coldfusion.server.tomcat.metrics.RequestTimingInfo;
import coldfusion.server.tomcat.metrics.TomcatMetrics;
import coldfusion.util.CaseInsensitiveHashtable;
import coldfusion.xml.rpc.CFCServlet;
import java.io.File;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class MetricsServiceImpl
extends ServiceBase
implements MetricsService {
    private TomcatMetrics metrics;
    private HashMap metricsMap;
    private HashMap<String, String> cfToTomcat;
    private int dbHitsIndex;
    private int avgDBTimeIndex;
    private int reqTimedoutIndex;
    private int avgDBTime = 0;
    private SimpleLoadMetric simpleLoad;
    private File configFile;
    private ConfigMap config;
    private int timingWindow;
    private int sampleRate;
    private int sampleSize;
    private int constLoad;
    private int maxRequests;
    private CfstatServer cfstat;
    private PerfmonClientImpl perfmon;
    private TomcatMetricsImpl tomcatmetrics;
    private boolean perfmonEnabled;
    private boolean metricsEnabled = false;
    private boolean cfstatEnabled;
    private int cfstatport;
    private String cfstatHost = "127.0.0.1";
    private int cfconnectorPort;

    public MetricsServiceImpl(File configFile, TomcatMetrics metrics) throws Exception {
        this.configFile = configFile;
        this.metrics = metrics;
        this.simpleLoad = new SimpleLoadMetric(metrics);
        this.cfstat = new CfstatServer();
        this.perfmon = new PerfmonClientImpl(configFile);
        this.tomcatmetrics = new TomcatMetricsImpl(configFile);
    }

    @Override
    public void updateMetric(String metricName, int delta) {
        if (metricName.equals("DBHits")) {
            this.metrics.updateMetric("DBHits", 1);
            this.metrics.updateMetric("AvgDBTime", (delta + this.avgDBTime) / 2 - this.avgDBTime);
        } else if (metricName.equals("errorCount")) {
            this.metrics.updateMetric("errorCount", delta);
        }
    }

    @Override
    public Object getMetric(String metricName) {
        Object o = this.metricsMap.get(metricName);
        if (o instanceof Metric) {
            return ((Metric)o).getMetricValue();
        }
        return this.metricsMap.get(metricName);
    }

    @Override
    public Hashtable getPerfmonMetrics() {
        CaseInsensitiveHashtable perfCounter = new CaseInsensitiveHashtable();
        ((Hashtable)perfCounter).put("InstanceName", "cfserver");
        Map<String, Object> snapshot = this.metrics.getSnapshot(true);
        this.addPerfmonCounters(perfCounter, snapshot);
        return perfCounter;
    }

    @Override
    public Hashtable getSnapshot() {
        Hashtable snapshot = this.getPerfmonMetrics();
        snapshot.put("SnapshotTime", Long.toString(this.metrics.getSnapshotTime()));
        return snapshot;
    }

    @Override
    public void start() throws ServiceException {
        try {
            super.start();
            this.config.setUnchanged();
            this.config.setConfigMapListener(this);
            this.setSettings(this.config);
            this.metrics.setPort(this.cfconnectorPort);
            this.metrics.init();
            this.fillMetricsMap();
            this.simpleLoad.start();
            if (this.cfstatEnabled) {
                this.cfstat.setCfstatport(this.cfstatport);
                this.cfstat.setCfstatInetAddr(this.cfstatHost);
                if (!this.cfstat.getState().name().equals("RUNNABLE") && !this.cfstat.getState().name().equals("TERMINATED")) {
                    this.cfstat.start();
                }
            }
            if (this.perfmonEnabled && System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
                this.perfmon.start();
            }
            if (this.metricsEnabled) {
                this.tomcatmetrics.start(this.metrics);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ServiceException) {
                throw (ServiceException)ex;
            }
            throw new ServiceException(ex);
        }
    }

    @Override
    public void stop() throws ServiceException {
        this.simpleLoad.stop();
        if (this.cfstatEnabled) {
            this.cfstat.stopServer();
        }
        if (this.perfmonEnabled && System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            this.perfmon.stop();
        }
        if (this.metricsEnabled) {
            this.tomcatmetrics.stop();
        }
        super.stop();
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.config = (ConfigMap)this.deserialize(this.configFile);
            if (this.perfmonEnabled && System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
                this.perfmon.load();
            }
            if (this.metricsEnabled) {
                this.tomcatmetrics.load();
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.config, this.configFile);
        this.config.setUnchanged();
    }

    @Override
    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadCast) throws ServiceException {
        this.serialize(this.config, this.configFile, broadCast, key, value, oldValue);
        this.config.setUnchanged();
    }

    private void fillMetricsMap() {
        this.cfToTomcat = new HashMap();
        this.cfToTomcat.put("ReqQueued", "currentThreadCount");
        this.cfToTomcat.put("ReqRunning", "currentThreadsBusy");
        this.cfToTomcat.put("BytesIn", "bytesReceived");
        this.cfToTomcat.put("BytesOut", "bytesSent");
        this.cfToTomcat.put("PageHits", "requestCount");
        this.metricsMap = new HashMap();
        this.metricsMap.put(this.simpleLoad.getMetricName(), this.simpleLoad);
        this.metricsMap.put("PageHits", new DefaultNeoMetric("PageHits", "requestCount", this.metrics));
        this.metricsMap.put("ReqQueued", new DefaultNeoMetric("ReqQueued", "currentThreadCount", this.metrics));
        this.metricsMap.put("ReqRunning", new DefaultNeoMetric("ReqRunning", "currentThreadsBusy", this.metrics));
        this.metrics.createMetric("errorCount");
        this.metricsMap.put("errorCount", new DefaultNeoMetric("errorCount", null, this.metrics));
        this.metrics.createMetric("DBHits");
        this.metricsMap.put("DBHits", new DefaultNeoMetric("DBHits", null, this.metrics));
        this.metricsMap.put("BytesIn", new DefaultNeoMetric("BytesIn", "bytesReceived", this.metrics));
        this.metricsMap.put("BytesOut", new DefaultNeoMetric("BytesOut", "bytesSent", this.metrics));
        this.metricsMap.put("AvgQueueTime", new DefaultNeoMetric("AvgQueueTime", null, this.metrics));
        this.metricsMap.put("AvgReqTime", new DefaultNeoMetric("AvgReqTime", null, this.metrics));
        this.metrics.createMetric("AvgDBTime");
        this.metricsMap.put("AvgDBTime", new DefaultNeoMetric("AvgDBTime", null, this.metrics));
        this.metricsMap.put("PREV_REQ_TIME", new DefaultNeoMetric("PREV_REQ_TIME", null, this.metrics));
        this.metricsMap.put("AVG_REQ_TIME", new AvgReqTimeMetric(this.metrics, this.timingWindow));
        this.metricsMap.put("PREV_REQ_TIME", new PrevReqTimeMetric(this.metrics));
    }

    private String getMetricFromSnapshot(String metric, Map<String, Object> snapshot) {
        String metricName = this.cfToTomcat.containsKey(metric) ? this.cfToTomcat.get(metric).toString() : metric;
        Object value = snapshot.get(metricName);
        if (value == null) {
            return "0";
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value);
        }
        return (String)value;
    }

    private void addPerfmonCounters(Hashtable container, Map<String, Object> snapshot) {
        container.put("PageHits", this.getMetricFromSnapshot("PageHits", snapshot));
        container.put("DBHits", this.getMetricFromSnapshot("DBHits", snapshot));
        container.put("BytesIn", this.getMetricFromSnapshot("BytesIn", snapshot));
        container.put("BytesOut", this.getMetricFromSnapshot("BytesOut", snapshot));
        container.put("AvgQueueTime", this.getMetricFromSnapshot("AvgQueueTime", snapshot));
        container.put("AvgDBTime", this.getMetricFromSnapshot("AvgDBTime", snapshot));
        container.put("AvgReqTime", this.getMetricFromSnapshot("AvgReqTime", snapshot));
        if (ServiceFactory.getLicenseService().isStandard()) {
            container.put("ReqQueued", this.getMetricFromSnapshot("ReqQueued", snapshot));
            container.put("ReqRunning", this.getMetricFromSnapshot("ReqRunning", snapshot));
            container.put("errorCount", this.getMetricFromSnapshot("errorCount", snapshot));
        } else {
            CfmServlet.waitTillServletInitialized();
            CfmServlet cfmServlet = CfmServlet.getCfmServlet();
            int requestsQueued = cfmServlet.getRequestsQueued();
            container.put("TemplateReqRunning", Integer.toString(cfmServlet.getRequestsRunning()));
            container.put("TemplateReqQueued", Integer.toString(requestsQueued));
            container.put("TemplateReqTimedOut", Integer.toString(cfmServlet.getRequestsTimedout()));
            CFCServlet.waitTillServletInitialized();
            CFCServlet cfcServlet = CFCServlet.getCFCServlet();
            int cfcQueued = cfcServlet.getCFCRequestsQueued();
            container.put("CfcReqRunning", Integer.toString(cfcServlet.getCFCRequestsRunning()));
            container.put("CfcReqQueued", Integer.toString(cfcQueued));
            container.put("CfcReqTimedOut", Integer.toString(cfcServlet.getCFCRequestsTimedout()));
            int webServiceQueued = cfcServlet.getWebServiceRequestsQueued();
            container.put("WsReqRunning", Integer.toString(cfcServlet.getWebServiceRequestsRunning()));
            container.put("WsReqQueued", Integer.toString(webServiceQueued));
            container.put("WsReqTimedOut", Integer.toString(cfcServlet.getWebServiceRequestsTimedout()));
            int tomcatTotalThreadCount = Integer.parseInt(this.getMetricFromSnapshot("currentThreadCount", snapshot));
            int tomcatBusyThreads = Integer.parseInt(this.getMetricFromSnapshot("currentThreadsBusy", snapshot));
            int minSpareThreads = Integer.parseInt(this.getMetricFromSnapshot("minSpareThreads", snapshot));
            int tomcatSpareThreads = tomcatTotalThreadCount - tomcatBusyThreads;
            int tomcatQueued = 0;
            tomcatQueued = tomcatTotalThreadCount <= minSpareThreads ? 0 : tomcatSpareThreads;
            int totalQueued = tomcatQueued + requestsQueued + webServiceQueued + cfcQueued;
            container.put("ReqQueued", Integer.toString(totalQueued));
            int totalRunning = tomcatBusyThreads - (requestsQueued + webServiceQueued + cfcQueued);
            if (totalRunning < 0) {
                totalRunning = 0;
            }
            container.put("ReqRunning", Integer.toString(totalRunning));
            container.put("errorCount", this.getMetricFromSnapshot("errorCount", snapshot));
        }
    }

    public void setSettings(Map settings) {
        if (this.config.get("cfstatport") != null) {
            this.cfstatport = Integer.parseInt(this.config.get("cfstatport").toString());
        }
        if (this.config.get("cfstathost") != null) {
            this.cfstatHost = this.config.get("cfstatHost").toString();
        }
        if (this.config.get("cfconnectorport") != null) {
            this.cfconnectorPort = Integer.parseInt(this.config.get("cfconnectorport").toString());
        }
        this.cfstatEnabled = Boolean.valueOf(this.config.get("cfstat").toString());
        this.perfmonEnabled = Boolean.valueOf(this.config.get("cfperfmon").toString());
        Object cfmet = this.config.get("cfmetrics");
        if (cfmet != null) {
            this.metricsEnabled = Boolean.valueOf(cfmet.toString());
        }
        this.timingWindow = Integer.parseInt(this.config.get("reqTimingWindow").toString());
        this.maxRequests = Integer.parseInt(this.config.get("simpleLoad.maxRequests").toString());
        this.simpleLoad.setMaxRequests(this.maxRequests);
        this.sampleRate = Integer.parseInt(this.config.get("simpleLoad.sampleRate").toString());
        this.simpleLoad.setSampleRate(this.sampleRate);
        this.sampleSize = Integer.parseInt(this.config.get("simpleLoad.sampleSize").toString());
        this.simpleLoad.setSampleSize(this.sampleSize);
        this.constLoad = Integer.parseInt(this.config.get("simpleLoad.constLoad").toString());
        this.simpleLoad.setConstLoad(this.constLoad);
    }

    public Map getSettings() {
        return this.config;
    }

    @Override
    public void setMetricsFrequency(int val) {
        try {
            if (!this.metricsEnabled && val > 0) {
                this.config.put("cfmetrics.pullfreq", (Object)val);
            } else if (this.metricsEnabled && val > 0) {
                this.config.put("cfmetrics.pullfreq", (Object)val);
                this.tomcatmetrics.stop();
                this.tomcatmetrics.start(this.metrics);
            }
        }
        catch (Exception ex) {
            this.info(ex.getMessage());
        }
    }

    @Override
    public int getMetricsFrequency() {
        if (this.config.get("cfmetrics.pullfreq") != null) {
            return (int)Double.parseDouble(this.config.get("cfmetrics.pullfreq").toString());
        }
        return 0;
    }

    @Override
    public void setMetricsEnabled(boolean enable) {
        try {
            if (!this.metricsEnabled && enable) {
                this.config.put("cfmetrics", (Object)"true");
                this.tomcatmetrics.start(this.metrics);
            } else if (this.metricsEnabled && !enable) {
                this.tomcatmetrics.stop();
                this.config.put("cfmetrics", (Object)"false");
            }
        }
        catch (Exception ex) {
            this.info(ex.getMessage());
        }
        this.metricsEnabled = enable;
    }

    public void setPerfmonEnabled(boolean enable) {
        try {
            boolean isBill = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
            if (!this.perfmonEnabled && enable && isBill) {
                this.config.put("cfperfmon", (Object)"true");
                this.perfmon.start();
            } else if (this.perfmonEnabled && !enable && isBill) {
                this.perfmon.stop();
                this.config.put("cfperfmon", (Object)"false");
            }
        }
        catch (Exception ex) {
            this.info(ex.getMessage());
        }
        this.perfmonEnabled = enable;
    }

    @Override
    public void setCfstatEnabled(boolean enable) {
        try {
            if (!this.cfstatEnabled && enable) {
                this.config.put("cfstat", (Object)"true");
                this.cfstat.start();
            } else if (this.cfstatEnabled && !enable) {
                this.cfstat.stopServer();
                this.config.put("cfstat", (Object)"false");
            }
        }
        catch (Exception ex) {
            this.info(ex.getMessage());
        }
        this.cfstatEnabled = enable;
    }

    public void setCfstatport(int cfstatport) {
        this.cfstatport = cfstatport;
        this.cfstat.setCfstatport(cfstatport);
        this.config.put("cfstatport", (Object)Integer.toString(cfstatport));
    }

    @Override
    public boolean setCfstatHost(String host) throws UnknownHostException {
        this.cfstatHost = host;
        this.config.put("cfstatHost", (Object)host);
        return this.cfstat.setCfstatInetAddr(host);
    }

    @Override
    public String getCfstatHost() {
        return this.cfstatHost;
    }

    public void setCFConnectorPort(int cfport) {
        this.cfconnectorPort = cfport;
        this.config.put("cfconnectorport", (Object)Integer.toString(cfport));
    }

    public void setMaxRequests(int maxReq) {
        this.maxRequests = maxReq;
        this.simpleLoad.setMaxRequests(maxReq);
        this.config.put("simpleLoad.maxRequests", (Object)new Integer(maxReq));
    }

    public void setReqTimingWindow(int seconds) {
        this.timingWindow = seconds;
        RequestTimingInfo info = this.metrics.getRequestTimingInfo();
        info.setReqTimingWindow(seconds);
        this.config.put("reqTimingWindow", (Object)new Integer(seconds));
    }

    public void setSampleSize(int size) {
        this.sampleSize = size;
        this.simpleLoad.setSampleSize(size);
        this.config.put("simpleLoad.sampleSize", (Object)new Integer(size));
    }

    public void setSampleRate(int rate) {
        this.sampleRate = rate;
        this.simpleLoad.setSampleRate(rate);
        this.config.put("simpleLoad.sampleRate", (Object)new Integer(rate));
    }

    public boolean getPerfmonEnabled() {
        return this.perfmonEnabled;
    }

    @Override
    public boolean getMetricsEnabled() {
        return this.metricsEnabled;
    }

    @Override
    public boolean getCfstatEnabled() {
        return this.cfstatEnabled;
    }

    public int getCFConnectorPort() {
        return this.cfconnectorPort;
    }

    public int getReqTimingWindow() {
        return this.timingWindow;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    class DefaultNeoMetric
    implements Metric {
        private String neoName;
        private String tcName;
        private String indexName;
        private int index = -2;
        private Metrics mm;

        DefaultNeoMetric(String neoName, String jrunName, Metrics mm) {
            this.neoName = neoName;
            this.tcName = jrunName;
            this.mm = mm;
            this.indexName = jrunName == null ? neoName : jrunName;
        }

        @Override
        public String getMetricName() {
            return this.neoName;
        }

        @Override
        public Object getMetricValue() {
            return this.mm.getMetrics().get(this.indexName);
        }
    }

    class AvgReqTimeMetric
    implements Metric {
        private RequestTimingInfo timingInfo;

        public AvgReqTimeMetric(TomcatMetrics mm, int window) {
            this.timingInfo = mm.getRequestTimingInfo();
            this.timingInfo.setReqTimingWindow(window);
        }

        @Override
        public String getMetricName() {
            return "AVG_REQ_TIME";
        }

        @Override
        public Object getMetricValue() {
            return this.timingInfo.getAvgReqTime();
        }
    }

    class PrevReqTimeMetric
    implements Metric {
        private RequestTimingInfo timingInfo;

        public PrevReqTimeMetric(TomcatMetrics mm) {
            this.timingInfo = mm.getRequestTimingInfo();
        }

        @Override
        public String getMetricName() {
            return "PREV_REQ_TIME";
        }

        @Override
        public Object getMetricValue() {
            return (int)this.timingInfo.getPrevReqTime();
        }
    }
}

