/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.jrun4.metrics;

import coldfusion.server.CFService;
import coldfusion.server.ConfigMap;
import coldfusion.server.MetricsService;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.LibMissingException;
import java.io.File;
import java.util.Hashtable;

public final class PerfmonClientImpl
extends ServiceBase
implements Runnable {
    private ConfigMap config;
    private File configFile;
    private long schedule_time;

    public PerfmonClientImpl(File configFile) {
        this.configFile = configFile;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        try {
            this.setSchedule(((Number)this.config.get("cfperfmon.pullfreq")).intValue());
            SchedulerService ss = ServiceFactory.getSchedulerService();
            ss.cancel(this);
            ss.schedule(this, System.currentTimeMillis() + this.getSchedule());
            this.initialization();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void stop() throws ServiceException {
        try {
            this.cleanUp();
            SchedulerService ss = ServiceFactory.getSchedulerService();
            ss.cancel(this);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.config = (ConfigMap)this.deserialize(this.configFile);
            this.setSchedule(((Number)this.config.get("cfperfmon.pullfreq")).intValue());
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    private synchronized long getSchedule() {
        return this.schedule_time;
    }

    private synchronized void setSchedule(int sched) {
        this.schedule_time = sched * 1000;
    }

    @Override
    public void run() {
        Hashtable data;
        MetricsService ms = ServiceFactory.getMetricsService();
        if (ms != null && (data = ms.getPerfmonMetrics()) != null && !data.isEmpty()) {
            this.setClientData("PageHits", Long.parseLong((String)data.get("PageHits")));
            this.setClientData("ReqQueued", Long.parseLong((String)data.get("ReqQueued")));
            this.setClientData("DBHits", Long.parseLong((String)data.get("DBHits")));
            this.setClientData("ReqRunning", Long.parseLong((String)data.get("ReqRunning")));
            this.setClientData("errorCount", Long.parseLong((String)data.get("errorCount")));
            this.setClientData("BytesIn", Long.parseLong((String)data.get("BytesIn")));
            this.setClientData("BytesOut", Long.parseLong((String)data.get("BytesOut")));
            this.setClientData("AvgQueueTime", Long.parseLong((String)data.get("AvgQueueTime")));
            this.setClientData("AvgDBTime", Long.parseLong((String)data.get("AvgDBTime")));
            this.setClientData("AvgReqTime", Long.parseLong((String)data.get("AvgReqTime")));
        }
        SchedulerService ss = ServiceFactory.getSchedulerService();
        ss.schedule(this, System.currentTimeMillis() + this.getSchedule());
    }

    public void setClientData(String name, long value) {
        try {
            this.upDate(name, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public native void initialization() throws Exception;

    public native void cleanUp() throws Exception;

    public native void upDate(String var1, long var2) throws Exception;

    static {
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            try {
                System.load(CFService.getLibPath() + File.separator + "PerfmonClient.dll");
            }
            catch (Throwable tLibraryProblem) {
                throw new LibMissingException(tLibraryProblem.toString());
            }
        }
    }
}

