/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.jrun4.metrics;

import coldfusion.log.CFLogs;
import coldfusion.server.ConfigMap;
import coldfusion.server.MetricsService;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.tomcat.metrics.TomcatMetrics;
import java.io.File;
import java.util.Map;

public class TomcatMetricsImpl
extends ServiceBase
implements Runnable {
    private File configFile;
    private ConfigMap config;
    private long schedule_time;
    private TomcatMetrics tcmetrics;

    public TomcatMetricsImpl(File configFile) {
        this.configFile = configFile;
    }

    public void start(TomcatMetrics metrics) throws ServiceException {
        super.start();
        try {
            this.tcmetrics = metrics;
            this.setSchedule(((Number)this.config.get("cfmetrics.pullfreq")).intValue());
            SchedulerService ss = ServiceFactory.getSchedulerService();
            ss.cancel(this);
            ss.schedule(this, System.currentTimeMillis() + this.getSchedule());
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void stop() throws ServiceException {
        try {
            SchedulerService ss = ServiceFactory.getSchedulerService();
            ss.cancel(this);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.config = (ConfigMap)this.deserialize(this.configFile);
            this.setSchedule(((Number)this.config.get("cfmetrics.pullfreq")).intValue());
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    private synchronized long getSchedule() {
        return this.schedule_time;
    }

    private synchronized void setSchedule(int sched) {
        this.schedule_time = sched * 1000;
    }

    @Override
    public void run() {
        try {
            MetricsService ms = ServiceFactory.getMetricsService();
            if (ms != null) {
                this.tcmetrics.collectMetrics();
                Map<String, Object> data = this.tcmetrics.getMetrics();
                Map<String, Object> sessiondata = this.tcmetrics.getSessionMetrics();
                CFLogs.METRICS_LOG.info("Max threads: " + data.get("maxThreads") + " Current thread count: " + data.get("currentThreadCount") + " Current thread busy: " + data.get("currentThreadsBusy") + " Max processing time: " + data.get("processingTime") + " Request count: " + data.get("requestCount") + " Error count: " + data.get("errorCount") + " Bytes received: " + data.get("bytesReceived") + " Bytes sent: " + data.get("bytesSent") + " Free memory: " + Long.valueOf(Runtime.getRuntime().freeMemory()) + " Total memory: " + Long.valueOf(Runtime.getRuntime().totalMemory()) + " Active Sessions: " + sessiondata.get("activeSessions"));
            }
        }
        catch (Exception ms) {
            // empty catch block
        }
        SchedulerService ss = ServiceFactory.getSchedulerService();
        ss.schedule(this, System.currentTimeMillis() + this.getSchedule());
    }
}

