/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.tomcat;

import coldfusion.log.CFLogs;
import coldfusion.runtime.RealPathCache;
import coldfusion.runtime.RuntimeServiceImpl;
import com.adobe.coldfusion.launcher.ServerConfigParser;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.jasper.JasperException;
import org.apache.tomcat.util.modeler.Registry;

public class RuntimeHelper
extends RuntimeServiceImpl {
    private MBeanServer mBeanServer;
    private static final String SERVER_XML = "server.xml";
    private static final String configPath = System.getProperty("coldfusion.home") + "/runtime/conf/";

    public RuntimeHelper(File file, String neoRoot, String appServer, String context_root) {
        super(file, neoRoot, appServer, context_root);
    }

    public RuntimeHelper(File file, String neoRoot, boolean commandline) {
        super(file, neoRoot, commandline);
    }

    public RuntimeHelper(File file, String neoRoot, String workingDir, boolean commandline) {
        super(file, neoRoot, workingDir, commandline);
    }

    @Override
    public int getActiveHandlers() {
        ServerConfigParser parser = new ServerConfigParser(configPath + SERVER_XML);
        try {
            parser.parse();
            return parser.getMaxThreads();
        }
        catch (JasperException e) {
            if (System.getSecurityManager() == null) {
                return this._getActiveHandlers();
            }
            Integer Iobj = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return RuntimeHelper.this._getActiveHandlers();
                }
            });
            return Iobj;
        }
    }

    private int _getActiveHandlers() {
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        int activeHandler = 25;
        String onStr = "*:type=ThreadPool,*";
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance objectInstance : set) {
                ObjectName objName = objectInstance.getObjectName();
                activeHandler = (Integer)this.mBeanServer.getAttribute(objName, "maxThreads");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activeHandler;
    }

    @Override
    public void setActiveHandlers(final int activeHandlers) {
        if (System.getSecurityManager() == null) {
            this._setActiveHandlers(activeHandlers);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                RuntimeHelper.this._setActiveHandlers(activeHandlers);
                return null;
            }
        });
    }

    private void _setActiveHandlers(int activeHandlers) {
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        String onStr = "*:type=ThreadPool,*";
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            boolean isAttributeSet = false;
            for (ObjectInstance objectInstance : set) {
                ObjectName objName = objectInstance.getObjectName();
                Attribute attribute = new Attribute("maxThreads", activeHandlers);
                this.mBeanServer.setAttribute(objName, attribute);
                isAttributeSet = true;
            }
            if (isAttributeSet) {
                ServerConfigParser parser = new ServerConfigParser(configPath + SERVER_XML);
                parser.parse();
                parser.setMaxThreads(Integer.toString(activeHandlers));
                parser.store();
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    @Override
    public boolean isCachePaths() {
        return (Boolean)this.request_settings.get("cacheWebServerPath");
    }

    @Override
    public void setCachePaths(boolean b) {
        Boolean value = b;
        System.setProperty("cache.webserver.paths", value.toString());
        this.request_settings.put("cacheWebServerPath", (Object)value);
        if (!b) {
            RealPathCache.clearAll();
        }
    }
}

