/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.tomcat.metrics;

public class RequestTimingInfo {
    private TimingInfoEntry[] samples = new TimingInfoEntry[50];
    private int index = 0;
    private static final int SAMPLE_SIZE = 50;
    private long timingWindow;

    public synchronized void saveReqTimingInfo(long reqRuntime) {
        TimingInfoEntry entry;
        this.samples[this.index] = entry = new TimingInfoEntry(reqRuntime, System.currentTimeMillis());
        ++this.index;
        if (this.index >= 50) {
            this.index = 0;
        }
    }

    public void setReqTimingWindow(int seconds) {
        this.timingWindow = seconds * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgReqTime() {
        int i;
        int lastEntry;
        long timeLimit = System.currentTimeMillis() - this.timingWindow;
        TimingInfoEntry[] snapshot = new TimingInfoEntry[50];
        boolean done = false;
        int totalTime = 0;
        int totalReqs = 0;
        RequestTimingInfo requestTimingInfo = this;
        synchronized (requestTimingInfo) {
            System.arraycopy(this.samples, 0, snapshot, 0, 50);
            lastEntry = this.index == 0 ? 49 : this.index - 1;
        }
        for (i = lastEntry; !done && i >= 0 && snapshot[i] != null; --i) {
            if (snapshot[i].reqEndtime >= timeLimit) {
                totalTime = (int)((long)totalTime + snapshot[i].reqRuntime);
                ++totalReqs;
                continue;
            }
            done = true;
        }
        for (i = 49; !done && i > lastEntry && snapshot[i] != null; --i) {
            if (snapshot[i].reqEndtime >= timeLimit) {
                totalTime = (int)((long)totalTime + snapshot[i].reqRuntime);
                ++totalReqs;
                continue;
            }
            done = true;
        }
        return totalReqs > 0 ? totalTime / totalReqs : 0;
    }

    public long getPrevReqTime() {
        int lastEntry;
        int curIndex = this.index;
        int n = lastEntry = curIndex == 0 ? 49 : this.index - 1;
        if (lastEntry < 0 || lastEntry > 50 || this.samples[lastEntry] == null) {
            return 0L;
        }
        return this.samples[lastEntry].reqRuntime;
    }

    class TimingInfoEntry {
        public long reqRuntime;
        public long reqEndtime;

        public TimingInfoEntry(long reqRuntime, long reqEndtime) {
            this.reqRuntime = reqRuntime;
            this.reqEndtime = reqEndtime;
        }
    }
}

