/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.tomcat.metrics;

import coldfusion.server.tomcat.metrics.Metrics;
import coldfusion.server.tomcat.metrics.RequestTimingInfo;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.tomcat.util.modeler.Registry;

public class TomcatMetrics
extends Metrics
implements NotificationListener {
    long lastSnapshotTime;
    int port = 8002;
    public static final String METRIC_AVG_QUEUE_TIME = "AvgQueueTime";
    public static final String METRIC_AVG_REQ_TIME = "AvgReqTime";
    private RequestTimingInfo reqTiming;
    private int totalreq = 0;
    private long totaltime = 0L;
    private long preProcessingTime = 0L;
    private long delta = 0L;
    MBeanServer mBeanServer;
    protected Vector<ObjectName> protocolHandlers = new Vector();
    protected Vector<ObjectName> threadPools = new Vector();
    protected Vector<ObjectName> requestProcessors = new Vector();
    protected Vector<ObjectName> globalRequestProcessors = new Vector();
    protected Map<String, Object> metrics = new HashMap<String, Object>();
    protected Map<String, Object> sessionmetrics = new HashMap<String, Object>();
    protected Runtime rt = Runtime.getRuntime();

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void init() throws Exception {
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        this.getHandlers();
        this.lastSnapshotTime = System.currentTimeMillis();
        this.createMetric(METRIC_AVG_QUEUE_TIME);
        this.createMetric(METRIC_AVG_REQ_TIME);
        this.reqTiming = new RequestTimingInfo();
        this.collectMetrics();
    }

    private void getConnectorState(ObjectName tpName, String name) throws Exception {
        this.metrics.put("name", name);
        this.metrics.put("maxThreads", this.mBeanServer.getAttribute(tpName, "maxThreads"));
        this.metrics.put("currentThreadCount", this.mBeanServer.getAttribute(tpName, "currentThreadCount"));
        this.metrics.put("currentThreadsBusy", this.mBeanServer.getAttribute(tpName, "currentThreadsBusy"));
        this.metrics.put("minSpareThreads", this.mBeanServer.getAttribute(tpName, "minSpareThreads"));
        try {
            this.metrics.put("keepAliveCount", this.mBeanServer.getAttribute(tpName, "keepAliveCount"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjectName grpName = null;
        Enumeration<ObjectName> enumeration = this.globalRequestProcessors.elements();
        while (enumeration.hasMoreElements()) {
            ObjectName objectName = enumeration.nextElement();
            if (!name.equals(objectName.getKeyProperty("name"))) continue;
            grpName = objectName;
        }
        this.metrics.put("maxTime", this.mBeanServer.getAttribute(grpName, "maxTime"));
        Long processingTime = (Long)this.mBeanServer.getAttribute(grpName, "processingTime");
        this.metrics.put("requestCount", this.mBeanServer.getAttribute(grpName, "requestCount"));
        this.metrics.put("processingTime", processingTime);
        this.delta = this.preProcessingTime > 0L && processingTime >= this.preProcessingTime ? processingTime - this.preProcessingTime : processingTime;
        this.preProcessingTime = processingTime;
        this.updateMetric(METRIC_AVG_REQ_TIME, this.delta);
        this.metrics.put("errorCount", this.mBeanServer.getAttribute(grpName, "errorCount"));
        this.metrics.put("bytesReceived", this.mBeanServer.getAttribute(grpName, "bytesReceived"));
        this.metrics.put("bytesSent", this.mBeanServer.getAttribute(grpName, "bytesSent"));
    }

    protected void getHandlers() throws Exception {
        String onStr = "*:type=ProtocolHandler,*";
        ObjectName objectName = new ObjectName(onStr);
        Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
        for (ObjectInstance oi : set) {
            this.protocolHandlers.addElement(oi.getObjectName());
        }
        onStr = "*:type=ThreadPool,*";
        objectName = new ObjectName(onStr);
        set = this.mBeanServer.queryMBeans(objectName, null);
        for (ObjectInstance oi : set) {
            this.threadPools.addElement(oi.getObjectName());
        }
        onStr = "*:type=GlobalRequestProcessor,*";
        objectName = new ObjectName(onStr);
        set = this.mBeanServer.queryMBeans(objectName, null);
        for (ObjectInstance oi : set) {
            this.globalRequestProcessors.addElement(oi.getObjectName());
        }
        onStr = "*:type=RequestProcessor,*";
        objectName = new ObjectName(onStr);
        set = this.mBeanServer.queryMBeans(objectName, null);
        for (ObjectInstance oi : set) {
            this.requestProcessors.addElement(oi.getObjectName());
        }
        onStr = "JMImplementation:type=MBeanServerDelegate";
        objectName = new ObjectName(onStr);
        this.mBeanServer.addNotificationListener(objectName, this, null, null);
    }

    @Override
    public Object getMetric(String name) {
        return this.metrics.get(name);
    }

    public void collectMetrics() throws Exception {
        Enumeration<ObjectName> enumeration = this.threadPools.elements();
        while (enumeration.hasMoreElements()) {
            ObjectName objectName = enumeration.nextElement();
            String name = objectName.getKeyProperty("name");
            String subType = objectName.getKeyProperty("subType");
            if (!name.contains(Integer.toString(this.port)) || subType != null) continue;
            this.getConnectorState(objectName, name);
        }
        this.getSessionState();
    }

    private void getSessionState() throws Exception {
        Set<ObjectName> set = this.mBeanServer.queryNames(new ObjectName("Catalina:type=Manager,context=/,host=localhost"), null);
        Iterator<ObjectName> iterator = set.iterator();
        ObjectName on = null;
        while (iterator.hasNext()) {
            on = iterator.next();
        }
        if (on != null) {
            this.sessionmetrics.put("activeSessions", this.mBeanServer.getAttribute(on, "activeSessions"));
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    public Map<String, Object> getSessionMetrics() {
        return this.sessionmetrics;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            String type;
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            if (notification.getType().equals("JMX.mbean.registered")) {
                String type2 = objectName.getKeyProperty("type");
                if (type2 != null) {
                    if (type2.equals("ProtocolHandler")) {
                        this.protocolHandlers.addElement(objectName);
                    } else if (type2.equals("ThreadPool")) {
                        this.threadPools.addElement(objectName);
                    } else if (type2.equals("GlobalRequestProcessor")) {
                        this.globalRequestProcessors.addElement(objectName);
                    } else if (type2.equals("RequestProcessor")) {
                        this.requestProcessors.addElement(objectName);
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered") && (type = objectName.getKeyProperty("type")) != null) {
                if (type.equals("ProtocolHandler")) {
                    this.protocolHandlers.removeElement(objectName);
                } else if (type.equals("ThreadPool")) {
                    this.threadPools.removeElement(objectName);
                } else if (type.equals("GlobalRequestProcessor")) {
                    this.globalRequestProcessors.removeElement(objectName);
                } else if (type.equals("RequestProcessor")) {
                    this.requestProcessors.removeElement(objectName);
                }
            }
            try {
                this.collectMetrics();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void updateMetric(String name, Object value) {
        if (name.equalsIgnoreCase(METRIC_AVG_REQ_TIME)) {
            this.reqTiming.saveReqTimingInfo((Long)value);
            int currentThreadCount = 0;
            if ((Long)value > 0L) {
                this.totaltime += ((Long)value).longValue();
                currentThreadCount = (Integer)this.getMetric("requestCount");
            }
            if (this.totaltime > 0L && currentThreadCount > 0) {
                this.metrics.put(METRIC_AVG_REQ_TIME, this.totaltime / (long)currentThreadCount);
            }
        } else if (name.equalsIgnoreCase("avgQtime")) {
            this.metrics.put("avgQtime", ((Integer)this.metrics.get("avgQtime") + (Integer)value) / 2);
        } else if (this.metrics.containsKey(name)) {
            Object o = this.metrics.get(name);
            if (o instanceof Integer && value instanceof Integer) {
                int i = (Integer)o;
                this.metrics.put(name, i += ((Integer)value).intValue());
            } else if (o instanceof Long) {
                long i = (Long)o;
                this.metrics.put(name, i += ((Long)value).longValue());
            } else {
                this.metrics.put(name, value);
            }
        } else {
            this.metrics.put(name, value);
        }
    }

    @Override
    public Map<String, Object> getSnapshot() {
        return this.getSnapshot(false);
    }

    @Override
    public Map<String, Object> getSnapshot(boolean reset) {
        if (!this.metrics.containsKey("freeMemory")) {
            this.createMetric("freeMemory");
        }
        if (!this.metrics.containsKey("totalMemory")) {
            this.createMetric("totalMemory");
        }
        this.updateMetric("freeMemory", (int)(this.rt.freeMemory() >> 10));
        this.updateMetric("totalMemory", (int)(this.rt.totalMemory() >> 10));
        this.lastSnapshotTime = System.currentTimeMillis();
        if (reset) {
            try {
                this.collectMetrics();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.metrics;
    }

    @Override
    public long getSnapshotTime() {
        return this.lastSnapshotTime;
    }

    @Override
    public void createMetric(String name) {
        this.getMetrics().put(name, null);
    }

    public RequestTimingInfo getRequestTimingInfo() {
        return this.reqTiming;
    }
}

