/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.serverless;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class InMemoryFile
extends File {
    private static final long serialVersionUID = 1L;
    byte[] contents;
    File file;

    public InMemoryFile(String pathname, File file) {
        super(pathname);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public int size() {
        return this.contents.length > 0 ? this.contents.length : 0;
    }

    public byte[] read() {
        return this.contents;
    }

    public synchronized void write(byte[] src) {
        this.contents = Arrays.copyOf(src, src.length);
    }

    @Override
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public File getParentFile() {
        return this.file.getParentFile();
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public File getAbsoluteFile() {
        return this.file.getAbsoluteFile();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this.file.getCanonicalFile();
    }
}

