/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import java.sql.ResultSet;
import java.sql.SQLException;

public class ColumnMetaData {
    private String name;
    private int columnSize;
    private int decimalDigits;
    private String isNullable;
    private int sqlType;
    private String typeName;
    private String colDefaultVal;
    private boolean isPK;
    private String tableName;

    public ColumnMetaData(ResultSet rs) throws SQLException {
        this.name = rs.getString("COLUMN_NAME");
        this.columnSize = rs.getInt("COLUMN_SIZE");
        this.decimalDigits = rs.getInt("DECIMAL_DIGITS");
        this.isNullable = rs.getString("IS_NULLABLE");
        this.sqlType = rs.getInt("DATA_TYPE");
        this.typeName = rs.getString("TYPE_NAME");
        this.colDefaultVal = rs.getString("COLUMN_DEF");
        this.tableName = rs.getString("TABLE_NAME");
    }

    public String getName() {
        return this.name;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getNullable() {
        return this.isNullable;
    }

    public boolean isNullable() {
        return this.isNullable != null && this.isNullable.equalsIgnoreCase("YES");
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getColDefaultVal() {
        return this.colDefaultVal;
    }

    public void setPK(boolean pk) {
        this.isPK = pk;
    }

    public boolean isPK() {
        return this.isPK;
    }

    public String getTableName() {
        return this.tableName;
    }
}

