/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.sql.DataSrcImpl;
import coldfusion.sql.TableMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DBMetaData {
    private Connection connection;
    private boolean internalConnection;
    private Map<String, TableMetaData> tables;
    private DatabaseMetaData meta;
    private static String[] TYPES = new String[]{"TABLE", "VIEW", "SYNONYM"};
    private String dbName;

    public DBMetaData(String datasource) throws SQLException {
        this(datasource, null, null);
    }

    public DBMetaData(String datasource, String userName, String password) throws SQLException {
        DataSrcImpl dsImpl = new DataSrcImpl();
        dsImpl.setDatasrc(datasource);
        dsImpl.validate();
        this.connection = userName == null ? dsImpl.getConnection() : dsImpl.getConnection(userName, password);
        this.internalConnection = true;
        this.init();
    }

    public DBMetaData(Connection conn) throws SQLException {
        this.connection = conn;
        this.init();
    }

    private void init() throws SQLException {
        this.meta = this.connection.getMetaData();
        this.tables = new HashMap<String, TableMetaData>();
        this.dbName = this.meta.getDatabaseProductName();
    }

    public DatabaseMetaData getDatabaseMetaData() {
        return this.meta;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetaData getTableMetaData(String tableName, String schema, String catalog) throws SQLException {
        String qualifiedName = this.getQualifiedName(tableName, schema, catalog);
        TableMetaData table = this.tables.get(qualifiedName);
        if (table != null) {
            return table;
        }
        catalog = this.getCaseInsensitiveName(catalog);
        schema = this.getCaseInsensitiveName(schema);
        tableName = this.getCaseInsensitiveName(tableName);
        try (ResultSet rs = this.meta.getTables(catalog, schema, tableName, TYPES);){
            while (rs.next()) {
                String dbtableName = rs.getString("TABLE_NAME");
                if (!tableName.equalsIgnoreCase(dbtableName)) continue;
                table = new TableMetaData(rs, this.meta);
                this.tables.put(qualifiedName, table);
                TableMetaData tableMetaData = table;
                return tableMetaData;
            }
        }
        return null;
    }

    private String getQualifiedName(String tableName, String schema, String catalog) {
        StringBuilder builder = new StringBuilder();
        if (catalog != null) {
            builder.append(catalog).append('.');
        }
        if (schema != null) {
            builder.append(schema).append('.');
        }
        builder.append(tableName);
        return builder.toString();
    }

    private String getCaseInsensitiveName(String name) throws SQLException {
        if (name == null) {
            return null;
        }
        if (this.meta.storesLowerCaseIdentifiers()) {
            return name.toLowerCase();
        }
        if (this.meta.storesUpperCaseIdentifiers()) {
            return name.toUpperCase();
        }
        return name;
    }

    public void close() {
        try {
            if (this.internalConnection) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

