/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.Cast;
import coldfusion.runtime.StringFunc;
import coldfusion.runtime.Struct;
import coldfusion.sql.DataSourceDefBlockedProperty;
import coldfusion.sql.Executive;
import coldfusion.sql.TwoFishCryptor;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DataSourceDef {
    public static final List<String> BLOCKED_PROPERTIES = Arrays.asList(System.getProperty("coldfusion.datasource.blocked.properties", "").split("\\s*,\\s*"));
    private static final String CONNECTION_STRING = "CONNECTIONPROPS";
    private static final String EXTENSIONS = "log,txt";
    public static final int DEFAULT_MAX_STATEMENTS = 1000;
    public static final int DEFAULT_EXPIRE_IDLE_CONNECTIONS = 420;
    public static final int DEFAULT_LOGIN_TIMEOUT = 30;
    public static final String DEFAULT_SELECT_METHOD = "direct";
    private static Logger LOG = Logger.getLogger("datasources");
    public static final String SQLSERVER = "MSSQLServer";
    public static final String ORACLE = "Oracle";
    public static final String DB2 = "DB2";
    public static final String INFORMIX = "Informix";
    public static final String OTHER = "other";
    public static final String JNDI = "jndi";
    public static final String ODBC = "odbc";
    protected static final int SQLSERV = 1;
    protected static final int ORA = 2;
    protected static final int DEEBEE2 = 4;
    protected static final int IFX = 5;
    protected static final int OTHR = 6;
    protected static final int MSDAO = 8;
    protected static final int J2EE = 7;
    private static final String JDBCBehavior = "jdbcbehavior";
    private static final String SEMICOLON_SEP = ";";
    public static Map VENDORS = new Struct();
    public static final String URL = "url";
    public static final String URLMAP = "urlmap";
    public static final String CLASS = "class";
    public static final String DESC = "description";
    public static final String USER = "username";
    public static final String PASSWORD = "password";
    public static final String POOLING = "pooling";
    public static final String TIMEOUT = "timeout";
    public static final String PORT = "port";
    public static final String TYPE = "type";
    public static final String INTERVAL = "interval";
    public static final String MAXCONNECTIONS = "maxconnections";
    public static final String DSN = "name";
    public static final String VENDOR = "DRIVER";
    public static final String LOGINTIMEOUT = "login_timeout";
    public static final String MAXPOOLEDSTATEMENTS = "MaxPooledStatements";
    public static final String DATABASE = "database";
    public static final String HOST = "host";
    public static final String CONNECTION_DISABLED = "disable";
    public static final String DISABLE_BLOB = "disable_blob";
    public static final String DISABLE_CLOB = "disable_clob";
    public static final String MAX_CLOB_SIZE = "buffer";
    public static final String MAX_BLOB_SIZE = "blob_buffer";
    public static final String SID = "sid";
    public static final String SERVICENAME = "servicename";
    public static final String SELECT_METHOD = "select_method";
    public static final String SEND_STRING_PARAM_AS_UNICODE = "sendStringParametersAsUnicode";
    public static final String INFORMIX_SERVER = "informixServer";
    public static final String USE_SPY_LOG = "usespylog";
    public static final String SPY_LOG_FILE = "spylogfile";
    public static final String VALIDATION_QUERY = "validationQuery";
    public static final String VALIDATE_CONNECTION = "validateConnection";
    public static final String SUPPORT_LINKS = "supportlinks";
    public static final String DISABLE_AUTOGEN_KEYS = "disable_autogenkeys";
    public static final String ALTER = "alter";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    public static final String STOREDPROC = "storedproc";
    public static final String INSERT = "insert";
    public static final String DROP = "drop";
    public static final String CREATE = "create";
    public static final String REVOKE = "revoke";
    public static final String SELECT = "select";
    public static final String GRANT = "grant";
    public static final String CLIENTINFO = "clientinfo";
    public static final String CI_CLIENTHOSTNAME = "ClientHostName";
    public static final String CI_CLIENTUSERNAME = "ClientUser";
    public static final String CI_APPLICATIONNAME = "ApplicationName";
    public static final String CI_APPLICATIONNAME_PREFIX = "ApplicationNamePrefix";
    private String dsn;
    private String className;
    private String desc = "";
    private String username;
    private String password;
    private String seed;
    private String url;
    private String sid;
    private String serviceName;
    private String driver;
    private boolean pooling = true;
    private boolean isDynamic = false;
    private boolean removeOnPageEnd = false;
    private int timeout = 420;
    private int interval = 420;
    private Map extraData;
    private TwoFishCryptor cryptor = new TwoFishCryptor();
    private int type = 6;
    private String jndiName;
    private Hashtable jndienv;
    private int maxconnections = -1;
    private int port;
    private int logintimeout = 30;
    private String vendor;
    private int maxPooledStatements = 1000;
    private String database;
    private String host;
    private Map dsnMap;
    private String selectMethod = "direct";
    private boolean strPrmUni;
    private String ifxSrv;
    private Struct allowedSQL = new Struct();
    private boolean restrictedSQL = false;
    public boolean isConnectionEnabled;
    public boolean isBlobEnabled;
    public boolean isClobEnabled;
    public boolean disableAutogenKeys = false;
    public int maxBlobSize = 64000;
    public int maxClobSize = 64000;
    private boolean useSpyLog = false;
    private String spyLogFile = null;
    private boolean supportLinks = true;
    private String validationQuery;
    private boolean validateConnection = false;
    private Struct clientInfoProperties = new Struct();
    private static final Boolean TRUE_VALUE;
    private static final Boolean FALSE_VALUE;
    private static final String ALWAYS_SEND_SETTXN_ISOLEVEL = "alwaysSendSetTxnIsoLevel";
    private static final String SET_TXN_ISOLEVEL = "alwaysSendSetTxnIsoLevel=true";
    private static final String USE_SYSTEM_PROXY_OPTIONS = "useSystemProxyOptions";
    private static final String DISABLE_PROXY_SETTINGS_FROM_SYSTEM_PROPERTIES = "useSystemProxyOptions=false";
    private static final String SERVICE_NAME_URL_KEY = "ServiceName=";
    public static String ODBC_CLASS;
    public static String ODBC_URL;

    public DataSourceDef() {
    }

    public DataSourceDef(Map m) {
        this.init(m);
    }

    String setServiceNameinJDBCURL(String url) {
        if (url != null && !url.isEmpty()) {
            String serviceNameAttr = SERVICE_NAME_URL_KEY + this.serviceName;
            ArrayList<CallSite> urlAttributes = new ArrayList<CallSite>();
            Collections.addAll(urlAttributes, url.split(SEMICOLON_SEP));
            boolean serviceNameExists = false;
            for (int i = 1; i < urlAttributes.size(); ++i) {
                if (!((String)urlAttributes.get(i)).startsWith(SERVICE_NAME_URL_KEY)) continue;
                serviceNameExists = true;
                break;
            }
            if (!serviceNameExists) {
                if (urlAttributes.size() > 1) {
                    if (((String)urlAttributes.get(1)).startsWith("SID")) {
                        urlAttributes.set(1, (CallSite)((Object)serviceNameAttr));
                    } else {
                        urlAttributes.add(1, (CallSite)((Object)serviceNameAttr));
                    }
                }
                return String.join((CharSequence)SEMICOLON_SEP, urlAttributes);
            }
        }
        return url;
    }

    private boolean keyExistsInURL(String url, String key) {
        String[] urlParams;
        for (String keyVal : urlParams = url.trim().split(SEMICOLON_SEP)) {
            String[] splitKeyVal = keyVal.split("=");
            if (!splitKeyVal[0].toLowerCase().startsWith(key)) continue;
            return true;
        }
        return false;
    }

    private void init(Map m) {
        String o;
        Object disableKeys;
        this.dsnMap = m;
        LOG.debug("DatasourceDef before: " + m);
        this.setDsn((String)m.get(DSN));
        this.setDesc((String)m.get(DESC));
        this.setUsername((String)m.get(USER));
        this.setPassword((String)m.get(PASSWORD));
        String pool = String.valueOf(m.get(POOLING));
        if (pool != null) {
            this.setPooling(Boolean.valueOf(pool));
        }
        if (m.containsKey(TIMEOUT)) {
            this.setTimeout(((Number)m.get(TIMEOUT)).intValue());
        }
        if (m.containsKey(INTERVAL)) {
            this.setInterval(((Number)m.get(INTERVAL)).intValue());
        }
        this.setExtraData((Map)m.get(URLMAP));
        this.setPort(this.extraData.get(PORT));
        this.setJndienv((Hashtable)m.get("jndiEnv"));
        this.setMaxConnections(this.extraData.get(MAXCONNECTIONS));
        this.setVendor((String)m.get(VENDOR));
        this.setClassName((String)m.get(CLASS));
        this.setLoginTimeout(m.get(LOGINTIMEOUT));
        this.setHost((String)this.extraData.get(HOST));
        this.setDatabase((String)this.extraData.get(DATABASE));
        this.setSid((String)this.extraData.get(SID));
        String serviceName = (String)this.extraData.get(SERVICENAME);
        if (serviceName != null && !serviceName.isEmpty()) {
            this.setServiceName(serviceName);
            m.put(URL, this.setServiceNameinJDBCURL((String)m.get(URL)));
        }
        this.setSelectMethod((String)this.extraData.get(SELECT_METHOD));
        if (this.extraData.containsKey(SEND_STRING_PARAM_AS_UNICODE)) {
            this.setStrPrmUni(Cast._boolean(this.extraData.get(SEND_STRING_PARAM_AS_UNICODE)));
        }
        this.setIfxSrv((String)this.extraData.get(INFORMIX_SERVER));
        Hashtable envString = (Hashtable)this.extraData.get("jndienv");
        if (this.getType() == 7 && envString != null) {
            this.setJndienv(envString);
        }
        this.putAllowedSQL(m.get(ALTER), ALTER);
        this.putAllowedSQL(m.get(UPDATE), UPDATE);
        this.putAllowedSQL(m.get(DELETE), DELETE);
        this.putAllowedSQL(m.get(STOREDPROC), STOREDPROC);
        this.putAllowedSQL(m.get(INSERT), INSERT);
        this.putAllowedSQL(m.get(DROP), DROP);
        this.putAllowedSQL(m.get(CREATE), CREATE);
        this.putAllowedSQL(m.get(REVOKE), REVOKE);
        this.putAllowedSQL(m.get(SELECT), SELECT);
        this.putAllowedSQL(m.get(GRANT), GRANT);
        this.setRestrictedSQL();
        this.isConnectionEnabled = !Cast._boolean(m.get(CONNECTION_DISABLED));
        this.isBlobEnabled = !Cast._boolean(m.get(DISABLE_BLOB));
        boolean bl = this.isClobEnabled = !Cast._boolean(m.get(DISABLE_CLOB));
        if (m.containsKey(MAX_BLOB_SIZE)) {
            this.maxBlobSize = Cast._int(m.get(MAX_BLOB_SIZE));
        }
        if (m.containsKey(MAX_CLOB_SIZE)) {
            this.maxClobSize = Cast._int(m.get(MAX_CLOB_SIZE));
        }
        if ((disableKeys = m.get(DISABLE_AUTOGEN_KEYS)) != null) {
            this.disableAutogenKeys = Cast._boolean(disableKeys);
        }
        this.setUseSpy(this.extraData.get(USE_SPY_LOG));
        Object origLogFile = this.extraData.get(SPY_LOG_FILE);
        String setSpyLogFile = this.setSpyLogFile(origLogFile);
        this.extraData.put(SPY_LOG_FILE, setSpyLogFile);
        if (setSpyLogFile.isEmpty()) {
            this.extraData.put(USE_SPY_LOG, false);
            this.setUseSpy(this.extraData.get(USE_SPY_LOG));
        }
        Object origUrl = (String)m.get(URL);
        if (origLogFile != null && origLogFile instanceof String && !(o = (String)origLogFile).equals(setSpyLogFile) && origUrl != null) {
            origUrl = ((String)origUrl).replace(o, setSpyLogFile);
        }
        if ("macromedia.jdbc.MacromediaDriver".equalsIgnoreCase(this.getClassName()) && origUrl != null && !((String)origUrl).isEmpty()) {
            Map connProperties = new CaseInsensitiveMap();
            if (this.extraData.containsKey(CONNECTION_STRING)) {
                connProperties = (Map)this.extraData.get(CONNECTION_STRING);
            }
            if (this.vendor.equalsIgnoreCase("oracle")) {
                if (!connProperties.containsKey(ALWAYS_SEND_SETTXN_ISOLEVEL) && !this.keyExistsInURL((String)origUrl, "alwayssendsettxnisolevel")) {
                    origUrl = (String)origUrl + ";alwaysSendSetTxnIsoLevel=true";
                }
                if (!connProperties.containsKey(USE_SYSTEM_PROXY_OPTIONS) && !this.keyExistsInURL((String)origUrl, "usesystemproxyoptions")) {
                    origUrl = (String)origUrl + ";useSystemProxyOptions=false";
                }
            } else if (this.vendor.equalsIgnoreCase("mssqlserver") && !connProperties.containsKey(USE_SYSTEM_PROXY_OPTIONS) && !this.keyExistsInURL((String)origUrl, "usesystemproxyoptions")) {
                origUrl = (String)origUrl + ";useSystemProxyOptions=false";
            }
            if (((String)origUrl).toLowerCase().indexOf(JDBCBehavior) == -1) {
                origUrl = (String)origUrl + ";jdbcbehavior=0";
            }
        }
        this.setUrl((String)origUrl);
        m.put(URL, origUrl);
        this.setSupportLinks(this.extraData.get(SUPPORT_LINKS));
        this.setValidationQuery((String)m.get(VALIDATION_QUERY));
        Object val = m.get(VALIDATE_CONNECTION);
        if (val != null) {
            this.setValidateConnection(Cast._boolean(val));
        } else {
            m.put(VALIDATE_CONNECTION, Boolean.FALSE);
            this.setValidateConnection(Boolean.FALSE);
        }
        Map clientinfoMap = (Map)m.get(CLIENTINFO);
        if (clientinfoMap != null) {
            this.clientInfoProperties.put(CI_CLIENTHOSTNAME, (Object)(clientinfoMap.get(CI_CLIENTHOSTNAME) != null ? Cast._boolean(clientinfoMap.get(CI_CLIENTHOSTNAME)) : Boolean.FALSE));
            this.clientInfoProperties.put(CI_CLIENTUSERNAME, (Object)(clientinfoMap.get(CI_CLIENTUSERNAME) != null ? Cast._boolean(clientinfoMap.get(CI_CLIENTUSERNAME)) : Boolean.FALSE));
            this.clientInfoProperties.put(CI_APPLICATIONNAME, (Object)(clientinfoMap.get(CI_APPLICATIONNAME) != null ? Cast._boolean(clientinfoMap.get(CI_APPLICATIONNAME)) : Boolean.FALSE));
            this.clientInfoProperties.put(CI_APPLICATIONNAME_PREFIX, clientinfoMap.get(CI_APPLICATIONNAME_PREFIX) != null ? clientinfoMap.get(CI_APPLICATIONNAME_PREFIX) : "");
            m.put(CLIENTINFO, this.clientInfoProperties);
        } else {
            this.clientInfoProperties.put(CI_CLIENTHOSTNAME, (Object)Boolean.FALSE);
            this.clientInfoProperties.put(CI_CLIENTUSERNAME, (Object)Boolean.FALSE);
            this.clientInfoProperties.put(CI_APPLICATIONNAME, (Object)Boolean.FALSE);
            this.clientInfoProperties.put(CI_APPLICATIONNAME_PREFIX, (Object)"");
            m.put(CLIENTINFO, this.clientInfoProperties);
        }
        LOG.debug("DatasourceDef after: " + m);
    }

    private void setDefaultBlockedProperties(Map m) {
        if (!BLOCKED_PROPERTIES.isEmpty()) {
            Object origUrl = (String)m.get(URL);
            Map connProperties = new CaseInsensitiveMap();
            if (this.extraData.containsKey(CONNECTION_STRING)) {
                connProperties = (Map)this.extraData.get(CONNECTION_STRING);
            }
            Map<String, String> map = DataSourceDefBlockedProperty.getBlockedPropertiesMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!BLOCKED_PROPERTIES.contains(key) || connProperties.containsKey(key)) continue;
                connProperties.put(key, value);
                origUrl = (String)origUrl + "&" + key + "=" + value + "&";
            }
            m.put(URL, origUrl);
            CFLogs.SERVER_LOG.debug("Url after adding blocked properties:" + (String)origUrl);
            if (!this.extraData.containsKey(CONNECTION_STRING)) {
                this.extraData.put(CONNECTION_STRING, connProperties);
            }
        }
    }

    public void validateBlockedProperties() {
        if (this.extraData != null && this.extraData.containsKey(CONNECTION_STRING)) {
            Map connProperties = new CaseInsensitiveMap();
            connProperties = (Map)this.extraData.get(CONNECTION_STRING);
            for (String blockedProperty : BLOCKED_PROPERTIES) {
                if (!connProperties.containsKey(blockedProperty) || DataSourceDefBlockedProperty.getValueByKey(blockedProperty) != null && connProperties.get(blockedProperty).equals(DataSourceDefBlockedProperty.getValueByKey(blockedProperty))) continue;
                CFLogs.SERVER_LOG.debug(blockedProperty + " is a blocked connection property");
                throw new UnsupportedOperationException(RB.getString((Object)this, "Blocked.Db.Connection.String", (Object)blockedProperty, (Object)"-Dcoldfusion.datasource.blocked.properties"));
            }
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String d) {
        this.driver = d;
    }

    private void putAllowedSQL(Object opAllowed, String sqlOpKeyword) {
        if (opAllowed == null) {
            this.allowedSQL.put(sqlOpKeyword, (Object)FALSE_VALUE);
        } else {
            String sqlOp = opAllowed.toString();
            if (Boolean.valueOf(sqlOp).booleanValue()) {
                this.allowedSQL.put(sqlOpKeyword, (Object)TRUE_VALUE);
            } else {
                this.allowedSQL.put(sqlOpKeyword, (Object)FALSE_VALUE);
            }
        }
    }

    public Struct getAllowedSQL() {
        return this.allowedSQL;
    }

    public void setAllowedSQL(Struct allowedSQL) {
        this.allowedSQL = allowedSQL;
        this.setRestrictedSQL();
    }

    private void setRestrictedSQL() {
        if (this.allowedSQL == null) {
            this.restrictedSQL = false;
            return;
        }
        Enumeration keys = this.allowedSQL.keys();
        while (keys.hasMoreElements()) {
            Object sqlAllowed = this.allowedSQL.get(keys.nextElement());
            if (sqlAllowed == null || !(sqlAllowed instanceof Boolean) || ((Boolean)sqlAllowed).booleanValue()) continue;
            this.restrictedSQL = true;
            return;
        }
        this.restrictedSQL = false;
    }

    public boolean isSQLRestricted() {
        return this.restrictedSQL;
    }

    public void setMap(Map m) {
        this.init(m);
    }

    public boolean isRemoveOnPageEnd() {
        return this.removeOnPageEnd;
    }

    public void setRemoveOnPageEnd(boolean removeOnPageEnd) {
        this.removeOnPageEnd = removeOnPageEnd;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        if (this.allowedSQL != null) {
            return this.allowedSQL.get(key.toString().toLowerCase());
        }
        return this.dsnMap.get(key.toString().toLowerCase());
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public String getIfxSrv() {
        return this.ifxSrv;
    }

    public void setIfxSrv(String ifxSrv) {
        this.ifxSrv = ifxSrv;
    }

    public boolean getStrPrmUni() {
        return this.strPrmUni;
    }

    public void setStrPrmUni(String strPrmUni) {
        this.strPrmUni = Cast._boolean(strPrmUni);
    }

    public void setStrPrmUni(boolean bl) {
        this.strPrmUni = bl;
    }

    public String getSelectMethod() {
        return this.selectMethod;
    }

    public void setSelectMethod(String selectMethod) {
        this.selectMethod = selectMethod;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getServicename() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public int getMaxClobSize() {
        return this.maxClobSize;
    }

    public void setMaxClobSize(int maxClobSize) {
        this.maxClobSize = maxClobSize;
    }

    public int getMaxBlobSize() {
        return this.maxBlobSize;
    }

    public void setMaxBlobSize(int maxBlobSize) {
        this.maxBlobSize = maxBlobSize;
    }

    public boolean isClobEnabled() {
        return this.isClobEnabled;
    }

    public void setClobEnabled(boolean clobEnabled) {
        this.isClobEnabled = clobEnabled;
    }

    public boolean isBlobEnabled() {
        return this.isBlobEnabled;
    }

    public void setBlobEnabled(boolean blobEnabled) {
        this.isBlobEnabled = blobEnabled;
    }

    public boolean isConnectionEnabled() {
        return this.isConnectionEnabled;
    }

    public void setConnectionEnabled(boolean connectionEnabled) {
        this.isConnectionEnabled = connectionEnabled;
    }

    public int getLogintimeout() {
        return this.logintimeout;
    }

    public void setLogintimeout(int logintimeout) {
        this.logintimeout = logintimeout;
    }

    public int getMaxconnections() {
        return this.maxconnections;
    }

    public void setMaxConnections(int maxconnections) {
        this.maxconnections = maxconnections;
    }

    public void setDatabase(String db) {
        this.database = db;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
        this.setType(vendor);
    }

    public String getVendor() {
        return this.vendor;
    }

    public Hashtable getJndienv() {
        return this.jndienv;
    }

    public void setLoginTimeout(Object to) {
        Integer i = (Integer)Cast._cast(to, Integer.class);
        if (i != null) {
            this.logintimeout = i;
        }
        this.extraData.put("_logintimeout", i);
    }

    public int getLoginTimeout() {
        return this.logintimeout;
    }

    public void setPort(Object port) {
        try {
            Integer i = (Integer)Cast._cast(port, Integer.class);
            this.extraData.put("_port", i);
            this.port = i;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setMaxConnections(Object maxcon) {
        if (maxcon != null) {
            Integer i = (Integer)Cast._cast(maxcon, Integer.class);
            this.maxconnections = i;
        }
    }

    public int getMaxConnections() {
        return this.maxconnections;
    }

    public void setJndienv(Hashtable jndienv) {
        this.jndienv = jndienv;
    }

    public static final Hashtable parseJndiEnv(String envString) {
        Hashtable<String, String> jenv = new Hashtable<String, String>();
        StringTokenizer stok = new StringTokenizer(envString, ",");
        while (stok.hasMoreElements()) {
            String token = stok.nextToken();
            int idx = token.indexOf("=");
            String name = token.substring(0, idx);
            String value = token.substring(idx + 1, token.length());
            jenv.put(name, value);
        }
        return jenv;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJNDIName() {
        return (String)this.extraData.get("jndiname");
    }

    public void setType(String type) {
        if (type == null) {
            return;
        }
        Integer ty = (Integer)VENDORS.get(type);
        if (ty == null) {
            this.setType(6);
            return;
        }
        this.setType(ty);
    }

    public void setType(int type) {
        this.type = type;
        if (type == 8) {
            this.setUrl(DataSourceDef.getJadoZoomUrl(this));
            this.setClassName(ODBC_CLASS);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public String getClassName() {
        return this.className;
    }

    public TwoFishCryptor getCryptor() {
        return this.cryptor;
    }

    public void setCryptor(TwoFishCryptor cryptor) {
        this.cryptor = cryptor;
    }

    public void setClassName(String className) {
        Object driverConfig;
        if (className == null && this.getVendor() != null && (driverConfig = Executive.getInstance().getDrivers().get(this.getVendor())) != null && ((Map)driverConfig).containsKey(CLASS)) {
            className = ((Map)driverConfig).get(CLASS).toString().trim();
        }
        this.className = className;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    protected String getPassword() {
        if (this.password == null) {
            return null;
        }
        if (this.password.equals("")) {
            return "";
        }
        Executive executive = Executive.getInstance();
        return PasswordUtils.decryptPassword(this.password, this.seed != null ? this.seed : executive.getSeed());
    }

    public void setPassword(String password) {
        this.setPassword(password, false);
    }

    public void setPassword(String password, boolean encrypt) {
        if (encrypt) {
            Executive executive = Executive.getInstance();
            this.password = PasswordUtils.encryptPassword(password, this.seed != null ? this.seed : executive.getSeed());
        } else {
            this.password = password;
        }
    }

    public void encryptPassword() {
        this.setPassword(this.password, true);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isPooling() {
        return this.pooling;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean getUseSpyLog() {
        return this.useSpyLog;
    }

    public void setUseSpy(Object useSpy) {
        try {
            this.useSpyLog = Cast._boolean(useSpy);
        }
        catch (Exception e) {
            this.useSpyLog = false;
        }
    }

    public String getSpyLogFile() {
        return this.spyLogFile;
    }

    public String setSpyLogFile(Object logFile) {
        String file;
        this.spyLogFile = "";
        if (logFile != null && logFile instanceof String && (file = (String)logFile) != null && !file.isEmpty() && DataSourceDef.checkAllowedFileExtensions(file).equals("true")) {
            this.spyLogFile = file;
        }
        return this.spyLogFile;
    }

    protected static String checkAllowedFileExtensions(String file) {
        if (file == null || file != null && file.isEmpty()) {
            return "true";
        }
        String extensions = EXTENSIONS;
        int index = file.lastIndexOf(".");
        if (index > 0) {
            String extension = file.substring(index + 1, file.length());
            for (String ext : extensions.split(",")) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return "true";
            }
        }
        return extensions;
    }

    public boolean getSupportLinks() {
        return this.supportLinks;
    }

    public void setSupportLinks(Object supportLinks) {
        try {
            this.supportLinks = Cast._boolean(supportLinks);
        }
        catch (Exception e) {
            this.supportLinks = true;
        }
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public boolean isValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public Struct getClientInfoProperties() {
        return this.clientInfoProperties;
    }

    public void setClientInfoProperties(Struct clientInfoProperties) {
        this.clientInfoProperties = clientInfoProperties;
    }

    public Map getExtraData() {
        return this.extraData;
    }

    public void setExtraData(Map extraData) {
        this.extraData = extraData;
    }

    public void setMaxPooledStatements(int stmts) {
        this.maxPooledStatements = stmts;
    }

    public int getMaxPooledStatements() {
        Object mxp;
        if (this.extraData != null && (mxp = this.extraData.get(MAXPOOLEDSTATEMENTS)) != null) {
            int mps = Integer.parseInt((String)this.extraData.get(MAXPOOLEDSTATEMENTS));
            return mps;
        }
        return this.maxPooledStatements;
    }

    public boolean isDisableAutogenKeys() {
        return this.disableAutogenKeys;
    }

    public void setDisableAutogenKeys(boolean disable) {
        this.disableAutogenKeys = Cast._boolean(disable);
    }

    protected static String getJadoZoomUrl(DataSourceDef def) {
        String username = def.getUsername();
        String pwd = def.getPassword();
        StringBuffer url = new StringBuffer(70);
        url.append(ODBC_URL);
        url.append("Driver={");
        url.append(def.getDriver());
        url.append("};Server=");
        url.append(def.getHost());
        url.append(SEMICOLON_SEP);
        if (username != null) {
            url.append("USER ID=");
            url.append(username);
            url.append(SEMICOLON_SEP);
            if (pwd != null) {
                url.append("Password=");
                url.append(pwd);
                url.append(SEMICOLON_SEP);
            }
        }
        return url.toString();
    }

    public static String getJDBCUrl(DataSourceDef def) {
        Object driverConfig = Executive.getInstance().getDrivers().get(def.getVendor());
        if (driverConfig == null) {
            return null;
        }
        if (!((Map)driverConfig).containsKey(URL)) {
            return null;
        }
        Object url = ((Map)driverConfig).get(URL).toString();
        String host = def.getHost();
        if (StringFunc.FindNoCase("[host]", (String)url, 1) != 0) {
            if (host != null && host.trim().length() != 0) {
                Object hostVal = "";
                hostVal = IPAddressUtils.isIPV6(def.getHost()) && StringFunc.FindNoCase(":", host, 1) != 0 ? "[" + host + "]" : host.split(":")[0];
                url = StringFunc.ReplaceNoCase((String)url, "[host]", (String)hostVal, "ONE");
            } else {
                url = StringFunc.ReplaceNoCase((String)url, "[host]", "localhost", "ONE");
            }
        }
        int port = def.getPort();
        if (StringFunc.FindNoCase("[port]", (String)url, 1) != 0) {
            String driverPort;
            url = port != 0 ? StringFunc.ReplaceNoCase((String)url, "[port]", Integer.toString(port), "ONE") : (((Map)driverConfig).get(PORT) != null && host.indexOf("\\") == -1 ? ((driverPort = ((Map)driverConfig).get(PORT).toString().trim()).length() != 0 ? StringFunc.ReplaceNoCase((String)url, "[port]", driverPort, "ONE") : StringFunc.ReplaceNoCase((String)url, ":[port]", "", "ONE")) : StringFunc.ReplaceNoCase((String)url, ":[port]", "", "ONE"));
        }
        String database = def.getDatabase();
        if (StringFunc.FindNoCase("[database]", (String)url, 1) != 0) {
            if (database != null && database.trim().length() != 0) {
                url = StringFunc.ReplaceNoCase((String)url, "[database]", database.trim(), "ONE");
            } else {
                url = StringFunc.ReplaceNoCase((String)url, "[database]", "", "ONE");
                url = StringFunc.ReplaceNoCase((String)url, "databaseName=", "", "ONE");
            }
        }
        String datasource = def.getDsn();
        if (StringFunc.FindNoCase("[datasource]", (String)url, 1) != 0) {
            if (datasource != null && datasource.trim().length() != 0) {
                url = StringFunc.ReplaceNoCase((String)url, "[datasource]", datasource.trim(), "ONE");
            } else {
                url = StringFunc.ReplaceNoCase((String)url, "[datasource]", "", "ONE");
                url = StringFunc.ReplaceNoCase((String)url, "serverDatasource=", "", "ONE");
            }
        }
        url = StringFunc.ReplaceNoCase((String)url, "[args]", "", "ALL");
        HashMap urlMap = def.getExtraData();
        if (urlMap == null) {
            urlMap = new HashMap();
        }
        if (StringFunc.FindNoCase("[isnewdb]", (String)url, 1) != 0) {
            Object isNewDB = urlMap.get("isnewdb");
            url = isNewDB != null ? StringFunc.ReplaceNoCase((String)url, "[isnewdb]", isNewDB.toString().trim(), "ALL") : StringFunc.ReplaceNoCase((String)url, "[isnewdb]", "false", "ALL");
        }
        if (StringFunc.FindNoCase("[qTimeout]", (String)url, 1) != 0) {
            Object qTimeout = urlMap.get("qTimeout");
            url = qTimeout != null ? StringFunc.ReplaceNoCase((String)url, "[qTimeout]", qTimeout.toString().trim(), "ALL") : StringFunc.ReplaceNoCase((String)url, "[qTimeout]", "0", "ALL");
        }
        if (StringFunc.FindNoCase("[informix_server]", (String)url, 1) != 0) {
            String informixServer = def.getIfxSrv();
            if (informixServer != null && informixServer.trim().length() != 0) {
                url = StringFunc.ReplaceNoCase((String)url, "[informix_server]", informixServer.trim(), "ALL");
            } else {
                url = StringFunc.ReplaceNoCase((String)url, "[informix_server]", "", "ALL");
                url = StringFunc.ReplaceNoCase((String)url, "informixServer=", "", "ALL");
            }
        }
        if (StringFunc.FindNoCase("[SID]", (String)url, 1) != 0) {
            String SID = def.getSid();
            url = SID != null && SID.trim().length() != 0 ? StringFunc.ReplaceNoCase((String)url, "[SID]", SID.trim(), "ALL") : StringFunc.ReplaceNoCase((String)url, "[SID]", "", "ALL");
        }
        if (StringFunc.FindNoCase("[ServiceName]", (String)url, 1) != 0) {
            String serviceName = def.getServicename();
            url = serviceName != null && serviceName.trim().length() != 0 ? StringFunc.ReplaceNoCase((String)url, "[ServiceName]", serviceName.trim(), "ALL") : StringFunc.ReplaceNoCase((String)url, "[ServiceName]", "", "ALL");
        }
        if (StringFunc.FindNoCase("[applicationintent]", (String)url, 1) != 0) {
            Object applicationIntent = urlMap.get("applicationintent");
            if (applicationIntent != null) {
                url = StringFunc.ReplaceNoCase((String)url, "[applicationintent]", applicationIntent.toString().trim(), "ALL");
            } else {
                url = StringFunc.ReplaceNoCase((String)url, "[applicationintent]", "", "ALL");
                url = StringFunc.ReplaceNoCase((String)url, "applicationintent=", "", "ALL");
            }
        }
        if (StringFunc.FindNoCase("[selectMethod]", (String)url, 1) != 0) {
            String selectMethod = def.getSelectMethod();
            if (selectMethod != null && selectMethod.trim().length() != 0) {
                url = StringFunc.ReplaceNoCase((String)url, "[selectMethod]", selectMethod.trim(), "ALL");
            } else {
                url = StringFunc.ReplaceNoCase((String)url, "[selectMethod]", "", "ALL");
                url = StringFunc.ReplaceNoCase((String)url, "selectMethod=", "", "ALL");
            }
        }
        if (StringFunc.FindNoCase("[sendStringParametersAsUnicode]", (String)url, 1) != 0) {
            String strPrmUni = String.valueOf(def.getStrPrmUni());
            url = strPrmUni != null && strPrmUni.trim().length() != 0 ? StringFunc.ReplaceNoCase((String)url, "[sendStringParametersAsUnicode]", strPrmUni.trim(), "ALL") : StringFunc.ReplaceNoCase((String)url, "[sendStringParametersAsUnicode]", "false", "ALL");
        }
        if (StringFunc.FindNoCase("[databaseFile]", (String)url, 1) != 0) {
            Object databaseFile = urlMap.get("databaseFile");
            url = databaseFile != null ? StringFunc.ReplaceNoCase((String)url, "[databaseFile]", StringFunc.Replace(databaseFile.toString().trim(), "\\", "\\\\", "ALL"), "ALL") : StringFunc.ReplaceNoCase((String)url, "[databaseFile]", "", "ALL");
        }
        url = (String)url + ";MaxPooledStatements=" + def.getMaxPooledStatements();
        if (def.getSid() != null && urlMap.containsKey("supportLinks")) {
            url = (String)url + ";SupportLinks=" + def.getSupportLinks();
        }
        if (def.getUseSpyLog() && def.getSpyLogFile() != null) {
            url = (String)url + ";SpyAttributes=(log=(file)" + def.getSpyLogFile() + "; linelimit=80;logTName=yes;timestamp=yes)";
        }
        return ((String)url).toString();
    }

    void setSeed(String seed) {
        this.seed = seed;
    }

    static {
        VENDORS.put(SQLSERVER, new Integer(1));
        VENDORS.put(ORACLE, new Integer(2));
        VENDORS.put(DB2, new Integer(4));
        VENDORS.put(INFORMIX, new Integer(5));
        VENDORS.put(OTHER, new Integer(6));
        VENDORS.put(JNDI, new Integer(7));
        VENDORS.put(ODBC, new Integer(8));
        TRUE_VALUE = new Boolean(true);
        FALSE_VALUE = new Boolean(false);
        ODBC_CLASS = "com.inzoom.jdbcado.Driver";
        ODBC_URL = "jdbc:izmado:Provider=MSDASQL;";
    }
}

