/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.QueryFunction;
import coldfusion.server.j2ee.sql.JRunConnectionHandle;
import coldfusion.sql.DBMetaDataColumnInfo;
import coldfusion.sql.QueryTable;
import coldfusion.sql.SqlImpl;
import coldfusion.sql.Table;
import coldfusion.util.RB;
import java.lang.invoke.CallSite;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DatabaseMetaDataUtil {
    protected SqlImpl impl = null;
    protected static Map metadatainfomap = new HashMap();
    protected DatabaseMetaData dbMetaData = null;
    protected String dsDatabaseName = null;
    protected boolean isCatalog = false;
    protected boolean isSchema = false;
    public static final String TYPE_VERSION = "version";
    public static final String TYPE_TABLES = "tables";
    public static final String TYPE_PROCEDURES = "procedures";
    public static final String TYPE_INDEX = "index";
    public static final String TYPE_FOREIGNKEYS = "foreignkeys";
    public static final String TYPE_COLUMNS = "columns";
    public static final String TYPE_DBNAMES = "dbnames";
    public static final String TYPE_CLIENTINFO = "clientinfo";
    public static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    public static final String CARDINALITY = "CARDINALITY";
    public static final String INDEX_NAME = "INDEX_NAME";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String VALUE_SEPERATOR = ",";
    private static final boolean isJVMSecurityEnabled = System.getSecurityManager() != null;
    private static boolean UNDERSCORE_WILDCARD_IN_TABLE_NAMES = false;

    public void setSqlImpl(SqlImpl impl) throws SQLException {
        this.impl = impl;
        List catalogList = this.getCatalogs();
        List schemaList = this.getSchemas();
        this.dsDatabaseName = impl.getCatalog();
        this.isCatalog = catalogList.contains(this.dsDatabaseName);
        this.isSchema = schemaList.contains(this.dsDatabaseName);
        Connection c = ((JRunConnectionHandle)impl.getConnection()).getPhysicalConnection();
        if (this.dsDatabaseName != null && this.dsDatabaseName.indexOf(45) != -1 && c.getClass().getName().equals("macromedia.jdbc.sqlserver.SQLServerConnection")) {
            StringBuffer dbName = new StringBuffer();
            dbName = dbName.append("[").append(this.dsDatabaseName).append("]");
            this.dsDatabaseName = dbName.toString();
        }
    }

    public Table getVersion() throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        String databaseVersion = dbMetaData.getDatabaseProductVersion();
        String databaseProductName = dbMetaData.getDatabaseProductName();
        String driverversion = dbMetaData.getDriverVersion();
        String drivername = dbMetaData.getDriverName();
        int jdbcmajorversion = dbMetaData.getJDBCMajorVersion();
        int jdbcminorversion = dbMetaData.getJDBCMinorVersion();
        String[] versionCols = this.getTypeColumns(TYPE_VERSION);
        QueryTable qtable = new QueryTable(0, versionCols, this.getTypeColumnDataTypes(TYPE_VERSION));
        QueryFunction.QueryAddRow(qtable);
        QueryFunction.QuerySetCell(qtable, versionCols[0], databaseVersion);
        QueryFunction.QuerySetCell(qtable, versionCols[1], databaseProductName);
        QueryFunction.QuerySetCell(qtable, versionCols[2], driverversion);
        QueryFunction.QuerySetCell(qtable, versionCols[3], drivername);
        QueryFunction.QuerySetCell(qtable, versionCols[4], new Integer(jdbcmajorversion));
        QueryFunction.QuerySetCell(qtable, versionCols[5], new Integer(jdbcminorversion));
        return qtable;
    }

    public Table getClientInfo() throws SQLException {
        try {
            DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
            ResultSet rsClientInfoProps = dbMetaData.getClientInfoProperties();
            return this.formTableFromResultSet(TYPE_CLIENTINFO, rsClientInfoProps);
        }
        catch (AbstractMethodError e) {
            throw new OperationNotSupportedException((Throwable)e);
        }
    }

    private String getCaseInsensitiveAttribute(String attribute, DatabaseMetaData dbMetaData) throws SQLException {
        if (attribute == null) {
            return null;
        }
        boolean storesAsLowerCase = dbMetaData.storesLowerCaseIdentifiers();
        boolean storesAsUpperCase = dbMetaData.storesUpperCaseIdentifiers();
        String caseInsensitivePattern = null;
        caseInsensitivePattern = storesAsLowerCase ? attribute.toLowerCase() : (storesAsUpperCase ? attribute.toUpperCase() : attribute);
        return caseInsensitivePattern;
    }

    private boolean tableExists(String tableName) throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        tableName = this.getCaseInsensitiveAttribute(tableName, dbMetaData);
        ResultSet rsTabs = null;
        String[] tabTypes = this.getTableTypes(dbMetaData);
        if (tableName != null && tableName.trim().equalsIgnoreCase("")) {
            return false;
        }
        rsTabs = this.isCatalog ? dbMetaData.getTables(this.dsDatabaseName, null, tableName, tabTypes) : (this.isSchema ? dbMetaData.getTables(null, this.dsDatabaseName, tableName, tabTypes) : dbMetaData.getTables(null, null, tableName, null));
        return rsTabs.next();
    }

    public Table getTables(String pattern) throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        pattern = this.getCaseInsensitiveAttribute(pattern, dbMetaData);
        ResultSet rsTabs = null;
        String[] tabTypes = this.getTableTypes(dbMetaData);
        if (pattern != null && pattern.trim().equalsIgnoreCase("")) {
            pattern = null;
        }
        rsTabs = this.isCatalog ? dbMetaData.getTables(this.dsDatabaseName, null, pattern, tabTypes) : (this.isSchema ? dbMetaData.getTables(null, this.dsDatabaseName, pattern, tabTypes) : dbMetaData.getTables(null, null, pattern, null));
        return this.formTableFromResultSet(TYPE_TABLES, rsTabs);
    }

    public Table getProcedures(String pattern) throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        ResultSet rsProcedures = null;
        if ((pattern = this.getCaseInsensitiveAttribute(pattern, dbMetaData)) != null && pattern.trim().equalsIgnoreCase("")) {
            pattern = null;
        }
        rsProcedures = this.isCatalog ? dbMetaData.getProcedures(this.dsDatabaseName, null, pattern) : (this.isSchema ? dbMetaData.getProcedures(null, this.dsDatabaseName, pattern) : dbMetaData.getProcedures(null, null, pattern));
        return this.formTableFromResultSet(TYPE_PROCEDURES, rsProcedures);
    }

    public Table getIndex(String tableName) throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        ResultSet rsIndex = null;
        tableName = this.getCaseInsensitiveAttribute(tableName, dbMetaData);
        if (this.isCatalog) {
            String schema = null;
            int tIndex = tableName.indexOf(46);
            if (tIndex > 0) {
                schema = tableName.substring(0, tIndex);
                tableName = tableName.substring(tIndex + 1, tableName.length());
            }
            rsIndex = dbMetaData.getIndexInfo(this.dsDatabaseName, schema, tableName, false, true);
        } else {
            rsIndex = this.isSchema ? dbMetaData.getIndexInfo(null, this.dsDatabaseName, tableName, false, true) : dbMetaData.getIndexInfo(null, null, tableName, false, true);
        }
        List list = this.formHashMapFromResultSet(TYPE_INDEX, rsIndex);
        if (list.size() == 0 && !this.tableExists(tableName)) {
            throw new SQLException(RB.getString((Object)this, "DatabaseMetaDataUtil.1", (Object)tableName));
        }
        return this.formTableFromList(TYPE_INDEX, list);
    }

    public Table getForeignkeys(String tableName) throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        ResultSet rsForeignKeys = null;
        tableName = this.getCaseInsensitiveAttribute(tableName, dbMetaData);
        if (this.isCatalog) {
            String schema = null;
            int tIndex = tableName.indexOf(46);
            if (tIndex > 0) {
                schema = tableName.substring(0, tIndex);
                tableName = tableName.substring(tIndex + 1, tableName.length());
            }
            rsForeignKeys = dbMetaData.getExportedKeys(this.dsDatabaseName, schema, tableName);
        } else {
            rsForeignKeys = this.isSchema ? dbMetaData.getExportedKeys(null, this.dsDatabaseName, tableName) : dbMetaData.getExportedKeys(null, null, tableName);
        }
        Table resultTable = this.formTableFromResultSet(TYPE_FOREIGNKEYS, rsForeignKeys);
        if (resultTable.getRowCount() == 0 && !this.tableExists(tableName)) {
            throw new SQLException(RB.getString((Object)this, "DatabaseMetaDataUtil.1", (Object)tableName));
        }
        return resultTable;
    }

    public Table getDbNames() throws SQLException {
        List catalogList = this.getCatalogs();
        List schemaList = this.getSchemas();
        QueryTable table = new QueryTable(0, new String[]{"DATABASE_NAME", "TYPE"}, new String[]{"CF_SQL_VARCHAR", "CF_SQL_VARCHAR"});
        ListIterator catlit = catalogList.listIterator();
        while (catlit.hasNext()) {
            QueryFunction.QueryAddRow(table);
            QueryFunction.QuerySetCell(table, "DATABASE_NAME", catlit.next());
            QueryFunction.QuerySetCell(table, "TYPE", "CATALOG");
        }
        ListIterator schmlit = schemaList.listIterator();
        while (schmlit.hasNext()) {
            QueryFunction.QueryAddRow(table);
            QueryFunction.QuerySetCell(table, "DATABASE_NAME", schmlit.next());
            QueryFunction.QuerySetCell(table, "TYPE", "SCHEMA");
        }
        return table;
    }

    public Table getColumns(String tableName, String pattern) throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        ResultSet rsColumns = null;
        String schema = null;
        if ((pattern = this.getCaseInsensitiveAttribute(pattern, dbMetaData)) != null && pattern.trim().equalsIgnoreCase("")) {
            pattern = null;
        }
        String origTableName = tableName = this.getCaseInsensitiveAttribute(tableName, dbMetaData);
        if (UNDERSCORE_WILDCARD_IN_TABLE_NAMES && tableName != null) {
            tableName = tableName.replaceAll("\\_", dbMetaData.getSearchStringEscape() + "\\_");
        }
        if (this.isCatalog) {
            int tIndex = tableName.indexOf(46);
            if (tIndex > 0) {
                schema = tableName.substring(0, tIndex);
                tableName = tableName.substring(tIndex + 1, tableName.length());
            }
            rsColumns = dbMetaData.getColumns(this.dsDatabaseName, schema, tableName, pattern);
        } else {
            rsColumns = this.isSchema ? dbMetaData.getColumns(null, this.dsDatabaseName, tableName, pattern) : dbMetaData.getColumns(null, null, tableName, pattern);
        }
        ResultSet rsPrimaryKeys = null;
        rsPrimaryKeys = this.isCatalog ? dbMetaData.getPrimaryKeys(this.dsDatabaseName, schema, origTableName) : (this.isSchema ? dbMetaData.getPrimaryKeys(null, this.dsDatabaseName, origTableName) : dbMetaData.getPrimaryKeys(null, null, origTableName));
        List listPrimaryKeys = this.getPrimaryKeysAsList(rsPrimaryKeys);
        ResultSet rsImportedKeys = null;
        rsImportedKeys = this.isCatalog ? dbMetaData.getImportedKeys(this.dsDatabaseName, schema, origTableName) : (this.isSchema ? dbMetaData.getImportedKeys(null, this.dsDatabaseName, origTableName) : dbMetaData.getImportedKeys(null, null, origTableName));
        Map mapFKInfo = this.getForeignkeyInfoAsMap(rsImportedKeys);
        QueryTable table = new QueryTable(0, this.getTypeColumns(TYPE_COLUMNS), this.getTypeColumnDataTypes(TYPE_COLUMNS));
        if (null == rsColumns) {
            return table;
        }
        while (rsColumns.next()) {
            QueryFunction.QueryAddRow(table);
            ArrayList colList = (ArrayList)metadatainfomap.get(TYPE_COLUMNS);
            ListIterator lit = colList.listIterator();
            String tabcolName = rsColumns.getString(COLUMN_NAME);
            while (lit.hasNext()) {
                String mappedVal;
                Object val;
                DBMetaDataColumnInfo dbColInfo = (DBMetaDataColumnInfo)lit.next();
                String colname = dbColInfo.getMappedColumnName();
                if (colname == null) {
                    colname = dbColInfo.getColumnName();
                }
                if (colname.equalsIgnoreCase("IS_PRIMARYKEY")) {
                    boolean isPrimaryKey = tabcolName != null ? listPrimaryKeys.contains(tabcolName) : false;
                    val = isPrimaryKey ? "YES" : "NO";
                    QueryFunction.QuerySetCell(table, colname, val);
                    continue;
                }
                if (colname.equalsIgnoreCase("IS_FOREIGNKEY")) {
                    boolean isForeignKey = tabcolName != null ? mapFKInfo.containsKey(tabcolName) : false;
                    val = isForeignKey ? "YES" : "NO";
                    QueryFunction.QuerySetCell(table, colname, val);
                    continue;
                }
                if (colname.equalsIgnoreCase("REFERENCED_PRIMARYKEY")) {
                    if (tabcolName != null && mapFKInfo.get(tabcolName) != null) {
                        String fkinfo = (String)mapFKInfo.get(tabcolName);
                        val = fkinfo.split(VALUE_SEPERATOR);
                        QueryFunction.QuerySetCell(table, colname, val[0]);
                        continue;
                    }
                    QueryFunction.QuerySetCell(table, colname, "N/A");
                    continue;
                }
                if (colname.equalsIgnoreCase("REFERENCED_PRIMARYKEY_TABLE")) {
                    if (tabcolName != null && mapFKInfo.get(tabcolName) != null) {
                        String fkinfo = (String)mapFKInfo.get(tabcolName);
                        val = fkinfo.split(VALUE_SEPERATOR);
                        QueryFunction.QuerySetCell(table, colname, val[1]);
                        continue;
                    }
                    QueryFunction.QuerySetCell(table, colname, "N/A");
                    continue;
                }
                if (dbColInfo.getColumnType() != null && dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_VARCHAR")) {
                    String val2 = rsColumns.getString(dbColInfo.getColumnName());
                    String mappedval = dbColInfo.getMappedValue(val2);
                    if (mappedval != null) {
                        val2 = mappedval;
                    }
                    if (dbColInfo.getColumnName().equals("IS_NULLABLE") && val2 != null) {
                        val2 = val2.trim();
                    }
                    QueryFunction.QuerySetCell(table, colname, val2);
                    continue;
                }
                if (dbColInfo.getColumnType() != null && dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_INTEGER")) {
                    int val3 = rsColumns.getInt(dbColInfo.getColumnName());
                    mappedVal = dbColInfo.getMappedValue(new Integer(val3).toString());
                    if (mappedVal != null) {
                        QueryFunction.QuerySetCell(table, colname, mappedVal);
                        continue;
                    }
                    QueryFunction.QuerySetCell(table, colname, new Integer(val3));
                    continue;
                }
                if (dbColInfo.getColumnType() == null || !dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_BIT")) continue;
                boolean val4 = rsColumns.getBoolean(dbColInfo.getColumnName());
                mappedVal = dbColInfo.getMappedValue(new Boolean(val4).toString());
                if (mappedVal != null) {
                    QueryFunction.QuerySetCell(table, colname, mappedVal);
                    continue;
                }
                String strVal = val4 ? "YES" : "NO";
                QueryFunction.QuerySetCell(table, colname, strVal);
            }
        }
        if (table.getRowCount() == 0 && !this.tableExists(tableName)) {
            throw new SQLException(RB.getString((Object)this, "DatabaseMetaDataUtil.1", (Object)origTableName));
        }
        return table;
    }

    private DatabaseMetaData getDatabaseMetaData() throws SQLException {
        if (this.dbMetaData == null) {
            this.dbMetaData = this.impl.getDataBaseMetaData();
        }
        return this.dbMetaData;
    }

    private List getPrimaryKeysAsList(ResultSet rsPrimaryKeys) throws SQLException {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        if (null == rsPrimaryKeys) {
            return primaryKeys;
        }
        while (rsPrimaryKeys.next()) {
            String colName = rsPrimaryKeys.getString(COLUMN_NAME);
            if (colName == null) continue;
            primaryKeys.add(colName);
        }
        return primaryKeys;
    }

    private Map getForeignkeyInfoAsMap(ResultSet rsImportedKeys) throws SQLException {
        HashMap<String, CallSite> foreignKeys = new HashMap<String, CallSite>();
        if (null == rsImportedKeys) {
            return foreignKeys;
        }
        while (rsImportedKeys.next()) {
            String foreignkeyname = rsImportedKeys.getString("FKCOLUMN_NAME");
            String primarykeyname = rsImportedKeys.getString("PKCOLUMN_NAME");
            String primarykeytable = rsImportedKeys.getString("PKTABLE_NAME");
            if (primarykeyname == null) {
                primarykeyname = " ";
            }
            if (primarykeytable == null) {
                primarykeyname = " ";
            }
            String value = primarykeyname + VALUE_SEPERATOR + primarykeytable;
            if (foreignkeyname == null) continue;
            foreignKeys.put(foreignkeyname, (CallSite)((Object)value));
        }
        return foreignKeys;
    }

    private Table formTableFromList(String type, List list) throws SQLException {
        QueryTable table = new QueryTable(0, this.getTypeColumns(type), this.getTypeColumnDataTypes(type));
        for (Map map : list) {
            QueryFunction.QueryAddRow(table);
            ArrayList colList = (ArrayList)metadatainfomap.get(type);
            ListIterator lit = colList.listIterator();
            while (lit.hasNext()) {
                DBMetaDataColumnInfo dbColInfo = (DBMetaDataColumnInfo)lit.next();
                String colname = dbColInfo.getMappedColumnName();
                if (colname == null) {
                    colname = dbColInfo.getColumnName();
                }
                QueryFunction.QuerySetCell(table, colname, map.get(colname));
            }
        }
        return table;
    }

    private Table formTableFromResultSet(String type, ResultSet rs) throws SQLException {
        QueryTable table = new QueryTable(0, this.getTypeColumns(type), this.getTypeColumnDataTypes(type));
        if (null == rs) {
            return table;
        }
        while (rs.next()) {
            QueryFunction.QueryAddRow(table);
            ArrayList colList = (ArrayList)metadatainfomap.get(type);
            ListIterator lit = colList.listIterator();
            while (lit.hasNext()) {
                String mappedVal;
                DBMetaDataColumnInfo dbColInfo = (DBMetaDataColumnInfo)lit.next();
                String colname = dbColInfo.getMappedColumnName();
                if (colname == null) {
                    colname = dbColInfo.getColumnName();
                }
                if (dbColInfo.getColumnType() != null && dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_VARCHAR")) {
                    String val = rs.getString(dbColInfo.getColumnName());
                    String mappedval = dbColInfo.getMappedValue(val);
                    if (mappedval != null) {
                        val = mappedval;
                    }
                    QueryFunction.QuerySetCell(table, colname, val);
                    continue;
                }
                if (dbColInfo.getColumnType() != null && dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_INTEGER")) {
                    int val = rs.getInt(dbColInfo.getColumnName());
                    mappedVal = dbColInfo.getMappedValue(new Integer(val).toString());
                    if (mappedVal != null) {
                        QueryFunction.QuerySetCell(table, colname, mappedVal);
                        continue;
                    }
                    QueryFunction.QuerySetCell(table, colname, new Integer(val));
                    continue;
                }
                if (dbColInfo.getColumnType() == null || !dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_BIT")) continue;
                boolean val = rs.getBoolean(dbColInfo.getColumnName());
                mappedVal = dbColInfo.getMappedValue(new Boolean(val).toString());
                if (mappedVal != null) {
                    QueryFunction.QuerySetCell(table, colname, mappedVal);
                    continue;
                }
                String strVal = val ? "YES" : "NO";
                QueryFunction.QuerySetCell(table, colname, strVal);
            }
        }
        return table;
    }

    private List formHashMapFromResultSet(String type, ResultSet rs) throws SQLException {
        ArrayList list = new ArrayList();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        if (null == rs) {
            return list;
        }
        int index = -1;
        while (rs.next()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            ArrayList colList = (ArrayList)metadatainfomap.get(type);
            ListIterator lit = colList.listIterator();
            while (lit.hasNext()) {
                String mappedVal;
                DBMetaDataColumnInfo dbColInfo = (DBMetaDataColumnInfo)lit.next();
                String colname = dbColInfo.getMappedColumnName();
                if (colname == null) {
                    colname = dbColInfo.getColumnName();
                }
                if (dbColInfo.getColumnType() != null && dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_VARCHAR")) {
                    String val = rs.getString(dbColInfo.getColumnName());
                    String mappedval = dbColInfo.getMappedValue(val);
                    if (mappedval != null) {
                        val = mappedval;
                    }
                    record.put(colname, val);
                    continue;
                }
                if (dbColInfo.getColumnType() != null && dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_INTEGER")) {
                    int val = rs.getInt(dbColInfo.getColumnName());
                    mappedVal = dbColInfo.getMappedValue(new Integer(val).toString());
                    if (mappedVal != null) {
                        record.put(colname, mappedVal);
                        continue;
                    }
                    record.put(colname, new Integer(val));
                    continue;
                }
                if (dbColInfo.getColumnType() == null || !dbColInfo.getColumnType().equalsIgnoreCase("CF_SQL_BIT")) continue;
                boolean val = rs.getBoolean(dbColInfo.getColumnName());
                mappedVal = dbColInfo.getMappedValue(new Boolean(val).toString());
                if (mappedVal != null) {
                    record.put(colname, mappedVal);
                    continue;
                }
                String strVal = val ? "YES" : "NO";
                record.put(colname, strVal);
            }
            String indexName = (String)record.get(INDEX_NAME);
            Object indexObj = indexMap.get(indexName);
            if (indexObj != null) {
                int i = (Integer)indexObj;
                Map oldRecord = (Map)list.get(i);
                this.mergeIndex(oldRecord, record);
                continue;
            }
            indexMap.put(indexName, new Integer(++index));
            list.add(record);
        }
        return list;
    }

    private void mergeIndex(Map m1, Map m2) {
        m1.put(COLUMN_NAME, m1.get(COLUMN_NAME) + ", " + m2.get(COLUMN_NAME));
        m1.put(ORDINAL_POSITION, m1.get(ORDINAL_POSITION) + ", " + m2.get(ORDINAL_POSITION));
    }

    private String[] getTableTypes(DatabaseMetaData dbMetaData) throws SQLException {
        ResultSet rsTabTypes = dbMetaData.getTableTypes();
        String[] tabTypes = null;
        ArrayList<String> rsList = new ArrayList<String>();
        if (null == rsTabTypes) {
            return tabTypes;
        }
        while (rsTabTypes.next()) {
            rsList.add(rsTabTypes.getString("TABLE_TYPE"));
        }
        tabTypes = rsList.toArray(new String[0]);
        return tabTypes;
    }

    private String[] getTypeColumns(String type) {
        ArrayList info = (ArrayList)metadatainfomap.get(type);
        String[] columns = new String[info.size()];
        ListIterator lit = info.listIterator();
        int i = 0;
        while (lit.hasNext()) {
            DBMetaDataColumnInfo colinfo = (DBMetaDataColumnInfo)lit.next();
            String columnname = colinfo.getMappedColumnName();
            if (columnname == null) {
                columnname = colinfo.getColumnName();
            }
            columns[i] = new String(columnname);
            ++i;
        }
        return columns;
    }

    private String[] getTypeColumnDataTypes(String type) {
        ArrayList info = (ArrayList)metadatainfomap.get(type);
        String[] columns = new String[info.size()];
        ListIterator lit = info.listIterator();
        int i = 0;
        while (lit.hasNext()) {
            DBMetaDataColumnInfo colinfo = (DBMetaDataColumnInfo)lit.next();
            String colType = colinfo.getMappedColType();
            if (colType == null) {
                colType = colinfo.getColumnType();
            }
            columns[i] = new String(colType);
            ++i;
        }
        return columns;
    }

    private List getCatalogs() throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        ResultSet rsCatalogs = dbMetaData.getCatalogs();
        ArrayList<String> catList = new ArrayList<String>();
        if (null == rsCatalogs) {
            return catList;
        }
        while (rsCatalogs.next()) {
            String cat = rsCatalogs.getString("TABLE_CAT");
            catList.add(cat);
        }
        return catList;
    }

    private List getSchemas() throws SQLException {
        DatabaseMetaData dbMetaData = this.getDatabaseMetaData();
        ResultSet rsSchemas = dbMetaData.getSchemas();
        ArrayList<String> schList = new ArrayList<String>();
        if (null == rsSchemas) {
            return schList;
        }
        while (rsSchemas.next()) {
            String cat = rsSchemas.getString("TABLE_SCHEM");
            schList.add(cat);
        }
        return schList;
    }

    static {
        UNDERSCORE_WILDCARD_IN_TABLE_NAMES = isJVMSecurityEnabled ? AccessController.doPrivileged(() -> Boolean.getBoolean("coldfusion.database.tablenames.wildcard.underscore")) : Boolean.getBoolean("coldfusion.database.tablenames.wildcard.underscore");
        ArrayList<DBMetaDataColumnInfo> versionColList = new ArrayList<DBMetaDataColumnInfo>();
        versionColList.add(new DBMetaDataColumnInfo("DATABASE_VERSION", "CF_SQL_VARCHAR", null, null));
        versionColList.add(new DBMetaDataColumnInfo("DATABASE_PRODUCTNAME", "CF_SQL_VARCHAR", null, null));
        versionColList.add(new DBMetaDataColumnInfo("DRIVER_VERSION", "CF_SQL_VARCHAR", null, null));
        versionColList.add(new DBMetaDataColumnInfo("DRIVER_NAME", "CF_SQL_VARCHAR", null, null));
        versionColList.add(new DBMetaDataColumnInfo("JDBC_MAJOR_VERSION", "CF_SQL_INTEGER", null, null));
        versionColList.add(new DBMetaDataColumnInfo("JDBC_MINOR_VERSION", "CF_SQL_INTEGER", null, null));
        metadatainfomap.put(TYPE_VERSION, versionColList);
        ArrayList<DBMetaDataColumnInfo> tabColList = new ArrayList<DBMetaDataColumnInfo>();
        tabColList.add(new DBMetaDataColumnInfo("TABLE_NAME", "CF_SQL_VARCHAR", null, null));
        tabColList.add(new DBMetaDataColumnInfo("TABLE_TYPE", "CF_SQL_VARCHAR", null, null));
        tabColList.add(new DBMetaDataColumnInfo("REMARKS", "CF_SQL_VARCHAR", null, null));
        metadatainfomap.put(TYPE_TABLES, tabColList);
        ArrayList<DBMetaDataColumnInfo> procColList = new ArrayList<DBMetaDataColumnInfo>();
        procColList.add(new DBMetaDataColumnInfo("PROCEDURE_NAME", "CF_SQL_VARCHAR", null, null));
        procColList.add(new DBMetaDataColumnInfo("REMARKS", "CF_SQL_VARCHAR", null, null));
        DBMetaDataColumnInfo procType = new DBMetaDataColumnInfo("PROCEDURE_TYPE", "CF_SQL_INTEGER", null, "CF_SQL_VARCHAR");
        procType.setMappedValue(new Integer(2).toString(), "Returns Result");
        procType.setMappedValue(new Integer(1).toString(), "Does Not Return Result");
        procType.setMappedValue(new Integer(0).toString(), "May Return Result");
        procColList.add(procType);
        metadatainfomap.put(TYPE_PROCEDURES, procColList);
        ArrayList<DBMetaDataColumnInfo> indexColList = new ArrayList<DBMetaDataColumnInfo>();
        indexColList.add(new DBMetaDataColumnInfo(INDEX_NAME, "CF_SQL_VARCHAR", null, null));
        DBMetaDataColumnInfo indexType = new DBMetaDataColumnInfo("TYPE", "CF_SQL_INTEGER", null, "CF_SQL_VARCHAR");
        indexType.setMappedValue(new Integer(0).toString(), "Table Statistic");
        indexType.setMappedValue(new Integer(1).toString(), "Clustered Index");
        indexType.setMappedValue(new Integer(2).toString(), "Hashed Index");
        indexType.setMappedValue(new Integer(3).toString(), "Other Index");
        indexColList.add(indexType);
        indexColList.add(new DBMetaDataColumnInfo(COLUMN_NAME, "CF_SQL_VARCHAR", null, null));
        indexColList.add(new DBMetaDataColumnInfo(ORDINAL_POSITION, "CF_SQL_VARCHAR", null, null));
        indexColList.add(new DBMetaDataColumnInfo("NON_UNIQUE", "CF_SQL_BIT", null, "CF_SQL_VARCHAR"));
        indexColList.add(new DBMetaDataColumnInfo(CARDINALITY, "CF_SQL_INTEGER", null, null));
        indexColList.add(new DBMetaDataColumnInfo("PAGES", "CF_SQL_INTEGER", null, null));
        metadatainfomap.put(TYPE_INDEX, indexColList);
        ArrayList<DBMetaDataColumnInfo> fkColList = new ArrayList<DBMetaDataColumnInfo>();
        fkColList.add(new DBMetaDataColumnInfo("FKCOLUMN_NAME", "CF_SQL_VARCHAR", null, null));
        fkColList.add(new DBMetaDataColumnInfo("FKTABLE_NAME", "CF_SQL_VARCHAR", null, null));
        fkColList.add(new DBMetaDataColumnInfo("PKCOLUMN_NAME", "CF_SQL_VARCHAR", null, null));
        DBMetaDataColumnInfo updateRule = new DBMetaDataColumnInfo("UPDATE_RULE", "CF_SQL_INTEGER", null, "CF_SQL_VARCHAR");
        updateRule.setMappedValue(new Integer(3).toString(), "do not allow update of primary key if it has been referenced");
        updateRule.setMappedValue(new Integer(0).toString(), "change foreign key to agree with primary key update");
        updateRule.setMappedValue(new Integer(2).toString(), "change foreign key to NULL if its primary key has been updated");
        updateRule.setMappedValue(new Integer(4).toString(), "change foreign key to default values if its primary key has been updated");
        updateRule.setMappedValue(new Integer(1).toString(), "do not allow update of primary key if it has been referenced");
        fkColList.add(updateRule);
        DBMetaDataColumnInfo deleteRule = new DBMetaDataColumnInfo("DELETE_RULE", "CF_SQL_INTEGER", null, "CF_SQL_VARCHAR");
        deleteRule.setMappedValue(new Integer(3).toString(), "do not allow delete of primary key if it has been referenced");
        deleteRule.setMappedValue(new Integer(0).toString(), "delete rows that refer a deleted key");
        deleteRule.setMappedValue(new Integer(2).toString(), "change foreign key to NULL if its primary key has been deleted");
        deleteRule.setMappedValue(new Integer(4).toString(), "change foreign key to default if its primary key has been deleted");
        deleteRule.setMappedValue(new Integer(1).toString(), "do not allow delete of primary key if it has been referenced");
        fkColList.add(deleteRule);
        metadatainfomap.put(TYPE_FOREIGNKEYS, fkColList);
        ArrayList<DBMetaDataColumnInfo> columnsColList = new ArrayList<DBMetaDataColumnInfo>();
        columnsColList.add(new DBMetaDataColumnInfo(COLUMN_NAME, "CF_SQL_VARCHAR", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("TYPE_NAME", "CF_SQL_VARCHAR", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("COLUMN_SIZE", "CF_SQL_INTEGER", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("DECIMAL_DIGITS", "CF_SQL_INTEGER", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("IS_NULLABLE", "CF_SQL_VARCHAR", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("REMARKS", "CF_SQL_VARCHAR", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("COLUMN_DEF", "CF_SQL_VARCHAR", "COLUMN_DEFAULT_VALUE", null));
        columnsColList.add(new DBMetaDataColumnInfo("CHAR_OCTET_LENGTH", "CF_SQL_INTEGER", null, null));
        columnsColList.add(new DBMetaDataColumnInfo(ORDINAL_POSITION, "CF_SQL_INTEGER", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("IS_PRIMARYKEY", "CF_SQL_VARCHAR", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("IS_FOREIGNKEY", "CF_SQL_VARCHAR", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("REFERENCED_PRIMARYKEY", "CF_SQL_VARCHAR", null, null));
        columnsColList.add(new DBMetaDataColumnInfo("REFERENCED_PRIMARYKEY_TABLE", "CF_SQL_VARCHAR", null, null));
        metadatainfomap.put(TYPE_COLUMNS, columnsColList);
        ArrayList<DBMetaDataColumnInfo> clientInfoColList = new ArrayList<DBMetaDataColumnInfo>();
        clientInfoColList.add(new DBMetaDataColumnInfo("NAME", "CF_SQL_VARCHAR", null, null));
        clientInfoColList.add(new DBMetaDataColumnInfo("MAX_LEN", "CF_SQL_INTEGER", null, null));
        clientInfoColList.add(new DBMetaDataColumnInfo("DEFAULT_VALUE", "CF_SQL_VARCHAR", null, null));
        clientInfoColList.add(new DBMetaDataColumnInfo("DESCRIPTION", "CF_SQL_VARCHAR", null, null));
        metadatainfomap.put(TYPE_CLIENTINFO, clientInfoColList);
    }

    public class OperationNotSupportedException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;

        public OperationNotSupportedException(Throwable ex) {
            super(ex);
        }
    }
}

