/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.monitor.Configuration;
import coldfusion.rds.RdsServlet;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFNumber;
import coldfusion.runtime.Cast;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.Struct;
import coldfusion.security.UserUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.DataSourceService;
import coldfusion.server.MetricsService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.j2ee.sql.JRunCallableStatement;
import coldfusion.server.j2ee.sql.JRunConnectionHandle;
import coldfusion.server.j2ee.sql.JRunStatement;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.CFDataSourceProxy;
import coldfusion.sql.CFNoResultSetTable;
import coldfusion.sql.CacheDetails;
import coldfusion.sql.CachedQuery;
import coldfusion.sql.DataSourceCreateException;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.DataSourceFactory;
import coldfusion.sql.ParameterList;
import coldfusion.sql.QueryDetails;
import coldfusion.sql.QueryTable;
import coldfusion.sql.Table;
import coldfusion.sql.TwoFishCryptor;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.util.LruCache;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.sql.DataSource;

public class Executive
extends ServiceBase
implements DataSourceService,
Observer {
    protected TwoFishCryptor cryptor = new TwoFishCryptor();
    private static final String OLDSEEDVAL = "0yJ!@1$r8p0L@r1$6yJ!@1rj";
    static final String MAX_CACHE_COUNT = "maxcachecount";
    static final boolean MSSQL_OSS_MULTIPLERESULTSSET = Boolean.parseBoolean(System.getProperty("coldfusion.jdbc.mssql.multi_resultset.supported", "false"));
    private static final String br = System.getProperty("line.separator");
    private String _rootDir;
    private File driversfile;
    private File datasourcefile;
    private ConfigMap drivers;
    private ConfigMap datasources;
    private ConfigMap defaults;
    private ConfigMap max_cache;
    private ConfigMap adobe_driver_version;
    private String seed;
    private ConfigMap copy;
    private String vendorClassName;
    private Map<Integer, CacheDetails> cachedQueryMap;
    private static final String SEMICOLON = ";";
    private static Executive instance = null;
    private LruCache query_cache = new LruCache(){

        @Override
        protected Object fetch(Object key) {
            return null;
        }
    };
    private LruCache query_cache2 = new LruCache(){

        @Override
        protected Object fetch(Object key) {
            return null;
        }
    };

    public Executive(File driversfile, File datasourcefile, String rootDir) {
        this.driversfile = driversfile;
        this.datasourcefile = datasourcefile;
        this._rootDir = rootDir;
        this.setEnableWatch(true);
        this.setWatchFile(driversfile);
        this.setWatchFile(datasourcefile);
        instance = this;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        if (this.isFirstLoad()) {
            PasswordUtils.getInstance().addObserver(this);
            CentralConfigClientUtil.delayStore(this);
        }
    }

    @Override
    public Map getDatasources() {
        if (!RdsServlet.getAuthenticated()) {
            ServiceFactory.getSecurityService().authenticateAdmin();
        }
        return this.datasources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getSMDatasources() {
        ConfigMap copy;
        if (!RdsServlet.getAuthenticated()) {
            ServiceFactory.getSecurityService().authenticateAdmin();
        }
        try {
            copy = ConfigMap.toConfigMap(this.datasources.duplicate(null));
        }
        catch (IllegalAccessException e1) {
            copy = this.datasources;
        }
        ConfigMap configMap = copy;
        synchronized (configMap) {
            Iterator i = copy.keySet().iterator();
            while (i.hasNext()) {
                String dsn = null;
                try {
                    dsn = (String)i.next();
                    ConfigMap ds = (ConfigMap)copy.get(dsn);
                    try {
                        String oldPass = (String)ds.get("password");
                        ds.put("password", (Object)PasswordUtils.reEncryptForSM(oldPass, this.seed, OLDSEEDVAL));
                    }
                    catch (Exception e) {
                        CFLogs.SERVER_LOG.error(e);
                    }
                }
                catch (Exception se) {
                    CFLogs.SERVER_LOG.warn("Datasource Exception in Encryption with new Seed: " + dsn, se);
                }
            }
        }
        return copy;
    }

    @Override
    public Map getDrivers() {
        return this.drivers;
    }

    @Override
    public Map getDefaults() {
        return this.defaults;
    }

    @Override
    public void setDefaults(Map defs) {
        this.defaults = (ConfigMap)defs;
        try {
            this.store();
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public List getNames() {
        return DataSourceFactory.getInstance().getDataSourceNames();
    }

    @Override
    public Number getMaxQueryCount() {
        return (Number)this.max_cache.get(MAX_CACHE_COUNT);
    }

    public String getAdobeDriverVersion() {
        return (String)this.adobe_driver_version.get("adobedriverversion");
    }

    @Override
    public synchronized void setMaxQueryCount(Number count) {
        this.max_cache.put(MAX_CACHE_COUNT, (Object)new Integer(count.intValue()));
        this.setMaxCacheQueryCount(((Number)this.max_cache.get(MAX_CACHE_COUNT)).intValue(), true);
        try {
            this.store();
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            DataSourceFactory.getInstance().clear();
            this.datasources = new ConfigMap(this, "datasources");
            Vector vQuerySettings = (Vector)this.deserialize(this.driversfile);
            Vector vDataSource = this.loadDataSourceConfig();
            this.drivers = (ConfigMap)vQuerySettings.elementAt(0);
            this.defaults = (ConfigMap)vQuerySettings.elementAt(1);
            this.adobe_driver_version = (ConfigMap)vQuerySettings.elementAt(2);
            ConfigMap _datasources = (ConfigMap)vDataSource.elementAt(0);
            this.max_cache = (ConfigMap)vDataSource.elementAt(1);
            for (String name : _datasources.keySet()) {
                ConfigMap c_M = (ConfigMap)_datasources.get(name);
                c_M.init(this, "datasource");
                DataSourceDef def = new DataSourceDef(c_M);
                try {
                    DataSourceFactory.getInstance().setDataSource(name, def);
                }
                catch (Exception se) {
                    CFLogs.SERVER_LOG.warn("Datasource not found: " + name, se);
                }
                this.datasources.put(name, (Object)c_M);
                ConfigMap urlmap = (ConfigMap)c_M.get("urlmap");
                if (urlmap != null) {
                    if (urlmap.get("spyLogFile") == null) {
                        urlmap.put("spyLogFile", (Object)"");
                    }
                    if (urlmap.get("useSpyLog") == null) {
                        urlmap.put("useSpyLog", (Object)Boolean.FALSE);
                    }
                    if ("Oracle".equalsIgnoreCase((String)c_M.get("DRIVER")) && urlmap.get("supportLinks") == null) {
                        urlmap.put("supportLinks", (Object)Boolean.TRUE);
                    }
                    urlmap.init(this, "urlmap");
                    urlmap.setConfigMapListener(this);
                }
                ConfigMap clientinfo = (ConfigMap)c_M.get("clientinfo");
                clientinfo.init(this, "clientinfo");
                clientinfo.setConfigMapListener(this);
            }
            this.datasources.setConfigMapListener(this);
            this.max_cache.setConfigMapListener(this);
            this.query_cache.setSize(((Number)this.max_cache.get(MAX_CACHE_COUNT)).intValue());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw new ServiceException(ex);
        }
    }

    Vector loadDataSourceConfig() {
        return (Vector)this.deserialize(this.datasourcefile);
    }

    private void setMaxCacheQueryCount(int count, boolean forceSet) {
        AppHelper.setMaxQueryCount(count, forceSet);
    }

    private DataSourceDef getDSDef(String dsn) {
        return DataSourceFactory.getInstance().getDataSourceDef(dsn);
    }

    @Override
    public void mapModified() {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key) {
        if (map == this.datasources) {
            try {
                this.removeDatasource(key.toString());
            }
            catch (SQLException sqle) {
                throw new ServiceRuntimeException(sqle);
            }
        }
        try {
            this.store(key, "", "DELETION");
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value, Object oldValue) {
        this.mapModified(map, key, value, oldValue, true);
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value, Object oldValue, boolean broadCast) {
        if (map == this.datasources) {
            ConfigMap m = (ConfigMap)value;
            m.put("ISJ2EE", (Object)Boolean.FALSE);
            String dsn = (String)m.get("name");
            DataSourceDef def = new DataSourceDef(m);
            try {
                DataSourceFactory.getInstance().setDataSource(dsn, def);
            }
            catch (SQLException sqle) {
                throw new DataSourceCreateException(sqle, dsn);
            }
        }
        try {
            this.store(key, value, oldValue, broadCast);
        }
        catch (ServiceBase.CCSEnabledButNotAvailableException ex) {
            CFLogs.SERVER_LOG.error(ex);
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value) {
        this.mapModified(map, key, value, null);
    }

    @Override
    public String encryptPassword(String p) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        return PasswordUtils.encryptPassword(p, this.seed);
    }

    @Override
    public void store() throws ServiceException {
        this.store(null, null, null, true);
    }

    @Override
    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        try {
            this.updateDataSourcesForMonitoring();
        }
        catch (Throwable th) {
            CFLogs.SERVER_LOG.error(th);
        }
        Vector<ConfigMap> vDrivers = new Vector<ConfigMap>();
        Vector<ConfigMap> vDatasources = new Vector<ConfigMap>();
        vDrivers.addElement(this.drivers);
        vDrivers.addElement(this.defaults);
        vDrivers.addElement(this.adobe_driver_version);
        if (Boolean.getBoolean("coldfusion.migrate.dsnloadonce")) {
            ConfigMap configMap = this.datasources;
            synchronized (configMap) {
                if (this.copy == null) {
                    this.copy = new ConfigMap(this, "datasources");
                }
                for (Object dsn : this.datasources.keySet()) {
                    if (this.copy.containsKey(dsn)) continue;
                    ConfigMap ds = (ConfigMap)this.datasources.get(dsn);
                    ConfigMap clon = new ConfigMap(this, "datasource");
                    clon.putAll((Map)ds);
                    this.copy.put(dsn, (Object)clon);
                }
                vDatasources.addElement(this.copy);
            }
        }
        ConfigMap configMap = this.datasources;
        synchronized (configMap) {
            ConfigMap copy = new ConfigMap(this, "datasources");
            for (Object dsn : this.datasources.keySet()) {
                ConfigMap ds = (ConfigMap)this.datasources.get(dsn);
                ConfigMap clon = new ConfigMap(this, "datasource");
                clon.putAll((Map)ds);
                copy.put(dsn, (Object)clon);
            }
            vDatasources.addElement(copy);
        }
        vDatasources.addElement(this.max_cache);
        this.serialize(vDrivers, this.driversfile, broadcast, key, value, oldValue);
        this.serialize(vDatasources, this.datasourcefile, broadcast, key, value, oldValue);
    }

    @Override
    public String getDbdir() {
        return this._rootDir + "/db";
    }

    private void updateDataSourcesForMonitoring() {
        Vector vDataSource = this.loadDataSourceConfig();
        ConfigMap _datasources = (ConfigMap)vDataSource.elementAt(0);
        Iterator keys = _datasources.keySet().iterator();
        while (keys.hasNext()) {
            try {
                String name = (String)keys.next();
                CFDataSource source = DataSourceFactory.getInstance().getDataSource(name);
                Struct strt = new Struct();
                strt.put("host", (Object)source.getDataSourceDef().getHost());
                strt.put("port", (Object)source.getDataSourceDef().getPort());
                strt.put("vendor", (Object)source.getDataSourceDef().getVendor());
                strt.put("db_server_name", (Object)source.getDataSourceDef().getDatabase());
                Configuration.INSTANCE.getDataSourcesMap().put(name, strt);
            }
            catch (Throwable th) {
                CFLogs.SERVER_LOG.error(th);
            }
        }
    }

    @Override
    public void removeDatasource(String dsn) throws SQLException {
        DataSourceFactory.getInstance().removeDataSource(dsn);
    }

    @Override
    public String checkAllowedFileExtensions(String file) {
        return DataSourceDef.checkAllowedFileExtensions(file);
    }

    @Override
    public boolean verifyDatasource(String dsn) {
        Connection conn1 = null;
        try {
            DataSource ds;
            DataSourceDef bean;
            if (!DataSourceDef.BLOCKED_PROPERTIES.isEmpty() && (bean = this.getDSDef(dsn.toLowerCase())) != null) {
                try {
                    bean.validateBlockedProperties();
                }
                catch (Exception e) {
                    this.removeDatasource(dsn);
                    throw e;
                }
            }
            if ((ds = this.getDatasource1(dsn)) == null) {
                throw new ConnectionVerificationFailedException(new Exception("Datasource not found - Datasource may not be available to ColdFusion"));
            }
            conn1 = ds.getConnection();
            boolean e = conn1 != null;
            return e;
        }
        catch (SQLException ex) {
            CFLogs.SERVER_LOG.error(ex);
            Throwable toThrow = this.getRealExceptionForDerby(ex);
            throw new ConnectionVerificationFailedException(toThrow);
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(ex);
            throw new ConnectionVerificationFailedException(ex);
        }
        finally {
            try {
                if (conn1 != null) {
                    conn1.close();
                }
            }
            catch (SQLException ex) {
                this.warning(ex.getMessage());
            }
        }
    }

    private Throwable getRealExceptionForDerby(SQLException ex) {
        SQLException next = ex.getNextException();
        Throwable cause = ex.getCause();
        if (next != null && next.getClass().getName().equals("org.apache.derby.impl.jdbc.EmbedSQLException")) {
            return next;
        }
        if (cause != null && cause.getClass().getName().equals("org.apache.derby.impl.jdbc.EmbedSQLException")) {
            return cause;
        }
        return ex;
    }

    @Override
    public DataSource getDatasource(String dsn) throws SQLException {
        if (!RdsServlet.getAuthenticated()) {
            try {
                ServiceFactory.getSecurityService().authenticateAdmin();
            }
            catch (Throwable e) {
                return new CFDataSourceProxy(DataSourceFactory.getInstance().getDataSource(dsn));
            }
        }
        return DataSourceFactory.getInstance().getDataSource(dsn);
    }

    DataSource getDatasource1(String dsn) throws SQLException {
        return DataSourceFactory.getInstance().getDataSource(dsn);
    }

    @Override
    public boolean datasourceExists(String dsn) {
        try {
            DataSource ds = this.getDatasource1(dsn);
            if (ds != null) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    private boolean isSQLServerDriver(Statement statement) {
        return statement instanceof JRunStatement && ((JRunStatement)statement).getNativeStatement().toString().startsWith("SQLServerStatement") || statement instanceof JRunCallableStatement && ((JRunCallableStatement)statement).getNativeCallableStatement().toString().startsWith("SQLServerCallableStatement");
    }

    private Table getRowSet(Statement stmt, boolean results, int[] rset_list, Integer rows, int maxBlobSize, int maxClobSize, boolean useBlob, boolean useClob, boolean supportsMultipleResults, boolean supportsGeneratedKeys) throws SQLException {
        if (rset_list != null && rset_list.length == 0) {
            return null;
        }
        boolean isSqlServerOSSDriver = MSSQL_OSS_MULTIPLERESULTSSET && this.isSQLServerDriver(stmt);
        Table curr = null;
        int updateCount = stmt.getUpdateCount();
        while (results || updateCount != -1) {
            if (RequestMonitor.isRequestTimedOut()) {
                throw new RequestTimedOutException("CFQUERY");
            }
            if (results) {
                QueryTable tempQT;
                curr = tempQT = new QueryTable();
                tempQT.setMaxBlobSize(maxBlobSize);
                tempQT.setMaxClobSize(maxClobSize);
                tempQT.setBlobEnabled(useBlob);
                tempQT.setClobEnabled(useClob);
                ResultSet rset = stmt.getResultSet();
                if (rows != null) {
                    tempQT.populate(rset, (int)rows);
                } else {
                    tempQT.populate(rset);
                }
                this.close(rset);
                return curr;
            }
            if (isSqlServerOSSDriver) {
                results = stmt.getMoreResults();
                updateCount = stmt.getUpdateCount();
                if (results) continue;
            }
            if (curr == null && updateCount > -1) {
                if (supportsGeneratedKeys) {
                    try {
                        curr = new CFNoResultSetTable(stmt.getGeneratedKeys());
                        if (((CFNoResultSetTable)curr).getGeneratedKeysMap() == null) {
                            curr = null;
                        } else if (updateCount > 1 && ((CFNoResultSetTable)curr).getUpdateCount() == 1) {
                            ((CFNoResultSetTable)curr).setUpdateCount(updateCount);
                        }
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                if (curr == null) {
                    curr = new CFNoResultSetTable(updateCount);
                }
            }
            if (!supportsMultipleResults) break;
            results = stmt.getMoreResults();
            updateCount = stmt.getUpdateCount();
            if (curr == null || ((CFNoResultSetTable)curr).getGeneratedKeysMap() != null || updateCount <= ((CFNoResultSetTable)curr).getUpdateCount()) continue;
            curr = null;
        }
        return curr;
    }

    private QueryTable initializeQueryTable(int maxBlobSize, int maxClobSize, boolean useBlob, boolean useClob) {
        QueryTable queryTable = new QueryTable();
        queryTable.setMaxBlobSize(maxBlobSize);
        queryTable.setMaxClobSize(maxClobSize);
        queryTable.setBlobEnabled(useBlob);
        queryTable.setClobEnabled(useClob);
        return queryTable;
    }

    private Table getRowSetsForRefCursorsInPostgres(ResultSet resultSet, int[] rset_rows, int index, int maxBlobSize, int maxClobSize, boolean useBlob, boolean useClob) throws SQLException {
        int col = 0;
        QueryTable head = null;
        QueryTable prev = null;
        QueryTable curr = null;
        while (resultSet.next()) {
            while (col < rset_rows.length) {
                curr = this.initializeQueryTable(maxBlobSize, maxClobSize, useBlob, useClob);
                curr.populate((ResultSet)resultSet.getObject(col + 1), rset_rows[index]);
                if (head == null) {
                    head = curr;
                } else {
                    curr.setPreviousTable(prev);
                    prev.setNextTable(curr);
                }
                prev = curr;
                ++index;
                ++col;
            }
        }
        this.close(resultSet);
        return head;
    }

    private boolean isPostGresRefCursor(String vendorClassName, ResultSetMetaData rsmd) throws SQLException {
        return vendorClassName.equalsIgnoreCase("org.postgresql.Driver") && rsmd.getColumnCount() > 0 && rsmd.getColumnType(1) == 2012;
    }

    private Table getRowSets(Statement stmt, boolean results, int[] rset_list, int[] rset_rows, int maxBlobSize, int maxClobSize, boolean useBlob, boolean useClob) throws SQLException {
        if (rset_list != null && rset_list.length == 0) {
            return null;
        }
        QueryTable head = null;
        QueryTable prev = null;
        int iteration = 0;
        int index = 0;
        while (results || stmt.getUpdateCount() != -1) {
            if (RequestMonitor.isRequestTimedOut()) {
                throw new RequestTimedOutException("CFSTOREDPROC");
            }
            ResultSet rset = stmt.getResultSet();
            if (rset != null && this.isPostGresRefCursor(this.vendorClassName, rset.getMetaData())) {
                return this.getRowSetsForRefCursorsInPostgres(rset, rset_rows, index, maxBlobSize, maxClobSize, useBlob, useClob);
            }
            if ((rset_list == null || index < rset_list.length && rset_list[index] == iteration) && results) {
                curr = this.initializeQueryTable(maxBlobSize, maxClobSize, useBlob, useClob);
                if (rset_rows != null) {
                    curr.populate(rset, rset_rows[index]);
                } else {
                    curr.populate(rset);
                }
                ++iteration;
                if (head == null) {
                    head = curr;
                } else {
                    curr.setPreviousTable(prev);
                    prev.setNextTable(curr);
                }
                prev = curr;
                ++index;
            } else if (results) {
                curr = this.initializeQueryTable(maxBlobSize, maxClobSize, useBlob, useClob);
                if (rset_rows != null) {
                    curr.populate(rset, 0);
                } else {
                    curr.populate(rset);
                }
                ++iteration;
                this.close(rset);
            }
            results = stmt.getMoreResults();
        }
        return head;
    }

    private void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            this.debug(sqle.getMessage());
            sqle.printStackTrace();
        }
    }

    @Override
    public boolean disableConnection(String dsn) {
        DataSourceDef bean = this.getDSDef(dsn.toLowerCase());
        return bean != null && !bean.isConnectionEnabled;
    }

    private String findSqlKeyword(String sql) {
        int index1 = sql.indexOf(32);
        int index2 = sql.indexOf(9);
        int index3 = sql.indexOf(br);
        if (index1 == -1) {
            index1 = index2 == -1 ? (index3 == -1 ? -1 : index3) : (index3 == -1 ? index2 : (index2 < index3 ? index2 : index3));
        } else if (index2 == -1) {
            if (index3 != -1) {
                index1 = index1 < index3 ? index1 : index3;
            }
        } else if (index3 == -1) {
            index1 = index1 < index2 ? index1 : index2;
        } else {
            index1 = index1 < index2 ? index1 : index2;
            index1 = index1 < index3 ? index1 : index3;
        }
        String token = index1 != -1 ? sql.substring(0, index1).trim() : sql;
        return token;
    }

    @Override
    public Table executeCall(Connection con, String sql, ParameterList params, int[] rset_rows, Integer timeout, Integer fetch, int[] rset_list, Object dsn, Struct clientInfo) throws SQLException {
        if (dsn instanceof String) {
            return this.executeCall(con, sql, params, rset_rows, timeout, fetch, rset_list, (String)dsn, clientInfo);
        }
        if (dsn instanceof CFDataSource) {
            DataSourceDef def = ((CFDataSource)dsn).getDataSourceDef();
            return this.executeCall(con, sql, params, rset_rows, timeout, fetch, rset_list, def, clientInfo);
        }
        return null;
    }

    @Override
    public Table executeCall(Connection con, String sql, ParameterList params, int[] rset_rows, Integer timeout, Integer fetch, int[] rset_list, String dsn, Struct clientInfo) throws SQLException {
        DataSourceDef bean = this.getDSDef(dsn.toLowerCase());
        return this.executeCall(con, sql, params, rset_rows, timeout, fetch, rset_list, bean, clientInfo);
    }

    @Override
    public Table executeCall(Connection con, String sql, ParameterList params, int[] rset_rows, Integer timeout, Integer fetch, int[] rset_list, DataSourceDef bean, Struct clientInfo) throws SQLException {
        this.vendorClassName = bean.getClassName();
        if (bean == null) {
            return this.executeCall(con, sql, params, rset_rows, timeout, fetch, rset_list, 64000, 64000, true, true, clientInfo);
        }
        Object obj = bean.get("storedproc");
        boolean isAllowedSql = obj == null ? true : (obj instanceof Boolean ? (Boolean)obj : false);
        clientInfo = this.prepareClientInfo(bean, clientInfo);
        if (isAllowedSql) {
            return this.executeCall(con, sql, params, rset_rows, timeout, fetch, rset_list, bean.maxBlobSize, bean.maxClobSize, bean.isBlobEnabled, bean.isClobEnabled, clientInfo);
        }
        throw new SQLException(RB.getString(this, "Executive.1"));
    }

    private Struct prepareClientInfo(DataSourceDef bean, Struct clientInfo) {
        String appPrefix;
        Struct clientInfoProperties;
        if (clientInfo == null) {
            clientInfo = new Struct();
        }
        if (Cast._boolean((clientInfoProperties = bean.getClientInfoProperties()).get("ClientHostName")) && !clientInfo.containsKey("ClientHostName")) {
            String host = FusionContext.getCurrent().getRequest().getServerName();
            clientInfo.put("ClientHostName", (Object)host);
        }
        if (Cast._boolean(clientInfoProperties.get("ClientUser")) && !clientInfo.containsKey("ClientUser")) {
            clientInfo.put("ClientUser", (Object)UserUtils.getAuthUser());
        }
        if (Cast._boolean(clientInfoProperties.get("ApplicationName")) && !clientInfo.containsKey("ApplicationName") && (appPrefix = Cast._String(clientInfoProperties.get("ApplicationNamePrefix"))) != null && appPrefix.length() > 0) {
            String appname = FusionContext.getCurrent().getApplicationName();
            clientInfo.put("ApplicationName", (Object)(appPrefix + appname));
        }
        return clientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table executeCall(Connection con, String sql, ParameterList params, int[] rset_rows, Integer timeout, Integer fetch, int[] rset_list, int maxBlobSize, int maxClobSize, boolean useBlob, boolean useClob, Struct clientInfo) throws SQLException, ClientInfoException, UnsupportedOperationException {
        this.setupClientInfo(con, clientInfo);
        CallableStatement stmt = null;
        long start = System.currentTimeMillis();
        try {
            int maxResultSize;
            sql = sql == null ? "" : sql.trim();
            stmt = con.prepareCall(sql);
            if (fetch != null) {
                try {
                    stmt.setFetchSize(fetch);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (timeout != null) {
                try {
                    stmt.setQueryTimeout(timeout);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((maxResultSize = this.getMaxResultSetSize(rset_rows)) >= 0) {
                try {
                    stmt.setMaxRows(maxResultSize);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!useBlob && !useClob) {
                try {
                    int fieldsize;
                    int n = fieldsize = maxClobSize > maxBlobSize ? maxClobSize : maxBlobSize;
                    if (fieldsize < 256) {
                        fieldsize = 256;
                    }
                    stmt.setMaxFieldSize(fieldsize);
                }
                catch (Throwable fieldsize) {
                    // empty catch block
                }
            }
            if (params != null) {
                params.setStatement(stmt);
            }
            Table curr = this.getRowSets(stmt, stmt.execute(), rset_list, rset_rows, maxBlobSize, maxClobSize, useBlob, useClob);
            if (params != null) {
                params.setOutParameters(stmt);
            }
            Table table = curr;
            return table;
        }
        finally {
            try {
                MetricsService ms = ServiceFactory.getMetricsService();
                long end = System.currentTimeMillis();
                ms.updateMetric("DBHits", (int)(end - start));
            }
            catch (ServiceFactory.ServiceNotAvailableException serviceNotAvailableException) {}
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private int getMaxResultSetSize(int[] resultSetSize) {
        int maxSize = -1;
        if (resultSetSize != null) {
            for (int x = 0; x < resultSetSize.length; ++x) {
                if (resultSetSize[x] == 0 || resultSetSize[x] == -1) {
                    maxSize = 0;
                    break;
                }
                if (maxSize >= resultSetSize[x]) continue;
                maxSize = resultSetSize[x];
            }
        }
        return maxSize;
    }

    @Override
    public Table executeQuery(Connection con, String sql, ParameterList params, Integer rset_rows, Integer timeout, Integer fetch, int[] rset_list, Object dsn, Struct clientInfo) throws SQLException {
        if (dsn instanceof String) {
            return this.executeQuery(con, sql, params, rset_rows, timeout, fetch, rset_list, (String)dsn, clientInfo);
        }
        if (dsn instanceof CFDataSource) {
            DataSourceDef def = ((CFDataSource)dsn).getDataSourceDef();
            return this.executeQuery(con, sql, params, rset_rows, timeout, fetch, rset_list, def, clientInfo);
        }
        return null;
    }

    @Override
    public Table executeQuery(Connection con, String sql, ParameterList params, Integer rset_rows, Integer timeout, Integer fetch, int[] rset_list, String dsn, Struct clientInfo) throws SQLException {
        DataSourceDef bean = this.getDSDef(dsn.toLowerCase());
        return this.executeQuery(con, sql, params, rset_rows, timeout, fetch, rset_list, bean, clientInfo);
    }

    @Override
    public Table executeQuery(Connection con, String sql, ParameterList params, Integer rows, Integer timeout, Integer fetch, int[] rset_list, DataSourceDef bean, Struct clientInfo) throws SQLException {
        sql = sql == null ? "" : sql.trim();
        boolean isAllowedSql = true;
        if (bean == null) {
            return this.executeQuery(con, sql, params, rows, timeout, fetch, rset_list, 64000, 64000, true, true, false, clientInfo);
        }
        if (bean.isSQLRestricted()) {
            String[] sqlStmts = sql.split(SEMICOLON);
            int sqlStmtsLength = sqlStmts.length;
            for (int i = 0; i < sqlStmtsLength && isAllowedSql; ++i) {
                String token = this.findSqlKeyword(sqlStmts[i].trim());
                Object obj = bean.get(token);
                isAllowedSql = obj == null ? true : (obj instanceof Boolean ? (Boolean)obj : false);
            }
        }
        clientInfo = this.prepareClientInfo(bean, clientInfo);
        if (isAllowedSql) {
            return this.executeQuery(con, sql, params, rows, timeout, fetch, rset_list, bean.maxBlobSize, bean.maxClobSize, bean.isBlobEnabled, bean.isClobEnabled, bean.disableAutogenKeys, clientInfo);
        }
        throw new SQLException(RB.getString(this, "Executive.2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table executeQuery(Connection con, String sql, ParameterList params, Integer rows, Integer timeout, Integer fetch, int[] rset_list, int maxBlobSize, int maxClobSize, boolean useBlob, boolean useClob, boolean disableAutogenKeys, Struct clientInfo) throws SQLException {
        this.setupClientInfo(con, clientInfo);
        Statement stmt = null;
        long start = System.currentTimeMillis();
        DatabaseMetaData dbmeta = con.getMetaData();
        boolean supportsMultipleResults = true;
        boolean supportsGeneratedKeys = false;
        boolean isOracleThin = false;
        if (con instanceof JRunConnectionHandle) {
            Connection c = ((JRunConnectionHandle)con).getPhysicalConnection();
            String className = c.getClass().getName();
            this.debug(className);
            if (className.equals("oracle.jdbc.driver.T4CConnection") || className.equals("oracle.jdbc.driver.T2CConnection")) {
                isOracleThin = true;
            } else if (className.equals("redbrick.jdbc.RBWConnection")) {
                try {
                    supportsMultipleResults = dbmeta.supportsMultipleResultSets();
                }
                catch (Throwable throwable) {}
            } else if (className.equals("macromedia.jdbc.sequelink.SequeLinkConnection")) {
                ServiceFactory.getSequelinkService(true);
            }
        }
        try {
            if (dbmeta != null) {
                String dbMetaClassName = dbmeta.getClass().getName();
                supportsGeneratedKeys = dbMetaClassName.equals("org.apache.derby.impl.jdbc.EmbedDatabaseMetaData") || dbMetaClassName.equals("org.apache.derby.impl.jdbc.EmbedDatabaseMetaData40") || dbMetaClassName.equals("org.apache.derby.client.net.NetDatabaseMetaData") || dbMetaClassName.equals("org.apache.derby.client.net.NetDatabaseMetaData40") ? true : (con.getClass().getName().equals("jrun.sql.JRunConnectionHandle") ? false : (dbMetaClassName.toLowerCase().startsWith("org.postgre") ? false : dbmeta.supportsGetGeneratedKeys()));
            }
        }
        catch (Throwable dbMetaClassName) {
            // empty catch block
        }
        if (disableAutogenKeys) {
            supportsGeneratedKeys = false;
        }
        try {
            Table curr;
            int len;
            int n = len = params == null ? 0 : params.length();
            if (len == 0) {
                stmt = con.createStatement();
            } else if (supportsGeneratedKeys) {
                try {
                    stmt = isOracleThin ? con.prepareStatement(sql) : con.prepareStatement(sql, 1);
                }
                catch (AbstractMethodError e) {
                    stmt = con.prepareStatement(sql);
                }
            } else {
                stmt = con.prepareStatement(sql);
            }
            if (fetch != null) {
                try {
                    stmt.setFetchSize(fetch);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (timeout != null) {
                try {
                    stmt.setQueryTimeout(timeout);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (rows != null) {
                try {
                    stmt.setMaxRows(rows);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (!useBlob && !useClob) {
                try {
                    int fieldsize;
                    int n2 = fieldsize = maxClobSize > maxBlobSize ? maxClobSize : maxBlobSize;
                    if (fieldsize < 256) {
                        fieldsize = 256;
                    }
                    stmt.setMaxFieldSize(fieldsize);
                }
                catch (Throwable fieldsize) {
                    // empty catch block
                }
            }
            boolean results = false;
            if (len == 0) {
                if (supportsGeneratedKeys) {
                    try {
                        results = isOracleThin ? stmt.execute(sql) : stmt.execute(sql, 1);
                    }
                    catch (AbstractMethodError e) {
                        results = stmt.execute(sql);
                    }
                } else {
                    results = stmt.execute(sql);
                }
            } else {
                params.setStatement(stmt);
                results = ((PreparedStatement)stmt).execute();
            }
            Table table = curr = this.getRowSet(stmt, results, rset_list, rows, maxBlobSize, maxClobSize, useBlob, useClob, supportsMultipleResults, supportsGeneratedKeys);
            return table;
        }
        finally {
            try {
                MetricsService ms = ServiceFactory.getMetricsService();
                long end = System.currentTimeMillis();
                ms.updateMetric("DBHits", (int)(end - start));
            }
            catch (ServiceFactory.ServiceNotAvailableException serviceNotAvailableException) {}
            if (stmt != null) {
                try {
                    stmt.setMaxRows(0);
                }
                catch (Throwable throwable) {}
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public Object getCachedQuery(QueryDetails key, String cacheRegion, Long cachedWithin) {
        String appName = null;
        if (FusionContext.getCurrent() != null) {
            appName = FusionContext.getCurrent().getApplicationName();
        }
        ApplicationScope appScope = null;
        if (appName != null) {
            appScope = ApplicationScopeTracker.getApplicationScope(appName);
        }
        if (!AppHelper.useInternalQueryCache(appScope)) {
            if (cacheRegion != null && !cacheRegion.equalsIgnoreCase("QUERY")) {
                GenericCache cache = GenericCacheFactory.getCache();
                CacheTO cacheTO = new CacheTO(appName, "QUERY", key.getCacheId(), null, -1L, -1L, cacheRegion, false, null);
                return cache.get(cacheTO, true);
            }
            Object argcacheid = key.getCacheId() instanceof String ? (String)key.getCacheId() : key.getCacheId();
            AppHelper.getDefaultCache(appScope);
            GenericCache cache = GenericCacheFactory.getCache();
            CacheTO cacheTO = new CacheTO(appName, "QUERY", argcacheid, null, -1L, -1L, cacheRegion, false, null);
            Object value = cache.get(cacheTO, false, cachedWithin == null ? null : Long.valueOf(cachedWithin));
            if (value != null) {
                return value;
            }
        } else {
            CachedQuery query = (CachedQuery)this.query_cache.get(key);
            if (query != null && (cachedWithin == null || System.currentTimeMillis() < query.getCreationTime() + cachedWithin)) {
                return query;
            }
        }
        return null;
    }

    @Override
    public void setCachedQuery(QueryDetails key, int hashCode, CachedQuery value, Long cachedWithin, boolean eternal, String cacheId, String cacheRegion, Long cacheMaxIdleTime) {
        String appName = null;
        if (FusionContext.getCurrent() != null) {
            appName = FusionContext.getCurrent().getApplicationName();
        }
        ApplicationScope appScope = null;
        if (appName != null) {
            appScope = ApplicationScopeTracker.getApplicationScope(appName);
        }
        if (!AppHelper.useInternalQueryCache(appScope)) {
            Object id;
            Object object = id = cacheId != null ? cacheId : key.getCacheId();
            if (this.cachedQueryMap == null) {
                this.cachedQueryMap = new HashMap<Integer, CacheDetails>();
            }
            CacheDetails details = new CacheDetails();
            details.setApplicationName(appName);
            details.setCacheId(id);
            details.setCacheRegion(cacheRegion);
            this.cachedQueryMap.put(hashCode, details);
            if (cacheRegion != null && !cacheRegion.equalsIgnoreCase("QUERY")) {
                CacheTO cacheTO = new CacheTO(appName, "QUERY", id, value, -1L, -1L, cacheRegion, false, null);
                if (cachedWithin != null && cachedWithin > 0L) {
                    cacheTO.setTimetoLive(cachedWithin / 1000L);
                } else if (eternal) {
                    cacheTO.eternal = true;
                }
                if (cacheMaxIdleTime != null && cacheMaxIdleTime > 0L) {
                    cacheTO.setTimetoidle(cacheMaxIdleTime);
                }
                GenericCache ehcache_cached_query = GenericCacheFactory.getCache();
                ehcache_cached_query.put(cacheTO, false);
            } else {
                Object queryCache = AppHelper.getDefaultCache(appScope);
                if (id != null && id instanceof String) {
                    id = (String)id;
                }
                CacheTO xObj = new CacheTO();
                xObj.id = id;
                xObj.value = value;
                xObj.objecttype = "QUERY";
                xObj.appname = appName;
                if (eternal) {
                    xObj.eternal = true;
                } else if (cachedWithin != null && cachedWithin > 0L) {
                    xObj.timetoLive = (int)(cachedWithin / 1000L);
                }
                if (cacheMaxIdleTime != null && cacheMaxIdleTime > 0L) {
                    xObj.setTimetoidle(cacheMaxIdleTime);
                }
                GenericCacheFactory.getCache().put(xObj, false);
            }
        } else {
            this.saveQueryInInternalCache(key, value);
        }
    }

    private void saveQueryInInternalCache(QueryDetails key, CachedQuery value) {
        this.query_cache.put(key, value);
        int hash2 = key.getHashcode2();
        Set<QueryDetails> qd = null;
        qd = this.query_cache2.keys().contains(hash2) ? (Set)this.query_cache2.get(hash2) : new HashSet<QueryDetails>();
        qd.add(key);
        this.query_cache2.put(hash2, qd);
    }

    @Override
    public synchronized void removeCachedQuery(QueryDetails key, String cacheId, String cacheRegion) {
        String appName = FusionContext.getCurrent().getApplicationName();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        if (!AppHelper.useInternalQueryCache(appScope)) {
            Object queryCache;
            GenericCache ehcache_cached_query = GenericCacheFactory.getCache();
            CacheTO cacheTO = new CacheTO();
            if (cacheId != null) {
                cacheTO.setId(cacheId);
            } else {
                cacheTO.setId(key.getCacheId());
            }
            if (cacheRegion == null) {
                cacheTO.setKey("QUERY");
            } else {
                cacheTO.setKey(cacheRegion);
            }
            ehcache_cached_query.remove(cacheTO);
            if (this.cachedQueryMap != null) {
                this.cachedQueryMap.remove(key.getHashcode2());
            }
            if ((queryCache = AppHelper.getDefaultCache(appScope)) != null) {
                GenericCache cache = GenericCacheFactory.getCache();
                cache.remove(cacheTO);
            }
        } else {
            this.query_cache.remove(key);
        }
    }

    @Override
    public synchronized void removeCachedQuery(String sql, String dsname, Array values, String region) {
        int result = dsname != null ? dsname.toLowerCase().hashCode() : 0;
        result = 29 * result + (sql != null ? sql.toLowerCase().hashCode() : 0);
        int paramhash = 0;
        if (null != values) {
            for (Object o : values) {
                if (o == null) continue;
                if (o instanceof CFNumber) {
                    paramhash += ((CFNumber)o).unwrap().hashCode();
                    continue;
                }
                if (o instanceof Number) {
                    paramhash += ((Number)o).toString().hashCode();
                    continue;
                }
                paramhash += o.hashCode();
            }
        }
        result = 29 * result + paramhash;
        String appName = FusionContext.getCurrent().getApplicationName();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        if (!AppHelper.useInternalQueryCache(appScope)) {
            CacheDetails details;
            if (this.cachedQueryMap != null && (details = this.cachedQueryMap.get(result)) != null) {
                GenericCache ehcache_cached_query = GenericCacheFactory.getCache();
                CacheTO cacheTO = new CacheTO();
                String regionName = region != null ? region : "QUERY";
                cacheTO.exact = true;
                cacheTO.setId(details.getCacheId());
                cacheTO.region = regionName;
                ehcache_cached_query.remove(cacheTO);
                this.cachedQueryMap.remove(result);
            }
        } else {
            Set keys = (Set)this.query_cache2.get(result);
            if (null == keys) {
                return;
            }
            for (QueryDetails qd : keys) {
                this.query_cache.remove(qd);
            }
        }
    }

    public void setupClientInfo(Connection c, Struct clientInfo) throws ClientInfoException, UnsupportedOperationException {
        block9: {
            if (clientInfo == null) {
                return;
            }
            if (clientInfo.isEmpty()) {
                return;
            }
            try {
                boolean isjdbc4Supported = false;
                if (c instanceof JRunConnectionHandle) {
                    JRunConnectionHandle jrunCHandle = (JRunConnectionHandle)c;
                    c = jrunCHandle.getPhysicalConnection();
                    isjdbc4Supported = jrunCHandle.isJDBC4Supported();
                }
                if (isjdbc4Supported) {
                    Properties p = new Properties();
                    Set clientInfoKeys = clientInfo.keySet();
                    if (clientInfoKeys != null && !clientInfoKeys.isEmpty()) {
                        for (String key : clientInfoKeys) {
                            Object value = clientInfo.get(key);
                            if (value == null) continue;
                            p.put(key, value);
                        }
                        c.setClientInfo(p);
                    }
                    break block9;
                }
                throw new UnsupportedOperationException();
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientInfoException((Throwable)e);
            }
        }
    }

    @Override
    public synchronized void purgeQueryCache() {
        this.purgeQueryCache(true);
    }

    @Override
    public synchronized void purgeQueryCache(boolean broadcast) {
        if (this.cachedQueryMap != null) {
            CacheTagHelper.purgeAllQueryCache(this.cachedQueryMap);
            this.cachedQueryMap.clear();
        }
        if (this.query_cache != null) {
            this.query_cache.clear();
        }
        if (this.query_cache2 != null) {
            this.query_cache2.clear();
        }
        if (broadcast) {
            try {
                CentralConfigClientUtil.pushActionToCCS("clearquerycache", "");
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    @Override
    public List getCachedQueries() {
        List cacheKeys;
        ArrayList<Object> queryList = new ArrayList<Object>();
        if (this.cachedQueryMap != null) {
            ArrayList<Integer> queriesToBeCleared = null;
            for (Map.Entry<Integer, CacheDetails> entry : this.cachedQueryMap.entrySet()) {
                Integer id = entry.getKey();
                try {
                    CacheDetails details = this.cachedQueryMap.get(id);
                    if (details == null) continue;
                    Object query = this.getObjectWithCacheDetails(details);
                    if (query != null) {
                        queryList.add(query);
                        continue;
                    }
                    if (queriesToBeCleared == null) {
                        queriesToBeCleared = new ArrayList();
                    }
                    queriesToBeCleared.add(id);
                }
                catch (CacheExceptions.CacheNotFoundException e) {
                    if (queriesToBeCleared == null) {
                        queriesToBeCleared = new ArrayList<Integer>();
                    }
                    queriesToBeCleared.add(id);
                }
                catch (Exception exception) {}
            }
            if (queriesToBeCleared != null) {
                for (Integer key : queriesToBeCleared) {
                    this.cachedQueryMap.remove(key);
                }
            }
        }
        if (this.query_cache2 != null && (cacheKeys = this.query_cache2.keys()) != null) {
            Iterator itr = cacheKeys.iterator();
            Set keys = null;
            while (itr.hasNext()) {
                keys = (Set)this.query_cache2.get(itr.next());
                for (QueryDetails qd : keys) {
                    Object query = this.query_cache.get(qd);
                    if (query == null) continue;
                    queryList.add(query);
                }
            }
        }
        return queryList;
    }

    private Object getObjectWithCacheDetails(CacheDetails details) {
        GenericCache cacheMgr = null;
        Map<String, GenericCache> cacheMgrMap = GenericCacheFactory.getCacheManagerMap();
        if (details.getApplicationName() != null && !details.getApplicationName().equals("") && cacheMgrMap != null) {
            cacheMgr = cacheMgrMap.get(details.getApplicationName());
        }
        if (cacheMgr == null) {
            cacheMgr = GenericCacheFactory.getServerWideCache();
        }
        if (cacheMgr != null) {
            CacheTO xObj = new CacheTO();
            xObj.setId(details.getCacheId());
            xObj.setKey(details.getCacheRegion());
            xObj.setObjecttype("QUERY");
            xObj.setAppname(details.getApplicationName());
            xObj.getQuiet = true;
            Object obj = cacheMgr.get(xObj, true);
            Map metaData = cacheMgr.getMetadata(xObj);
            if (obj != null) {
                ((CachedQuery)obj).getStats().setCacheHit(Math.toIntExact((Long)metaData.get("cache_hitcount")));
                ((CachedQuery)obj).getStats().setCacheMiss(Math.toIntExact((Long)metaData.get("cache_misscount")));
            }
            return obj;
        }
        return null;
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("defaults.keys", "create,storedproc,insert,delete,select,update,drop,alter,grant,revoke,pooling,disable,timeout,interval,login_timeout,buffer,blob_buffer,disable_clob,disable_blob,usespylog,spylogfile,supportlinks, validationquery,disable_autogenkeys,validateConnection,clientinfo");
            this.rb.put("defaults.types", "java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.String,java.lang.Boolean,java.lang.String,java.lang.Boolean,java.lang.Boolean,coldfusion.server.ConfigMap");
            this.rb.put("defaults.formats", "coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.MapFormatter");
            this.rb.put("driver.keys", "name,vendor,class,url,handler,port,host");
            this.rb.put("driver.types", "java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String");
            this.rb.put("driver.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("datasource.keys", "type,jndiDir,ISJ2EE,valid,urlmap,name,driver,description,class,url,username,password,create,storedproc,insert,delete,select,update,drop,alter,grant,revoke,disable,pooling,timeout,interval,login_timeout,buffer,blob_buffer,disable_clob,disable_blob,usespylog,spylogfile,supportlinks,validationquery,disable_autogenkeys,validateConnection,clientinfo");
            this.rb.put("datasource.types", "java.lang.String,java.lang.String,java.lang.Boolean,java.lang.Boolean,coldfusion.server.ConfigMap,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Number,java.lang.Boolean,java.lang.Boolean,java.lang.Boolean,java.lang.String,java.lang.Boolean,java.lang.String,java.lang.Boolean,java.lang.Boolean,coldfusion.server.ConfigMap");
            this.rb.put("datasource.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.MapFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.MapFormatter");
            this.rb.put("drivers.keys", "");
            this.rb.put("drivers.types", "coldfusion.server.ConfigMap");
            this.rb.put("drivers.formats", "coldfusion.server.MapFormatter");
            this.rb.put("drivers.value", "driver");
            this.rb.put("datasources.keys", "");
            this.rb.put("datasources.types", "coldfusion.server.ConfigMap");
            this.rb.put("datasources.formats", "coldfusion.server.MapFormatter");
            this.rb.put("datasources.value", "datasource");
            this.rb.put("maxcachecount.keys", MAX_CACHE_COUNT);
            this.rb.put("maxcachecount.types", "java.lang.Number");
            this.rb.put("maxcachecount.formats", "coldfusion.server.NumberFormatter");
        }
        return this.rb;
    }

    static Executive getInstance() {
        return instance;
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEncryptPassword(String oldSeed) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        Vector<ConfigMap> vDatasources = new Vector<ConfigMap>();
        ConfigMap configMap = this.datasources;
        synchronized (configMap) {
            ConfigMap copy = new ConfigMap(this, "datasources");
            Iterator i = this.datasources.keySet().iterator();
            while (i.hasNext()) {
                String dsn = null;
                try {
                    dsn = (String)i.next();
                    ConfigMap ds = (ConfigMap)this.datasources.get(dsn);
                    try {
                        String oldPass = (String)ds.get("password");
                        ds.put("password", (Object)PasswordUtils.reEncryptWithNewSeed(oldPass, oldSeed, this.seed));
                    }
                    catch (Exception e) {
                        CFLogs.SERVER_LOG.error(e);
                    }
                    ConfigMap clon = new ConfigMap(this, "datasource");
                    clon.putAll((Map)ds);
                    copy.put(dsn, (Object)clon);
                    DataSourceDef def = new DataSourceDef(clon);
                    def.setSeed(this.seed);
                    DataSourceFactory.getInstance().setDataSource(dsn, def);
                }
                catch (Exception se) {
                    CFLogs.SERVER_LOG.warn("Datasource Exception in Encryption with new Seed: " + dsn, se);
                }
            }
            vDatasources.addElement(copy);
        }
        vDatasources.addElement(this.max_cache);
        this.serialize(vDatasources, this.datasourcefile);
    }

    String getSeed() {
        if (null != this.seed) {
            return this.seed;
        }
        return PasswordUtils.getInstance().getSeedValue();
    }

    @Override
    public Map reEncryptPasswordForMigration(Map ds, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        SecurityService security = ServiceFactory.getSecurityService();
        security.authenticateAdmin();
        if (!PasswordUtils.isAESS(majorVersion, minorVersion) && (oldSeed == null || oldSeed != null && oldSeed.length() == 0)) {
            oldSeed = OLDSEEDVAL;
        }
        if (ds != null) {
            try {
                String oldPass = (String)ds.get("password");
                ds.put("password", PasswordUtils.reEncryptWithNewSeed(oldPass, oldSeed, this.seed, oldAlgoValue, majorVersion, minorVersion));
            }
            catch (Exception se) {
                CFLogs.SERVER_LOG.error("Datasource Exception in Encryption with new Seed: " + ds.get("name"), se);
            }
        }
        return ds;
    }

    public static class ConnectionVerificationFailedException
    extends ServiceRuntimeException {
        private static final long serialVersionUID = 1L;

        ConnectionVerificationFailedException(Throwable ex) {
            super(ex);
        }
    }

    public class ClientInfoException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;

        public ClientInfoException(Throwable ex) {
            super(ex);
        }
    }

    public class DataSourceAccessDeniedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String dsn;

        public DataSourceAccessDeniedException(String dsn) {
            this.dsn = dsn;
        }
    }
}

