/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.sql.CFDataSource;
import coldfusion.sql.DataSourceDef;
import coldfusion.sql.DataSourceException;
import coldfusion.sql.DataSourceFactory;
import coldfusion.sql.IDataSourceManager;
import coldfusion.sql.JNDIUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class J2EEDataSource
implements IDataSourceManager {
    Hashtable jndiEnv = null;

    protected J2EEDataSource(Hashtable jndiEnv) {
        this.jndiEnv = jndiEnv;
    }

    @Override
    public List getNames() throws Exception {
        return null;
    }

    @Override
    public void removeDatasource(DataSourceDef dsn) throws SQLException {
    }

    @Override
    public DataSource getDataSource(String dsn) throws SQLException {
        DataSourceDef def = DataSourceFactory.getInstance().getDataSourceDef(dsn);
        Hashtable jEnv = null;
        if (def != null) {
            jEnv = def.getJndienv();
        }
        Context ctx = null;
        DataSource ds = null;
        try {
            ctx = JNDIUtils.getContext(jEnv);
            ds = JNDIUtils.getJNDIDataSource(dsn, ctx);
            if (ds == null) {
                throw new DataSourceException(dsn);
            }
        }
        catch (NamingException ne) {
            throw new DataSourceException(ne, dsn);
        }
        finally {
            JNDIUtils.close(ctx);
        }
        return ds;
    }

    @Override
    public CFDataSource newDataSource(DataSourceDef def) throws SQLException {
        Hashtable jEnv = def.getJndienv();
        String jndiName = def.getJNDIName();
        DataSource ds = null;
        Context ctx = null;
        try {
            ctx = JNDIUtils.getContext(jEnv);
            ds = JNDIUtils.getJNDIDataSource(jndiName, ctx);
            if (ds == null) {
                throw new DataSourceException(jndiName);
            }
        }
        catch (NamingException ne) {
            throw new DataSourceException(ne, def.getJNDIName());
        }
        finally {
            JNDIUtils.close(ctx);
        }
        CFDataSource cfds = new CFDataSource(ds);
        cfds.setDataSourceDef(def);
        return cfds;
    }
}

