/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.runtime.CFPage;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.QueryTableWrapper;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.Table;
import coldfusion.sql.imq.Row;
import coldfusion.util.DateUtils;
import coldfusion.util.IOUtils;
import coldfusion.wddx.RecordSet;
import com.allaire.cfx.Query;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetListener;

public class QueryTable
extends Table
implements RowSet,
RecordSet {
    private static final long serialVersionUID = 1L;
    private int update_count;
    private int fetch_size;
    private boolean read_null = false;
    protected int pos = 0;
    static final boolean DATETIME_STR = Boolean.getBoolean("coldfusion.jdbc.datetime.str");
    static final boolean MYSQL_DATETIME_TIMESTAMP = Boolean.parseBoolean(System.getProperty("coldfusion.jdbc.mysql.datetime.timestamp", "true"));
    int _maxBlobSize = -1;
    int _maxClobSize = -1;
    boolean useBlob;
    boolean useClob;

    public QueryTable() {
    }

    public QueryTable(Query cfx) throws SQLException, IllegalAccessException {
        this.populate(cfx);
    }

    public QueryTable(ResultSet rs) throws SQLException {
        this.populate(rs);
    }

    public QueryTable(QueryTable rs) throws SQLException, IllegalAccessException {
        this(rs, -1);
    }

    public QueryTable(QueryTable rs, int maxrows) throws SQLException, IllegalAccessException {
        this.populate(rs, maxrows);
        this._maxBlobSize = rs._maxBlobSize;
        this._maxClobSize = rs._maxClobSize;
        this.fetch_size = rs.fetch_size;
        this.read_null = rs.read_null;
        this.update_count = rs.update_count;
        this.useClob = rs.useClob;
        this.useBlob = rs.useBlob;
        this.setQueryStat(rs.getQueryStat());
    }

    public QueryTable(int rows, String[] cols) {
        super(rows, cols);
    }

    public QueryTable(int rows, String[] colNames, String[] sqlColTypeNames) {
        super(rows, colNames, sqlColTypeNames);
    }

    public QueryTable(int rows, String[] colNames, String[] sqlColTypeNames, int[] sqlColTypes) {
        super(rows, colNames, sqlColTypeNames, sqlColTypes);
    }

    public QueryTable(int rows, String collist) {
        super(rows, collist);
    }

    public QueryTable(int rows) {
        super(rows, 0);
        this.col_count = 0;
    }

    public QueryTable(QueryTableWrapper qtWrapper) {
        this();
        this.initQTFromWrapper(qtWrapper);
    }

    private void initQTFromWrapper(QueryTableWrapper qtWrapper) {
        this.fetch_size = qtWrapper.getFetch_size();
        this.read_null = qtWrapper.isRead_null();
        this.pos = qtWrapper.getPos();
        this.update_count = qtWrapper.getUpdate_count();
        Table table = (Table)qtWrapper.getTable();
        this.setNextTable(table.nextTable());
        this.setPreviousTable(table.previousTable());
        this.setCached(table.isCached());
        this.setCol_count(table.getCol_count());
        this.setColumnNames(table.getColumnNames(), false);
        this.setHead(table.getHead());
        this.setTail(table.getTail());
        this.setMeta(table.getMeta());
        this.setRow_count(table.getRow_count());
        this.setRowVector(table.getRowVector());
    }

    public void setUpdateCount(int count) {
        this.update_count = count;
    }

    public int getUpdateCount() {
        return this.update_count;
    }

    public int getRecordCount() {
        return this.row_count;
    }

    public int recordCount() {
        return this.row_count;
    }

    public int getCurrentRow() {
        return this.pos;
    }

    public String[] getColumnList() {
        return this.getColumnNames();
    }

    public void populate(Query cfx) throws SQLException, IllegalAccessException {
        this.meta = new QueryTableMetaData(cfx);
        this.setColumnNames(this.meta.getColumnLabels(), false);
        int rowCount = cfx.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            Row row = new Row(this.col_count, true);
            for (int col = 0; col < this.col_count; ++col) {
                Object obj = cfx.getData(r + 1, col + 1);
                obj = CFPage.Duplicate(obj);
                row.setColumn(col, obj);
            }
            this.addRowLast(row);
        }
    }

    public void populate(QueryTable rs, int maxrows) throws SQLException, IllegalAccessException {
        if (rs.getMetaData() != null) {
            QueryTableMetaData md = new QueryTableMetaData((QueryTableMetaData)rs.getMetaData());
            this.setMetaData(md);
        }
        this.setColumnNames(rs.getColumnNames(), false);
        int rowCount = rs.getRowCount();
        if (maxrows > 0 && maxrows < rowCount) {
            rowCount = maxrows;
        }
        for (int r = 0; r < rowCount; ++r) {
            Row row = new Row(this.col_count, true);
            Row otherRow = rs.getRow(r);
            for (int col = 0; col < this.col_count; ++col) {
                Object obj = otherRow.getColumn(col);
                obj = CFPage.Duplicate(obj);
                row.setColumn(col, obj);
            }
            this.addRowLast(row);
        }
    }

    protected void makeShallowCopy(QueryTable qt, int maxrows) {
        super.makeShallowCopy(qt, maxrows);
        this.meta = (QueryTableMetaData)qt.getMetaData();
    }

    public void populate(ResultSet rs) throws SQLException {
        this.populate(rs, -1);
    }

    private static String toHexString(byte num) {
        Object result = "";
        long uint = 0xFFL & (long)num;
        String s = Long.toString(uint, 16);
        result = s.length() == 1 ? "0" + s : s;
        return result;
    }

    private static String formatAsGUID(byte[] obj) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(QueryTable.toHexString(obj[3]));
        buffer.append(QueryTable.toHexString(obj[2]));
        buffer.append(QueryTable.toHexString(obj[1]));
        buffer.append(QueryTable.toHexString(obj[0]));
        buffer.append('-');
        buffer.append(QueryTable.toHexString(obj[5]));
        buffer.append(QueryTable.toHexString(obj[4]));
        buffer.append('-');
        buffer.append(QueryTable.toHexString(obj[7]));
        buffer.append(QueryTable.toHexString(obj[6]));
        buffer.append('-');
        buffer.append(QueryTable.toHexString(obj[8]));
        buffer.append(QueryTable.toHexString(obj[9]));
        buffer.append('-');
        for (int i = 10; i < 16; ++i) {
            buffer.append(QueryTable.toHexString(obj[i]));
        }
        return buffer.toString().toUpperCase();
    }

    public void populate(ResultSet rs, int maxrows) throws SQLException {
        boolean isMySQLDriver;
        if (rs instanceof QueryTable) {
            this.makeShallowCopy((QueryTable)rs, maxrows);
            return;
        }
        this.meta = new QueryTableMetaData(rs.getMetaData());
        this.setColumnNames(this.meta.getColumnLabels(), false);
        int count = 0;
        boolean isMySqlBit = false;
        boolean bl = isMySQLDriver = MYSQL_DATETIME_TIMESTAMP ? rs.getMetaData().getClass().getName().startsWith("com.mysql.cj") : false;
        for (int k = 0; rs.next() && (maxrows == -1 || k < maxrows); ++k) {
            if (count % 10 == 9 && RequestMonitor.isRequestTimedOut()) {
                throw new RequestTimedOutException("CFQUERY");
            }
            ++count;
            Row row = new Row(this.col_count, true);
            for (int col = 0; col < this.col_count; ++col) {
                Object obj = null;
                if (this.meta.getColumnType(col + 1) == 12) {
                    obj = rs.getString(col + 1);
                } else {
                    String colTName = this.meta.getColumnTypeName(col + 1);
                    if (colTName != null && colTName.equalsIgnoreCase("GUID") && this.meta.getColumnType(col + 1) == -2) {
                        byte[] barray;
                        obj = rs.getObject(col + 1);
                        if (obj instanceof byte[] && (barray = (byte[])obj).length >= 16) {
                            obj = QueryTable.formatAsGUID(barray);
                        }
                    } else if (rs.getMetaData().getClass().getName().toString().equalsIgnoreCase("com.mysql.jdbc.ResultSetMetaData") && "TINYINT".equalsIgnoreCase(colTName) && (this.meta.getColumnType(col + 1) == -7 || isMySqlBit)) {
                        this.meta.column_type[col] = -6;
                        isMySqlBit = true;
                        obj = new Integer(rs.getInt(col + 1));
                    } else if (DATETIME_STR && this.meta.column_type[col] == 93) {
                        obj = rs.getObject(col + 1, String.class);
                    } else {
                        obj = rs.getObject(col + 1);
                        if (MYSQL_DATETIME_TIMESTAMP && this.meta.column_type[col] == 93 && isMySQLDriver && obj instanceof LocalDateTime) {
                            obj = Timestamp.valueOf((LocalDateTime)obj);
                        }
                    }
                }
                row.setColumn(col, obj);
            }
            this.addRowLast(row, false);
        }
        this.resetRowVector();
        block5: for (int col = 0; col < this.col_count; ++col) {
            int colType = this.meta.getColumnType(col + 1);
            switch (colType) {
                case -4: 
                case -1: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2009: 
                case 2011: {
                    for (int rowId = 0; rowId < this.row_count; ++rowId) {
                        Row row = this.getRow(rowId);
                        Object obj = QueryTable.resolveObject(row.getColumn(col), this.useBlob ? -1 : this._maxBlobSize, this.useClob ? -1 : this._maxClobSize);
                        row.setColumn(col, obj);
                    }
                    continue block5;
                }
            }
        }
    }

    public void maskDateTimeColumns(int cType, String mask, CFLocale cflocale) {
        for (int col = 0; col < this.col_count; ++col) {
            int colType = this.meta.getColumnType(col + 1);
            if (colType != cType) continue;
            for (int rowId = 0; rowId < this.row_count; ++rowId) {
                Row row = this.getRow(rowId);
                Object obj = row.getColumn(col);
                if (obj == null) continue;
                if (colType == 93) {
                    obj = DateUtils.formatDate(obj, cflocale, mask);
                } else if (colType == 92) {
                    obj = DateUtils.formatTime(obj, mask, cflocale);
                }
                row.setColumn(col, obj);
            }
        }
    }

    protected void setMaxBlobSize(int size) {
        this._maxBlobSize = size;
    }

    protected void setMaxClobSize(int size) {
        this._maxClobSize = size;
    }

    protected void setBlobEnabled(boolean blob) {
        this.useBlob = blob;
    }

    protected void setClobEnabled(boolean clob) {
        this.useClob = clob;
    }

    public static final Object resolveObject(Object obj, int maxBlobSize, int maxClobSize) throws SQLException {
        try {
            if (obj instanceof String && maxClobSize != -1 && ((String)obj).length() > maxClobSize) {
                obj = ((String)obj).substring(0, maxClobSize);
            }
            if (obj instanceof byte[] && maxBlobSize != -1 && ((byte[])obj).length > maxBlobSize) {
                byte[] newBytes = new byte[maxBlobSize];
                System.arraycopy(obj, 0, newBytes, 0, maxBlobSize);
                obj = newBytes;
            }
            if (obj instanceof Blob) {
                obj = IOUtils.toByteArray(((Blob)obj).getBinaryStream(), maxBlobSize);
            } else if (obj instanceof Clob) {
                obj = IOUtils.toCharArray(((Clob)obj).getCharacterStream(), maxClobSize);
            } else if (obj instanceof NClob) {
                obj = IOUtils.toCharArray(((NClob)obj).getCharacterStream(), maxClobSize);
            } else if (obj instanceof SQLXML) {
                obj = IOUtils.toCharArray(((SQLXML)obj).getCharacterStream(), maxClobSize);
            }
            if (obj instanceof Array) {
                obj = ((Array)obj).getArray();
            } else if (obj instanceof InputStream) {
                obj = IOUtils.toByteArray((InputStream)obj, maxBlobSize);
            } else if (obj instanceof Reader) {
                obj = IOUtils.toCharArray((Reader)obj, maxClobSize);
            }
            return obj;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public boolean next() {
        boolean b;
        if (this.row_count > 0 && this.pos < this.row_count) {
            ++this.pos;
            b = true;
        } else {
            this.pos = 0;
            b = false;
        }
        return b;
    }

    @Override
    public void close() {
        this.pos = 0;
    }

    @Override
    public boolean wasNull() {
        return this.read_null;
    }

    @Override
    public int addColumn(String column_name) {
        return this.addColumn(column_name, null);
    }

    @Override
    public int addColumn(String column_name, Vector column_data) {
        return this.addColumn(column_name, null, column_data);
    }

    public int addColumn(String column_name, String columnType, Vector column_data) {
        boolean validateDataType = false;
        int colId = this.findColumn(column_name);
        if (colId > 0 && this.col_count > 0) {
            return 0;
        }
        this.addColumnName(column_name);
        if (columnType != null) {
            int sqlType = QueryFunction.isValidColumnType(columnType);
            this.meta.addColumnType(sqlType);
            validateDataType = true;
        }
        if (column_data != null) {
            int new_column_size;
            int i;
            if (this.row_count > 0) {
                for (i = 0; i < this.row_count; ++i) {
                    Row temp = this.getRow(i);
                    if (temp.getSize() < this.col_count) {
                        this.getRow(i).setSize(this.col_count);
                        continue;
                    }
                    temp.setColumn(this.col_count - 1, null);
                }
            }
            if ((new_column_size = column_data.size()) > this.row_count) {
                int newAddedRowsNum = new_column_size - this.row_count;
                for (i = 0; i < newAddedRowsNum; ++i) {
                    this.addRowLast(new Row(this.col_count, false));
                }
            }
            for (i = 0; i < new_column_size; ++i) {
                this.setField(i + 1, this.col_count, column_data.get(i), validateDataType);
            }
        }
        return this.col_count;
    }

    public Object deleteColumn(String colName) {
        int colId = this.findColumn(colName);
        if (colId == 0) {
            throw new QueryFunction.QueryColumnNameException(colName);
        }
        if (this.row_count > 0) {
            for (int i = 0; i < this.row_count; ++i) {
                Row temp = this.getRow(i);
                if (temp.getSize() <= colId) continue;
                temp.deleteColumn(colId - 1, this.col_count + 1);
            }
        }
        this.deleteColumnnNameAndType(colId - 1);
        return this;
    }

    @Override
    public String getString(int columnIndex) {
        Object obj = this.getObject(columnIndex);
        return obj == null ? null : obj.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() != 0.0;
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue() != '0';
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble(obj.toString()) != 0.0;
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> boolean");
            }
        }
        if (obj instanceof char[]) {
            return true;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> boolean");
    }

    @Override
    public byte getByte(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? (byte)1 : 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue() != '0' ? (byte)1 : 0;
        }
        if (obj instanceof String) {
            try {
                return Byte.parseByte(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> byte");
            }
        }
        if (obj instanceof char[]) {
            return 1;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> byte");
    }

    @Override
    public short getShort(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? (short)1 : 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue() != '0' ? (short)1 : 0;
        }
        if (obj instanceof String) {
            try {
                return Short.parseShort(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> short");
            }
        }
        if (obj instanceof char[]) {
            return 1;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> short");
    }

    @Override
    public int getInt(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return Character.digit(ch, 10);
            }
            throw new TypeConversionException(obj.getClass().getName() + " -> int");
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> int");
            }
        }
        if (obj instanceof char[]) {
            return 1;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> int");
    }

    @Override
    public long getLong(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1L : 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return Character.digit(ch, 10);
            }
            throw new TypeConversionException(obj.getClass().getName() + " -> long");
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> long");
            }
        }
        if (obj instanceof char[]) {
            return 1L;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> long");
    }

    @Override
    public float getFloat(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0f : 0.0f;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return Character.digit(ch, 10);
            }
            throw new TypeConversionException(obj.getClass().getName() + " -> float");
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> float");
            }
        }
        if (obj instanceof char[]) {
            return 1.0f;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> float");
    }

    @Override
    public double getDouble(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1.0 : 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return Character.digit(ch, 10);
            }
            throw new TypeConversionException(obj.getClass().getName() + " -> double");
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> double");
            }
        }
        if (obj instanceof char[]) {
            return 1.0;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> double");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws TypeConversionException {
        return this.getBigDecimal(columnIndex).setScale(scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> byte[]");
    }

    @Override
    public Date getDate(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Timestamp) {
            return new Date(((Timestamp)obj).getTime());
        }
        try {
            DateFormat df = DateFormat.getDateInstance();
            return new Date(df.parse(obj.toString()).getTime());
        }
        catch (Exception ex) {
            throw new TypeConversionException(obj.getClass().getName() + " -> Date");
        }
    }

    @Override
    public Time getTime(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof Timestamp) {
            return new Time(((Timestamp)obj).getTime());
        }
        try {
            DateFormat df = DateFormat.getDateInstance();
            return new Time(df.parse(obj.toString()).getTime());
        }
        catch (Exception ex) {
            throw new TypeConversionException(obj.getClass().getName() + " -> Time");
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof Time) {
            return new Timestamp(((Time)obj).getTime());
        }
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        try {
            DateFormat df = DateFormat.getDateInstance();
            return new Timestamp(df.parse(obj.toString()).getTime());
        }
        catch (Exception ex) {
            throw new TypeConversionException(obj.getClass().getName() + " -> Timestamp");
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof char[]) {
            try {
                return new ByteArrayInputStream(String.valueOf((char[])obj).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> InputStream");
            }
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        if (obj instanceof String) {
            try {
                return new ByteArrayInputStream(((String)obj).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> InputStream");
            }
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> InputStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) {
        throw new UnsupportedOperationException("RowSet.getUnicodeStream()");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> InputStream");
    }

    @Override
    public String getString(String columnName) {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws TypeConversionException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws TypeConversionException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws TypeConversionException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws TypeConversionException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws TypeConversionException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws TypeConversionException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws TypeConversionException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws TypeConversionException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws TypeConversionException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws TypeConversionException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws TypeConversionException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws TypeConversionException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws TypeConversionException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws TypeConversionException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws TypeConversionException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException("RowSet.getWarnings()");
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public String getCursorName() {
        throw new UnsupportedOperationException("RowSet.getCursorName()");
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.meta;
    }

    public void setMetaData(QueryTableMetaData qMetaData) {
        this.meta = qMetaData;
    }

    @Override
    public Object getObject(int columnIndex) {
        Object obj = this.getField(this.pos, columnIndex);
        this.read_null = obj == null;
        return obj;
    }

    @Override
    public Object getObject(String columnName) {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < this.col_count; ++i) {
            if (!this.col_names[i].equalsIgnoreCase(columnName)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof char[]) {
            try {
                return new InputStreamReader(new ByteArrayInputStream(String.valueOf((char[])obj).getBytes("ASCII")));
            }
            catch (UnsupportedEncodingException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> InputStream");
            }
        }
        if (obj instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])obj));
        }
        if (obj instanceof String) {
            try {
                return new InputStreamReader(new ByteArrayInputStream(((String)obj).getBytes("ASCII")));
            }
            catch (UnsupportedEncodingException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> InputStream");
            }
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> Reader");
    }

    @Override
    public Reader getCharacterStream(String columnName) throws TypeConversionException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws TypeConversionException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? new BigDecimal(1) : new BigDecimal(0);
        }
        if (obj instanceof Number) {
            try {
                return new BigDecimal(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> BigDecimal");
            }
        }
        if (obj instanceof Character) {
            char ch = ((Character)obj).charValue();
            if (ch >= '0' && ch <= '9') {
                return new BigDecimal(obj.toString());
            }
            throw new TypeConversionException(obj.getClass().getName() + " -> BigDecimal");
        }
        if (obj instanceof String) {
            try {
                return new BigDecimal(obj.toString());
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException(obj.getClass().getName() + " -> BigDecimal");
            }
        }
        if (obj instanceof char[]) {
            return new BigDecimal(1);
        }
        throw new TypeConversionException(obj.getClass().getName() + " -> BigDecimal");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws TypeConversionException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() {
        return this.pos == 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.pos > this.row_count;
    }

    @Override
    public boolean isFirst() {
        return this.pos == 1;
    }

    @Override
    public boolean isLast() {
        return this.pos == this.row_count;
    }

    @Override
    public void beforeFirst() {
        this.pos = 0;
    }

    @Override
    public void afterLast() {
        this.pos = this.row_count + 1;
    }

    @Override
    public boolean first() {
        this.pos = 1;
        return true;
    }

    @Override
    public boolean last() {
        this.pos = this.row_count;
        return true;
    }

    @Override
    public int getRow() {
        return this.pos;
    }

    @Override
    public boolean absolute(int row) {
        if (row <= -1) {
            this.pos = this.row_count + 1 + row;
            if (this.pos <= 0) {
                this.pos = 0;
                return false;
            }
            return true;
        }
        this.pos = row;
        if (this.pos > this.row_count) {
            this.pos = this.row_count + 1;
            return false;
        }
        return true;
    }

    @Override
    public boolean relative(int rows) {
        this.pos += rows;
        if (this.pos < 0) {
            this.pos = 0;
            return false;
        }
        if (this.pos > this.row_count) {
            this.pos = this.row_count;
            return false;
        }
        return true;
    }

    @Override
    public boolean previous() {
        if (this.row_count > 0 && this.pos > 0) {
            --this.pos;
            return true;
        }
        this.pos = 0;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) {
        throw new UnsupportedOperationException("RowSet.setFetchDirection()");
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) {
        this.fetch_size = rows;
    }

    @Override
    public int getFetchSize() {
        return this.fetch_size;
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) {
        throw new UnsupportedOperationException("RowSet.updateNull()");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) {
        throw new UnsupportedOperationException("RowSet.updateBoolean()");
    }

    @Override
    public void updateByte(int columnIndex, byte x) {
        throw new UnsupportedOperationException("RowSet.updateByte()");
    }

    @Override
    public void updateShort(int columnIndex, short x) {
        throw new UnsupportedOperationException("RowSet.updateShort()");
    }

    @Override
    public void updateInt(int columnIndex, int x) {
        throw new UnsupportedOperationException("RowSet.updateInt()");
    }

    @Override
    public void updateLong(int columnIndex, long x) {
        throw new UnsupportedOperationException("RowSet.updateLong()");
    }

    @Override
    public void updateFloat(int columnIndex, float x) {
        throw new UnsupportedOperationException("RowSet.updateFloat()");
    }

    @Override
    public void updateDouble(int columnIndex, double x) {
        throw new UnsupportedOperationException("RowSet.updateDouble()");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) {
        throw new UnsupportedOperationException("RowSet.updateBigDecimal()");
    }

    @Override
    public void updateString(int columnIndex, String x) {
        throw new UnsupportedOperationException("RowSet.updateString()");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) {
        throw new UnsupportedOperationException("RowSet.updateBytes()");
    }

    @Override
    public void updateDate(int columnIndex, Date x) {
        throw new UnsupportedOperationException("RowSet.updateDate()");
    }

    @Override
    public void updateTime(int columnIndex, Time x) {
        throw new UnsupportedOperationException("RowSet.updateTime()");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) {
        throw new UnsupportedOperationException("RowSet.updateTimestamp()");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) {
        throw new UnsupportedOperationException("RowSet.updateAsciiStream()");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) {
        throw new UnsupportedOperationException("RowSet.updateBinaryStream()");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) {
        throw new UnsupportedOperationException("RowSet.updateCharacterStream()");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) {
        throw new UnsupportedOperationException("RowSet.updateObject()");
    }

    @Override
    public void updateObject(int columnIndex, Object x) {
        throw new UnsupportedOperationException("RowSet.updateObject()");
    }

    @Override
    public void updateNull(String columnName) {
        throw new UnsupportedOperationException("RowSet.updateNull()");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) {
        throw new UnsupportedOperationException("RowSet.updateBoolean()");
    }

    @Override
    public void updateByte(String columnName, byte x) {
        throw new UnsupportedOperationException("RowSet.updateByte()");
    }

    @Override
    public void updateShort(String columnName, short x) {
        throw new UnsupportedOperationException("RowSet.updateShort()");
    }

    @Override
    public void updateInt(String columnName, int x) {
        throw new UnsupportedOperationException("RowSet.updateInt()");
    }

    @Override
    public void updateLong(String columnName, long x) {
        throw new UnsupportedOperationException("RowSet.updateLong()");
    }

    @Override
    public void updateFloat(String columnName, float x) {
        throw new UnsupportedOperationException("RowSet.updateFloat()");
    }

    @Override
    public void updateDouble(String columnName, double x) {
        throw new UnsupportedOperationException("RowSet.updateDouble()");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) {
        throw new UnsupportedOperationException("RowSet.updateBigDecimal()");
    }

    @Override
    public void updateString(String columnName, String x) {
        throw new UnsupportedOperationException("RowSet.updateString()");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) {
        throw new UnsupportedOperationException("RowSet.updateBytes()");
    }

    @Override
    public void updateDate(String columnName, Date x) {
        throw new UnsupportedOperationException("RowSet.updateDate()");
    }

    @Override
    public void updateTime(String columnName, Time x) {
        throw new UnsupportedOperationException("RowSet.updateTime()");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) {
        throw new UnsupportedOperationException("RowSet.updateTimestamp()");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) {
        throw new UnsupportedOperationException("RowSet.updateAsciiStream()");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) {
        throw new UnsupportedOperationException("RowSet.updateBinaryStream()");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) {
        throw new UnsupportedOperationException("RowSet.updateCharacterStream()");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) {
        throw new UnsupportedOperationException("RowSet.updateObject()");
    }

    @Override
    public void updateObject(String columnName, Object x) {
        throw new UnsupportedOperationException("RowSet.updateObject()");
    }

    @Override
    public void insertRow() {
        throw new UnsupportedOperationException("RowSet.insertRow()");
    }

    @Override
    public void updateRow() {
        throw new UnsupportedOperationException("RowSet.updateRow()");
    }

    @Override
    public void deleteRow() {
        throw new UnsupportedOperationException("RowSet.deleteRow()");
    }

    @Override
    public void refreshRow() {
    }

    @Override
    public void cancelRowUpdates() {
    }

    @Override
    public void moveToInsertRow() {
        throw new UnsupportedOperationException("RowSet.moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() {
        throw new UnsupportedOperationException("RowSet.moveToCurrentRow()");
    }

    @Override
    public Statement getStatement() {
        return null;
    }

    @Override
    public Ref getRef(int i) {
        throw new UnsupportedOperationException("RowSet.getRef()");
    }

    @Override
    public Blob getBlob(int i) {
        throw new UnsupportedOperationException("RowSet.getBlob()");
    }

    @Override
    public Clob getClob(int i) {
        throw new UnsupportedOperationException("RowSet.getClob()");
    }

    @Override
    public Array getArray(int i) {
        throw new UnsupportedOperationException("RowSet.getArray()");
    }

    @Override
    public Ref getRef(String colName) {
        throw new UnsupportedOperationException("RowSet.getRef()");
    }

    @Override
    public Blob getBlob(String colName) {
        throw new UnsupportedOperationException("RowSet.getBlob()");
    }

    @Override
    public Clob getClob(String colName) {
        throw new UnsupportedOperationException("RowSet.getClob()");
    }

    @Override
    public Array getArray(String colName) {
        throw new UnsupportedOperationException("RowSet.getArray()");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) {
        throw new UnsupportedOperationException("RowSet.getDate(int, Calendar)");
    }

    @Override
    public Date getDate(String columnName, Calendar cal) {
        throw new UnsupportedOperationException("RowSet.getDate(String, Calendar)");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) {
        throw new UnsupportedOperationException("RowSet.getTime(int, Calendar)");
    }

    @Override
    public Time getTime(String columnName, Calendar cal) {
        throw new UnsupportedOperationException("RowSet.getTime(String, Calendar)");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) {
        throw new UnsupportedOperationException("RowSet.getTimestamp(int, Calendar)");
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) {
        throw new UnsupportedOperationException("RowSet.getTimestamp(String, Calendar)");
    }

    @Override
    public void addRowSetListener(RowSetListener rowsetlistener) {
        throw new UnsupportedOperationException("RowSet.addRowSetListener()");
    }

    @Override
    public void clearParameters() {
        this.pos = 0;
        this.col_count = 0;
        this.row_count = 0;
        this.clear();
    }

    @Override
    public void execute() {
        throw new UnsupportedOperationException("RowSet.execute()");
    }

    @Override
    public String getCommand() {
        throw new UnsupportedOperationException("RowSet.getCommand()");
    }

    @Override
    public String getDataSourceName() {
        throw new UnsupportedOperationException("RowSet.getDataSourceName()");
    }

    @Override
    public boolean getEscapeProcessing() {
        throw new UnsupportedOperationException("RowSet.getEscapeProcessing()");
    }

    @Override
    public int getMaxFieldSize() {
        throw new UnsupportedOperationException("RowSet.getMaxFieldSize()");
    }

    @Override
    public int getMaxRows() {
        return this.row_count;
    }

    @Override
    public String getPassword() {
        throw new UnsupportedOperationException("RowSet.getPassword()");
    }

    @Override
    public int getQueryTimeout() {
        throw new UnsupportedOperationException("RowSet.getQueryTimeout()");
    }

    @Override
    public int getTransactionIsolation() {
        throw new UnsupportedOperationException("RowSet.getTransactionIsolation()");
    }

    public Map getTypeMap() {
        throw new UnsupportedOperationException("RowSet. getTypeMap()");
    }

    @Override
    public String getUrl() {
        throw new UnsupportedOperationException("RowSet.getUrl()");
    }

    @Override
    public String getUsername() {
        throw new UnsupportedOperationException("RowSet.getUsername()");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void removeRowSetListener(RowSetListener rowsetlistener) {
        throw new UnsupportedOperationException("RowSet.removeRowSetListener()");
    }

    @Override
    public void setArray(int i, Array array) {
        throw new UnsupportedOperationException("RowSet.setArray()");
    }

    @Override
    public void setAsciiStream(int i, InputStream inputstream, int j) {
        throw new UnsupportedOperationException("RowSet.setAsciiStream()");
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bigdecimal) {
        throw new UnsupportedOperationException("RowSet.setBigDecimal()");
    }

    @Override
    public void setBinaryStream(int i, InputStream inputstream, int j) {
        throw new UnsupportedOperationException("RowSet.setBinaryStream()");
    }

    @Override
    public void setBlob(int i, Blob blob) {
        throw new UnsupportedOperationException("RowSet.setBlob()");
    }

    @Override
    public void setBoolean(int i, boolean flag) {
        throw new UnsupportedOperationException("RowSet.setBoolean()");
    }

    @Override
    public void setByte(int i, byte byte0) {
        throw new UnsupportedOperationException("RowSet.setByte()");
    }

    @Override
    public void setBytes(int i, byte[] byte0) {
        throw new UnsupportedOperationException("RowSet.setBytes()");
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int j) {
        throw new UnsupportedOperationException("RowSet.setCharacterStream()");
    }

    @Override
    public void setClob(int i, Clob clob) {
        throw new UnsupportedOperationException("RowSet.setClob()");
    }

    @Override
    public void setNCharacterStream(String s, Reader r) {
        throw new UnsupportedOperationException("RowSet.setNCharacterStream(java.lang.String,java.io.Reader)");
    }

    @Override
    public void setNCharacterStream(String s, Reader r, long l) {
        throw new UnsupportedOperationException("RowSet.setNCharacterStream(java.lang.String,java.io.Reader,long) ");
    }

    @Override
    public void setNCharacterStream(int i, Reader r, long l) {
        throw new UnsupportedOperationException("RowSet.setNCharacterStream(int,java.io.Reader,long) ");
    }

    @Override
    public void setNString(String s, String s1) {
        throw new UnsupportedOperationException("RowSet.setNString(java.lang.String,java.lang.String) ");
    }

    @Override
    public void setNString(int i, String str) {
        throw new UnsupportedOperationException("RowSet.setNString(int,java.lang.String)");
    }

    @Override
    public void setTimestamp(String str, Timestamp t, Calendar c) {
        throw new UnsupportedOperationException("RowSet.setTimestamp(java.lang.String,java.sql.Timestamp,java.util.Calendar)");
    }

    @Override
    public void setTime(String s, Time t, Calendar c) {
        throw new UnsupportedOperationException("RowSet.setTime(java.lang.String,java.sql.Time,java.util.Calendar) ");
    }

    @Override
    public void setTime(String s, Time t) {
        throw new UnsupportedOperationException("RowSet.setTime(java.lang.String,java.sql.Time)");
    }

    @Override
    public void setDate(String s, Date d, Calendar c) {
        throw new UnsupportedOperationException("RowSet.setDate(java.lang.String,java.sql.Date,java.util.Calendar)");
    }

    @Override
    public void setDate(String s, Date d) {
        throw new UnsupportedOperationException("RowSet.setDate(java.lang.String,java.sql.Date)");
    }

    @Override
    public void setClob(String s, Reader r) {
        throw new UnsupportedOperationException("RowSet.setClob(java.lang.String,java.io.Reader)");
    }

    @Override
    public void setClob(String s, Clob c) {
        throw new UnsupportedOperationException("RowSet.setClob(java.lang.String,java.sql.Clob)");
    }

    @Override
    public void setClob(String s, Reader r, long l) {
        throw new UnsupportedOperationException("RowSet.setClob(java.lang.String,java.io.Reader,long)");
    }

    @Override
    public void setClob(int i, Reader r) {
        throw new UnsupportedOperationException("RowSet.setClob(int,java.io.Reader)");
    }

    @Override
    public void setLong(String s, long l) {
        throw new UnsupportedOperationException("RowSet.setLong(java.lang.String,long)");
    }

    @Override
    public void setClob(int i, Reader r, long l) {
        throw new UnsupportedOperationException("RowSet.setClob(int,java.io.Reader,long)");
    }

    @Override
    public void setBlob(String s, InputStream is) {
        throw new UnsupportedOperationException("RowSet.setBlob(java.lang.String,java.io.InputStream)");
    }

    @Override
    public void setBlob(String s, Blob b) {
        throw new UnsupportedOperationException("RowSet.setBlob(java.lang.String,java.sql.Blob)");
    }

    @Override
    public void setBlob(String s, InputStream is, long l) {
        throw new UnsupportedOperationException("RowSet.setBlob(java.lang.String,java.io.InputStream,long)");
    }

    @Override
    public void setBlob(int i, InputStream is) {
        throw new UnsupportedOperationException("RowSet.setBlob(int,java.io.InputStream)");
    }

    @Override
    public void setBlob(int i, InputStream is, long l) {
        throw new UnsupportedOperationException("RowSet.setBlob(int,java.io.InputStream,long)");
    }

    @Override
    public void setObject(String s, Object o) {
        throw new UnsupportedOperationException("RowSet.setObject(java.lang.String,java.lang.Object)");
    }

    @Override
    public void setObject(String s, Object o, int i) {
        throw new UnsupportedOperationException("RowSet.setObject(java.lang.String,java.lang.Object,int)");
    }

    @Override
    public void setObject(String s, Object o, int i, int j) {
        throw new UnsupportedOperationException("RowSet.setObject(java.lang.String,java.lang.Object,int,int)");
    }

    @Override
    public void setNCharacterStream(int i, Reader r) {
        throw new UnsupportedOperationException("RowSet.setNCharacterStream(int,java.io.Reader) ");
    }

    @Override
    public void setCharacterStream(String s, Reader r) {
        throw new UnsupportedOperationException("RowSet.setCharacterStream(java.lang.String,java.io.Reader) ");
    }

    @Override
    public void setCharacterStream(int i, Reader r) {
        throw new UnsupportedOperationException("RowSet.setCharacterStream(int,java.io.Reader)");
    }

    @Override
    public void setBinaryStream(String s, InputStream is) {
        throw new UnsupportedOperationException("RowSet.setBinaryStream(java.lang.String,java.io.InputStream) ");
    }

    @Override
    public void setBinaryStream(int i, InputStream is) {
        throw new UnsupportedOperationException("RowSet.setBinaryStream(int,java.io.InputStream)");
    }

    @Override
    public void setAsciiStream(String s, InputStream is) {
        throw new UnsupportedOperationException("RowSet.setAsciiStream(java.lang.String,java.io.InputStream) ");
    }

    @Override
    public void setAsciiStream(int i, InputStream is) {
        throw new UnsupportedOperationException("RowSet.setAsciiStream(int,java.io.InputStream) ");
    }

    @Override
    public void setAsciiStream(String s, InputStream is, int i) {
        throw new UnsupportedOperationException("RowSet.setAsciiStream(java.lang.String,java.io.InputStream,int)");
    }

    @Override
    public void setCharacterStream(String s, Reader r, int i) {
        throw new UnsupportedOperationException("RowSet.setCharacterStream(java.lang.String,java.io.Reader,int)");
    }

    @Override
    public void setBinaryStream(String s, InputStream is, int i) {
        throw new UnsupportedOperationException("RowSet.setBinaryStream(java.lang.String,java.io.InputStream,int) ");
    }

    @Override
    public void setTimestamp(String s, Timestamp t) {
        throw new UnsupportedOperationException("RowSet.setTimestamp(java.lang.String,java.sql.Timestamp) ");
    }

    @Override
    public void setBytes(String s, byte[] b) {
        throw new UnsupportedOperationException("RowSet.setBytes(java.lang.String,byte[]) ");
    }

    @Override
    public void setString(String s, String s1) {
        throw new UnsupportedOperationException("RowSet.setString(java.lang.String,java.lang.String) ");
    }

    @Override
    public void setBigDecimal(String s, BigDecimal b) {
        throw new UnsupportedOperationException("RowSet.setBigDecimal(java.lang.String,java.math.BigDecimal) ");
    }

    @Override
    public void setDouble(String s, double d) {
        throw new UnsupportedOperationException("RowSet.setDouble(java.lang.String,double)");
    }

    @Override
    public void setFloat(String s, float f) {
        throw new UnsupportedOperationException("RowSet.setFloat(java.lang.String,float)");
    }

    @Override
    public void setInt(String s, int i) {
        throw new UnsupportedOperationException("RowSet.setInt(java.lang.String,int)");
    }

    @Override
    public void setShort(String str, short s) {
        throw new UnsupportedOperationException("RowSet.setShort(java.lang.String,short)");
    }

    @Override
    public void setByte(String s, byte b) {
        throw new UnsupportedOperationException("RowSet.setByte(java.lang.String,byte)");
    }

    @Override
    public void setBoolean(String s, boolean b) {
        throw new UnsupportedOperationException("RowSet.setBoolean(java.lang.String,boolean)");
    }

    @Override
    public void setNull(String s, int i, String s1) {
        throw new UnsupportedOperationException("RowSet.setNull(java.lang.String,int,java.lang.String)");
    }

    @Override
    public void setNull(String s, int i) {
        throw new UnsupportedOperationException("RowSet.setNull(java.lang.String,int)");
    }

    @Override
    public void updateClob(String s, Reader r) {
        throw new UnsupportedOperationException("ResultSet.updateClob(java.lang.String,java.io.Reader)");
    }

    @Override
    public void updateClob(int i, Reader r) {
        throw new UnsupportedOperationException("ResultSet.updateClob(int,java.io.Reader) ");
    }

    @Override
    public void updateBlob(String s, InputStream is) {
        throw new UnsupportedOperationException("ResultSet.updateBlob(java.lang.String,java.io.InputStream)");
    }

    @Override
    public void updateBlob(int i, InputStream is) {
        throw new UnsupportedOperationException("ResultSet.updateBlob(int,java.io.InputStream)");
    }

    @Override
    public void updateCharacterStream(String s, Reader r) {
        throw new UnsupportedOperationException("ResultSet.updateCharacterStream(java.lang.String,java.io.Reader)");
    }

    @Override
    public void updateBinaryStream(String s, InputStream is) {
        throw new UnsupportedOperationException("ResultSet.updateBinaryStream(java.lang.String,java.io.InputStream)");
    }

    @Override
    public void updateAsciiStream(String s, InputStream is) {
        throw new UnsupportedOperationException("ResultSet.updateAsciiStream(java.lang.String,java.io.InputStream)");
    }

    @Override
    public void updateCharacterStream(int i, Reader r) {
        throw new UnsupportedOperationException("ResultSet.updateCharacterStream(int,java.io.Reader)");
    }

    @Override
    public void updateBinaryStream(int i, InputStream is) {
        throw new UnsupportedOperationException("ResultSet.updateBinaryStream(int,java.io.InputStream)");
    }

    @Override
    public void updateAsciiStream(int i, InputStream is) {
        throw new UnsupportedOperationException("ResultSet.updateAsciiStream(int,java.io.InputStream)");
    }

    @Override
    public void updateNCharacterStream(String str, Reader r) {
        throw new UnsupportedOperationException("ResultSet.updateNCharacterStream(java.lang.String,java.io.Reader)");
    }

    @Override
    public void updateNCharacterStream(int i, Reader r) {
        throw new UnsupportedOperationException("ResultSet.updateNCharacterStream(int,java.io.Reader)");
    }

    @Override
    public void updateClob(String s, Reader r, long l) {
        throw new UnsupportedOperationException("ResultSet.updateClob(java.lang.String,java.io.Reader,long)");
    }

    @Override
    public void updateClob(int i, Reader r, long l) {
        throw new UnsupportedOperationException("ResultSet.updateClob(int,java.io.Reader,long)");
    }

    @Override
    public void updateBlob(String s, InputStream is, long l) {
        throw new UnsupportedOperationException("ResultSet.updateBlob(java.lang.String,java.io.InputStream,long)");
    }

    @Override
    public void updateBlob(int i, InputStream is, long l) {
        throw new UnsupportedOperationException("ResultSet.updateBlob(int,java.io.InputStream,long)");
    }

    @Override
    public void updateCharacterStream(String s, Reader r, long l) {
        throw new UnsupportedOperationException("ResultSet.updateCharacterStream(java.lang.String,java.io.Reader,long)");
    }

    @Override
    public void updateBinaryStream(String s, InputStream i, long l) {
        throw new UnsupportedOperationException("ResultSet.updateBinaryStream(java.lang.String,java.io.InputStream,long)");
    }

    @Override
    public void updateAsciiStream(String s, InputStream i, long l) {
        throw new UnsupportedOperationException("ResultSet.updateAsciiStream(java.lang.String,java.io.InputStream,long)");
    }

    @Override
    public void updateCharacterStream(int i, Reader r, long l) {
        throw new UnsupportedOperationException("ResultSet.updateCharacterStream(int,java.io.Reader,long) ");
    }

    @Override
    public void updateBinaryStream(int i, InputStream is, long l) {
        throw new UnsupportedOperationException("ResultSet.updateBinaryStream(int,java.io.InputStream,long)");
    }

    @Override
    public void updateAsciiStream(int i, InputStream is, long l) {
        throw new UnsupportedOperationException("ResultSet.updateAsciiStream(int,java.io.InputStream,long)");
    }

    @Override
    public void updateNCharacterStream(String s, Reader r, long l) {
        throw new UnsupportedOperationException("ResultSet.updateNCharacterStream(java.lang.String,java.io.Reader,long)");
    }

    @Override
    public void updateNCharacterStream(int i, Reader r, long l) {
        throw new UnsupportedOperationException("ResultSet.updateNCharacterStream(int,java.io.Reader,long)");
    }

    @Override
    public Reader getNCharacterStream(String s) {
        throw new UnsupportedOperationException("ResultSet.getNCharacterStream(java.lang.String)");
    }

    @Override
    public Reader getNCharacterStream(int i) {
        throw new UnsupportedOperationException("ResultSet.getNCharacterStream(int)");
    }

    @Override
    public String getNString(String s) {
        throw new UnsupportedOperationException("ResultSet.getNString(java.lang.String)");
    }

    @Override
    public String getNString(int i) {
        throw new UnsupportedOperationException("ResultSet.getNString(int)");
    }

    @Override
    public void updateNString(String s, String s2) {
        throw new UnsupportedOperationException("ResultSet.updateNString(java.lang.String,java.lang.String)");
    }

    @Override
    public void updateNString(int i, String s) {
        throw new UnsupportedOperationException("ResultSet.updateNString(int,java.lang.String)");
    }

    @Override
    public boolean isClosed() {
        throw new UnsupportedOperationException("ResultSet.isClosed()");
    }

    @Override
    public int getHoldability() {
        throw new UnsupportedOperationException("ResultSet.getHoldability()");
    }

    @Override
    public void setCommand(String s) {
        throw new UnsupportedOperationException("RowSet.setCommand()");
    }

    @Override
    public void setConcurrency(int i) {
        throw new UnsupportedOperationException("RowSet.setConcurrency()");
    }

    @Override
    public void setDataSourceName(String s) {
        throw new UnsupportedOperationException("RowSet.setDataSourceName()");
    }

    @Override
    public void setDate(int i, Date date) {
        throw new UnsupportedOperationException("RowSet.setDate()");
    }

    @Override
    public void setDate(int i, Date date, Calendar calendar) {
        throw new UnsupportedOperationException("RowSet.setDate()");
    }

    @Override
    public void setDouble(int i, double d) {
        throw new UnsupportedOperationException("RowSet.setDouble()");
    }

    @Override
    public void setEscapeProcessing(boolean flag) {
        throw new UnsupportedOperationException("RowSet.setEscapeProcessing()");
    }

    @Override
    public void setFloat(int i, float f) {
        throw new UnsupportedOperationException("RowSet.setFloat()");
    }

    @Override
    public void setInt(int i, int j) {
        throw new UnsupportedOperationException("RowSet.setInt()");
    }

    @Override
    public void setLong(int i, long l) {
        throw new UnsupportedOperationException("RowSet.setLong()");
    }

    @Override
    public void setMaxFieldSize(int i) {
        throw new UnsupportedOperationException("RowSet.setMaxFieldSize()");
    }

    @Override
    public void setMaxRows(int i) {
        throw new UnsupportedOperationException("RowSet.setMaxRows()");
    }

    @Override
    public void setNull(int i, int j) {
        throw new UnsupportedOperationException("RowSet.setNull()");
    }

    @Override
    public void setNull(int i, int j, String s) {
        throw new UnsupportedOperationException("RowSet.setNull()");
    }

    @Override
    public void setObject(int i, Object obj) {
        throw new UnsupportedOperationException("RowSet.setObject()");
    }

    @Override
    public void setObject(int i, Object obj, int j) {
        throw new UnsupportedOperationException("RowSet.setObject()");
    }

    @Override
    public void setObject(int i, Object obj, int j, int k) {
        throw new UnsupportedOperationException("RowSet.setObject()");
    }

    @Override
    public void setPassword(String s) {
        throw new UnsupportedOperationException("RowSet.setPassword()");
    }

    @Override
    public void setQueryTimeout(int i) {
        throw new UnsupportedOperationException("RowSet.setQueryTimeout()");
    }

    @Override
    public void setReadOnly(boolean flag) {
        throw new UnsupportedOperationException("RowSet.setReadOnly()");
    }

    @Override
    public void setRef(int i, Ref ref) {
        throw new UnsupportedOperationException("RowSet.setRef()");
    }

    @Override
    public void setShort(int i, short word0) {
        throw new UnsupportedOperationException("RowSet.setShort()");
    }

    @Override
    public void setString(int i, String s) {
        throw new UnsupportedOperationException("RowSet.setString()");
    }

    @Override
    public void setTime(int i, Time time) {
        throw new UnsupportedOperationException("RowSet.setTime()");
    }

    @Override
    public void setTime(int i, Time time, Calendar calendar) {
        throw new UnsupportedOperationException("RowSet.setTime()");
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) {
        throw new UnsupportedOperationException("RowSet.setTimestamp()");
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar calendar) {
        throw new UnsupportedOperationException("RowSet.setTimestamp()");
    }

    @Override
    public void setTransactionIsolation(int i) {
        throw new UnsupportedOperationException("RowSet.setTransactionIsolation()");
    }

    @Override
    public void setType(int i) {
        throw new UnsupportedOperationException("RowSet.setType()");
    }

    public void setTypeMap(Map map) {
        throw new UnsupportedOperationException("RowSet.setTypeMap()");
    }

    @Override
    public void setUrl(String s) {
        throw new UnsupportedOperationException("RowSet.setUrl()");
    }

    @Override
    public void setURL(int parameterIndex, URL x) {
        throw new UnsupportedOperationException("RowSet.setUrl()");
    }

    @Override
    public void setUsername(String s) {
        throw new UnsupportedOperationException("RowSet.setUsername()");
    }

    @Override
    public String getRecordsetType() {
        return QueryTable.class.getName();
    }

    public QueryTable getShallowCopy() {
        QueryTable newQueryTable = null;
        try {
            Object obj = this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            newQueryTable = (QueryTable)obj;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (newQueryTable == null) {
            newQueryTable = new QueryTable();
        }
        newQueryTable.makeShallowCopy(this, -1);
        return newQueryTable;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryTable) {
            return ((QueryTable)obj).list.equals(this.list);
        }
        return false;
    }

    public boolean equalsForAutoScalarise(Object obj) {
        if (obj instanceof QueryTable) {
            return ((QueryTable)obj).list == this.list;
        }
        return false;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.getURL(int)");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.getURL(String)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateArray(int, Array)");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateArray(String, Array)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateBlob(int, Blob)");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateBlob(String, Blob)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateClob(int, Clob)");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateClob(String, Clob)");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateRef(int, Ref)");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException("ResultSet.updateRef(String, Ref)");
    }

    @Override
    public Object writeReplace() {
        QueryTableWrapper qtWrapper = new QueryTableWrapper();
        qtWrapper.setFetch_size(this.fetch_size);
        qtWrapper.setPos(this.pos);
        qtWrapper.setRead_null(this.read_null);
        qtWrapper.setUpdate_count(this.update_count);
        qtWrapper.setTable(super.writeReplace());
        return qtWrapper;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void setNClob(int i, Reader r) {
    }

    @Override
    public void setNClob(int i, NClob n) {
    }

    @Override
    public void setNClob(int i, Reader r, long l) {
    }

    @Override
    public void setNClob(String i, Reader r, long l) {
    }

    public void setNClob(String s, long l) {
    }

    @Override
    public void setNClob(String s, NClob n) {
    }

    @Override
    public void setNClob(String s, Reader r) {
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("QueryTable.getRowId(int columnIndex)");
    }

    @Override
    public RowId getRowId(String columnIndex) throws SQLException {
        throw new UnsupportedOperationException("QueryTable.getRowId(String columnIndex)");
    }

    @Override
    public void setRowId(String d, RowId r) {
    }

    @Override
    public void setRowId(int r, RowId t) {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setSQLXML(int d, SQLXML dd) {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("QueryTable.getRowId(int columnIndex, Map m)");
    }

    public Object getObject(String columnLabel, Map map) throws SQLException {
        throw new UnsupportedOperationException("QueryTable.getRowId(String columnLabel, Map m)");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException("QueryTable.getRowId(int columnIndex, Class type)");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException("QueryTable.getRowId(String columnLabel, Class type)");
    }

    class TypeConversionException
    extends SQLException {
        TypeConversionException(String s) {
            super(s);
        }
    }
}

