/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.QueryTableMetaDataWrapper;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructUtils;
import coldfusion.sql.QuerySQLException;
import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.imqTable;
import com.allaire.cfx.Query;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class QueryTableMetaData
implements ResultSetMetaData,
Serializable {
    protected int column_count;
    protected String[] column_label;
    protected boolean[] column_case;
    protected int[] column_type;
    protected String[] column_type_names;
    private String[] column_table_names = null;
    private boolean[] column_isSearchable = null;
    private int[] column_isNullable = null;
    private boolean predefined = true;
    private static final boolean collectAllMetaData = false;
    public static final int COLUMN_TYPE_UNDEFINED = -999;
    private Struct extendedMeta;

    public QueryTableMetaData() {
    }

    public QueryTableMetaData(Query cfx) {
        this.column_label = cfx.getColumns();
        this.column_count = this.column_label.length;
        this.column_type = new int[this.column_count];
        this.column_case = new boolean[this.column_count];
        this.column_type_names = new String[this.column_count];
        for (int i = 0; i < this.column_count; ++i) {
            if (this.column_label[i] == null || this.column_label[i].length() == 0) {
                this.column_label[i] = "COMPUTED_COLUMN_" + (i + 1);
            }
            this.column_type[i] = 2000;
        }
    }

    public QueryTableMetaData(ResultSet rs, Tag tag) throws SQLException {
        String tagClassName = tag.getClass().getName();
        if (tagClassName.equals("coldfusion.tagext.sql.InsertTag") || tagClassName.equals("coldfusion.tagext.sql.UpdateTag")) {
            ArrayList<String> columnLabelAsList = new ArrayList<String>();
            ArrayList<Integer> columnTypeAsList = new ArrayList<Integer>();
            ArrayList<String> columnTypeNamesAsList = new ArrayList<String>();
            int columns = 0;
            while (rs.next()) {
                columnLabelAsList.add(rs.getString("COLUMN_NAME"));
                columnTypeAsList.add(rs.getInt("DATA_TYPE"));
                try {
                    columnTypeNamesAsList.add(rs.getString("TYPE_NAME"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++columns;
            }
            this.column_count = columns;
            this.column_label = columnLabelAsList.toArray(new String[this.column_count]);
            this.column_type = new int[this.column_count];
            for (int j = 0; j < columnTypeAsList.size(); ++j) {
                this.column_type[j] = (Integer)columnTypeAsList.get(j);
            }
            this.column_type_names = columnTypeNamesAsList.toArray(new String[this.column_count]);
        }
    }

    public QueryTableMetaData(ResultSetMetaData meta) throws SQLException {
        this.column_count = meta.getColumnCount();
        this.column_case = new boolean[this.column_count];
        this.column_label = new String[this.column_count];
        this.column_type = new int[this.column_count];
        this.column_type_names = new String[this.column_count];
        boolean mysql = false;
        if (meta.getClass().getName().equals("com.mysql.jdbc.ResultSetMetaData") && !Boolean.getBoolean("coldfusion.mysql.enableiscasesensitive")) {
            mysql = true;
        }
        for (int i = 0; i < this.column_count; ++i) {
            this.column_label[i] = meta.getColumnLabel(i + 1);
            if (this.column_label[i] == null || this.column_label[i].length() == 0) {
                this.column_label[i] = "COMPUTED_COLUMN_" + (i + 1);
            }
            this.column_case[i] = mysql ? false : meta.isCaseSensitive(i + 1);
            this.column_type[i] = meta.getColumnType(i + 1);
            try {
                this.column_type_names[i] = meta.getColumnTypeName(i + 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public QueryTableMetaData(QueryTableMetaData meta) throws SQLException {
        this.column_count = meta.getColumnCount();
        this.column_case = new boolean[this.column_count];
        this.column_label = new String[this.column_count];
        if (meta.column_type != null) {
            this.column_type = new int[this.column_count];
            this.column_type_names = new String[this.column_count];
        }
        for (int i = 0; i < this.column_count; ++i) {
            this.column_label[i] = meta.getColumnLabel(i + 1);
            if (this.column_label[i] == null || this.column_label[i].length() == 0) {
                this.column_label[i] = "COMPUTED_COLUMN_" + (i + 1);
            }
            this.column_case[i] = meta.isCaseSensitive(i + 1);
            if (meta.column_type == null) continue;
            try {
                this.column_type[i] = meta.getColumnType(i + 1);
                this.column_type_names[i] = meta.getColumnTypeName(i + 1);
            }
            catch (Exception e) {
                this.column_case[i] = false;
                this.column_type[i] = 12;
                this.column_type_names[i] = "java.lang.String";
            }
            if (!"nvarchar".equals(this.column_type_names[i])) continue;
            this.column_type[i] = 12;
        }
        if (meta.getExtendedMetaData() != null) {
            this.setExtendedMetaData((Struct)meta.getExtendedMetaData().clone());
        }
    }

    public QueryTableMetaData(QueryTable qtbl) throws SQLException {
        this.column_count = qtbl.getColumnCount();
        this.column_label = new String[this.column_count];
        this.column_type = new int[this.column_count];
        this.column_type_names = new String[this.column_count];
        this.column_case = new boolean[this.column_count];
        for (int i = 0; i < this.column_count; ++i) {
            this.column_label[i] = qtbl.getColumnName(i + 1);
            if (this.column_label[i] == null || this.column_label[i].length() == 0) {
                this.column_label[i] = "COMPUTED_COLUMN_" + (i + 1);
            }
            this.column_type[i] = qtbl.guessColumnType(i);
            this.column_type_names[i] = imqTable.getColumnTypeName(this.column_type[i]);
            this.column_case[i] = false;
        }
        this.setPredefined(false);
    }

    public QueryTableMetaData(String[] columns) {
        this.column_count = columns.length;
        this.column_label = new String[this.column_count];
        this.column_type = null;
        this.column_type_names = null;
        this.column_case = new boolean[this.column_count];
        for (int i = 0; i < this.column_count; ++i) {
            this.column_label[i] = columns[i];
            if (this.column_label[i] == null || this.column_label[i].length() == 0) {
                this.column_label[i] = "COMPUTED_COLUMN_" + (i + 1);
            }
            this.column_case[i] = false;
        }
        this.setPredefined(false);
    }

    public QueryTableMetaData(String[] columns, String[] sqlColTypeNames, int[] sqlColTypes) {
        this.column_count = columns.length;
        this.column_label = new String[this.column_count];
        this.column_type = new int[this.column_count];
        this.column_type_names = new String[this.column_count];
        this.column_case = new boolean[this.column_count];
        for (int i = 0; i < this.column_count; ++i) {
            this.column_label[i] = columns[i];
            if (this.column_label[i] == null || this.column_label[i].length() == 0) {
                this.column_label[i] = "COMPUTED_COLUMN_" + (i + 1);
            }
            this.column_type[i] = sqlColTypes[i];
            this.column_type_names[i] = sqlColTypeNames[i];
            this.column_case[i] = false;
        }
    }

    public QueryTableMetaData(QueryTableMetaDataWrapper qtMetaDataWrapper) {
        this.initFromWrapper(qtMetaDataWrapper);
    }

    private void initFromWrapper(QueryTableMetaDataWrapper qtMetaDataWrapper) {
        this.column_case = qtMetaDataWrapper.getColumn_case();
        this.column_count = qtMetaDataWrapper.getColumn_count();
        this.column_isNullable = qtMetaDataWrapper.getColumn_isNullable();
        this.column_isSearchable = qtMetaDataWrapper.getColumn_isSearchable();
        this.column_label = qtMetaDataWrapper.getColumn_label();
        this.column_table_names = qtMetaDataWrapper.getColumn_table_names();
        this.column_type = qtMetaDataWrapper.getColumn_type();
        this.column_type_names = qtMetaDataWrapper.getColumn_type_names();
        this.extendedMeta = (Struct)qtMetaDataWrapper.getExtendedMeta();
        this.predefined = qtMetaDataWrapper.isPredefined();
    }

    public static Array getQueryMetaData(ResultSet rs) {
        Array queryMeta = new Array();
        try {
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                Struct queryColMeta = QueryTableMetaData.getQueryColumnMetaData(meta, i);
                ArrayUtil.ArrayAppend(queryMeta, queryColMeta);
            }
        }
        catch (SQLException sqlExp) {
            throw new QuerySQLException(sqlExp);
        }
        return queryMeta;
    }

    public static Struct getQueryColumnMetaData(ResultSetMetaData meta, int i) throws SQLException {
        Struct queryColMeta = new Struct(false);
        StructUtils.StructInsert(queryColMeta, "Name", meta.getColumnName(i), false);
        try {
            StructUtils.StructInsert(queryColMeta, "TypeName", meta.getColumnTypeName(i), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            StructUtils.StructInsert(queryColMeta, "IsCaseSensitive", meta.isCaseSensitive(i), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryColMeta;
    }

    public void InferMetaDataTypes(QueryTable qtbl) throws SQLException {
        if (this.column_type == null) {
            start = 0;
            this.column_type = new int[this.column_count];
            this.column_type_names = new String[this.column_count];
        } else {
            start = this.column_type.length;
            int[] tempColType = new int[this.column_count];
            System.arraycopy(this.column_type, 0, tempColType, 0, this.column_type.length);
            this.column_type = tempColType;
            String[] tempColTypeNames = new String[this.column_count];
            System.arraycopy(this.column_type_names, 0, tempColTypeNames, 0, this.column_type_names.length);
            this.column_type_names = tempColTypeNames;
        }
        for (int i = start; i < this.column_count; ++i) {
            this.column_type[i] = qtbl.guessColumnType(i);
            this.column_type_names[i] = imqTable.getColumnTypeName(this.column_type[i]);
        }
        this.setPredefined(false);
    }

    public void addColumnName(String colName, boolean colCase) {
        ++this.column_count;
        String[] tempColNames = new String[this.column_count];
        System.arraycopy(this.column_label, 0, tempColNames, 0, this.column_label.length);
        tempColNames[this.column_count - 1] = colName;
        this.column_label = tempColNames;
        boolean[] tempColCase = new boolean[this.column_count];
        if (this.column_case != null) {
            System.arraycopy(this.column_case, 0, tempColCase, 0, this.column_case.length);
            tempColCase[this.column_count - 1] = colCase;
        } else {
            for (int i = 0; i < this.column_count; ++i) {
                tempColCase[i] = false;
            }
        }
        this.column_case = tempColCase;
    }

    public void deleteColumnNameAndType(int colId) {
        --this.column_count;
        String[] tempColNames = new String[this.column_count];
        System.arraycopy(this.column_label, 0, tempColNames, 0, colId);
        System.arraycopy(this.column_label, colId + 1, tempColNames, colId, this.column_count - colId);
        this.column_label = tempColNames;
        boolean[] tempColCase = new boolean[this.column_count];
        System.arraycopy(this.column_case, 0, tempColCase, 0, colId);
        System.arraycopy(this.column_case, colId + 1, tempColCase, colId, this.column_count - colId);
        this.column_case = tempColCase;
        this.deleteColumnType(colId);
    }

    private void deleteColumnType(int colId) {
        if (this.column_type != null && this.column_type.length > 0) {
            int[] tempColTypes = new int[this.column_count];
            System.arraycopy(this.column_type, 0, tempColTypes, 0, colId);
            System.arraycopy(this.column_type, colId + 1, tempColTypes, colId, this.column_count - colId);
            this.column_type = tempColTypes;
        }
        if (this.column_type_names != null && this.column_type_names.length > 0) {
            String[] tempColTypeNames = new String[this.column_count];
            System.arraycopy(this.column_type_names, 0, tempColTypeNames, 0, colId);
            System.arraycopy(this.column_type_names, colId + 1, tempColTypeNames, colId, this.column_count - colId);
            this.column_type_names = tempColTypeNames;
        }
    }

    public void addColumnType(int SqlColType) {
        if (this.column_type == null) {
            this.column_type = new int[this.column_count];
            this.column_type_names = new String[this.column_count];
            for (int i = 0; i < this.column_count; ++i) {
                this.column_type_names[i] = "";
                this.column_type[i] = -1234;
            }
        } else if (this.column_type.length < this.column_count) {
            int[] tempColType = new int[this.column_count];
            System.arraycopy(this.column_type, 0, tempColType, 0, this.column_type.length);
            this.column_type = tempColType;
            String[] tempColTypeNames = new String[this.column_count];
            System.arraycopy(this.column_type_names, 0, tempColTypeNames, 0, this.column_type_names.length);
            this.column_type_names = tempColTypeNames;
        }
        this.column_type[this.column_count - 1] = SqlColType;
        this.column_type_names[this.column_count - 1] = QueryTable.getColumnTypeName(SqlColType);
    }

    public boolean isTypeKnown() {
        return this.column_type != null && this.column_type.length >= this.column_count;
    }

    public boolean isTypeKnown(int columnIdx) {
        return this.column_type != null && this.column_type.length >= columnIdx && columnIdx >= 1 && this.column_type[columnIdx - 1] != -1234;
    }

    public void resetTypes() {
        if (!this.predefined && this.column_type != null && this.column_label != null) {
            if (this.column_type.length != this.column_label.length) {
                this.column_type = null;
            } else {
                for (int colType : this.column_type) {
                    if (colType != -1234 && colType != 1111) continue;
                    this.column_type = null;
                    break;
                }
            }
        }
    }

    private void setPredefined(boolean b) {
        this.predefined = b;
    }

    public void setColumnCount(int colCount) {
        this.column_count = colCount;
    }

    public void setColumnLabel(String[] colLabel) {
        this.column_label = colLabel;
    }

    public void setColumnCase(boolean[] colCase) {
        this.column_case = colCase;
    }

    public void setColumnType(int[] colType) {
        this.column_type = colType;
    }

    public void setColumnTypeNames(String[] colTypeNames) {
        this.column_type_names = colTypeNames;
    }

    @Override
    public int getColumnCount() {
        return this.column_count;
    }

    @Override
    public boolean isAutoIncrement(int column) {
        throw new UnsupportedOperationException("isAutoIncrement()");
    }

    @Override
    public boolean isCaseSensitive(int column) {
        if (this.column_case != null) {
            return this.column_case[column - 1];
        }
        throw new UnsupportedOperationException("isCaseSensitive()");
    }

    @Override
    public boolean isSearchable(int column) {
        if (this.column_isSearchable != null) {
            return this.column_isSearchable[column - 1];
        }
        throw new UnsupportedOperationException("isSearchable()");
    }

    @Override
    public boolean isCurrency(int column) {
        throw new UnsupportedOperationException("isCurrency()");
    }

    @Override
    public int isNullable(int column) {
        if (this.column_isNullable != null) {
            return this.column_isNullable[column - 1];
        }
        throw new UnsupportedOperationException("isNullable()");
    }

    @Override
    public boolean isSigned(int column) {
        throw new UnsupportedOperationException("isSigned()");
    }

    @Override
    public int getColumnDisplaySize(int column) {
        throw new UnsupportedOperationException("getColumnDisplaySize()");
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (this.column_label != null) {
            return this.column_label[column - 1];
        }
        throw new UnsupportedOperationException("getColumnLabel()");
    }

    public String[] getColumnLabels() {
        return this.column_label;
    }

    @Override
    public String getColumnName(int column) {
        if (this.column_label != null) {
            return this.column_label[column - 1];
        }
        throw new UnsupportedOperationException("getColumnName()");
    }

    @Override
    public int getColumnType(int column) {
        return this.getColumnType(column, true);
    }

    public int getColumnType(int column, boolean throwException) {
        if (this.column_type != null && column <= this.column_type.length) {
            return this.column_type[column - 1];
        }
        if (throwException) {
            throw new UnsupportedOperationException("getColumnType()");
        }
        return -999;
    }

    @Override
    public String getColumnTypeName(int column) {
        if (this.column_type_names != null) {
            return this.column_type_names[column - 1];
        }
        throw new UnsupportedOperationException("getColumnTypeName()");
    }

    @Override
    public String getSchemaName(int column) {
        throw new UnsupportedOperationException("getSchemaName()");
    }

    @Override
    public int getPrecision(int column) {
        throw new UnsupportedOperationException("getPrecision()");
    }

    @Override
    public int getScale(int column) {
        throw new UnsupportedOperationException("getScale()");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.column_table_names != null) {
            return this.column_table_names[column - 1];
        }
        throw new UnsupportedOperationException("getTableName()");
    }

    @Override
    public String getCatalogName(int column) {
        throw new UnsupportedOperationException("getCatalog()");
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new UnsupportedOperationException("isReadOnly()");
    }

    @Override
    public boolean isWritable(int column) {
        throw new UnsupportedOperationException("isWritable()");
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        throw new UnsupportedOperationException("isDefinitelyWritable()");
    }

    @Override
    public String getColumnClassName(int column) {
        throw new UnsupportedOperationException("getColumnClassName()");
    }

    public void setExtendedMetaData(Struct extendedMeta) {
        this.extendedMeta = extendedMeta;
    }

    public Struct getExtendedMetaData() {
        return this.extendedMeta;
    }

    public Object writeReplace() {
        QueryTableMetaDataWrapper qtMetadata = new QueryTableMetaDataWrapper();
        qtMetadata.setColumn_case(this.column_case);
        qtMetadata.setColumn_count(this.column_count);
        qtMetadata.setColumn_isNullable(this.column_isNullable);
        qtMetadata.setColumn_isSearchable(this.column_isSearchable);
        qtMetadata.setColumn_label(this.column_label);
        qtMetadata.setColumn_table_names(this.column_table_names);
        qtMetadata.setColumn_type(this.column_type);
        qtMetadata.setColumn_type_names(this.column_type_names);
        qtMetadata.setExtendedMeta((Object)this.extendedMeta);
        qtMetadata.setPredefined(this.predefined);
        return qtMetadata;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("QueryTableMetaData.isWrapperFor(Class<?> iface)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("QueryTableMetaData.unwrap(Class<T> iface)");
    }

    public void removeUnnamedColumns() {
        for (int i = 0; i < this.column_count; ++i) {
            if (this.getColumnName(i + 1) == null || !"".equals(this.getColumnName(i + 1).trim())) continue;
            --this.column_count;
        }
    }
}

