/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql;

import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.sql.QueryStat;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.server.j2ee.sql.JRunConnectionHandle;
import coldfusion.sql.CFDataSource;
import coldfusion.sql.ConnectionSource;
import coldfusion.sql.DataSrcImpl;
import coldfusion.sql.ParameterList;
import coldfusion.sql.Table;
import coldfusion.util.RB;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;

public class SqlImpl {
    protected ConnectionSource src;
    protected String username;
    protected String password;
    protected String sql;
    protected Integer maxrows;
    protected Integer timeout;
    protected Integer fetch;
    protected int[] rset_list;
    protected int[] rset_rows;
    protected boolean close_con = true;
    protected ParameterList params;
    private String queryName;
    private boolean isCached = false;
    private boolean doMonitor = true;
    private QueryStat queryStat = null;
    private int lineNo;
    private boolean disableAutoGenKeys = false;
    private boolean queryLevelAutoGenEnable = false;
    private String storedProcName = null;

    public String getStoredProcName() {
        return this.storedProcName;
    }

    public void setStoredProcName(String storedProcName) {
        this.storedProcName = storedProcName;
    }

    public void setDisableAutoGenKeys(boolean disableAutoGenKeys) {
        this.queryLevelAutoGenEnable = true;
        this.disableAutoGenKeys = disableAutoGenKeys;
    }

    public void setConnectionSource(ConnectionSource s) {
        this.src = s;
    }

    public ConnectionSource getConnectionSource() {
        return this.src;
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSql(String s) {
        this.sql = s.trim();
    }

    public String getSql() {
        return this.sql;
    }

    public void setMaxrows(Integer r) {
        this.maxrows = r;
    }

    public Integer getMaxrows() {
        return this.maxrows;
    }

    public void setTimeout(Integer to) {
        this.timeout = to;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setFetchsize(Integer f) {
        this.fetch = f;
    }

    public Integer getFetchsize() {
        return this.fetch;
    }

    public void setDebug(boolean d) {
    }

    public boolean getDebug() {
        return false;
    }

    public void setCloseConnection(boolean c) {
        this.close_con = c;
    }

    public boolean getCloseConnection() {
        return this.close_con;
    }

    public ParameterList getParamList() {
        return this.params;
    }

    public void setParamList(ParameterList paramList) {
        this.params = paramList;
    }

    public void setInParam(Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        if (this.params == null) {
            this.params = new ParameterList();
        }
        this.params.setInParam(value, sqltype, scale, sqltype_name, dbvarname);
    }

    public void setInOutParam(Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        if (this.params == null) {
            this.params = new ParameterList();
        }
        this.params.setInOutParam(value, sqltype, scale, sqltype_name, dbvarname);
    }

    public void setOutParam(int sqltype, int scale, String sqltype_name, String dbvarname) {
        if (this.params == null) {
            this.params = new ParameterList();
        }
        this.params.setOutParam(sqltype, scale, sqltype_name, dbvarname);
    }

    public void setInParam(int pos, Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        if (this.params == null) {
            this.params = new ParameterList();
        }
        this.params.setInParam(pos, value, sqltype, scale, sqltype_name, dbvarname);
    }

    public void setInOutParam(int pos, Object value, int sqltype, int scale, String sqltype_name, String dbvarname) {
        if (this.params == null) {
            this.params = new ParameterList();
        }
        this.params.setInOutParam(pos, value, sqltype, scale, sqltype_name, dbvarname);
    }

    public void setOutParam(int pos, int sqltype, int scale, String sqltype_name, String dbvarname) {
        if (this.params == null) {
            this.params = new ParameterList();
        }
        this.params.setOutParam(pos, sqltype, scale, sqltype_name, dbvarname);
    }

    public void setResultSetList(int[] list) {
        this.rset_list = list;
    }

    public void setResultSetRows(int[] list) {
        this.rset_rows = list;
    }

    public void setQueryName(String name) {
        this.queryName = name;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public boolean getIsCached() {
        return this.isCached;
    }

    public void setIsCached(boolean isCached) {
        this.isCached = isCached;
    }

    public void markNoMonitor() {
        this.doMonitor = false;
    }

    public QueryStat getQueryStat() {
        return this.queryStat;
    }

    public String getDSN() {
        String DSN = null;
        if (this.src instanceof DataSrcImpl) {
            DSN = ((DataSrcImpl)this.src).getName();
        }
        return DSN;
    }

    public String getCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public void validate() throws SQLException {
        if (this.src == null) {
            throw new SQLException(RB.getString(this, "SqlImpl.1"));
        }
        this.src.validate();
    }

    public Connection getConnection() throws SQLException {
        return this.src.getConnection(this.username, this.password);
    }

    public Struct getClientInfo() throws Exception {
        Struct clientInfoStruct;
        block5: {
            clientInfoStruct = null;
            boolean isjdbc4Supported = false;
            Connection c = this.getConnection();
            if (c instanceof JRunConnectionHandle) {
                JRunConnectionHandle jrunCHandle = (JRunConnectionHandle)c;
                c = jrunCHandle.getPhysicalConnection();
                isjdbc4Supported = jrunCHandle.isJDBC4Supported();
            }
            if (isjdbc4Supported) {
                Properties clientInfoProps = c.getClientInfo();
                clientInfoStruct = new Struct();
                Set<Object> keys = clientInfoProps.keySet();
                for (Object key : keys) {
                    Object value = clientInfoProps.get(key);
                    if (value == null) continue;
                    clientInfoStruct.put(key, value);
                }
                break block5;
            }
            throw new UnsupportedOperationException();
        }
        return clientInfoStruct;
    }

    public Table execute(boolean inTxn, Struct clientInfoProperties) throws SQLException {
        Table table;
        boolean auto;
        Connection conn;
        String className;
        Connection c;
        if (this.doMonitor) {
            this.recordQueryMetrics();
        }
        if ((c = this.src.getConnection(this.username, this.password)) instanceof JRunConnectionHandle && ((className = (conn = ((JRunConnectionHandle)c).getPhysicalConnection()).getClass().getName()).contains("org.apache.derby.impl.jdbc.EmbedConnection") || className.contains("org.apache.derby.client.net.NetConnection"))) {
            c.setAutoCommit(false);
        }
        try {
            auto = c.getAutoCommit();
        }
        catch (SQLException ex) {
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(true, ex);
            }
            if (this.close_con) {
                c.close();
            }
            throw ex;
        }
        try {
            if (this.src instanceof DataSrcImpl) {
                if (((DataSrcImpl)this.src).getDatasrc() instanceof CFDataSource && this.queryLevelAutoGenEnable) {
                    ((CFDataSource)((DataSrcImpl)this.src).getDatasrc()).getDataSourceDef().setDisableAutogenKeys(this.disableAutoGenKeys);
                }
                table = ServiceFactory.getDataSourceService().executeQuery(c, this.sql, this.params, this.maxrows, this.timeout, this.fetch, this.rset_list, ((DataSrcImpl)this.src).getDatasrc(), clientInfoProperties);
            } else {
                table = ServiceFactory.getDataSourceService().executeQuery(c, this.sql, this.params, this.maxrows, this.timeout, this.fetch, this.rset_list, -1, -1, true, true, this.disableAutoGenKeys, clientInfoProperties);
            }
        }
        catch (SQLException ex) {
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(true, ex);
            }
            if (!auto && !inTxn) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this.close_con) {
                c.close();
            }
            throw ex;
        }
        try {
            if (!auto && !inTxn) {
                c.commit();
            }
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(false, null);
            }
            if (table != null) {
                table.setQueryStat(this.queryStat);
            }
            Table ex = table;
            return ex;
        }
        catch (SQLException ex) {
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(true, ex);
            }
            if (!auto && !inTxn) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw ex;
        }
        finally {
            if (this.close_con) {
                c.close();
            }
        }
    }

    private void recordQueryMetrics() {
        boolean isStoredProc = false;
        if (this.storedProcName != null && this.queryName == null) {
            this.queryName = this.storedProcName;
            isStoredProc = true;
        }
        this.queryStat = RequestMonitorEventProcessor.onQueryStart(this.queryName, this.isCached, this.getDSN(), this.sql, this.lineNo, isStoredProc);
    }

    public Table executeCall(boolean inTxn, Struct clientInfoProperties) throws SQLException {
        Table table;
        boolean auto;
        if (this.doMonitor) {
            this.recordQueryMetrics();
        }
        Connection c = this.src.getConnection(this.username, this.password);
        try {
            auto = c.getAutoCommit();
        }
        catch (SQLException ex) {
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(true, ex);
            }
            if (this.close_con) {
                c.close();
            }
            throw ex;
        }
        try {
            table = this.src instanceof DataSrcImpl ? ServiceFactory.getDataSourceService().executeCall(c, this.sql, this.params, this.rset_rows, this.timeout, this.fetch, this.rset_list, ((DataSrcImpl)this.src).getDatasrc(), clientInfoProperties) : ServiceFactory.getDataSourceService().executeCall(c, this.sql, this.params, this.rset_rows, this.timeout, this.fetch, this.rset_list, -1, -1, true, true, clientInfoProperties);
        }
        catch (SQLException ex) {
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(true, ex);
            }
            if (!auto && !inTxn) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this.close_con) {
                c.close();
            }
            throw ex;
        }
        try {
            if (!auto && !inTxn) {
                c.commit();
            }
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(false, null);
            }
            if (table != null) {
                table.setQueryStat(this.queryStat);
            }
            Table ex = table;
            return ex;
        }
        catch (SQLException ex) {
            if (this.doMonitor) {
                RequestMonitorEventProcessor.onQueryEnd(true, ex);
            }
            if (!auto && !inTxn) {
                try {
                    c.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw ex;
        }
        finally {
            if (this.close_con) {
                c.close();
            }
        }
    }

    public void clearSqlParams() {
        if (this.params != null) {
            this.params.clear();
        }
    }

    public DatabaseMetaData getDataBaseMetaData() throws SQLException {
        Connection c = this.src.getConnection(this.username, this.password);
        return c.getMetaData();
    }

    public void clear() {
        this.username = null;
        this.password = null;
        this.sql = null;
        this.maxrows = null;
        this.timeout = null;
        this.fetch = null;
        this.rset_list = null;
        this.close_con = true;
        this.clearSqlParams();
    }
}

