/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.BooleanComparator;
import coldfusion.sql.imq.CaseInsensitiveStringComparator;
import coldfusion.sql.imq.GenericComparator;
import coldfusion.sql.imq.ImqUnsupportedSortException;
import coldfusion.sql.imq.UnknownComparator;
import coldfusion.sql.imq.rttExpr;

public abstract class Comparator {
    int compare(Object objL, Object objR) {
        if (objL == null) {
            return objR == null ? 0 : -1;
        }
        return objR == null ? 1 : -9;
    }

    public static Comparator createComparator(int sqlType, boolean caseSensitive) {
        int javaType = rttExpr.SqlToJavaMapping(sqlType);
        if (javaType > 0 && javaType < 9) {
            return new GenericComparator();
        }
        if (javaType == 9 || javaType == 0) {
            if (caseSensitive || javaType == 0) {
                return new GenericComparator();
            }
            return new CaseInsensitiveStringComparator();
        }
        if (javaType == 11) {
            return new BooleanComparator();
        }
        if (javaType == -1) {
            return new UnknownComparator();
        }
        throw new ImqUnsupportedSortException(rttExpr.getSqlTypeName(sqlType));
    }
}

