/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ColumnMetaData;
import coldfusion.sql.imq.GroupByColumnList;
import coldfusion.sql.imq.SelectColumn;
import coldfusion.sql.imq.SelectColumnList;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttResultcolumnref;
import coldfusion.sql.imq.rttSelectExprSpec;

final class ExprColumn
extends SelectColumn {
    static final char RESULT = '\u0001';
    static final char GROUPBY = '\u0002';
    static final char ORDERBY = '\u0004';
    static final char HAVING = '\b';
    private String aliasName = null;
    private rttExpr expr = null;
    private ColumnMetaData metaData;
    private int rsColId;
    private int colUse;

    ExprColumn(rttExpr expression, char columnUse) {
        this.expr = expression;
        this.expr.setExprColumn(this);
        this.aliasName = null;
        this.metaData = new ColumnMetaData(expression);
        this.colUse = columnUse;
    }

    ExprColumn(rttExpr expression, String alias, char columnUse) {
        this.expr = expression;
        this.expr.setExprColumn(this);
        this.aliasName = alias;
        this.metaData = new ColumnMetaData(expression);
        this.colUse = columnUse;
    }

    String getAliasName() {
        return this.aliasName;
    }

    void setMetaData(ColumnMetaData colMetaData) {
        this.metaData = colMetaData;
    }

    ColumnMetaData getMetaData() {
        return this.metaData;
    }

    int getResultColumnId() {
        return this.rsColId;
    }

    @Override
    void setResultColumnId(int colId) {
        this.rsColId = colId;
    }

    void addUse(char columnUse) {
        this.colUse |= columnUse;
    }

    boolean isResultColumnOnly() {
        return (this.colUse | 1) == 1;
    }

    boolean hasAggrExpr() {
        return this.expr.hasAggrExpr();
    }

    rttExpr getExpr() {
        return this.expr;
    }

    String getName() {
        Object name = "";
        if (this.aliasName != null) {
            name = this.aliasName;
        } else if (this.expr != null) {
            name = this.expr.getName();
        }
        if (name == "") {
            name = "Column_" + String.valueOf(this.rsColId);
        }
        return name;
    }

    int getType() {
        return this.metaData.colType;
    }

    @Override
    void validate(SelectColumnList expandedList, TableList tableList) throws imqException {
        this.expr.validate(tableList);
        if (this.expr instanceof rttExprNum && this.expr.getJavaType() == 9) {
            this.expr = ((rttExprNum)this.expr).asRttExprString();
        }
        expandedList.addColumn(this);
        this.metaData.colName = this.getName();
        this.metaData.colCase = this.expr.getCase();
        this.metaData.colType = this.expr.getSqlType();
    }

    void validateGroupBy(rttSelectExprSpec selectSpec) throws imqException {
        rttResultcolumnref colref;
        GroupByColumnList groupByList = selectSpec.getGroupByList();
        if (groupByList != null && !this.expr.hasAggrExpr() && this.aliasName != null && (colref = groupByList.findByAlias(this.aliasName)) != null) {
            colref.setResultColumnId(this.rsColId);
            colref.setExprColumn(this);
            return;
        }
        this.expr.validateGroupBy(selectSpec);
    }

    @Override
    Object evaluate(TableListIterator tblListIter) throws imqException {
        if (tblListIter.getEvaluationMode() == 1) {
            return tblListIter.getCurrentRow(0).getColumn(this.rsColId);
        }
        this.expr.evaluate(tblListIter);
        return this.expr.getResult();
    }
}

