/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.Token;

public class ParseException
extends Exception {
    public static final int VISITED_COND_EXP = 1;
    public static final int VISITED_COND_PRIMARY = 2;
    public static final int VISITED_SIMPLE_COND = 3;
    public static final int VISITED_COND_TEST = 4;
    public static final int VISITED_COND_FACTOR = 5;
    public static final int VISITED_COMPARISON_OPERATOR = 6;
    public static final int VISITED_COMPARISON_COND = 7;
    public static final int VISITED_ROW_CONSTRUCTOR = 8;
    public static final int VISITED_NULL_COND = 9;
    public static final int VISITED_SELECT_SPEC = 10;
    public static final int VISITED_SELECT_LIST = 11;
    public static final int VISITED_SELECT_COLUMN = 12;
    public static final int VISITED_INPUT = 13;
    public static final int VISITED_ESCAPE = 14;
    public static final int VISITED_ORDER_BY = 15;
    public static int MAX_VISITED = 20;
    private boolean[] visited;
    protected String imqMessage = "";
    protected static String imqHeader = "<br><b>Query Of Queries syntax error.</b><br>";
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public void prependImqMessage(String msg, int visitedFlagIdx) {
        if (!this.visited[visitedFlagIdx]) {
            this.visited[visitedFlagIdx] = true;
            this.imqMessage = msg + this.eol + this.imqMessage;
        }
    }

    private void initVisitedFlags() {
        this.visited = new boolean[MAX_VISITED];
        for (int i = 0; i < MAX_VISITED; ++i) {
            this.visited[i] = false;
        }
    }

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.initVisitedFlags();
    }

    public ParseException() {
        this.specialConstructor = false;
        this.initVisitedFlags();
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
        this.initVisitedFlags();
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        Object expected = "";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = (String)expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = (String)expected + "...";
            }
            expected = (String)expected + this.eol + "    ";
        }
        String retval = imqHeader + this.eol;
        retval = retval + "Encountered \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = retval + " ";
            }
            if (tok.kind == 0) {
                retval = retval + this.tokenImage[0];
                break;
            }
            retval = retval + this.add_escapes(tok.image);
            tok = tok.next;
        }
        retval = retval + "." + this.eol;
        retval = retval + this.imqMessage;
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

