/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.RowTuple;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.imqTable;

class TableListIterator {
    static final int EVAL_NORMAL = 0;
    static final int EVAL_HAVING = 1;
    static final int EVAL_GROUP_BY = 2;
    private TableList tblList;
    protected RowTuple currTuple;
    private int size;
    private int evalMode;

    TableListIterator(TableList tableList) {
        this(tableList, 0);
    }

    TableListIterator(TableList tableList, int mode) {
        this.tblList = tableList;
        this.size = this.tblList.size();
        this.currTuple = new RowTuple(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.currTuple.set(i, this.getImqTable(i).firstRow());
        }
        this.evalMode = mode;
    }

    QueryTable getQueryTable(int TableId) {
        return this.tblList.getQueryTable(TableId);
    }

    imqTable getImqTable(int TableId) {
        return this.tblList.getImqTable(TableId);
    }

    Row getCurrentRow(int TableId) {
        return this.currTuple.get(TableId);
    }

    RowTuple getCurrentTuple() {
        return this.currTuple;
    }

    void setCurrentTuple(RowTuple rowTuple) {
        this.currTuple = rowTuple;
    }

    int getEvaluationMode() {
        return this.evalMode;
    }

    boolean hasNext(int TableId) {
        return this.currTuple.get(TableId) != null;
    }

    void next(int TableId) {
        this.currTuple.next(TableId);
    }

    void resetWithinGroup(int TableId) {
    }

    void reset(int TableId) {
        this.currTuple.set(TableId, this.getImqTable(TableId).firstRow());
    }

    void reset(int TableId, Row currRow) {
        this.currTuple.set(TableId, currRow);
    }
}

