/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.ColumnMetaData;
import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.ImqColumnNotInTableException;
import coldfusion.sql.imq.ImqNotInTableListException;
import coldfusion.sql.imq.SelectColumn;
import coldfusion.sql.imq.SelectColumnList;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExprColumnref;
import java.sql.ResultSetMetaData;

final class TableRefColumn
extends SelectColumn {
    String tableName;
    String colName;
    String aliasName;

    TableRefColumn(String TableName, String ColumnName, String alias) {
        this.tableName = TableName;
        this.colName = ColumnName;
        this.aliasName = alias;
    }

    @Override
    void validate(SelectColumnList expandedList, TableList tableList) throws imqException {
        QueryTable table = tableList.getQueryTable(this.tableName);
        if (table == null) {
            String columnName = this.tableName + "." + this.colName;
            throw new imqException(new ImqNotInTableListException(columnName));
        }
        ResultSetMetaData tblMeta = table.getMetaData();
        int colId = table.findColumn(this.colName);
        if (colId == 0) {
            String columnName = this.tableName + "." + this.colName;
            throw new imqException(new ImqColumnNotInTableException(columnName, this.tableName));
        }
        int tblId = tableList.getTableId(this.tableName);
        rttExprColumnref colRefExpr = new rttExprColumnref(this.tableName, this.colName, table, tblId, colId);
        ExprColumn exprCol = new ExprColumn(colRefExpr, this.aliasName, '\u0001');
        ColumnMetaData colMeta = new ColumnMetaData(tblMeta, colId);
        colMeta.colName = exprCol.getName();
        exprCol.setMetaData(colMeta);
        expandedList.addColumn(exprCol);
    }
}

