/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ColumnList;
import coldfusion.sql.imq.Comparator;
import coldfusion.sql.imq.OrderedColumn;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.imqTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

class TableSorter {
    static final int DESCENDING = -1;
    static final int ASCENDING = 1;
    static final boolean ORDER_BY_CASEINSENSITIVE = Boolean.getBoolean("coldfusion.application.orderby.caseinsensitive");
    imqTable tbl;
    int[] colId;
    int[] colOrder;
    Comparator[] colComparator;
    int colCount;
    List[] rowVectors;
    boolean caseSensitive;

    private void createSortingVectors() {
        int i;
        this.rowVectors = new List[2];
        int size = this.tbl.list.size();
        this.rowVectors[0] = Collections.synchronizedList(new ArrayList(size));
        this.rowVectors[1] = Collections.synchronizedList(new ArrayList(size));
        for (i = 0; i < size; ++i) {
            this.rowVectors[0].add(this.tbl.getRow(i));
            this.rowVectors[1].add(null);
        }
        this.colComparator = new Comparator[this.colCount];
        for (i = 0; i < this.colCount; ++i) {
            int sqlType = this.tbl.meta.getColumnType(this.colId[i] + 1);
            this.colComparator[i] = Comparator.createComparator(sqlType, this.caseSensitive);
        }
    }

    public TableSorter(imqTable imqTbl, ColumnList columnIdList) {
        this.tbl = imqTbl;
        this.colCount = columnIdList.size();
        this.colId = new int[this.colCount];
        this.colOrder = new int[this.colCount];
        this.caseSensitive = !ORDER_BY_CASEINSENSITIVE;
        int i = 0;
        ListIterator iter = columnIdList.listIterator();
        while (iter.hasNext()) {
            OrderedColumn colObj = (OrderedColumn)iter.next();
            this.colId[i] = colObj.getResultColumnId();
            this.colOrder[i] = colObj.isDescendingOrder() ? -1 : 1;
            ++i;
        }
        this.createSortingVectors();
    }

    public TableSorter(imqTable imqTbl, ColumnList columnIdList, boolean isCaseSensitive) {
        this.tbl = imqTbl;
        this.colCount = columnIdList.size();
        this.colId = new int[this.colCount];
        this.colOrder = new int[this.colCount];
        this.caseSensitive = isCaseSensitive;
        int i = 0;
        ListIterator iter = columnIdList.listIterator();
        while (iter.hasNext()) {
            OrderedColumn colObj = (OrderedColumn)iter.next();
            this.colId[i] = colObj.getResultColumnId();
            this.colOrder[i] = colObj.isDescendingOrder() ? -1 : 1;
            ++i;
        }
        this.createSortingVectors();
    }

    public TableSorter(imqTable imqTbl, int resultColCount) {
        this.tbl = imqTbl;
        this.colCount = resultColCount;
        this.colId = new int[this.colCount];
        this.colOrder = new int[this.colCount];
        this.caseSensitive = true;
        for (int i = 0; i < this.colCount; ++i) {
            this.colId[i] = i;
            this.colOrder[i] = 1;
        }
        this.createSortingVectors();
    }

    public TableSorter(imqTable imqTbl, int[] ColumnId, int[] ColumnOrder, boolean CaseSensitive) {
        this.tbl = imqTbl;
        this.colCount = ColumnId.length;
        this.colId = ColumnId;
        this.colOrder = ColumnOrder;
        this.caseSensitive = CaseSensitive;
        this.createSortingVectors();
    }

    int compareTo(List vect, int rowId1, int rowId2) {
        return this.compareTo((Row)vect.get(rowId1), (Row)vect.get(rowId2));
    }

    int compareTo(Row row1, Row row2) {
        int result = 0;
        for (int i = 0; i < this.colCount; ++i) {
            Object obj2;
            Object obj1 = row1.getColumn(this.colId[i]);
            result = this.colComparator[i].compare(obj1, obj2 = row2.getColumn(this.colId[i]));
            if (result == 0) continue;
            return result * this.colOrder[i];
        }
        return 0;
    }

    private void merge(List fromVector, List toVector, int Ls, int LeRs, int Re) {
        int Ti = Ls;
        int Li = Ls;
        int Ri = LeRs;
        while (Li < LeRs && Ri < Re) {
            if (this.compareTo(fromVector, Li, Ri) <= 0) {
                toVector.set(Ti++, fromVector.get(Li++));
                continue;
            }
            toVector.set(Ti++, fromVector.get(Ri++));
        }
        while (Li < LeRs) {
            toVector.set(Ti++, fromVector.get(Li++));
        }
        while (Ri < Re) {
            toVector.set(Ti++, fromVector.get(Ri++));
        }
    }

    private void mergeSort(List fromVector, List toVector, int fromRowId, int toRowId, boolean level) {
        if (fromRowId + 1 < toRowId) {
            int rowId = (int)Math.floor((fromRowId + toRowId) / 2);
            this.mergeSort(fromVector, toVector, fromRowId, rowId, !level);
            this.mergeSort(fromVector, toVector, rowId, toRowId, !level);
            if (level) {
                this.merge(toVector, fromVector, fromRowId, rowId, toRowId);
            } else {
                this.merge(fromVector, toVector, fromRowId, rowId, toRowId);
            }
        } else if (fromRowId + 1 == toRowId) {
            toVector.set(fromRowId, fromVector.get(fromRowId));
        }
    }

    void mergeSort() {
        this.mergeSort(this.rowVectors[0], this.rowVectors[1], 0, this.rowVectors[0].size(), true);
    }
}

