/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.sql.QueryStat;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.ImqTableWrapper;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.Struct;
import coldfusion.runtime.locale.CFNumberFormat;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.OrderByColumnList;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.TableSorter;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class imqTable
implements Serializable,
MemoryTrackable {
    private static final int INITIAL_COLUMN_NUMBER = 8;
    private static final int VECTOR_INIT_CAPACITY = 64;
    private static final int VECTOR_CAPACITY_INCR = 64;
    protected QueryTableMetaData meta;
    protected String[] col_names;
    protected int col_count;
    protected List<Row> list;
    private ArrayList<Row> listInternalUse;
    protected int row_count;
    private Row head;
    private Row tail;
    private MemoryTrackerProxy mtProxy;
    private QueryStat queryStat;
    private boolean cached = false;

    public imqTable() {
        this(0, 0);
    }

    public imqTable(int rows, int columns) {
        this.col_count = columns;
        this.col_names = new String[columns];
        for (int i = 0; i < this.col_count; ++i) {
            this.col_names[i] = "COMPUTED_COLUMN_" + (i + 1);
        }
        this.createRows(rows);
        this.createMetaData(this.col_names);
    }

    public imqTable(String[] columns) {
        this.col_count = columns.length;
        this.col_names = new String[this.col_count];
        for (int i = 0; i < this.col_count; ++i) {
            this.col_names[i] = columns[i];
        }
        this.createRows(0);
        this.createMetaData(this.col_names);
    }

    public imqTable(int rows, String[] columns) {
        this.col_count = columns.length;
        this.col_names = new String[this.col_count];
        for (int i = 0; i < this.col_count; ++i) {
            this.col_names[i] = columns[i];
        }
        this.createRows(rows);
        this.createMetaData(this.col_names);
    }

    public imqTable(int rows, String[] columns, String[] sqlColTypeNames) {
        this.col_count = columns.length;
        this.col_names = new String[this.col_count];
        int[] sqlColTypes = new int[this.col_count];
        for (int i = 0; i < this.col_count; ++i) {
            this.col_names[i] = columns[i];
            sqlColTypes[i] = QueryFunction.isValidColumnType(sqlColTypeNames[i]);
        }
        this.createRows(rows);
        this.meta = new QueryTableMetaData(columns, sqlColTypeNames, sqlColTypes);
    }

    public imqTable(int rows, String[] columns, String[] sqlColTypeNames, int[] sqlColTypes) {
        this.col_count = columns.length;
        this.col_names = new String[this.col_count];
        for (int i = 0; i < this.col_count; ++i) {
            this.col_names[i] = columns[i];
        }
        this.createRows(rows);
        this.meta = new QueryTableMetaData(columns, sqlColTypeNames, sqlColTypes);
    }

    public imqTable(int rows, String collist) {
        StringTokenizer t = new StringTokenizer(collist, ",");
        this.col_count = t.countTokens();
        this.col_names = new String[this.col_count];
        int i = 0;
        while (t.hasMoreTokens()) {
            this.col_names[i++] = t.nextToken().trim();
        }
        this.createRows(rows);
        this.createMetaData(this.col_names);
    }

    public imqTable(ImqTableWrapper imqWrapper) {
        this(0, 0);
        this.initImqTableFromWrapper(imqWrapper);
    }

    private void initImqTableFromWrapper(ImqTableWrapper imqWrapper) {
        this.cached = imqWrapper.isCached();
        this.col_count = imqWrapper.getCol_count();
        this.col_names = imqWrapper.getCol_names();
        this.head = (Row)imqWrapper.getHead();
        this.meta = (QueryTableMetaData)imqWrapper.getMetaData();
        this.row_count = imqWrapper.getRow_count();
        this.list = imqWrapper.getRowVector();
        if (this.list != null) {
            Iterator<Row> itr = this.list.iterator();
            Row rowObj = null;
            Row prevRow = null;
            while (itr.hasNext()) {
                rowObj = itr.next();
                if (prevRow != null) {
                    prevRow.next = rowObj;
                }
                prevRow = rowObj;
            }
        }
        this.tail = (Row)imqWrapper.getTail();
    }

    private <T> List getSyncList(int size) {
        this.listInternalUse = new ArrayList(size);
        this.list = Collections.synchronizedList(this.listInternalUse);
        return this.list;
    }

    private void createRows(int rows) {
        if (rows <= 0) {
            this.row_count = 0;
            this.list = this.getSyncList(64);
            return;
        }
        this.list = this.getSyncList(rows);
        this.addRows(rows, true);
        Row row = new Row(this.col_count, true);
    }

    private void createMetaData(String[] columnNames) {
        this.meta = new QueryTableMetaData(columnNames);
    }

    public int getRowCount() {
        return this.row_count;
    }

    public String[] getColumnNames() {
        return this.col_names;
    }

    public Struct getResult() {
        return this.getMeta().getExtendedMetaData();
    }

    protected int addRows(int rows, boolean exactColCount) {
        if (rows < 0) {
            return this.row_count;
        }
        for (int i = 0; i < rows; ++i) {
            this.addRowLast(new Row(this.col_count, exactColCount));
        }
        return this.row_count;
    }

    public void setColumnNames(String[] columns) {
        this.setColumnNames(columns, false);
    }

    public void setColumnNames(String[] columns, boolean preserveCase) {
        this.col_count = columns.length;
        this.col_names = new String[this.col_count];
        for (int i = 0; i < this.col_count; ++i) {
            this.col_names[i] = preserveCase ? columns[i] : columns[i].toUpperCase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureCapacity(int size) {
        List<Row> list = this.list;
        synchronized (list) {
            this.listInternalUse.ensureCapacity(size);
        }
    }

    public void clear() {
        for (int i = 0; i < this.col_count; ++i) {
            this.col_names[i] = null;
        }
        this.list.clear();
        this.tail = null;
        this.head = null;
        this.col_count = 0;
        this.row_count = 0;
    }

    public void addColumnName(String column_name) {
        if (this.col_names.length <= this.col_count) {
            String[] tempColNames = new String[this.col_names.length + 1];
            System.arraycopy(this.col_names, 0, tempColNames, 0, this.col_names.length);
            this.col_names = tempColNames;
        }
        this.col_names[this.col_count++] = column_name;
        this.meta.addColumnName(column_name, false);
    }

    public void deleteColumnnNameAndType(int colId) {
        int i = 0;
        for (i = colId + 1; i < this.col_names.length && i < this.col_count; ++i) {
            this.col_names[i - 1] = this.col_names[i];
        }
        if (i == this.col_count) {
            this.col_names[i - 1] = null;
        }
        this.meta.deleteColumnNameAndType(colId);
        --this.col_count;
    }

    public Row getRow(int rowId) {
        return this.list.get(rowId);
    }

    public Object deleteRow(int rowId) {
        if (rowId <= 0) {
            throw new QueryFunction.InvalidRowNumberException(1, rowId, "deleteRow");
        }
        int count = this.getRowCount();
        if (rowId > count) {
            throw new QueryFunction.RowNumberOutOfBoundException(rowId);
        }
        Row row = this.getRow(rowId - 1);
        this.removeRows(rowId - 1, 1);
        return this;
    }

    protected Object getField(Row row, int column) {
        return row == null || column < 1 || column > this.col_count ? null : row.getColumn(column - 1);
    }

    void setField(Row row, int column, Object value) {
        if (row == null || column < 1 || column > this.col_count) {
            return;
        }
        row.setColumn(column - 1, value);
    }

    public Row firstRow() {
        return this.head;
    }

    public Row lastRow() {
        return this.tail;
    }

    public Row nextRow(Row currRow) {
        return currRow.next;
    }

    public Row previousRow(Row currRow) {
        return currRow.prev;
    }

    void addRowAfter(Row currRow, Row addedRow, boolean updateVector) {
        if (currRow.next != null) {
            currRow.next.prev = addedRow;
            addedRow.next = currRow.next;
        } else {
            this.tail = addedRow;
            addedRow.next = null;
        }
        currRow.next = addedRow;
        addedRow.prev = currRow;
        ++this.row_count;
        if (updateVector) {
            this.list.add(addedRow);
        }
        addedRow.setMemoryTrackerProxy(this.mtProxy);
    }

    protected void addRowLast(Row addedRow, boolean updateVector) {
        if (this.tail == null) {
            this.head = addedRow;
            this.tail = addedRow;
            addedRow.next = null;
            addedRow.prev = null;
            this.row_count = 1;
            if (updateVector) {
                this.list.add(addedRow);
            }
            addedRow.setMemoryTrackerProxy(this.mtProxy);
        } else {
            this.addRowAfter(this.tail, addedRow, updateVector);
        }
    }

    protected void addRowLast(Row addedRow) {
        this.addRowLast(addedRow, true);
    }

    protected void addRow(Object[] rowA) {
        Row row = new Row(rowA);
        this.addRowLast(row, true);
    }

    public void removeRows(int rowIndex, int numRows) {
        for (int i = rowIndex; i < rowIndex + numRows; ++i) {
            Row row = this.list.get(i);
            this.removeRow(row);
        }
        this.resetRowVector();
    }

    void removeRow(Row row) {
        if (row.next != null) {
            row.next.prev = row.prev;
        } else {
            this.tail = row.prev;
        }
        if (row.prev != null) {
            row.prev.next = row.next;
        } else {
            this.head = row.next;
        }
        --this.row_count;
        if (this.mtProxy != null) {
            this.mtProxy.onRemoveObject(row.getRowData());
            row.setMemoryTrackerProxy(null);
        }
    }

    protected void resetRowVector() {
        this.ensureCapacity(this.row_count);
        this.list.clear();
        Row currRow = this.head;
        while (currRow != null) {
            this.list.add(currRow);
            currRow = currRow.next;
        }
    }

    protected void resetRowLinks() {
        for (int i = 0; i < this.row_count - 1; ++i) {
            Row rowNext;
            int j = i + 1;
            Row row = this.list.get(i);
            row.next = rowNext = this.list.get(j);
            rowNext.prev = row;
        }
        if (this.row_count > 0) {
            this.head = this.list.get(0);
            this.head.prev = null;
            this.tail = this.list.get(this.row_count - 1);
            this.tail.next = null;
        }
    }

    protected void makeShallowCopy(imqTable qt, int maxrows) {
        if (this.mtProxy != null) {
            this.mtProxy.resetMemory();
            this.mtProxy.onAddObject(qt);
        }
        this.col_names = qt.col_names;
        this.col_count = qt.col_count;
        this.list = qt.list;
        if (maxrows == -1 || qt.row_count < maxrows) {
            this.row_count = qt.row_count;
            this.tail = qt.tail;
        } else {
            this.row_count = maxrows;
            this.tail = qt.list.get(maxrows - 1);
            this.tail.next = null;
        }
        this.head = qt.head;
    }

    public int guessColumnType(int colId) throws imqException {
        int rowId;
        if (this.row_count < 1) {
            return 1111;
        }
        Object obj = this.getRow(0).getColumn(colId);
        int javaType = rttExpr.guesstimateJavaType(obj);
        for (rowId = 0; rowId < this.row_count && rowId < 50; ++rowId) {
            obj = this.getRow(rowId).getColumn(colId);
            int tmpJavaType = rttExpr.guesstimateJavaType(obj);
            javaType = rttExpr.getMaxCompatible(javaType, tmpJavaType);
        }
        for (rowId = 0; rowId < this.row_count; ++rowId) {
            obj = this.getRow(rowId).getColumn(colId);
            if (javaType == 9) {
                obj = rttExpr.castTo(obj, javaType);
            } else if (Locale.getDefault().getCountry().compareToIgnoreCase("US") == 0) {
                obj = rttExpr.castTo(obj, javaType);
            } else if (obj instanceof String) {
                if (javaType == 4) {
                    obj = new Double(CFNumberFormat.LsParseNumber((String)obj, Locale.getDefault()));
                } else if (javaType == 4) {
                    obj = CFPage.internal_LSParseDateTime((String)obj, Locale.getDefault());
                }
            }
            this.getRow(rowId).setColumn(colId, obj);
        }
        return rttExpr.JavaToSqlMapping(javaType);
    }

    public static String getColumnTypeName(int sqlType) {
        try {
            return rttExpr.getSqlTypeName(sqlType);
        }
        catch (Exception e) {
            return "UNKNOWN";
        }
    }

    private void sort(TableSorter tblSorter) {
        tblSorter.mergeSort();
        this.list = tblSorter.rowVectors[0];
        this.row_count = tblSorter.rowVectors[0].size();
        this.resetRowLinks();
    }

    public void sort(OrderByColumnList orderByList) {
        if (this.row_count < 2) {
            return;
        }
        TableSorter tblSorter = new TableSorter(this, orderByList);
        this.sort(tblSorter);
    }

    public void sort(OrderByColumnList orderByList, boolean isCaseSensitive) {
        if (this.row_count < 2) {
            return;
        }
        TableSorter tblSorter = new TableSorter(this, orderByList, isCaseSensitive);
        this.sort(tblSorter);
    }

    void sort(int colCount) {
        if (this.row_count < 2) {
            return;
        }
        TableSorter tblSorter = new TableSorter(this, colCount);
        this.sort(tblSorter);
    }

    public void sort(int colIdx, boolean direction, boolean caseSensitive) {
        if (this.row_count < 2) {
            return;
        }
        int[] colId = new int[]{colIdx - 1};
        int[] colOrder = new int[]{direction ? 1 : -1};
        TableSorter tblSorter = new TableSorter(this, colId, colOrder, caseSensitive);
        this.sort(tblSorter);
    }

    public void sort(int colIdx, boolean direction) {
        this.sort(colIdx, direction, true);
    }

    void mergeAll(imqTable tbl) {
        if (tbl.head == null) {
            return;
        }
        if (this.tail != null) {
            this.tail.next = tbl.head;
            this.tail = tbl.tail;
        } else {
            this.head = tbl.head;
            this.tail = tbl.tail;
        }
        this.row_count += tbl.row_count;
        this.resetRowVector();
        if (this.mtProxy != null) {
            this.mtProxy.onAddObject(tbl);
        }
    }

    void mergeDistinct(imqTable tbl) throws imqException {
        Row row2;
        Row row1;
        if (this.head == null) {
            this.head = tbl.head;
            this.tail = tbl.tail;
            this.row_count = tbl.row_count;
            this.list = tbl.list;
            if (this.mtProxy != null) {
                this.mtProxy.onAddObject(tbl);
            }
            return;
        }
        if (tbl.head == null) {
            return;
        }
        this.head = null;
        this.tail = null;
        List<Row> V1 = this.list;
        List<Row> V2 = tbl.list;
        int rowCount1 = this.row_count;
        int rowCount2 = tbl.row_count;
        this.list = this.getSyncList(rowCount1 + rowCount2);
        this.row_count = 0;
        if (this.mtProxy != null) {
            this.mtProxy.resetMemory();
        }
        int i1 = 0;
        int i2 = 0;
        while (i1 < rowCount1 && i2 < rowCount2) {
            row1 = V1.get(i1);
            int diff = row1.compareTo(row2 = V2.get(i2));
            if (diff < 0) {
                this.addRowLast(row1);
                ++i1;
                continue;
            }
            if (diff > 0) {
                this.addRowLast(row2);
                ++i2;
                continue;
            }
            this.addRowLast(row1);
            ++i1;
            ++i2;
        }
        while (i1 < rowCount1) {
            row1 = V1.get(i1);
            this.addRowLast(row1);
            ++i1;
        }
        while (i2 < rowCount2) {
            row2 = V2.get(i2);
            this.addRowLast(row2);
            ++i2;
        }
    }

    void removeDuplicateRows() throws imqException {
        this.removeDuplicateRows(-1);
    }

    void removeDuplicateRows(int colCount) throws imqException {
        Row row;
        if (this.row_count == 0) {
            return;
        }
        this.head = row = this.list.get(0);
        row.prev = null;
        int i = 1;
        int newRowCount = 1;
        while (i < this.row_count) {
            Row rowNext;
            if (!(rowNext = this.list.get(i++)).equals(row, colCount)) {
                row.next = rowNext;
                rowNext.prev = row;
                row = rowNext;
                ++newRowCount;
                continue;
            }
            if (this.mtProxy == null) continue;
            this.mtProxy.onRemoveObject(rowNext.getRowData());
            rowNext.setMemoryTrackerProxy(null);
        }
        this.tail = row;
        row.next = null;
        this.row_count = newRowCount;
        this.resetRowVector();
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    @Override
    public int getScopeType() {
        return -1;
    }

    @Override
    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.mtProxy;
    }

    @Override
    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        if (mtp != null && mtp != this.mtProxy) {
            for (int i = 0; i < this.list.size(); ++i) {
                this.list.get(i).setMemoryTrackerProxy(mtp);
            }
            if (this.queryStat != null) {
                this.queryStat.setSize(mtp.getBuiltInMemoryTracker().getEstimatedMemory());
            }
        }
        this.mtProxy = mtp;
    }

    @Override
    public Iterator valuesIterator() {
        ArrayList<Object[]> rowData = new ArrayList<Object[]>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            rowData.add(this.list.get(i).getRowData());
        }
        return rowData.iterator();
    }

    public QueryStat getQueryStat() {
        return this.queryStat;
    }

    public void setQueryStat(QueryStat stat) {
        this.queryStat = stat;
    }

    public QueryTableMetaData getMeta() {
        return this.meta;
    }

    public void setMeta(QueryTableMetaData meta) {
        this.meta = meta;
    }

    public int getCol_count() {
        return this.col_count;
    }

    public void setCol_count(int col_count) {
        this.col_count = col_count;
    }

    public List getRowVector() {
        return this.list;
    }

    public void setRowVector(List list) {
        this.list = list;
        this.resetRowLinks();
    }

    public int getRow_count() {
        return this.row_count;
    }

    public void setRow_count(int row_count) {
        this.row_count = row_count;
    }

    public Row getTail() {
        return this.tail;
    }

    public void setTail(Row tail) {
        this.tail = tail;
    }

    public Row getHead() {
        return this.head;
    }

    public void setHead(Row head) {
        this.head = head;
    }

    public Object writeReplace() {
        ImqTableWrapper imqWrapper = new ImqTableWrapper();
        imqWrapper.setCached(this.cached);
        imqWrapper.setCol_count(this.col_count);
        imqWrapper.setCol_names(this.col_names);
        imqWrapper.setHead((Object)this.head);
        imqWrapper.setMetaData((Object)this.meta);
        imqWrapper.setRow_count(this.row_count);
        imqWrapper.setRowVector(this.list);
        imqWrapper.setTail((Object)this.tail);
        return imqWrapper;
    }
}

