/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.jdbcConnection;
import jakarta.servlet.jsp.PageContext;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class jdbcDriver
implements Driver {
    private static final String startURL = "jdbc:imq:";
    static final int MAJOR = 1;
    static final int MINOR = 0;
    static final String VERSION = "1.0";
    static final String PRODUCT = "IMQ: In Memory Query";
    private static final String debugImqStandalone = System.getProperty("DEBUG_IMQ");

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String password;
        if (!this.acceptsURL(url)) {
            return null;
        }
        String user = info.getProperty("user");
        if (user == null) {
            user = "";
        }
        if ((password = info.getProperty("password")) == null) {
            password = "";
        }
        PageContext pageContext = null;
        if ((debugImqStandalone == null || debugImqStandalone.compareToIgnoreCase("standalone") != 0) && (pageContext = (PageContext)info.get("page_context")) == null) {
            throw new SQLException("IMQ requires a PageContext to find the in memory tables.");
        }
        String s = url.substring(startURL.length());
        return new jdbcConnection(s, user, password, pageContext);
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(startURL);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        DriverPropertyInfo[] pinfo = new DriverPropertyInfo[2];
        DriverPropertyInfo p = new DriverPropertyInfo("user", null);
        p.value = info.getProperty("user");
        p.required = true;
        pinfo[0] = p;
        p = new DriverPropertyInfo("password", null);
        p.value = info.getProperty("password");
        p.required = true;
        pinfo[1] = p;
        return pinfo;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new jdbcDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

