/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ImqTypeMismatchException;
import coldfusion.sql.imq.ImqWrongOperandTypeException;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttExprNumBinary;
import coldfusion.sql.imq.rttExprString;
import coldfusion.sql.imq.rttExprStringConcat;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

final class rttExprNumBinaryAdd
extends rttExprNumBinary {
    rttExprNumBinaryAdd(rttExprNum left, rttExprNum right) {
        super(left, right);
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        super.evaluate(tblListIter);
        switch (this.getJavaType()) {
            case 1: 
            case 2: {
                long lval = this.Le.getLong() + this.Re.getLong();
                this.setResultObject(lval);
                break;
            }
            case 3: 
            case 4: {
                double dval = this.Le.getDouble() + this.Re.getDouble();
                this.setResultObject(dval);
                break;
            }
            case 5: {
                BigDecimal dval = this.Le.getBigDecimal().add(this.Re.getBigDecimal());
                this.setResult(dval);
                break;
            }
            case 9: {
                this.resultObj = (String)this.Le.getResult() + (String)this.Re.getResult();
                break;
            }
            case 8: {
                long lval = ((Date)this.Le.getResult()).getTime() + ((Date)this.Re.getResult()).getTime();
                this.resultObj = new Date(lval);
                break;
            }
            case 6: {
                long lval = ((Time)this.Le.getResult()).getTime() + ((Time)this.Re.getResult()).getTime();
                this.resultObj = new Time(lval);
                break;
            }
            case 7: {
                long lval = ((Timestamp)this.Le.getResult()).getTime() + ((Timestamp)this.Re.getResult()).getTime();
                this.resultObj = new Timestamp(lval);
                break;
            }
        }
    }

    @Override
    int combinedJavaType(int lt, int rt) throws imqException {
        int lst = rttExpr.JavaToSqlMapping(lt);
        int rst = rttExpr.JavaToSqlMapping(rt);
        if (!rttExpr.isPlusCompatible(lt)) {
            ImqWrongOperandTypeException ex = new ImqWrongOperandTypeException("+", rttExpr.getSqlTypeName(lst), "left");
            throw new imqException(ex);
        }
        if (!rttExpr.isPlusCompatible(rt)) {
            ImqWrongOperandTypeException ex = new ImqWrongOperandTypeException("+", rttExpr.getSqlTypeName(rst), "right");
            throw new imqException(ex);
        }
        if (rttExpr.isNumeric(lt) && rttExpr.isNumeric(rt)) {
            return lt < rt ? rt : lt;
        }
        if (lt == rt) {
            return lt;
        }
        ImqTypeMismatchException ex = new ImqTypeMismatchException("+", rttExpr.getSqlTypeName(lst), rttExpr.getSqlTypeName(rst));
        throw new imqException(ex);
    }

    @Override
    rttExprString asRttExprString() {
        rttExprString Lse = this.Le.asRttExprString();
        rttExprString Rse = this.Re.asRttExprString();
        return new rttExprStringConcat(Lse, Rse);
    }
}

