/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ImqWrongOperandTypeException;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttExprNumBinary;
import java.math.BigDecimal;

public class rttExprNumBinaryModulus
extends rttExprNumBinary {
    rttExprNumBinaryModulus(rttExprNum left, rttExprNum right) {
        super(left, right);
    }

    @Override
    void evaluate(TableListIterator tblListItr) throws imqException {
        super.evaluate(tblListItr);
        switch (this.getJavaType()) {
            case 1: 
            case 2: {
                long result = this.Le.getLong() % this.Re.getLong();
                this.setResultObject(result);
                break;
            }
            case 3: 
            case 4: {
                double result = this.Le.getDouble() % this.Re.getDouble();
                this.setResultObject(result);
                break;
            }
            case 5: {
                BigDecimal result = this.Le.getBigDecimal().remainder(this.Re.getBigDecimal());
                this.setResult(result);
            }
        }
    }

    @Override
    void validate(TableList tableList) throws imqException {
        super.validate(tableList);
        int javaType = this.Le.getJavaType();
        if (!this.validateOperandTypes(javaType)) {
            ImqWrongOperandTypeException ex = new ImqWrongOperandTypeException("%", rttExpr.getSqlTypeName(javaType), "left");
            throw new imqException(ex);
        }
        javaType = this.Re.getJavaType();
        if (!this.validateOperandTypes(javaType)) {
            ImqWrongOperandTypeException ex = new ImqWrongOperandTypeException("%", rttExpr.getSqlTypeName(javaType), "right");
            throw new imqException(ex);
        }
    }

    private boolean validateOperandTypes(int javaType) {
        return javaType >= 1 && javaType <= 5 || javaType == 9 || javaType == -1;
    }
}

