/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.ImqWrongOperandTypeException;
import coldfusion.sql.imq.TableList;
import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttExprNum;
import coldfusion.sql.imq.rttExprNumBinary;

public class rttExprNumBitwiseOp
extends rttExprNumBinary {
    private String operatorType;

    rttExprNumBitwiseOp(rttExprNum left, rttExprNum right, String Op) {
        super(left, right);
        this.operatorType = Op;
    }

    @Override
    void evaluate(TableListIterator tblListItr) throws imqException {
        super.evaluate(tblListItr);
        long result = 0L;
        switch (this.operatorType) {
            case "&": {
                result = this.Le.getLong() & this.Re.getLong();
                break;
            }
            case "|": {
                result = this.Le.getLong() | this.Re.getLong();
                break;
            }
            case "~": {
                result = this.Le.getLong() ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case "^": {
                result = this.Le.getLong() ^ this.Re.getLong();
                break;
            }
            case "<<": {
                result = this.Le.getLong() << (int)this.Re.getLong();
                break;
            }
            case ">>": {
                result = this.Le.getLong() >> (int)this.Re.getLong();
            }
        }
        this.setResultObject(result);
    }

    @Override
    void validate(TableList tableList) throws imqException {
        super.validate(tableList);
        int javaType = this.Le.getJavaType();
        if (!this.validateOperandTypes(javaType)) {
            ImqWrongOperandTypeException ex = new ImqWrongOperandTypeException(this.operatorType, rttExpr.getSqlTypeName(javaType), "left");
            throw new imqException(ex);
        }
        javaType = this.Re.getJavaType();
        if (!this.validateOperandTypes(javaType)) {
            ImqWrongOperandTypeException ex = new ImqWrongOperandTypeException(this.operatorType, rttExpr.getSqlTypeName(javaType), "right");
            throw new imqException(ex);
        }
    }

    private boolean validateOperandTypes(int javaType) {
        return javaType >= 1 && javaType <= 2 || javaType >= 9 && javaType <= 11;
    }
}

