/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.imq.TableListIterator;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExprColumnref;
import coldfusion.sql.imq.rttExprRef;
import coldfusion.sql.imq.rttSelectExprSpec;

class rttExprString
extends rttExprRef {
    static final int NONE = 0;
    static final int UPPER = 1;
    static final int LOWER = 2;
    private int mode = 0;
    Object processedResult;

    rttExprString() {
    }

    rttExprString(String strVal) {
        this.resultObj = rttExprString.escapeSingleQuotes(strVal);
        this.colRefExpr = null;
        this.javaType = 9;
        this.sqlType = 12;
    }

    public Object getProcessedResult() {
        return this.processedResult;
    }

    public void setProcessedResult(Object processedResult) {
        this.processedResult = processedResult;
    }

    rttExprString(rttExprColumnref colExpr, int Mode) {
        this.resultObj = null;
        this.colRefExpr = colExpr;
        this.mode = Mode;
    }

    void setMode(int Mode) {
        this.mode = Mode;
    }

    @Override
    boolean hasAggrExpr() {
        return false;
    }

    @Override
    void validateGroupBy(rttSelectExprSpec selectSpec) throws imqException {
        if (this.colRefExpr != null) {
            this.colRefExpr.validateGroupBy(selectSpec);
        }
    }

    @Override
    void validateHaving(rttSelectExprSpec selectSpec) throws imqException {
        if (this.colRefExpr != null) {
            this.colRefExpr.validateHaving(selectSpec);
            this.javaType = this.colRefExpr.javaType;
            this.sqlType = this.colRefExpr.sqlType;
        }
    }

    void UpperLower() {
        if (this.getJavaType() == 9) {
            String result = (String)this.getResult();
            if (result != null) {
                switch (this.mode) {
                    case 1: {
                        result = result.toUpperCase();
                        break;
                    }
                    case 2: {
                        result = result.toLowerCase();
                    }
                }
            }
            if (this.colRefExpr != null) {
                this.colRefExpr.resultObj = result;
            } else {
                this.resultObj = result;
            }
        }
    }

    @Override
    void evaluate(TableListIterator tblListIter) throws imqException {
        super.evaluate(tblListIter);
        this.UpperLower();
    }

    static String escapeSingleQuotes(String s) {
        if (s == null) {
            return s;
        }
        int beginLoc = 0;
        int quoteLoc = s.indexOf("''", beginLoc);
        if (quoteLoc >= 0) {
            StringBuffer workBuff = new StringBuffer();
            while (quoteLoc >= 0) {
                workBuff.append(s.substring(beginLoc, quoteLoc + 1));
                beginLoc = quoteLoc + 2;
                quoteLoc = s.indexOf("''", beginLoc);
            }
            workBuff.append(s.substring(beginLoc));
            return workBuff.toString();
        }
        return s;
    }
}

