/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.sql.imq;

import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.ExprColumn;
import coldfusion.sql.imq.ImqUnionUnmatchingSizeException;
import coldfusion.sql.imq.ImqUnionUnmatchingTypesException;
import coldfusion.sql.imq.OrderByColumnList;
import coldfusion.sql.imq.SelectColumnList;
import coldfusion.sql.imq.imqException;
import coldfusion.sql.imq.rttExpr;
import coldfusion.sql.imq.rttSelectExpr;
import coldfusion.sql.imq.rttSelectStmt;

class rttSelectExprUnion
extends rttSelectExpr {
    boolean isUnionAll;
    rttSelectExpr leftExpr;
    rttSelectExpr rightExpr;
    private int resultColCount;
    private SelectColumnList resultColList;

    rttSelectExprUnion(rttSelectExpr exprL, rttSelectExpr exprR, boolean isAll) {
        this.leftExpr = exprL;
        this.rightExpr = exprR;
        this.isUnionAll = isAll;
    }

    @Override
    void setParentStmt(rttSelectStmt stmt) {
        this.leftExpr.setParentStmt(stmt);
        this.rightExpr.setParentStmt(stmt);
    }

    @Override
    public SelectColumnList getExpandedSelectList() {
        return this.resultColList;
    }

    @Override
    void evaluate() throws imqException {
        this.leftExpr.evaluate();
        this.rightExpr.evaluate();
        QueryTable leftTbl = this.leftExpr.getResultTable();
        QueryTable rightTbl = this.rightExpr.getResultTable();
        if (!this.isUnionAll) {
            leftTbl.sort(leftTbl.col_count);
            leftTbl.removeDuplicateRows();
            rightTbl.sort(rightTbl.col_count);
            rightTbl.removeDuplicateRows();
            leftTbl.mergeDistinct(rightTbl);
        } else {
            leftTbl.mergeAll(rightTbl);
        }
        this.resultTable = this.leftExpr.getResultTable();
    }

    @Override
    void validate() throws imqException {
        this.leftExpr.validate();
        this.rightExpr.validate();
        SelectColumnList leftResultList = this.leftExpr.getExpandedSelectList();
        SelectColumnList rightResultList = this.rightExpr.getExpandedSelectList();
        if (leftResultList.getResultColumnCount() != rightResultList.getResultColumnCount()) {
            throw new imqException(new ImqUnionUnmatchingSizeException());
        }
        this.resultColCount = leftResultList.getResultColumnCount();
        for (int i = 0; i < leftResultList.getResultColumnCount(); ++i) {
            ExprColumn leftCol = leftResultList.getColumn(i);
            ExprColumn rightCol = rightResultList.getColumn(i);
            if (rttExpr.isUnionCompatibleSqlTypes(leftCol.getType(), rightCol.getType())) continue;
            String Ltn = rttExpr.getSqlTypeName(leftCol.getType());
            String Rtn = rttExpr.getSqlTypeName(rightCol.getType());
            throw new imqException(new ImqUnionUnmatchingTypesException(i + 1, Ltn, Rtn));
        }
        this.resultColList = leftResultList;
    }

    @Override
    void validateOrderBy(OrderByColumnList groupByList) throws imqException {
        this.leftExpr.validateOrderBy(groupByList);
    }
}

