/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext;

import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.CfxTagBase;
import coldfusion.tagext.NativeCFXException;
import coldfusion.tagext.NativeCfx;
import coldfusion.util.RuntimeWrapper;
import com.allaire.cfx.CustomTag;
import com.allaire.cfx.Request;
import com.allaire.cfx.Response;
import jakarta.servlet.jsp.JspException;
import java.util.Map;

public final class CfxTag
extends CfxTagBase {
    private String className;
    private String nativeLibrary;
    private String procedure;
    private boolean bCached = false;
    private NativeCfx nativeCfx;
    private CustomTag tag;

    @Override
    public void setClass(String o) {
        this.className = o;
        Map metadata = this.getRuntimeMetaData();
        if (metadata != null) {
            if (metadata.get("TYPE").toString().equalsIgnoreCase("CPP")) {
                this.nativeLibrary = metadata.get("LIBRARY").toString();
                this.procedure = metadata.get("PROCEDURE").toString();
                Object obj = metadata.get("CACHE");
                this.bCached = obj == null ? false : Cast._boolean(obj, false);
            } else {
                this.className = metadata.get("CLASSNAME").toString();
            }
        }
    }

    public String getCfxTagAttributeClass(String o) {
        return this.className;
    }

    @Override
    public int doStartTag() throws JspException {
        long startTime;
        block12: {
            this.onTagStart();
            startTime = System.currentTimeMillis();
            try {
                if (this.nativeLibrary == null) {
                    if (this.tag == null) {
                        try {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            if (cl == null) {
                                cl = this.getClass().getClassLoader();
                            }
                            Class<?> c = Class.forName(this.className, true, cl);
                            this.tag = (CustomTag)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (ClassCastException ex) {
                            throw new CFXClassCastException(this.className, ex);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new CFXClassNotFoundException(this.className, ex);
                        }
                        catch (Exception ex) {
                            throw new CFXClassLoadingException(this.className, ex);
                        }
                    }
                    this.tag.processRequest((Request)this, (Response)this);
                    break block12;
                }
                if (this.nativeCfx == null) {
                    this.nativeCfx = new NativeCfx(this);
                    this.nativeCfx.setLibrary(this.nativeLibrary);
                    this.nativeCfx.setProcedure(this.procedure);
                    this.nativeCfx.setCached(this.bCached);
                }
                this.nativeCfx.processRequest();
            }
            catch (NativeCFXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeWrapper(ex);
            }
        }
        if (this.debug()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.write("<HR><B>");
            this.write(this.className);
            this.write("</B> Execution Time = " + elapsedTime);
            this.write(" ms <BR>");
            this.write("<HR>");
        }
        this.onTagEnd();
        return 0;
    }

    private Map getRuntimeMetaData() {
        RuntimeService svc = ServiceFactory.getRuntimeService();
        if (svc != null) {
            return (Map)svc.getCfxtags().get("CFX_" + this.className);
        }
        throw new IllegalStateException("service isn't loaded");
    }

    public class CFXClassCastException
    extends ExpressionException {
        public String tagName;

        CFXClassCastException(String tagName, Throwable e) {
            this.tagName = tagName;
        }
    }

    public class CFXClassNotFoundException
    extends ExpressionException {
        public String tagName;

        CFXClassNotFoundException(String tagName, Throwable e) {
            this.tagName = tagName;
        }
    }

    public class CFXClassLoadingException
    extends ExpressionException {
        public String tagName;

        CFXClassLoadingException(String tagName, Throwable e) {
            super(e);
            this.tagName = tagName;
        }
    }
}

