/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext;

import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateException;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.lang.IncludeTag;
import coldfusion.tagext.lang.LoopTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.IterationTag;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.RowSet;

public abstract class QueryLoop
extends GenericTag
implements IterationTag,
TryCatchFinally {
    protected static final int DEF_MAXROWS = -1;
    protected static final int DEF_START = 1;
    protected static final int DEF_END = -1;
    protected QueryTable query;
    protected boolean is_maxrows_set = false;
    protected int maxrows = -1;
    protected int startrow = 1;
    protected int Endrow;
    protected String group;
    protected boolean ignore_cases = false;
    protected boolean is_endrow_set = false;
    protected int endrow = -1;
    protected boolean is_push_queryscope = false;
    protected int current;
    protected int row_count;
    protected int original_startrow;
    protected QueryTable originalQuery = null;
    protected boolean deferAttributeProcessing = false;
    protected QueryLoop[] tags;
    protected Object ref_value;
    protected int orig_current;

    public void setQuery(Object s) {
        Object q = s;
        if (s instanceof String) {
            q = this.pageContext.findAttribute((String)s);
        }
        if (q instanceof QueryTable) {
            this.query = ((QueryTable)q).getShallowCopy();
            this.originalQuery = (QueryTable)q;
        } else if (q != null) {
            try {
                if (!(q instanceof ResultSet)) {
                    throw new InvalidTagAttributeException(this.tagNameFromClass(((Object)((Object)this)).getClass()), "query", s);
                }
                this.query = new QueryTable((ResultSet)q);
            }
            catch (SQLException ex) {
                this.query = null;
            }
        } else {
            throw new InvalidTagAttributeException(this.tagNameFromClass(((Object)((Object)this)).getClass()), "query", s);
        }
    }

    public RowSet getRowSet() {
        return this.query;
    }

    public void setStartrow(int n) {
        this.startrow = n;
    }

    public void setDeferattributeprocessing(boolean setting) {
        this.deferAttributeProcessing = setting;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.is_push_queryscope = false;
        if (this.query == null || this.query.getRowCount() == 0) {
            return 0;
        }
        this.original_startrow = this.query.getCurrentRow();
        ((NeoPageContext)this.pageContext).pushQueryScope(this.query);
        this.is_push_queryscope = true;
        this.row_count = 0;
        this.row_count = this.query.getRowCount();
        this.Endrow = this.maxrows != -1 ? (this.startrow + this.maxrows - 1 < this.row_count ? this.startrow + this.maxrows - 1 : this.row_count) : (this.endrow == -1 ? this.row_count : this.endrow);
        if (this.startrow <= this.Endrow && this.startrow <= this.row_count) {
            this.query.absolute(this.startrow);
            this.current = this.startrow;
            if (this.originalQuery != null) {
                this.originalQuery.absolute(this.current);
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int doAfterBody() throws JspException {
        return this.doAfterBodyHelper();
    }

    private int doAfterBodyHelper() throws JspException {
        if (this.query == null) {
            return 0;
        }
        ++this.current;
        if (this.originalQuery != null) {
            this.originalQuery.absolute(this.current);
        }
        return this.query.next() && this.current <= this.Endrow ? 1 : 0;
    }

    public int doAfterBody2() throws JspException {
        if (this.query == null) {
            return 0;
        }
        return !this.query.isLast() && this.current + 1 <= this.Endrow ? 1 : 0;
    }

    public int doEndTag() throws JspException {
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.query = null;
        this.maxrows = -1;
        this.startrow = 1;
        this.group = null;
        this.ignore_cases = false;
        this.endrow = -1;
        this.tags = null;
        this.ref_value = null;
        super.release();
    }

    @Override
    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    @Override
    public void doFinally() {
        QueryLoop tagToReset;
        if (this.query != null && this.is_push_queryscope) {
            ((NeoPageContext)this.pageContext).popQueryScope();
            this.query.beforeFirst();
        }
        if (this.originalQuery != null) {
            this.originalQuery.absolute(this.original_startrow);
        }
        if (this.tags != null && this.tags.length != 0 && this.query == null && (tagToReset = this.findTagToReset(this.tags)) != null) {
            tagToReset.current = this.orig_current;
            tagToReset.resetQuery(this.orig_current);
        }
    }

    protected int advance() throws JspException {
        Object current_value;
        boolean sameGroup;
        if (this.tags.length == 0 && this.query == null) {
            return 0;
        }
        String sGroup = this.getGroupName();
        if (this.query == null && sGroup == null) {
            return this.tags[0].advanceOneRow();
        }
        if (this.query == null) {
            Object current_value2;
            boolean sameGroup2;
            do {
                current_value2 = this.getCurrentValue();
                if (this.tags[0].advanceOneRow() != 0) continue;
                return 0;
            } while (sameGroup2 = this.compareGroupVals(current_value2, this.getCurrentValue()));
            return 1;
        }
        if (sGroup == null) {
            return this.advanceOneRow();
        }
        do {
            current_value = this.getCurrentValue();
            if (this.doAfterBodyHelper() != 0) continue;
            return 0;
        } while (sameGroup = this.compareGroupVals(current_value, this.getCurrentValue()));
        return 1;
    }

    protected int advanceOneRow() throws JspException {
        if (this.tags.length == 0 && this.query == null) {
            return 0;
        }
        String sGroup = this.getGroupName();
        if (this.query == null && sGroup == null) {
            return this.tags[0].advanceOneRow();
        }
        if (this.query == null) {
            Object current_value = this.getCurrentValue();
            if (this.tags[0].advanceOneRow() != 0 && this.compareGroupVals(current_value, this.getCurrentValue())) {
                return 1;
            }
            return 0;
        }
        if (sGroup == null) {
            return this.doAfterBodyHelper();
        }
        Object current_value = this.getCurrentValue();
        if (this.doAfterBodyHelper() != 0 && this.compareGroupVals(current_value, this.getCurrentValue())) {
            return 1;
        }
        return 0;
    }

    protected Object getCurrentValue() {
        return this.getCurrentValue(this.getGroupName());
    }

    protected Object getCurrentValue(String sGroupName) {
        if (this.query != null) {
            int colNum = this.query.findColumn(sGroupName);
            if (colNum == 0) {
                throw new InvalidGroupNameException(sGroupName);
            }
            return this.query.getRow(this.current - 1).getColumn(colNum - 1);
        }
        return this.tags[0].getCurrentValue(sGroupName);
    }

    protected boolean compareGroupVals(Object one, Object two) {
        String cur_val = Cast._String(one);
        String new_val = Cast._String(two);
        if (this.isGroupcasesensitiveValue()) {
            return cur_val.equals(new_val);
        }
        return cur_val.equalsIgnoreCase(new_val);
    }

    public void resetQuery(int orig_start) {
        if (this.query != null) {
            this.query.absolute(orig_start);
        }
        if (this.originalQuery != null) {
            this.originalQuery.absolute(orig_start);
        }
    }

    public boolean isGroupcasesensitiveValue() {
        return this.ignore_cases;
    }

    public String getGroupName() {
        return this.group;
    }

    public QueryTable getQueryTable() {
        return this.query;
    }

    protected QueryLoop[] findAllQueryLoopTags(Class type) {
        ArrayList<QueryLoop> list = null;
        QueryLoop t = this;
        while ((t = t.getParent()) != null) {
            Tag parent;
            boolean groupAttributeInCFLoop;
            if (type.isAssignableFrom(((Object)((Object)t)).getClass())) {
                if (list == null) {
                    list = new ArrayList<QueryLoop>(4);
                }
                list.add(t);
                continue;
            }
            if (!(t instanceof IncludeTag) || ((IncludeTag)((Object)t)).getTemplate() != this.pageContext.getPage() || (groupAttributeInCFLoop = (parent = t.getParent()) != null && parent instanceof LoopTag && ((LoopTag)parent).getGroupName() != null)) continue;
            break;
        }
        if (list != null) {
            return list.toArray(new QueryLoop[list.size()]);
        }
        return new QueryLoop[0];
    }

    protected QueryLoop findQueryLoopTag(Class type) {
        QueryLoop tag = this;
        while ((tag = tag.getParent()) != null && !type.isAssignableFrom(((Object)((Object)tag)).getClass())) {
        }
        return tag;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public QueryLoop findTagToReset(QueryLoop[] tags) {
        if (tags == null) {
            return null;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].query == null) continue;
            return tags[i];
        }
        return null;
    }

    public static class InvalidGroupNameException
    extends TemplateException {
        private String group;

        public InvalidGroupNameException(String sGroupName) {
            this.group = sGroupName;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public class InvalidQueryNestingException
    extends TemplateException {
    }
}

