/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.ApplicationException;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.form.GridColumnData;
import coldfusion.tagext.html.form.GridTag;
import coldfusion.tagext.validation.AttributeNotSupportedException;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class AjaxGridHelper
implements AjaxImport {
    public static final String IMPORT_TAGNAME = "CFGRID";
    private static final String CFGRID_JS = "/package/cfgrid.js";
    private static final String SELECTED_COLOUR_CLASS = ".x-grid-item-selected";
    private static final String SELECTED_BG_COLOUR_DEFAULT = "white";
    private static final int COL_TYPE_STRING = 0;
    private static final int COL_TYPE_NUMBER = 1;
    private static final int COL_TYPE_BOOLEAN = 2;
    private static final int COL_TYPE_DATE = 3;
    private static final int COL_TYPE_COMBOBOX = 4;
    private static final String GRIDTAG = "CFGRID";
    private static final String DATA_FN = "getData";
    private static final String GRID_ID_PREFIX = "cfgrid";
    private static final String DATA_MODEL = "_cf_gridDataModel";
    private static final String DATA_PROXY = "_cf_gridDataProxy";
    private static final String DATA_FN_SCOPE = "_cf_scope";
    private static final String DATA_FN_ARG = "_cf_arg";
    private static final String DATA_FN_READER = "_cf_reader";
    private static final String DATA_FN_CALLBACK = "_cf_callback";
    private static final String DATA_FN_ERROR_HANDLER = "_cf_grid_errorhandler";
    public static final String DATA_FN_PAGE = "cfgridpage";
    public static final String DATA_FN_PAGESIZE = "cfgridpagesize";
    public static final String DATA_FN_SORTCOL = "cfgridsortcolumn";
    public static final String DATA_FN_SORTDIR = "cfgridsortdirection";
    private static final String GRIDNAME = "_cf_gridname";
    private static final String SELECETIONP_MODE = "_cf_selectionModel";
    private static final String[] DATA_FN_PARAMS = new String[]{"_cf_gridDataProxy", "cfgridpage", "cfgridpagesize", "cfgridsortcolumn", "cfgridsortdirection", "_cf_grid_errorhandler", "_cf_callback", "_cf_scope", "_cf_arg", "_cf_reader"};
    private static final String COL_MODEL = "_cf_gridColModel";
    private static final String OPEN_DATA = "var _cf_gridData = [";
    private static final String CLOSE_DATA = "];";
    private static final String DATA_MODEL_STRING1 = "Ext.define('cf_gridmodel-";
    private static final String DATA_MODEL_STRING2 = "', { extend: 'Ext.data.Model', fields: _cf_gridColModel,idProperty : 'CFGRIDROWINDEX' });";
    private static final String CONSTRUCT_STATIC_DATA_MODEL1 = "var _cf_gridDataModel = Ext.create('Ext.data.Store', { model : 'cf_gridmodel-";
    private static final String CONSTRUCT_STATIC_DATA_MODEL2 = "', data: _cf_gridData,proxy: {  type: 'memory',reader : new Ext.data.reader.Array({id:_cf_gridColModel.length-1}, _cf_gridColModel)}});";
    private static final String CONSTRUCT_STATIC_GROUPROW_DATA_MODEL_START = "var _cf_gridDataModel = Ext.create('Ext.data.Store', { groupField :";
    private static final String CONSTRUCT_STATIC_GROUPROW_DATA_MODEL_END1 = ", model : 'cf_gridmodel-";
    private static final String CONSTRUCT_STATIC_GROUPROW_DATA_MODEL_END2 = "', data: _cf_gridData,proxy: {  type: 'memory',reader : new Ext.data.reader.Array({id:_cf_gridColModel.length-1}, _cf_gridColModel)}});";
    private static final String OPEN_CONSTRUCT_DYNAMIC_DATA_MODEL1 = "var _cf_gridDataModel = Ext.create('Ext.data.Store',{ model : 'cf_gridmodel-";
    private static final String OPEN_CONSTRUCT_DYNAMIC_DATA_MODEL2 = "',proxy:{type: 'customcfajax',reader: {type: 'my-json',root: 'data',totalProperty: 'totalrows'},url:";
    private static final String OPEN_CONSTRUCT_DYNAMIC_DATA_MODEL_JS1 = "var _cf_gridDataModel = Ext.create('Ext.data.Store',{ model : 'cf_gridmodel-";
    private static final String OPEN_CONSTRUCT_DYNAMIC_DATA_MODEL_JS2 = "',proxy:{type: 'jsajax',reader: {type: 'my-json',root: 'data',totalProperty: 'totalrows'}";
    private static final String CLOSE_CONSTRUCT_DYNAMIC_DATA_MODEL = "}, remoteSort:true, sortInfo:true});";
    private static final String OPEN_CONSTRUCT_DYNAMIC_GROUPROW_DATA_MODEL = "var _cf_gridDataModel = new Ext.data.GroupingStore({proxy:new ColdFusion.Grid.ExtProxy(";
    private static final String CLOSE_CONSTRUCT_DYNAMIC_GROUPROW_DATA_MODEL = "), reader:new ColdFusion.Grid.ExtReader(_cf_gridColModel), remoteSort:true, sortInfo:{field:";
    private static final String LOAD_DATA_FN = "ColdFusion.Grid.loadData";
    private static final String CHECK_BOX_INIT = "new ColdFusion.Grid.CheckColumn({";
    private static final String CHANGE_FN = "onChange";
    private static final String CHANGE_FN_ACTION = "cfgridaction";
    private static final String CHANGE_FN_ROW = "cfgridrow";
    private static final String CHANGE_FN_CHANGED = "cfgridchanged";
    private static final String CHANGE_FN_CALLBACK = "_cf_gridchangecallback";
    private static final String CHANGE_FN_GRID = "_cf_grid";
    private static final String CHANGE_FN_ERROR_HANDLER = "_cf_grid_errorhandler";
    private static final String CHANGE_FN_GRID_PROPERTIES = "_cf_grid_properties";
    private static final String STYLE_GRID_TEXT_LEFT_ALIGN = "  .x-grid-header-offset { text-align: left; }";
    private static final String[] CHANGE_FN_PARAMS = new String[]{"cfgridaction", "cfgridrow", "cfgridchanged", "_cf_gridchangecallback", "_cf_grid", "_cf_grid_errorhandler", "_cf_grid_properties"};
    private static final String OPEN_COL_MODEL = "var _cf_gridColModel = [";
    private static final String CLOSE_COL_MODEL = "];";
    private static final String COL_HEADER = "header:";
    private static final String COL_SORT_TYPE = "sortType:";
    private static final String COL_SORTABLE = "sortable:";
    private static final String COL_WIDTH = "width:";
    private static final String COL_EDITOR = "editor:";
    private static final String COL_HIDDEN_TRUE = "hidden:true";
    private static final String COL_NAME = "'colName':";
    private static final String NAME = "'name':";
    private static final String DATA_INDEX = "dataIndex:";
    private static final String ID = "id:";
    private static final String MENU_DISABLED = "menuDisabled:";
    private static final String EDITABLE = "editable:";
    private static final String HEADER_CLASS_PREFIX = "x-grid-hd-";
    private static final String COL_CLASS_PREFIX = "x-grid-cell-";
    private static final String ROW_CLASS = "x-grid-row";
    private static final String STRIPE_ROW_CLASS = "x-grid-row-alt";
    private static final String[] COL_SORT_TYPES = new String[5];
    private static final String EDITOR_OPEN = "{xtype:'combobox'";
    private static final String NEW_EDITOR_OPEN = "new new Ext.form.";
    private static final String EDITOR_CLOSE = "())";
    private static final String[] COL_EDITOR_TYPES;
    private static final String DATE_FIELD_RENDERE_FUNC_NAME = "ColdFusion.Grid.formatDate";
    private static final String DATE_FIELD_CONVERT_FUNC_NAME = "ColdFusion.Grid.convertDate";
    private static SimpleDateFormat dateFormatter;
    private static final String TEXT_FIELD_EDITOR = "'textfield'";
    private static final String NUMBER_FIELD_EDITOR = "'numberfield'";
    private static final String BOOLEAN_EDITOR = "'checkbox'";
    private static final String COMBOBOX_EDITOR_BEGIN = "{xtype:'combobox',triggerAction: 'all', transform:'";
    private static final String COMBOBOX_EDITOR_END = "', lazyRender:true, editable:false,listClass: 'x-combo-list-small'}";
    private static final String DATE_FIELD_EDITOR = "{xtype:'datefield', format:";
    private static final String DEFAULT_DATE_FORMAT = "m/d/y";
    private static final String OPEN_CELL_CLICK_INFO = "{'appendKey':";
    private static final String OPEN_CELL_CLICK_COLINFO = "colInfo:[";
    private static final String CELL_CLICK_COLINFO_HREF = "'href':";
    private static final String CELL_CLICK_COLINFO_HREFKEY = "'hrefKey':";
    private static final String CELL_CLICK_COLINFO_TARGET = "'target':";
    private static final String COL_EDITOR_SELECT = ",transform:'";
    private static final String COL_EDITOR_SELECT_CLOSE = "',lazyRender:true,editable:false, triggerAction: 'all'}";
    private static final String OPEN_GRID_INIT = "ColdFusion.Grid.init(";
    private static final String SELECT_EDITOR_PREFIX = "cf_grid_select";
    private static final String COMMA = ",";
    private static final String OPEN_SELECT_TAG = "<select id='";
    private static final String END_SELECT_TAG = "' class='ygrid-editor'>";
    private static final String CLOSE_SELECT_TAG = "</select>";
    private static final String OPEN_OPTION_TAG = "<option value='";
    private static final String INFIX_OPTION_TAG = "'>";
    private static final String CLOSE_OPTION_TAG = "</option>";
    private static final String OPEN_SET_ACTIONS = "ColdFusion.objectCache[";
    private static final String INFIX_SET_ACTIONS = "] = new ColdFusion.Grid.Actions(";
    private static final String CLOSE_SET_ACTIONS = ");";
    private static final String DEFAULT_TEXT_COLOUR = "#0B333C";
    private static final String DEFAULT_SELECT_COLOUR = "#7FCDFE";
    private static final String GRID_DIV_STYLE = "border: 1px solid #cccccc; overflow: hidden;";
    private static final String HEADER_IMG_SOURCE_HOLDER_KEY = "IMG_PLACE_HOLDER";
    private static final String HEADER_IMG_MARKUP = "<img style=\"background-repeat:no-repeat;overflow:hidden;margin-left:2px;vertical-align:middle;\" src=\"IMG_PLACE_HOLDER\"/>";
    private static final String CONSTRUCT_CHECK_BOX_SELECTION_ = " var _cf_selectionModel = new Ext.selection.CheckboxModel();";
    private static final String CELL_EDIT_PLUGIN_VAR = "_cf_celleditplugin";
    private static final String CELL_EDIT_PLUGIN = " var _cf_celleditplugin = Ext.create('Ext.grid.plugin.CellEditing',{clicksToEdit:1});";
    private HtmlAssembler htmlAssembler;
    private GridTag gridTag;
    private List columns;
    private PageContext pageContext;
    private boolean isEdit;
    private boolean isStatic;
    private int[] columnTypes;
    private StringBuffer selectEditorBuffer;
    private int selectId = 0;
    private StringBuffer styles = new StringBuffer();
    private String gridId;
    private String onChangeFunction;
    private BindProcessor bindProcessor;
    private String checkBoxColumnModelVarName = null;
    private boolean hasWindowParent = false;
    private List pluginsList = new ArrayList();
    private String autoExpandColumn = "";

    public AjaxGridHelper(GridTag gridTag, PageContext context, Boolean hasWindowParent) {
        this.gridTag = gridTag;
        this.columns = gridTag.getColumns();
        this.pageContext = context;
        this.hasWindowParent = hasWindowParent;
        this.htmlAssembler = HtmlAssembler.getInstance(context, true);
        this.gridId = GRID_ID_PREFIX + this.htmlAssembler.getId();
    }

    AjaxGridHelper() {
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/yui/yahoo-dom-event/yahoo-dom-event.js");
        htmlAssembler.importJS("/yui/animation/animation-min.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/ext/source/widgets/DataView.js");
        htmlAssembler.importJS("/ext/source/widgets/SplitButton.js");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS(CFGRID_JS);
    }

    public String getGridId() {
        return this.gridId;
    }

    public void generate(JspWriter out) throws IOException, JspException {
        AjaxImportTag.generateImports("CFGRID", this.htmlAssembler);
        QueryTable query = this.gridTag.getQuery();
        if (query != null && query.findColumn("CFGRIDROWINDEX") != 0) {
            GridColumnData griColData = new GridColumnData();
            griColData.setName("CFGRIDROWINDEX");
            griColData.setDisplay(false);
            this.columns.add(griColData);
        }
        this.isEdit = this.gridTag.getSelectMode().equalsIgnoreCase("EDIT");
        boolean bl = this.isStatic = this.gridTag.getBind() == null;
        if (this.isStatic) {
            if (this.gridTag.isPageSizeDefined()) {
                throw new PageSizeNotAllowedForStaticGridException();
            }
        } else if (this.gridTag.getGroupField() != null && this.gridTag.getGroupField().length() > 0) {
            throw new GroupFieldNotAllowedForDynamicGridException();
        }
        this.generateStyles();
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent(OPEN_SET_ACTIONS).appendContent(this.gridTag.getIdAttribute(), true).appendContent(INFIX_SET_ACTIONS).appendContent(this.gridId, true).appendContent(CLOSE_SET_ACTIONS).newLine();
        String initFn = this.htmlAssembler.openFunction("GRIDTAG", "initAjaxGrid", true, true, null);
        if (this.gridTag.isMultiRowSelect()) {
            this.htmlAssembler.appendContent(CONSTRUCT_CHECK_BOX_SELECTION_);
            this.htmlAssembler.newLine();
        }
        this.checkIfAutowidthRequired();
        this.generateColumnModel();
        if (this.isStatic) {
            this.generateStaticDataSet();
        } else {
            this.generateDynamicDataSet();
        }
        this.generateOnChangeFunction();
        if (this.isEdit) {
            this.htmlAssembler.appendContent(CELL_EDIT_PLUGIN);
        }
        this.generateInitCall();
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent("Ext.form.ComboBox.prototype.triggerAction = 'all'");
        this.htmlAssembler.appendContent(";");
        this.htmlAssembler.closeFunction();
        this.htmlAssembler.setEventOnLoad(initFn);
        this.htmlAssembler.closeScriptTag();
        if (this.selectEditorBuffer != null) {
            this.htmlAssembler.appendContent(this.selectEditorBuffer.toString());
        }
        this.htmlAssembler.writeHead(out);
        this.htmlAssembler.writeHtml(out);
    }

    public static String getStyle(GridTag gridTag) {
        StringBuffer style = new StringBuffer(GRID_DIV_STYLE);
        if (gridTag.getHeight() != null) {
            style.append("height:").append(gridTag.getHeight()).append("px").append(';');
        }
        String width = gridTag.getWidth();
        if (gridTag.getWidth() != null && (width = AjaxUtils.checkValidCSSUnits(gridTag.getWidth())) == null) {
            width = gridTag.getWidth();
        }
        return style.toString();
    }

    private String calculateGridWidth() {
        int size = 0;
        for (int i = 0; i < this.columns.size() - 1; ++i) {
            GridColumnData column = (GridColumnData)this.columns.get(i);
            String width = column.getWidth();
            if (!column.isDisplay()) continue;
            if (width != null) {
                try {
                    int widthSize = Integer.parseInt(width);
                    size += widthSize;
                }
                catch (NumberFormatException e) {
                    size += 100;
                }
                continue;
            }
            return "0";
        }
        return "" + size;
    }

    private void generateStyles() {
        GridColumnData column;
        int i;
        int checkboxCount = 0;
        String selectColor = this.gridTag.getSelectColor() == null ? DEFAULT_SELECT_COLOUR : this.gridTag.getSelectColor();
        for (i = 0; i < this.columns.size(); ++i) {
            column = (GridColumnData)this.columns.get(i);
            if (column.getType() != null && column.getType().equalsIgnoreCase("BOOLEAN")) {
                ++checkboxCount;
            }
            this.styles.append("#").append(this.gridId).append(" ").append(".").append(COL_CLASS_PREFIX).append(this.getGridColId(column.getName().toUpperCase())).append('{');
            this.generateColumnStyle(column);
            this.styles.append('}').append(" ");
            this.styles.append("#").append(this.gridId).append(" ").append("#").append(this.getGridColId(column.getName().toUpperCase())).append("-textEl").append('{');
            this.generateHeaderStyle(column);
            this.styles.append('}').append(" ");
            this.styles.append("#").append(this.gridId).append(" ").append(SELECTED_COLOUR_CLASS).append(" ").append(".").append(COL_CLASS_PREFIX).append(this.getGridColId(column.getName().toUpperCase())).append('{').append("background-color").append(':').append(selectColor).append(" ").append("!important").append(';').append('}').append(" ");
        }
        if (selectColor != null && selectColor.length() > 0) {
            this.styles.append("#").append(this.gridId).append(" ").append(".x-grid-with-row-lines .x-grid-item.x-grid-item-selected").append(" ").append('{').append("background-color").append(':').append(selectColor).append(" ").append("!important").append(';').append('}').append(" ");
        }
        if (this.gridTag.getBgColor() != null) {
            this.addGridStyleProperty(ROW_CLASS, "background-color", this.gridTag.getBgColor());
        }
        for (i = 0; i < this.columns.size(); ++i) {
            column = (GridColumnData)this.columns.get(i);
            this.styles.append("#").append(this.gridId).append(" ").append(".").append(ROW_CLASS).append(" ").append(".").append(COL_CLASS_PREFIX).append(this.getGridColId(column.getName().toUpperCase())).append('{').append("background-color").append(':').append(this.gridTag.getBgColor()).append('}').append(" ");
            if (!this.gridTag.getStripeRows()) continue;
            this.styles.append("#").append(this.gridId).append(" ").append(".").append(STRIPE_ROW_CLASS).append(" ").append(".").append(COL_CLASS_PREFIX).append(this.getGridColId(column.getName().toUpperCase())).append('{').append("background-color").append(':').append(this.gridTag.getStripeRowColor()).append('}').append(" ");
        }
        if (this.gridTag.getStripeRows()) {
            this.styles.append("#").append(this.gridId).append(" ").append(".x-grid-with-row-lines .x-grid-item.x-grid-item-alt").append(" ").append('{').append("background-color").append(':').append(this.gridTag.getStripeRowColor()).append('}').append(" ");
        }
    }

    private void addGridStyleProperty(String cssClass, String property, String value) {
        this.styles.append(" ");
        this.styles.append("#").append(this.gridId).append(" ").append(".").append(cssClass).append('{');
        this.addStyleProperty(property, value, false);
        this.styles.append('}').append(" ");
    }

    private void generateColumnStyle(GridColumnData column) {
        String colour;
        String string = colour = column.getTextColor() == null ? this.gridTag.getTextColor() : column.getTextColor();
        if (colour == null) {
            colour = DEFAULT_TEXT_COLOUR;
        }
        String font = column.getFont() == null ? this.gridTag.getFont() : column.getFont();
        String fontSize = column.getFontSize() == null ? this.gridTag.getFontSize() : column.getFontSize();
        boolean isItalic = this.gridTag.isItalic() || column.isItalic();
        boolean isBold = this.gridTag.isBold() || column.isBold();
        this.generateTextStyle(colour, font, fontSize, isItalic, isBold);
        String backgroundColour = column.getBgColor();
        if (backgroundColour != null) {
            this.addStyleProperty("background-color", backgroundColour);
        }
        if (this.gridTag.getHref() != null || column.getHref() != null && (!column.isSelect() || !this.isEdit)) {
            this.addStyleProperty("text-decoration", "underline");
        }
    }

    private void generateTextStyle(String colour, String font, String fontSize, boolean isItalic, boolean isBold) {
        if (colour != null) {
            this.addStyleProperty("color", colour);
        }
        if (font != null) {
            this.addStyleProperty("font-family", font, true);
        }
        if (fontSize != null) {
            this.addStyleProperty("font-size", fontSize);
        }
        if (isItalic) {
            this.addStyleProperty("font-style", "italic");
        }
        if (isBold) {
            this.addStyleProperty("font-weight", "bold");
        }
    }

    private void addStyleProperty(String property, String value) {
        this.addStyleProperty(property, value, false);
    }

    private void addStyleProperty(String property, String value, boolean quoteValue) {
        this.addStyleProperty(property, value, quoteValue, false);
    }

    private void addStyleProperty(String property, String value, boolean quoteValue, boolean important) {
        this.styles.append(property).append(':');
        if (quoteValue) {
            this.styles.append("'");
        }
        this.styles.append(value);
        if (quoteValue) {
            this.styles.append("'");
        }
        if (important) {
            this.styles.append(" ").append("!important");
        }
        this.styles.append(';');
    }

    private void generateHeaderStyle(GridColumnData column) {
        String colour;
        String string = colour = column.getHeaderTextColor() == null ? this.gridTag.getColHeaderTextColor() : column.getHeaderTextColor();
        if (colour == null) {
            colour = DEFAULT_TEXT_COLOUR;
        }
        String font = column.getHeaderFont() == null ? this.gridTag.getColHeaderFont() : column.getHeaderFont();
        String fontSize = column.getHeaderFontSize() == null ? this.gridTag.getColHeaderFontSize() : column.getHeaderFontSize();
        boolean isItalic = this.gridTag.isColHeaderItalic() || column.isHeaderItalic();
        boolean isBold = this.gridTag.isColHeaderBold() || column.isHeaderBold();
        this.generateTextStyle(colour, font, fontSize, isItalic, isBold);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateColumnModel() throws JspException {
        QueryTable query = this.gridTag.getQuery();
        this.columnTypes = new int[this.columns.size()];
        StringBuffer columnModelsb = new StringBuffer();
        columnModelsb.append(OPEN_COL_MODEL);
        for (int i = 0; i < this.columns.size(); ++i) {
            int colType = 0;
            GridColumnData column = (GridColumnData)this.columns.get(i);
            if (column.getType() != null) {
                if (column.getType().equalsIgnoreCase("string_noCase")) {
                    colType = 0;
                } else if (column.getType().equalsIgnoreCase("boolean")) {
                    colType = 2;
                } else if (column.getType().equalsIgnoreCase("numeric")) {
                    colType = 1;
                } else if (column.getType().equalsIgnoreCase("date")) {
                    colType = 3;
                } else {
                    if (!column.getType().equalsIgnoreCase("combobox")) throw new InvalidColumnTypeException(column.getType());
                    colType = 4;
                }
            } else if (query != null) {
                query.beforeFirst();
                query.next();
                Object colValue = query.getObject(column.getName());
                query.beforeFirst();
                if (colValue != null) {
                    if (colValue instanceof String) {
                        colType = 0;
                    } else if (colValue instanceof Number) {
                        colType = 1;
                    } else if (colValue instanceof Boolean) {
                        colType = 2;
                    } else if (colValue instanceof Date) {
                        colType = 3;
                    }
                }
            }
            this.columnTypes[i] = colType;
            if (i > 0) {
                columnModelsb.append(',');
            }
            int colWidth = 0;
            try {
                colWidth = Integer.parseInt(column.getWidth());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean isColumnEditable = this.isEdit && column.isSelect();
            this.autoExpandColumn = this.parseAutoExpandColumn().toUpperCase();
            this.appendColumnModel(column, colType, true, isColumnEditable, colWidth, columnModelsb);
        }
        columnModelsb.append("];");
        this.htmlAssembler.appendContent(columnModelsb.toString()).newLine();
    }

    private void appendColumnModel(GridColumnData column, int colType, boolean sort, boolean edit, int colWidth, StringBuffer columnModelsb) throws JspException {
        String mask;
        Object header;
        String headerIcon = column.getHeaderIcon();
        Object object = column.getHeader() == null ? (headerIcon == null ? column.getName() : "") : (header = column.getHeader());
        if (headerIcon != null) {
            header = HEADER_IMG_MARKUP.replace(HEADER_IMG_SOURCE_HOLDER_KEY, headerIcon) + (String)header;
        }
        String ucColName = column.getName().toUpperCase();
        if (colType == 2) {
            this.checkBoxColumnModelVarName = "_cf_checkBoxColumnModel_" + ucColName;
            this.htmlAssembler.appendContent("var ").appendContent(this.checkBoxColumnModelVarName).appendContent(" =");
            this.htmlAssembler.appendContent(CHECK_BOX_INIT).appendContent(COL_HEADER).appendContent((String)header, true);
            this.htmlAssembler.appendContent(',').appendContent(DATA_INDEX).appendContent(ucColName, true);
            this.htmlAssembler.appendContent(',').appendContent(ID).appendContent(this.getGridColId(ucColName), true);
            this.htmlAssembler.appendContent(',').appendContent(NAME).appendContent(ucColName, true);
            this.htmlAssembler.appendContent(',').appendContent(COL_NAME).appendContent(ucColName, true);
            this.htmlAssembler.appendContent(',').appendContent(MENU_DISABLED).appendContent(!column.isHeaderMenu());
            this.htmlAssembler.appendContent(',').appendContent(EDITABLE).appendContent(edit);
            this.htmlAssembler.appendContent(',').appendContent("convert:ColdFusion.Grid.convertBoolean");
            if (edit) {
                this.htmlAssembler.appendContent(',').appendContent("editor:'checkbox'");
            }
            if (!column.isDisplay()) {
                this.htmlAssembler.appendContent(',').appendContent(COL_HIDDEN_TRUE);
            }
            if (colWidth > 0) {
                this.htmlAssembler.appendContent(',').appendContent(COL_WIDTH).appendContent(String.valueOf(colWidth));
            }
            this.htmlAssembler.appendContent("});");
            this.htmlAssembler.newLine();
            columnModelsb.append(this.checkBoxColumnModelVarName);
            this.pluginsList.add(this.checkBoxColumnModelVarName);
            return;
        }
        columnModelsb.append('{');
        columnModelsb.append(COL_HEADER);
        HtmlAssembler.singleQuote((String)header, false, columnModelsb);
        columnModelsb.append(',').append(COL_NAME).append("'" + ucColName + "'");
        columnModelsb.append(',').append(ID).append("'" + this.getGridColId(ucColName) + "'");
        columnModelsb.append(',').append(NAME).append("'" + ucColName + "'");
        columnModelsb.append(',').append(DATA_INDEX).append("'" + ucColName + "'");
        columnModelsb.append(',').append(MENU_DISABLED).append(!column.isHeaderMenu());
        if (column.getDataAlign() != null) {
            columnModelsb.append(',').append("align:").append("'" + column.getDataAlign().trim() + "'");
        }
        if (sort) {
            columnModelsb.append(',');
            columnModelsb.append(COL_SORT_TYPE).append(COL_SORT_TYPES[colType]);
            columnModelsb.append(',');
            columnModelsb.append(COL_SORTABLE).append("true");
        }
        if (colType == 3) {
            mask = column.getMask() != null ? column.getMask() : DEFAULT_DATE_FORMAT;
            columnModelsb.append(',').append("format:").append(HtmlAssembler.singleQuote(mask));
            columnModelsb.append(',').append("xtype:").append(HtmlAssembler.singleQuote("datecolumn"));
            columnModelsb.append(',').append("type:").append(HtmlAssembler.singleQuote("date"));
        }
        if (column.getName().equalsIgnoreCase(this.autoExpandColumn) && !this.gridTag.getAutoWidth()) {
            columnModelsb.append(',');
            columnModelsb.append("flex:1");
        }
        if (edit && column.isSelect()) {
            columnModelsb.append(',');
            if (column.getValues() != null) {
                selectId = this.appendSelectBuffer(column);
                columnModelsb.append(COL_EDITOR).append(EDITOR_OPEN).append(COL_EDITOR_SELECT).append(selectId).append(COL_EDITOR_SELECT_CLOSE);
            } else {
                switch (colType) {
                    case 1: {
                        columnModelsb.append(COL_EDITOR).append(NUMBER_FIELD_EDITOR);
                        break;
                    }
                    case 0: {
                        columnModelsb.append(COL_EDITOR).append(TEXT_FIELD_EDITOR);
                        break;
                    }
                    case 2: {
                        columnModelsb.append("renderer:").append("ColdFusion.Grid.formatBoolean").append(',');
                        columnModelsb.append(COL_EDITOR).append(BOOLEAN_EDITOR);
                        break;
                    }
                    case 3: {
                        mask = column.getMask() != null ? column.getMask() : DEFAULT_DATE_FORMAT;
                        columnModelsb.append(COL_EDITOR).append(DATE_FIELD_EDITOR).append(HtmlAssembler.singleQuote(mask)).append("}");
                        break;
                    }
                    case 4: {
                        selectId = this.appendSelectBuffer(column);
                        columnModelsb.append(COL_EDITOR).append(COMBOBOX_EDITOR_BEGIN).append(selectId).append(COMBOBOX_EDITOR_END);
                        break;
                    }
                }
            }
        }
        if (colWidth > 0) {
            columnModelsb.append(',');
            columnModelsb.append(COL_WIDTH).append(String.valueOf(colWidth));
        }
        if (!column.isDisplay()) {
            columnModelsb.append(',').append(COL_HIDDEN_TRUE);
        }
        columnModelsb.append('}');
    }

    private void checkIfAutowidthRequired() {
        if (this.gridTag.getAutoWidth() || this.gridTag.getWidth() != null) {
            return;
        }
        boolean noWidthsGiven = true;
        for (GridColumnData gcd : this.gridTag.getColumns()) {
            if (gcd.getWidth() == null) continue;
            noWidthsGiven = false;
            break;
        }
        if (noWidthsGiven) {
            this.gridTag.setAutoWidth(true);
        }
    }

    private String getGridColId(String ucColName) {
        return this.gridTag.getIdAttribute() + "_" + ucColName;
    }

    private String appendSelectBuffer(GridColumnData column) throws JspException {
        if (this.selectEditorBuffer == null) {
            this.selectEditorBuffer = new StringBuffer();
        }
        String selectIdString = SELECT_EDITOR_PREFIX + this.selectId;
        this.selectEditorBuffer.append("<div style='display:none'>");
        if (column.getValues() != null) {
            String delimiter = column.getValuesDelimiter() == null ? COMMA : column.getValuesDelimiter();
            StringTokenizer values = new StringTokenizer(column.getValues(), delimiter);
            StringTokenizer valuesDisplay = null;
            if (column.getValuesDisplay() != null) {
                valuesDisplay = new StringTokenizer(column.getValuesDisplay(), delimiter);
            }
            this.selectEditorBuffer.append('\n');
            this.selectEditorBuffer.append(OPEN_SELECT_TAG).append(selectIdString);
            if (values != null) {
                this.selectEditorBuffer.append(END_SELECT_TAG);
                while (values.hasMoreTokens()) {
                    String value = values.nextToken().trim();
                    String display = valuesDisplay == null ? value : valuesDisplay.nextToken().trim();
                    this.selectEditorBuffer.append(OPEN_OPTION_TAG).append(value).append(INFIX_OPTION_TAG).append(display).append(CLOSE_OPTION_TAG);
                }
            }
        } else {
            String bind = "";
            BindProcessor bindProcessor = new BindProcessor();
            bindProcessor.processBind(selectIdString, "true", null, bind, true, this.htmlAssembler, -1, this.pageContext);
            this.selectEditorBuffer.append("style='display: none;'>");
        }
        this.selectEditorBuffer.append(CLOSE_SELECT_TAG);
        this.selectEditorBuffer.append("</div>");
        ++this.selectId;
        return selectIdString;
    }

    private void generateCellClickInfo() {
        this.htmlAssembler.appendContent(OPEN_CELL_CLICK_INFO).appendContent(this.gridTag.isAppendKey()).appendContent(',').appendContent(OPEN_CELL_CLICK_COLINFO);
        for (int i = 0; i < this.columns.size(); ++i) {
            String hrefKey;
            String target;
            String href;
            GridColumnData column;
            if (i > 0) {
                this.htmlAssembler.appendContent(',');
            }
            if ((column = (GridColumnData)this.columns.get(i)).isSelect() && this.isEdit) {
                this.htmlAssembler.appendContent("null");
                continue;
            }
            String string = href = column.getHref() == null ? this.gridTag.getHref() : column.getHref();
            if (href == null) {
                this.htmlAssembler.appendContent("null");
                continue;
            }
            this.htmlAssembler.appendContent('{');
            this.htmlAssembler.appendContent(CELL_CLICK_COLINFO_HREF).appendContent(href, true);
            String string2 = target = column.getTarget() == null ? this.gridTag.getTarget() : column.getTarget();
            if (target != null) {
                this.htmlAssembler.appendContent(',');
                this.htmlAssembler.appendContent(CELL_CLICK_COLINFO_TARGET).appendContent(target, true);
            }
            String string3 = hrefKey = column.getHrefKey() == null ? this.gridTag.getHrefKey() : column.getHrefKey();
            if (hrefKey != null) {
                int hrefKeyCol = -1;
                for (int j = 0; j < this.columns.size(); ++j) {
                    GridColumnData compareCol = (GridColumnData)this.columns.get(j);
                    if (!compareCol.getName().equalsIgnoreCase(hrefKey)) continue;
                    hrefKeyCol = j;
                    break;
                }
                if (hrefKeyCol != -1) {
                    this.htmlAssembler.appendContent(',');
                    this.htmlAssembler.appendContent(CELL_CLICK_COLINFO_HREFKEY).appendContent(hrefKeyCol);
                }
            }
            this.htmlAssembler.appendContent('}');
        }
        this.htmlAssembler.appendContent(']');
        this.htmlAssembler.appendContent('}');
    }

    private void generateStaticDataSet() {
        int rowCount;
        QueryTable query = this.gridTag.getQuery();
        query.beforeFirst();
        this.htmlAssembler.appendContent(OPEN_DATA);
        int n = rowCount = this.gridTag.getMaxRows() > 0 ? this.gridTag.getMaxRows() : query.getRowCount();
        if (rowCount > query.getRowCount()) {
            rowCount = query.getRowCount();
        }
        for (int i = 0; i < rowCount; ++i) {
            query.next();
            if (i > 0) {
                this.htmlAssembler.appendContent(',');
            }
            this.htmlAssembler.appendContent('[');
            block8: for (int j = 0; j < this.columns.size(); ++j) {
                Object value;
                GridColumnData column = (GridColumnData)this.columns.get(j);
                if (j > 0) {
                    this.htmlAssembler.appendContent(',');
                }
                if ((value = query.getObject(column.getName())) == null) {
                    value = "";
                }
                switch (this.columnTypes[j]) {
                    case 1: {
                        this.htmlAssembler.appendContent(value.toString());
                        continue block8;
                    }
                    case 2: {
                        if (value instanceof String) {
                            String strValue = (String)value;
                            if (strValue.equalsIgnoreCase("TRUE") || strValue.equalsIgnoreCase("FALSE") || strValue.trim().equals("1") || strValue.trim().equals("0")) {
                                this.htmlAssembler.appendContent(value.toString());
                                continue block8;
                            }
                            this.htmlAssembler.appendContent(value.toString(), true);
                            continue block8;
                        }
                        this.htmlAssembler.appendContent(value.toString());
                        continue block8;
                    }
                    case 0: {
                        this.htmlAssembler.appendContent(value.toString(), true);
                        continue block8;
                    }
                    case 3: {
                        Object dateValue = "";
                        if (value instanceof Date) {
                            dateValue = dateFormatter.format((Date)value);
                        } else {
                            dateValue = value.toString();
                            String[] valueArray = ((String)(dateValue = ((String)dateValue).split(" ")[0])).split("-");
                            if (valueArray.length >= 3) {
                                dateValue = valueArray[1] + "/" + valueArray[2] + "/" + valueArray[0];
                            }
                        }
                        this.htmlAssembler.appendContent((String)dateValue, true);
                        continue block8;
                    }
                    case 4: {
                        this.htmlAssembler.appendContent(value.toString(), true);
                    }
                }
            }
            this.htmlAssembler.appendContent(']');
        }
        query.beforeFirst();
        this.htmlAssembler.appendContent("];");
        this.htmlAssembler.newLine();
        if (this.gridTag.getGroupField() != null && this.gridTag.getGroupField().length() > 0) {
            String sortField = this.determineSortFieldForGrouping(this.gridTag.getGroupField());
            this.htmlAssembler.appendContent(DATA_MODEL_STRING1 + this.gridTag.getName() + DATA_MODEL_STRING2).appendContent(CONSTRUCT_STATIC_GROUPROW_DATA_MODEL_START).appendContent(this.gridTag.getGroupField().toUpperCase(), true).appendContent(CONSTRUCT_STATIC_GROUPROW_DATA_MODEL_END1 + this.gridTag.getName() + "', data: _cf_gridData,proxy: {  type: 'memory',reader : new Ext.data.reader.Array({id:_cf_gridColModel.length-1}, _cf_gridColModel)}});");
        } else {
            this.htmlAssembler.appendContent(DATA_MODEL_STRING1 + this.gridTag.getName() + DATA_MODEL_STRING2).newLine();
            this.htmlAssembler.appendContent(CONSTRUCT_STATIC_DATA_MODEL1 + this.gridTag.getName() + "', data: _cf_gridData,proxy: {  type: 'memory',reader : new Ext.data.reader.Array({id:_cf_gridColModel.length-1}, _cf_gridColModel)}});").newLine();
        }
    }

    private void generateDynamicDataSet() throws JspException {
        this.bindProcessor = new BindProcessor();
        this.bindProcessor.addBindToParam(GRIDNAME, "'" + this.gridTag.getIdAttribute() + "'");
        this.bindProcessor.addBindToParam(DATA_FN_CALLBACK, DATA_FN_CALLBACK);
        this.bindProcessor.addBindToParam(DATA_FN_SCOPE, DATA_FN_SCOPE);
        this.bindProcessor.addBindToParam(DATA_FN_ARG, DATA_FN_ARG);
        this.bindProcessor.addBindToParam("_cf_grid_errorhandler", "_cf_grid_errorhandler");
        this.bindProcessor.addBindToParam(DATA_PROXY, DATA_PROXY);
        this.bindProcessor.addBindToParam(DATA_FN_READER, DATA_FN_READER);
        this.bindProcessor.addReservedWord(DATA_FN_PAGE);
        this.bindProcessor.addReservedWord(DATA_FN_PAGESIZE);
        this.bindProcessor.addReservedWord(DATA_FN_SORTCOL);
        this.bindProcessor.addReservedWord(DATA_FN_SORTDIR);
        this.bindProcessor.setOutput(false);
        this.bindProcessor.setBindToFunction(true);
        this.bindProcessor.setErrorHandler("_cf_grid_errorhandler");
        this.bindProcessor.processBind(LOAD_DATA_FN, "true", null, this.gridTag.getBind(), false, this.htmlAssembler, -1, this.pageContext);
        if (this.bindProcessor.getBindType() != 2 && this.bindProcessor.getBindType() != 1 && this.bindProcessor.getBindType() != 3) {
            throw new InvalidBindTypeException();
        }
        List unmatched = this.bindProcessor.getUnmatchedReservedWords();
        if (unmatched.size() > 0) {
            throw new MissingReservedWordsException("BIND", unmatched);
        }
        this.bindProcessor.assembleImports(this.htmlAssembler);
        String bindFunction = this.htmlAssembler.openFunction("CFGRID", DATA_FN, true, true, DATA_FN_PARAMS);
        this.bindProcessor.generateDirectCall(this.htmlAssembler);
        this.htmlAssembler.closeFunction();
        String onErrorFn = this.gridTag.isOnErrorSet() ? this.gridTag.getOnError() : "null";
        this.htmlAssembler.newLine();
        if (this.gridTag.getGroupField() != null && this.gridTag.getGroupField().length() > 0) {
            throw new AttributeNotSupportedException(GRID_ID_PREFIX, "dynamic grid");
        }
        this.htmlAssembler.appendContent(DATA_MODEL_STRING1 + this.gridTag.getName() + DATA_MODEL_STRING2).newLine();
        String[] data = null;
        try {
            data = this.bindProcessor.parseBindForGrid("", "", this.gridTag.getBind(), -1, "", this.pageContext, this.gridTag, this.htmlAssembler);
        }
        catch (Exception e) {
            throw new InvalidBindExpressionException();
        }
        String url = data[0];
        if (data.length > 1 && data[1].length() > 0 && this.bindProcessor.getBindType() != 1) {
            this.htmlAssembler.appendContent("ColdFusion.Grid.GridBindelementsMap['" + this.gridTag.getId() + "'] = " + data[1]);
        }
        if (this.bindProcessor.getBindType() == 1) {
            this.htmlAssembler.appendContent("var _cf_gridDataModel = Ext.create('Ext.data.Store',{ model : 'cf_gridmodel-" + this.gridTag.getName() + OPEN_CONSTRUCT_DYNAMIC_DATA_MODEL_JS2);
        } else {
            this.htmlAssembler.appendContent("var _cf_gridDataModel = Ext.create('Ext.data.Store',{ model : 'cf_gridmodel-" + this.gridTag.getName() + OPEN_CONSTRUCT_DYNAMIC_DATA_MODEL2);
        }
        this.htmlAssembler.appendContent(url).appendContent(CLOSE_CONSTRUCT_DYNAMIC_DATA_MODEL);
    }

    private String determineSortFieldForGrouping(String groupField) {
        GridColumnData column;
        int i;
        boolean isGroupFieldValid = false;
        for (i = 0; i < this.columns.size(); ++i) {
            column = (GridColumnData)this.columns.get(i);
            if (!column.getName().equalsIgnoreCase(groupField)) continue;
            isGroupFieldValid = true;
            break;
        }
        if (!isGroupFieldValid) {
            throw new InvalidGroupFieldException(groupField);
        }
        for (i = 0; i < this.columns.size(); ++i) {
            column = (GridColumnData)this.columns.get(i);
            if (column.getName().equalsIgnoreCase(groupField)) continue;
            return column.getName();
        }
        return groupField;
    }

    private void generateOnChangeFunction() throws JspException {
        String onChangeBind = this.gridTag.getOnChange();
        if (!this.isEdit || onChangeBind == null) {
            return;
        }
        BindProcessor onChangeProcessor = new BindProcessor();
        onChangeProcessor.addReservedWord(CHANGE_FN_ACTION);
        onChangeProcessor.addReservedWord(CHANGE_FN_ROW);
        onChangeProcessor.addReservedWord(CHANGE_FN_CHANGED);
        onChangeProcessor.setOutput(false);
        onChangeProcessor.setErrorHandler("_cf_grid_errorhandler");
        onChangeProcessor.addBindToParam(CHANGE_FN_GRID, CHANGE_FN_GRID);
        onChangeProcessor.addBindToParam(CHANGE_FN_GRID_PROPERTIES, CHANGE_FN_GRID_PROPERTIES);
        onChangeProcessor.setBindToFunction(true);
        onChangeProcessor.setHTTPMethod("'POST'");
        onChangeProcessor.processBind(CHANGE_FN_CALLBACK, null, null, onChangeBind, false, this.htmlAssembler, -1, this.pageContext);
        if (onChangeProcessor.getBindType() != 2 && onChangeProcessor.getBindType() != 1 && onChangeProcessor.getBindType() != 3) {
            throw new InvalidBindTypeForOnChangeException();
        }
        List unmatched = onChangeProcessor.getUnmatchedReservedWords();
        if (unmatched.size() > 0) {
            throw new MissingReservedWordsException("ONCHANGE", unmatched);
        }
        this.htmlAssembler.newLine();
        this.onChangeFunction = this.htmlAssembler.openFunction("CFGRID", CHANGE_FN, true, true, CHANGE_FN_PARAMS);
        onChangeProcessor.generateDirectCall(this.htmlAssembler);
        this.htmlAssembler.closeFunction();
    }

    private String stripUnitFromSize(String size) {
        if (size == null || size.trim().length() == 0) {
            return null;
        }
        char lastSizeChar = size.charAt(size.length() - 1);
        if (!Character.isDigit(lastSizeChar)) {
            if (lastSizeChar == '%') {
                return size.substring(0, size.length() - 1);
            }
            String sizeUnits = size.substring(size.length() - 2).toLowerCase();
            if (!(sizeUnits.equals("px") || sizeUnits.equals("em") || sizeUnits.equals("ex") || sizeUnits.equals("in") || sizeUnits.equals("cm") || sizeUnits.equals("mm") || sizeUnits.equals("pt") || sizeUnits.equals("pc"))) {
                return size;
            }
            return size.substring(0, size.length() - 2);
        }
        return size;
    }

    private String parseAutoExpandColumn() {
        GridColumnData column;
        int i;
        String defaultColumn = "";
        for (i = 0; i < this.columns.size(); ++i) {
            column = (GridColumnData)this.columns.get(i);
            if (!column.isAutoExpand()) continue;
            return column.getName();
        }
        for (i = 0; i < this.columns.size(); ++i) {
            column = (GridColumnData)this.columns.get(i);
            if (!column.isDisplay() || column.hasAutoExpandBeenSet()) continue;
            defaultColumn = column.getName();
            break;
        }
        return defaultColumn;
    }

    private void generateInitCall() {
        String width;
        String height = this.gridTag.getHeight();
        if (height != null) {
            height = this.stripUnitFromSize(height);
        }
        if ((width = this.gridTag.getWidth()) != null) {
            width = this.stripUnitFromSize(width);
        } else {
            width = this.calculateGridWidth();
            if ("0".equals(width)) {
                width = "''";
            }
        }
        ((GridColumnData)this.gridTag.getColumns().get(0)).getWidth();
        this.htmlAssembler.newLine();
        this.htmlAssembler.appendContent(OPEN_GRID_INIT).appendContent(this.gridTag.getIdAttribute(), true).appendContent(',').appendContent(this.gridTag.getName(), true).appendContent(',').appendContent(this.gridTag.getParentFormTag().getIdAttribute(), true).appendContent(',').appendContent(!this.isStatic).appendContent(',').appendContent(this.isEdit).appendContent(',').appendContent(this.gridTag.getBindOnLoad()).appendContent(',').appendContent(this.gridTag.getAutoWidth()).appendContent(',').appendContent(this.autoExpandColumn, true).appendContent(',').appendContent(COL_MODEL).appendContent(',').appendContent(DATA_MODEL).appendContent(',').appendContent(width).appendContent(',').appendContent(height).appendContent(',').appendContent(this.gridTag.getStripeRows()).appendContent(',').appendContent(this.styles.toString(), true).appendContent(',').appendContent(this.gridTag.getPageSize()).appendContent(',').appendContent(this.gridTag.isSelectOnLoad()).appendContent(',').appendContent(this.gridTag.isPreservePageOnSort()).appendContent(',');
        if (this.gridTag.isMultiRowSelect()) {
            this.htmlAssembler.appendContent(SELECETIONP_MODE).appendContent(',');
        } else {
            this.htmlAssembler.appendContent("null").appendContent(',');
        }
        this.htmlAssembler.appendContent(this.gridTag.isCollapsible()).appendContent(',').appendContent(this.gridTag.getGroupField() == null ? "null" : this.gridTag.getGroupField().toUpperCase(), this.gridTag.getGroupField() != null).appendContent(',');
        this.htmlAssembler.appendContent(this.gridTag.getTitle() == null ? "null" : this.gridTag.getTitle(), this.gridTag.getTitle() != null).appendContent(',');
        String insertText = null;
        if (this.gridTag.isInsert()) {
            insertText = this.gridTag.getInsertButton();
        }
        this.htmlAssembler.appendContent(insertText, insertText != null).appendContent(',');
        String deleteText = null;
        if (this.gridTag.isDelete()) {
            deleteText = this.gridTag.getDeleteButton();
        }
        this.htmlAssembler.appendContent(deleteText, deleteText != null).appendContent(',');
        this.generateCellClickInfo();
        this.htmlAssembler.appendContent(',');
        this.htmlAssembler.appendContent(this.onChangeFunction);
        this.htmlAssembler.appendContent(',');
        String onError = this.gridTag.isOnErrorSet() ? this.gridTag.getOnError() : "null";
        this.htmlAssembler.appendContent(onError).appendContent(',');
        this.htmlAssembler.appendContent(this.gridTag.getOnLoad() != null ? this.gridTag.getOnLoad() : "null").appendContent(',');
        if (this.isEdit) {
            this.pluginsList.add(CELL_EDIT_PLUGIN_VAR);
        }
        this.htmlAssembler.appendContent(this.pluginsList.size() > 0 ? this.pluginsList.toString() : "null");
        if (!this.isStatic) {
            this.htmlAssembler.appendContent(',');
            this.htmlAssembler.appendContent(this.bindProcessor.getEventParams());
        } else {
            this.htmlAssembler.appendContent(',');
            this.htmlAssembler.appendContent("undefined");
        }
        this.htmlAssembler.appendContent(',');
        this.htmlAssembler.appendContent(this.hasWindowParent);
        this.htmlAssembler.appendContent(',');
        this.htmlAssembler.appendContent(this.gridTag.getStripeRowColor(), true);
        this.htmlAssembler.appendContent(CLOSE_SET_ACTIONS);
    }

    static {
        AjaxGridHelper.COL_SORT_TYPES[0] = "'asUCString'";
        AjaxGridHelper.COL_SORT_TYPES[1] = "'asFloat'";
        AjaxGridHelper.COL_SORT_TYPES[2] = "'asUCString'";
        AjaxGridHelper.COL_SORT_TYPES[3] = "'asDate'";
        AjaxGridHelper.COL_SORT_TYPES[4] = "'asUCString'";
        COL_EDITOR_TYPES = new String[5];
        AjaxGridHelper.COL_EDITOR_TYPES[0] = "TextField";
        AjaxGridHelper.COL_EDITOR_TYPES[1] = "NumberField";
        AjaxGridHelper.COL_EDITOR_TYPES[2] = "Checkbox";
        AjaxGridHelper.COL_EDITOR_TYPES[3] = "DateField";
        AjaxGridHelper.COL_EDITOR_TYPES[4] = "ComboBox";
        dateFormatter = new SimpleDateFormat("MMMMM, dd yyyy HH:mm:ss");
    }

    public static class PageSizeNotAllowedForStaticGridException
    extends ApplicationException {
    }

    public static class GroupFieldNotAllowedForDynamicGridException
    extends ApplicationException {
    }

    public class InvalidColumnTypeException
    extends TagValidationException {
        public String columnType;

        public InvalidColumnTypeException(String columnType) {
            this.columnType = columnType;
        }
    }

    public static class InvalidBindTypeException
    extends ApplicationException {
    }

    public class MissingReservedWordsException
    extends ApplicationException {
        public String missingWords = "";
        public String attribute;

        public MissingReservedWordsException(String attribute, List words) {
            this.attribute = attribute;
            for (int i = 0; i < words.size(); ++i) {
                if (i > 0) {
                    this.missingWords = this.missingWords + AjaxGridHelper.COMMA;
                }
                this.missingWords = this.missingWords + words.get(i);
            }
        }
    }

    public static class InvalidBindExpressionException
    extends ApplicationException {
    }

    public static class InvalidGroupFieldException
    extends ApplicationException {
        public String groupField;

        public InvalidGroupFieldException(String groupField) {
            this.groupField = groupField;
        }
    }

    public static class InvalidBindTypeForOnChangeException
    extends ApplicationException {
    }

    public static class selectModeEditNotAllowedForStaticGridException
    extends ApplicationException {
    }

    public static class HeightWidthInPercentageNotSupportedException
    extends ApplicationException {
    }

    public static class InsertionNotAllowedForStaticGridException
    extends ApplicationException {
    }
}

