/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.html.ajax.AjaxGridHelper;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxProxyTag;
import coldfusion.tagext.html.ajax.AjaxSliderHelper;
import coldfusion.tagext.html.ajax.ButtonTag;
import coldfusion.tagext.html.ajax.DateFieldHelper;
import coldfusion.tagext.html.ajax.DivTag;
import coldfusion.tagext.html.ajax.FileUploadTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.LayoutTag;
import coldfusion.tagext.html.ajax.MapTag;
import coldfusion.tagext.html.ajax.MessageBoxTag;
import coldfusion.tagext.html.ajax.PodTag;
import coldfusion.tagext.html.ajax.ProgressBarTag;
import coldfusion.tagext.html.ajax.RichTextEditorHelper;
import coldfusion.tagext.html.ajax.TooltipTag;
import coldfusion.tagext.html.ajax.WindowTag;
import coldfusion.tagext.html.form.FormTag;
import coldfusion.tagext.io.ChartTag;
import jakarta.servlet.jsp.JspException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class AjaxImportTag
extends GenericTag {
    private static ThreadLocal<Map> ajaxImportParamsThreadLocal = new ThreadLocal();
    private String tags;
    private String scriptSrc;
    private String cssSrc;
    private static String VALID_TAGS = "";
    private static Map params = new HashMap();
    private static HashMap ajaxTags = new HashMap();
    private static final String IMPORT_TAG_FN = "ColdFusion.Ajax.importTag('";
    private static final String CHECK_IMPORT_FN = "ColdFusion.Ajax.checkImportedTag('";

    public String getTags() {
        return this.tags;
    }

    public void setCssSrc(String cssSrc) {
        this.cssSrc = cssSrc;
    }

    public String getCssSrc() {
        return this.cssSrc;
    }

    public void setScriptSrc(String scriptSrc) {
        this.scriptSrc = scriptSrc;
    }

    public String getScriptSrc() {
        return this.scriptSrc;
    }

    public void setTags(String tags) {
        this.tags = tags.toUpperCase().trim();
    }

    public void setParams(Map params) {
        AjaxImportTag.params = params;
        ajaxImportParamsThreadLocal.set(params);
    }

    public static Map getParams() {
        return ajaxImportParamsThreadLocal.get();
    }

    public static void clearImportParam() {
        ajaxImportParamsThreadLocal.remove();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(this.pageContext, false);
        if (htmlAssembler.getRequestContainerId() == null) {
            if (this.scriptSrc != null) {
                htmlAssembler.setScriptSrc(this.scriptSrc);
            }
            if (this.cssSrc != null) {
                htmlAssembler.setCssSrc(this.cssSrc);
            }
            AjaxImportTag.generateImports("CFAJAXPROXY", htmlAssembler);
            if (this.tags != null) {
                StringTokenizer st = new StringTokenizer(this.tags, ",");
                if (st.countTokens() == 0) {
                    throw new TagsEmptyException();
                }
                while (st.hasMoreTokens()) {
                    String tagName = st.nextToken().trim();
                    AjaxImportTag.generateImports(tagName, htmlAssembler);
                }
            }
            htmlAssembler.writeHead(this.out);
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.tags = null;
        this.scriptSrc = null;
        this.cssSrc = null;
        super.release();
    }

    public static void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.checkIfScriptSrcModified(tagName);
        if (htmlAssembler.isTagImported(tagName)) {
            return;
        }
        if (htmlAssembler.isTopPage()) {
            AjaxImport tag = (AjaxImport)ajaxTags.get(tagName);
            if (tag == null) {
                throw new InvalidTagException(tagName, VALID_TAGS);
            }
            tag.generateImports(tagName, htmlAssembler);
            htmlAssembler.openScriptTag();
            htmlAssembler.appendContent(IMPORT_TAG_FN).appendContent(tagName).appendContent("'").appendContent(");");
            htmlAssembler.closeScriptTag();
        } else {
            AjaxImportTag.generateCheckImportFn(tagName, htmlAssembler);
        }
        htmlAssembler.markTagImported(tagName);
    }

    public static void generateCheckImportFn(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.openScriptTag();
        htmlAssembler.appendContent(CHECK_IMPORT_FN).appendContent(tagName).appendContent("'").appendContent(");");
        htmlAssembler.closeScriptTag();
    }

    static {
        ajaxTags.put("CFGRID", new AjaxGridHelper());
        ajaxTags.put("CFAJAXPROXY", new AjaxProxyTag());
        ajaxTags.put("CFINPUT-DATEFIELD", new DateFieldHelper());
        LayoutTag t = new LayoutTag();
        ajaxTags.put("CFLAYOUT-BORDER", t);
        ajaxTags.put("CFLAYOUT-TAB", t);
        ajaxTags.put("CFLAYOUT-ACCORDION", t);
        ajaxTags.put("CFPOD", new PodTag());
        ajaxTags.put("CFTEXTAREA", new RichTextEditorHelper());
        ajaxTags.put("CFTOOLTIP", new TooltipTag());
        ajaxTags.put("CFWINDOW", new WindowTag());
        ajaxTags.put("CFFORM", new FormTag());
        ajaxTags.put("CFCHART", new ChartTag());
        ajaxTags.put("CFDIV", new DivTag());
        ajaxTags.put("CFFILEUPLOAD", new FileUploadTag());
        ajaxTags.put("CFPROGRESSBAR", new ProgressBarTag());
        ajaxTags.put("CFMESSAGEBOX", new MessageBoxTag());
        ajaxTags.put("CFMAP", new MapTag());
        ajaxTags.put("CFBUTTON", new ButtonTag());
        ajaxTags.put("CFSLIDER", new AjaxSliderHelper());
        WebSocketService webSocketService = ServiceFactory.getWebsocketService();
        if (webSocketService != null) {
            webSocketService.setWebSocketForAjaxTag(ajaxTags);
        }
        boolean first = true;
        Iterator keys = ajaxTags.keySet().iterator();
        while (keys.hasNext()) {
            if (!first) {
                VALID_TAGS = VALID_TAGS + ", ";
            }
            VALID_TAGS = VALID_TAGS + (String)keys.next();
            first = false;
        }
    }

    public static class TagsEmptyException
    extends ApplicationException {
    }

    public static class InvalidTagException
    extends ApplicationException {
        public String tagName;
        public String validTags;

        public InvalidTagException(String tagName, String validTags) {
            this.tagName = tagName;
            this.validTags = validTags;
        }
    }
}

