/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AjaxRBFileMap {
    private static HashMap scriptSrcMap = new HashMap();
    private static final String BASEPATH = "/messages/";
    private static final String BASENAME = "cfmessage";
    private static final String EXTENSION = ".js";

    public static void importResourceBundleJS(Locale locale, HtmlAssembler htmlAssembler) {
        String ajaxScriptSrc = htmlAssembler.getImportAjaxPath();
        HashMap rbFileMap = (HashMap)scriptSrcMap.get(ajaxScriptSrc);
        if (rbFileMap == null) {
            rbFileMap = new HashMap();
            scriptSrcMap.put(ajaxScriptSrc, rbFileMap);
        }
        String rbFileName = AjaxRBFileMap.getRBFileName(locale, rbFileMap, ajaxScriptSrc + BASEPATH);
        htmlAssembler.importJS(BASEPATH + rbFileName);
    }

    public static String getRBFileName(Locale locale, Map rbFileMap, String basePath) {
        Object rbFileName = (String)rbFileMap.get(locale);
        if (rbFileName == null) {
            if (locale == null) {
                locale = CFLocaleMgr.getMgr().getDefaultCFLocale().GetJavaLocaleObj();
            }
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            FusionContext fc = FusionContext.getCurrent();
            if (language != null) {
                String fileName;
                if (country != null) {
                    if (variant != null) {
                        fileName = "cfmessage_" + language + "_" + country + "_" + variant + EXTENSION;
                        Object object = rbFileName = AjaxRBFileMap.fileExists(fileName, basePath, fc) ? fileName : null;
                    }
                    if (rbFileName == null) {
                        fileName = "cfmessage_" + language + "_" + country + EXTENSION;
                        Object object = rbFileName = AjaxRBFileMap.fileExists(fileName, basePath, fc) ? fileName : null;
                    }
                }
                if (rbFileName == null) {
                    fileName = "cfmessage_" + language + EXTENSION;
                    Object object = rbFileName = AjaxRBFileMap.fileExists(fileName, basePath, fc) ? fileName : null;
                }
            }
            if (rbFileName == null) {
                rbFileName = "cfmessage.js";
            }
            rbFileMap.put(locale, rbFileName);
        }
        return rbFileName;
    }

    private static boolean fileExists(String fileName, String basePath, FusionContext fc) {
        String realPath = fc.getRealPath(basePath + fileName);
        return AjaxRBFileMap._fileExists(new File(realPath));
    }

    private static boolean _fileExists(final File f) {
        if (System.getSecurityManager() == null) {
            return f.exists();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.exists();
            }
        });
    }
}

