/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.form.SliderTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;

public class AjaxSliderHelper
implements AjaxImport {
    private SliderTag sliderTag;
    private HtmlAssembler htmlAssembler;
    private PageContext pageContext;
    private String sliderId;
    private String divId;
    public static final String IMPORT_TAGNAME = "CFSLIDER";
    private static final String SLIDER = "slider";
    private static final String CF_SLIDER = "cf_slider";
    private static final String SLIDER_INIT = "ColdFusion.Slider.init(";

    public AjaxSliderHelper(SliderTag sliderTag, PageContext context) {
        this.sliderTag = sliderTag;
        this.pageContext = context;
        this.sliderId = sliderTag.getName() != null ? sliderTag.getName() : CF_SLIDER + this.htmlAssembler.getId();
        this.divId = "_cfslider_" + this.sliderId;
        this.htmlAssembler = HtmlAssembler.getInstance(context, true);
        if (sliderTag.getMin() >= sliderTag.getMax()) {
            throw new InvalidMinMaxAttribException(sliderTag.getMin(), sliderTag.getMax());
        }
        if (sliderTag.getValue() != "") {
            if (sliderTag.getMin() > Double.parseDouble(sliderTag.getValue()) || Double.parseDouble(sliderTag.getValue()) > sliderTag.getMax()) {
                throw new InvalidValueAttribException(sliderTag.getValue(), sliderTag.getMin(), sliderTag.getMax());
            }
        } else {
            sliderTag.setDefValue();
        }
    }

    public AjaxSliderHelper() {
    }

    public void generate(JspWriter out) throws IOException, JspException {
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("Ext.onReady(function(){");
        this.htmlAssembler.appendContent("var ");
        String functionName = this.htmlAssembler.openFunction(SLIDER, "init", true, true, null);
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(SLIDER);
        this.htmlAssembler.appendContent("=");
        this.htmlAssembler.appendContent(SLIDER_INIT, false).appendContent(this.divId, true).appendContent(',').appendContent(this.sliderId, true).appendContent(',').appendContent(!this.sliderTag.isVertical() ? "false" : "true").appendContent(',').appendContent(this.sliderTag.getWidth() == null ? "null" : this.sliderTag.getWidth()).appendContent(',').appendContent(this.sliderTag.getHeight() == null ? "null" : this.sliderTag.getHeight()).appendContent(',').appendContent(this.sliderTag.getValue() == null ? "null" : this.sliderTag.getValue()).appendContent(',').appendContent((String)(this.sliderTag.getMin() == null ? "null" : "" + this.sliderTag.getMin())).appendContent(',').appendContent((String)(this.sliderTag.getMax() == null ? "null" : "" + this.sliderTag.getMax())).appendContent(',').appendContent(!this.sliderTag.getClickToChange() ? "false" : "true").appendContent(',').appendContent((String)(this.sliderTag.getIncrement() == null ? "null" : this.sliderTag.getIncrement())).appendContent(',').appendContent(!this.sliderTag.getTip() ? "false" : "true").appendContent(',').appendContent(this.sliderTag.getOnChange() == null ? "null" : this.sliderTag.getOnChange()).appendContent(',').appendContent(this.sliderTag.getOnDrag() == null ? "null" : this.sliderTag.getOnDrag()).appendContent(");");
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.appendContent("});");
        this.htmlAssembler.closeScriptTag();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.sliderTag.release();
        }
    }

    public String getSliderId() {
        return this.sliderId;
    }

    public String getDivId() {
        return this.divId;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/yui/yahoo-dom-event/yahoo-dom-event.js");
        htmlAssembler.importJS("/yui/animation/animation-min.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/package/cfslider.js");
    }

    public String getStyle() {
        return null;
    }

    private void addSliderStyleProperty(String cssClass, String property, String value) {
    }

    public class InvalidMinMaxAttribException
    extends TagValidationException {
        public Double min;
        public Double max;

        public InvalidMinMaxAttribException(Double min, Double max) {
            this.min = min;
            this.max = max;
        }
    }

    public class InvalidValueAttribException
    extends TagValidationException {
        public String value;
        public Double min;
        public Double max;

        public InvalidValueAttribException(String value, Double min, Double max) {
            this.value = value;
            this.min = min;
            this.max = max;
        }
    }
}

