/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ClientScope;
import coldfusion.runtime.Encryptor;
import coldfusion.runtime.MD5;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SessionScope;
import coldfusion.util.Hex;
import java.io.IOException;
import java.util.ArrayList;

public class AjaxUtils {
    private static final String DEFAULT_ENCRYPTION_KEY = "" + new Object().hashCode();
    private static final ArrayList hexaColorChars = new ArrayList(15);

    public static String checkValidCSSUnits(String size) {
        String sizeStr = size = size.trim();
        String sizeUnits = "px";
        char lastSizeChar = size.charAt(size.length() - 1);
        if (!Character.isDigit(lastSizeChar)) {
            if (lastSizeChar == '%') {
                sizeUnits = "%";
            } else {
                sizeUnits = size.substring(size.length() - 2).toLowerCase();
                if (!(sizeUnits.equals("px") || sizeUnits.equals("em") || sizeUnits.equals("ex") || sizeUnits.equals("in") || sizeUnits.equals("cm") || sizeUnits.equals("mm") || sizeUnits.equals("pt") || sizeUnits.equals("pc"))) {
                    return null;
                }
            }
            sizeStr = lastSizeChar == '%' ? size.substring(0, size.length() - 1) : size.substring(0, size.length() - 2);
            sizeStr = sizeStr.trim();
        }
        try {
            double sizeDouble = Double.parseDouble(sizeStr);
            if (sizeDouble <= 0.0) {
                return null;
            }
        }
        catch (NumberFormatException nEx) {
            return null;
        }
        return sizeStr + sizeUnits;
    }

    public static void validateOverFlowValues(String overflow, String tagname) {
        if (!(overflow == null || overflow.equalsIgnoreCase("auto") || overflow.equalsIgnoreCase("visible") || overflow.equalsIgnoreCase("hidden") || overflow.equalsIgnoreCase("scroll"))) {
            throw new AjaxOverflowInvalidUsageException(tagname);
        }
    }

    public static String constructClientId(FusionContext fc) {
        Scope cs;
        String urltoken = null;
        Scope ss = (Scope)fc.hiddenScope.get("SESSION");
        if (ss != null && ss instanceof SessionScope) {
            urltoken = (String)ss.get("urltoken");
        }
        if (urltoken == null && (cs = (Scope)fc.hiddenScope.get("CLIENT")) != null && cs instanceof ClientScope) {
            urltoken = (String)cs.get("urltoken");
        }
        String cid = null;
        if (urltoken != null) {
            MD5 md5 = new MD5(urltoken);
            try {
                md5.getDigest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            cid = md5.getStringDigest();
        }
        return cid;
    }

    public static void verifyClient() {
        Scope fs;
        String requestClientId = null;
        FusionContext fc = FusionContext.getCurrent();
        Scope us = (Scope)fc.hiddenScope.get("URL");
        if (us != null) {
            requestClientId = (String)us.get("_cf_clientid");
        }
        if (requestClientId == null && (fs = (Scope)fc.hiddenScope.get("FORM")) != null) {
            requestClientId = (String)fs.get("_cf_clientid");
        }
        if (requestClientId == null) {
            throw new ClientVerificationException();
        }
        String clientId = AjaxUtils.constructClientId(fc);
        if (clientId != null && !requestClientId.equals(clientId)) {
            throw new ClientVerificationException();
        }
    }

    public static String encryptAppName(String appName, String clientId) {
        if (appName == null || appName.length() == 0) {
            return "";
        }
        byte[] appNameBytes = appName.getBytes();
        String key = clientId;
        if (key == null) {
            key = DEFAULT_ENCRYPTION_KEY;
        } else if (key.length() > 5) {
            key = key.substring(0, 5);
        }
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = Encryptor.encrypt(appNameBytes, key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encryptedBytes == null ? "" : Hex.bytesToHex(encryptedBytes);
    }

    public static String decryptAppName() {
        Scope fs;
        String requestClientId = null;
        String encodedAppName = null;
        FusionContext fc = FusionContext.getCurrent();
        Scope us = (Scope)fc.hiddenScope.get("URL");
        if (us != null) {
            requestClientId = (String)us.get("_cf_clientid");
            encodedAppName = (String)us.get("_cf_ajaxproxytoken");
        }
        if (requestClientId == null && encodedAppName == null && (fs = (Scope)fc.hiddenScope.get("FORM")) != null) {
            requestClientId = (String)fs.get("_cf_clientid");
            encodedAppName = (String)fs.get("_cf_ajaxproxytoken");
        }
        if (encodedAppName == null) {
            return null;
        }
        byte[] encodedAppNameBytes = Hex.hexToBytes(encodedAppName);
        String key = requestClientId;
        if (key == null) {
            key = DEFAULT_ENCRYPTION_KEY;
        } else if (key.length() > 5) {
            key = key.substring(0, 5);
        }
        byte[] decryptedBytes = null;
        try {
            decryptedBytes = Encryptor.decrypt(encodedAppNameBytes, key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decryptedBytes == null ? null : new String(decryptedBytes);
    }

    public static boolean checkHexaColorFormat(String color) {
        if (color != null && color.length() == 6) {
            boolean colorInHexa = true;
            String tempbg = color.toUpperCase();
            for (int i = 0; i < 6; ++i) {
                if (hexaColorChars.contains(Character.valueOf(tempbg.charAt(i)))) continue;
                colorInHexa = false;
                break;
            }
            return colorInHexa;
        }
        return false;
    }

    static {
        hexaColorChars.add(Character.valueOf('0'));
        hexaColorChars.add(Character.valueOf('1'));
        hexaColorChars.add(Character.valueOf('2'));
        hexaColorChars.add(Character.valueOf('3'));
        hexaColorChars.add(Character.valueOf('4'));
        hexaColorChars.add(Character.valueOf('5'));
        hexaColorChars.add(Character.valueOf('6'));
        hexaColorChars.add(Character.valueOf('7'));
        hexaColorChars.add(Character.valueOf('8'));
        hexaColorChars.add(Character.valueOf('9'));
        hexaColorChars.add(Character.valueOf('A'));
        hexaColorChars.add(Character.valueOf('B'));
        hexaColorChars.add(Character.valueOf('C'));
        hexaColorChars.add(Character.valueOf('D'));
        hexaColorChars.add(Character.valueOf('E'));
        hexaColorChars.add(Character.valueOf('F'));
    }

    public static class AjaxOverflowInvalidUsageException
    extends TagValidationException {
        public String ajaxtagname;

        AjaxOverflowInvalidUsageException(String ajaxtagname) {
            this.ajaxtagname = ajaxtagname;
        }
    }

    public static class ClientVerificationException
    extends ApplicationException {
    }

    public static class AjaxTagInvalidAttributeException
    extends TagValidationException {
        public String nameoftag;
        public String attribute;

        public AjaxTagInvalidAttributeException(String attribute, String nameoftag) {
            this.attribute = attribute;
            this.nameoftag = nameoftag;
        }
    }
}

