/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.HashMap;

public class ButtonTag
extends GenericTag
implements AjaxImport {
    public static final String IMPORT_TAGNAME = "CFBUTTON";
    private String icon = null;
    private String label = null;
    private String onClick = null;
    private String onToggle = null;
    private String onMouseOver = null;
    private String onMouseOut = null;
    private boolean toggle = false;
    private String name = null;
    private String tip = null;
    private String type = null;
    private String style = null;
    private String align = null;
    private HtmlAssembler htmlAssembler;
    private static final String BUTTON = "button";
    private static final String CFBUTTON = "cf_button";
    private static final String BUTTONINIT = "ColdFusion.Button.init(";

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getOnToggle() {
        return this.onToggle;
    }

    public void setOnToggle(String onToggle) {
        this.onToggle = onToggle;
    }

    public String getOnMouseOver() {
        return this.onMouseOver;
    }

    public void setOnMouseOver(String onMouseOver) {
        this.onMouseOver = onMouseOver;
    }

    public String getOnMouseOut() {
        return this.onMouseOut;
    }

    public void setOnMouseOut(String onMouseOut) {
        this.onMouseOut = onMouseOut;
    }

    public boolean getToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/yui/yahoo-dom-event/yahoo-dom-event.js");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/yui/animation/animation-min.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/package/cfbutton.js");
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateAttribute();
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        JspWriter out = this.pageContext.getOut();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.align != null) {
            map.put("Align", this.align);
        }
        if (this.name == null) {
            this.name = CFBUTTON + this.htmlAssembler.getId();
        }
        String divId = this.name;
        this.htmlAssembler.openDivTag(divId, null, null, map);
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        this.htmlAssembler.closeDivTag();
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("var ");
        String functionName = this.htmlAssembler.openFunction(BUTTON, "init", true, true, null);
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(BUTTON);
        this.htmlAssembler.appendContent("=");
        this.htmlAssembler.appendContent(BUTTONINIT).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(this.label, true).appendContent(',').appendContent(this.icon == null ? "null" : HtmlAssembler.singleQuote(this.icon)).appendContent(',').appendContent(this.tip, true).appendContent(',').appendContent(this.onClick == null ? "null" : this.onClick).appendContent(',').appendContent(this.onToggle == null ? "null" : this.onToggle).appendContent(',').appendContent(this.onMouseOver == null ? "null" : this.onMouseOver).appendContent(',').appendContent(this.onMouseOut == null ? "null" : this.onMouseOut).appendContent(',').appendContent(this.toggle ? "true" : "false").appendContent(");");
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.closeScriptTag();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    private void validateAttribute() {
        if (this.onToggle != null && !this.toggle) {
            throw new InvalidOnToggleException(this.onToggle);
        }
    }

    private String formatStyleString() {
        StringBuffer sb = new StringBuffer();
        if (this.align != null) {
            sb.append("text-Align:").append(this.align).append(';');
        }
        return sb.toString();
    }

    @Override
    public void release() {
        this.name = null;
        this.icon = null;
        this.style = "";
        this.toggle = false;
        this.label = null;
        this.tip = null;
        this.onClick = null;
        this.onMouseOut = null;
        this.onMouseOver = null;
        this.onToggle = null;
        this.align = null;
    }

    public class InvalidOnToggleException
    extends TagValidationException {
        public String toggleHandler;

        public InvalidOnToggleException(String onToggle) {
            this.toggleHandler = onToggle;
        }
    }
}

