/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.compiler.validation.TagValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.Cast;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.ScopeAwareTag;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.net.ResolvePage;
import coldfusion.util.URLEncoder;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class FileUploadTag
extends ScopeAwareTag
implements AjaxImport {
    private static final GenericTagPermission tp = new GenericTagPermission("cffileupload");
    public static final String IMPORT_TAGNAME = "CFFILEUPLOAD";
    public static final String SESSION_MGMT_NAME = "sessionmanagement";
    static Pattern cfTokenPattern;
    static Pattern j2eeTokenPattern;
    private PatternMatcher matcher = new Perl5Matcher();
    private String url = null;
    private String url_queryString = null;
    private String url_cookie = null;
    private String addButtonLabel = null;
    private String clearButtonlabel = null;
    private String height = null;
    private String maxFileSelect = null;
    private String maxUploadSize = null;
    private String name = null;
    private String onComplete = null;
    private String onUploadComplete = null;
    private String onError = null;
    private boolean progressBar = true;
    private String style = null;
    private String uploadButtonLabel = null;
    private String deleteButtonLabel = null;
    private String title = null;
    private String width = null;
    public final int defaultUploadSize = 0xA00000;
    private long fileSize = 0xA00000L;
    private String bgcolor = null;
    private String extensionFilter = null;
    private boolean hideUploadButton = false;
    private String wmode = null;
    private boolean stopOnError = true;
    private String selectColor = null;
    private String textColor = null;
    private String titleTextColor = null;
    private String rollOverColor = null;
    private String titleTextAlign = null;
    private String align = "left";
    private String headerColor = null;
    private int panelWidth = 420;
    private HtmlAssembler htmlAssembler;
    private static final String FILEUPLOAD = "fileupload";
    private static final String CFFILEUPLOAD = "cf_fileupload";
    private static final String SWFFILEUPLOADINIT = "ColdFusion.FileUpload.create(";
    private static final String CSS_CLASS = "cf-upload-container";
    private static final ArrayList colorChars;
    private static final ArrayList WMODE_TYPES;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMaxFileSelect() {
        return this.maxFileSelect;
    }

    public void setMaxFileSelect(String maxFileSelect) {
        this.maxFileSelect = maxFileSelect;
    }

    public String getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setMaxUploadSize(String maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public String getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    public String getExtensionFilter() {
        return this.extensionFilter;
    }

    public void setExtensionFilter(String extensionFilter) {
        this.extensionFilter = extensionFilter;
    }

    public boolean getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(boolean progressBar) {
        this.progressBar = progressBar;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getAddButtonLabel() {
        return this.addButtonLabel;
    }

    public void setAddButtonLabel(String addButtonLabel) {
        this.addButtonLabel = addButtonLabel;
    }

    public String getDeleteButtonLabel() {
        return this.deleteButtonLabel;
    }

    public void setDeleteButtonLabel(String deleteButtonLabel) {
        this.deleteButtonLabel = deleteButtonLabel;
    }

    public String getClearButtonlabel() {
        return this.clearButtonlabel;
    }

    public void setClearButtonlabel(String clearButtonlabel) {
        this.clearButtonlabel = clearButtonlabel;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getOnComplete() {
        return this.onComplete;
    }

    public void setOnComplete(String onComplete) {
        this.onComplete = onComplete;
    }

    public String getOnUploadComplete() {
        return this.onUploadComplete;
    }

    public void setOnUploadComplete(String onUploadComplete) {
        this.onUploadComplete = onUploadComplete;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        this.onError = onError;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUploadButtonLabel() {
        return this.uploadButtonLabel;
    }

    public void setUploadButtonLabel(String uploadButtonLabel) {
        this.uploadButtonLabel = uploadButtonLabel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getHideUploadButton() {
        return this.hideUploadButton;
    }

    public void setHideUploadButton(boolean hideUploadButton) {
        this.hideUploadButton = hideUploadButton;
    }

    public String getWmode() {
        return this.wmode;
    }

    public void setWmode(String wmode) {
        this.wmode = wmode;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importStylesheet("/resources/cf/uploadfile.css");
        htmlAssembler.importJS("/yui/yahoo-dom-event/yahoo-dom-event.js");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/yui/animation/animation-min.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/package/cffileupload_swf.js");
    }

    public void validateAttribute() {
        Tag t = this.getParent();
        if (this.name == null) {
            this.name = CFFILEUPLOAD + this.htmlAssembler.getId();
        } else if (this.name.trim().equals("") || this.name.indexOf(",") > 0 || this.name.indexOf(" ") > 0) {
            throw new EmptyNameException(this.name);
        }
        if (this.url == null || this.url.length() == 0) {
            this.url = (String)this.pageContext.findAttribute("CGI.SCRIPT_NAME");
        }
        if (this.maxUploadSize != null && !this.maxUploadSize.trim().equals("")) {
            try {
                long size = Integer.parseInt(this.maxUploadSize);
                this.fileSize = size * 1024L * 1024L;
                if (!this.url.toLowerCase().startsWith("http://")) {
                    Map requestThrottleSetting = ServiceFactory.getRuntimeService().getRequestThrottleSettings();
                    float requestThrottleMemory = Float.parseFloat(requestThrottleSetting.get("total-throttle-memory").toString());
                    float PostDataSize = ServiceFactory.getRuntimeService().getPostSizeLimit();
                    if ((float)size > requestThrottleMemory || (float)size > PostDataSize) {
                        throw new InsufficientPostSizeLimit(size, requestThrottleMemory, PostDataSize);
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidMaxUploadSizeException(this.maxUploadSize);
            }
        }
        if (this.maxFileSelect != null && !this.maxFileSelect.trim().equals("")) {
            try {
                Integer.parseInt(this.maxFileSelect);
            }
            catch (NumberFormatException e) {
                throw new InvalidMaxFileSelectException(this.maxFileSelect);
            }
        }
        if (this.width != null && !this.width.trim().equals("")) {
            try {
                this.width = this.width.trim();
                if (this.width.endsWith("px") || this.width.endsWith("pt")) {
                    this.width = this.width.substring(0, this.width.length() - 2);
                }
                this.panelWidth = Integer.parseInt(this.width);
            }
            catch (NumberFormatException e) {
                throw new InvalidWidthException(this.width);
            }
        }
        if (this.wmode != null && !WMODE_TYPES.contains(this.wmode.toLowerCase())) {
            throw new InvalidWmodeTypeException(this.wmode, WMODE_TYPES);
        }
        if (this.align != null) {
            this.align = this.align.trim().toLowerCase();
            if (!(this.align.equals("left") || this.align.equals("right") || this.align.equals("center"))) {
                throw new InvalidAlignAttributeException();
            }
        }
        if (this.bgcolor == null) {
            this.bgcolor = this.extractStyleProperty("bgcolor");
        }
        this.textColor = this.extractStyleProperty("textcolor");
        this.titleTextColor = this.extractStyleProperty("titletextcolor");
        this.titleTextAlign = this.extractStyleProperty("titletextalign");
        this.headerColor = this.extractStyleProperty("headercolor");
        this.rollOverColor = this.extractStyleProperty("rollovercolor");
        this.selectColor = this.extractStyleProperty("selectcolor");
        if (this.isColorInHexa(this.bgcolor) && !this.bgcolor.startsWith("#")) {
            this.bgcolor = "#" + this.bgcolor;
        }
        if (this.isColorInHexa(this.textColor) && !this.textColor.startsWith("#")) {
            this.textColor = "#" + this.textColor;
        }
        if (this.isColorInHexa(this.selectColor) && !this.selectColor.startsWith("#")) {
            this.selectColor = "#" + this.selectColor;
        }
        if (this.isColorInHexa(this.rollOverColor) && !this.rollOverColor.startsWith("#")) {
            this.rollOverColor = "#" + this.rollOverColor;
        }
        if (this.isColorInHexa(this.titleTextColor)) {
            if (this.titleTextColor.startsWith("#")) {
                this.titleTextColor = this.titleTextColor.substring(1);
            }
            this.titleTextColor = "" + Integer.parseInt(this.titleTextColor, 16);
        }
        if (this.isColorInHexa(this.headerColor) && !this.headerColor.startsWith("#")) {
            this.headerColor = "#" + this.headerColor;
        }
    }

    private boolean isColorInHexa(String color) {
        if (color != null && color.startsWith("#")) {
            color = color.substring(1);
        }
        if (color != null && color.length() == 6) {
            boolean colorInHexa = true;
            String tempbg = color.toUpperCase();
            for (int i = 0; i < 6; ++i) {
                if (colorChars.contains(Character.valueOf(tempbg.charAt(i)))) continue;
                colorInHexa = false;
                break;
            }
            return colorInHexa;
        }
        return false;
    }

    private String extractStyleProperty(String propertyname) {
        String value = null;
        if (this.style == null || this.style.length() == 0) {
            return value;
        }
        StringTokenizer st = new StringTokenizer(this.style, ";");
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken().trim();
            int colonIndex = s1.indexOf(58);
            if (colonIndex <= 0) continue;
            String pname = s1.substring(0, colonIndex);
            String pvalue = s1.substring(colonIndex + 1, s1.length());
            if (!pname.equalsIgnoreCase(propertyname)) continue;
            value = pvalue;
            break;
        }
        return value;
    }

    private String resolveURL(String src) {
        ResolvePage rp = new ResolvePage();
        String baseUrlStr = null;
        try {
            baseUrlStr = this.getBaseURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String parentUrl = rp.prepareUrl(baseUrlStr);
        String actualBaseUrl = rp.baseUrl(baseUrlStr);
        String contextUrl = actualBaseUrl + this.request.getContextPath();
        String resolvedUrl = rp.resolveUrl(src, parentUrl, contextUrl);
        return resolvedUrl == null ? src : resolvedUrl;
    }

    private String getBaseURL() throws MalformedURLException {
        if (this.request instanceof DummyHttpServletRequest) {
            String url = ((DummyHttpServletRequest)this.request).getPathTranslated();
            return VFSFileFactory.getFileObject(url).toURL().toString();
        }
        return this.request.getRequestURL().toString();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateAttribute();
        if (!this.url.startsWith("/") && !this.url.startsWith("http")) {
            this.url = this.resolveURL(this.url);
        }
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        String styleStr = this.formatStyleString();
        this.htmlAssembler.openDivTag(this.name, null, styleStr);
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        this.htmlAssembler.closeDivTag();
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("var ");
        String functionName = this.htmlAssembler.openFunction(FILEUPLOAD, "init", true, true, null);
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(FILEUPLOAD);
        this.htmlAssembler.appendContent("=");
        String initMethod = null;
        initMethod = SWFFILEUPLOADINIT;
        this.encodeUrl();
        this.htmlAssembler.appendContent(initMethod).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(this.url, true).appendContent(',').appendContent(this.url_queryString != null ? HtmlAssembler.singleQuote(this.url_queryString) : null).appendContent(',').appendContent(this.url_cookie != null ? HtmlAssembler.singleQuote(this.url_cookie) : null).appendContent(',').appendContent(this.addButtonLabel != null ? HtmlAssembler.singleQuote(this.addButtonLabel) : null).appendContent(',').appendContent(this.clearButtonlabel != null ? HtmlAssembler.singleQuote(this.clearButtonlabel) : null).appendContent(',').appendContent(this.uploadButtonLabel != null ? HtmlAssembler.singleQuote(this.uploadButtonLabel) : null).appendContent(',').appendContent(this.deleteButtonLabel != null ? HtmlAssembler.singleQuote(this.deleteButtonLabel) : null).appendContent(',').appendContent(this.title != null ? HtmlAssembler.singleQuote(this.title) : null).appendContent(',').appendContent(this.maxFileSelect).appendContent(',').appendContent(this.fileSize).appendContent(',').appendContent(this.onComplete == null ? null : this.onComplete).appendContent(',').appendContent(this.onUploadComplete == null ? null : this.onUploadComplete).appendContent(',').appendContent(this.onError == null ? null : this.onError).appendContent(',').appendContent(this.width != null ? this.width : null).appendContent(',').appendContent(this.height != null ? this.height : null).appendContent(',').appendContent(this.bgcolor != null ? HtmlAssembler.singleQuote(this.bgcolor) : "null").appendContent(',').appendContent(this.selectColor != null ? HtmlAssembler.singleQuote(this.selectColor) : "null").appendContent(',').appendContent(this.rollOverColor != null ? HtmlAssembler.singleQuote(this.rollOverColor) : "null").appendContent(',').appendContent(this.textColor != null ? HtmlAssembler.singleQuote(this.textColor) : "null").appendContent(',').appendContent(this.titleTextColor != null ? HtmlAssembler.singleQuote(this.titleTextColor) : "null").appendContent(',').appendContent(this.headerColor != null ? HtmlAssembler.singleQuote(this.headerColor) : "null").appendContent(',').appendContent(this.titleTextAlign != null ? HtmlAssembler.singleQuote(this.titleTextAlign) : "null").appendContent(',').appendContent(this.extensionFilter != null ? HtmlAssembler.singleQuote(this.extensionFilter) : "null").appendContent(',').appendContent(this.progressBar ? "true" : "false").appendContent(',').appendContent(this.request.getContextPath() == "" ? HtmlAssembler.singleQuote("/") : HtmlAssembler.singleQuote(this.request.getContextPath())).appendContent(',').appendContent(this.hideUploadButton ? "true" : "false").appendContent(',').appendContent(this.stopOnError ? "true" : "false").appendContent(',').appendContent(this.wmode == null ? "null" : HtmlAssembler.singleQuote(this.wmode)).appendContent(',').appendContent(this.align == null ? "null" : HtmlAssembler.singleQuote(this.align)).appendContent(");");
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.closeScriptTag();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    private void encodeUrl() {
        Map settings;
        int index = this.url.indexOf(63);
        if (index > 0) {
            this.url_queryString = this.url.substring(index + 1);
            this.url_queryString = URLEncoder.encode(this.url_queryString);
            this.url = this.url.substring(0, index);
        }
        String appName = FusionContext.getCurrent().getApplicationName();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        boolean sessionManagement = false;
        if (appScope != null && (settings = appScope.getApplicationSettingsMap()) != null) {
            Object obj = settings.get(SESSION_MGMT_NAME);
            sessionManagement = Cast._boolean(obj);
        }
        if (sessionManagement) {
            Map scope;
            String urltoken;
            if (!this.matcher.contains(this.url, cfTokenPattern) && (urltoken = (String)(scope = this.getSessionScope()).get("urltoken")) != null) {
                if (this.matcher.contains(urltoken, j2eeTokenPattern)) {
                    this.url = this.url + ";jsessionid=" + scope.get("sessionid");
                }
                this.url = this.url + "?" + urltoken;
            }
            if (!this.matcher.contains(this.url, j2eeTokenPattern)) {
                this.response.encodeRedirectURL(this.url);
            }
        }
        if ((index = this.url.indexOf(63)) > 0) {
            this.url_cookie = this.url.substring(index + 1);
            this.url = this.url.substring(0, index);
        }
        if (this.url_cookie != null) {
            this.url_cookie = URLEncoder.encode(this.url_cookie);
        }
        this.url = URLEncoder.encode(this.url);
    }

    private String formatStyleString() {
        StringBuffer sb = new StringBuffer();
        if (this.align != null) {
            sb.append("text-Align:").append(this.align).append(';');
        }
        return sb.toString();
    }

    @Override
    public void release() {
        this.url = null;
        this.url_cookie = null;
        this.url_queryString = null;
        this.maxFileSelect = null;
        this.name = null;
        this.progressBar = true;
        this.width = null;
        this.panelWidth = 300;
        this.onComplete = null;
        this.onUploadComplete = null;
        this.onError = null;
        this.addButtonLabel = null;
        this.clearButtonlabel = null;
        this.height = null;
        this.maxFileSelect = null;
        this.maxUploadSize = null;
        this.fileSize = 0xA00000L;
        this.style = null;
        this.uploadButtonLabel = null;
        this.title = null;
        this.extensionFilter = null;
        this.hideUploadButton = false;
        this.wmode = null;
        this.stopOnError = true;
        this.bgcolor = null;
        this.selectColor = null;
        this.rollOverColor = null;
        this.textColor = null;
        this.titleTextColor = null;
        this.titleTextAlign = null;
        this.align = "left";
        this.headerColor = null;
    }

    static {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            cfTokenPattern = compiler.compile("[\\?&](CFID|CFTOKEN)=", 32769);
            j2eeTokenPattern = compiler.compile("[\\?&]JSESSIONID=", 32769);
        }
        catch (MalformedPatternException e) {
            CFLogs.SERVER_LOG.error(e);
        }
        colorChars = new ArrayList(15);
        colorChars.add(Character.valueOf('0'));
        colorChars.add(Character.valueOf('1'));
        colorChars.add(Character.valueOf('2'));
        colorChars.add(Character.valueOf('3'));
        colorChars.add(Character.valueOf('4'));
        colorChars.add(Character.valueOf('5'));
        colorChars.add(Character.valueOf('6'));
        colorChars.add(Character.valueOf('7'));
        colorChars.add(Character.valueOf('8'));
        colorChars.add(Character.valueOf('9'));
        colorChars.add(Character.valueOf('A'));
        colorChars.add(Character.valueOf('B'));
        colorChars.add(Character.valueOf('C'));
        colorChars.add(Character.valueOf('D'));
        colorChars.add(Character.valueOf('E'));
        colorChars.add(Character.valueOf('F'));
        WMODE_TYPES = new ArrayList(3);
        WMODE_TYPES.add("window");
        WMODE_TYPES.add("transparent");
        WMODE_TYPES.add("opaque");
    }

    public class EmptyNameException
    extends TagValidationException {
        public String name;

        public EmptyNameException(String name) {
            this.name = name;
        }
    }

    public class InsufficientPostSizeLimit
    extends TagValidationException {
        public float uploadSize;
        public float postSizeLimit;
        public float requestThrottleMemory;

        public InsufficientPostSizeLimit(float uploadSize, float postSizeLimit, float requestThrottleMemory) {
            this.uploadSize = uploadSize;
            this.postSizeLimit = postSizeLimit;
            this.requestThrottleMemory = requestThrottleMemory;
        }
    }

    public class InvalidMaxUploadSizeException
    extends TagValidationException {
        public String value;

        public InvalidMaxUploadSizeException(String value) {
            this.value = value;
        }
    }

    public class InvalidMaxFileSelectException
    extends TagValidationException {
        public String value;

        public InvalidMaxFileSelectException(String value) {
            this.value = value;
        }
    }

    public class InvalidWidthException
    extends TagValidationException {
        public String value;

        public InvalidWidthException(String value) {
            this.value = value;
        }
    }

    public class InvalidWmodeTypeException
    extends TagValidationException {
        public String wmode;
        public String allowed;

        public InvalidWmodeTypeException(String wmode, List allowedList) {
            this.wmode = wmode;
            this.allowed = ArrayUtil.ArrayToList(allowedList, ",").toUpperCase();
        }
    }

    public class InvalidAlignAttributeException
    extends TagValidationException {
    }

    public static class AjaxTagInvalidAttributeException
    extends TagValidationException {
        public String nameoftag;
        public String attribute;
        public String value;

        public AjaxTagInvalidAttributeException(String attribute, String nameoftag, String value) {
            this.attribute = attribute;
            this.nameoftag = nameoftag;
            this.value = value;
        }
    }

    public class EmptyActionException
    extends TagValidationException {
        public String action;

        public EmptyActionException(String action) {
            this.action = action;
        }
    }
}

