/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.security.ESAPIUtils;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.tagext.html.HtmlheadTag;
import coldfusion.tagext.html.ajax.AjaxRBFileMap;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class HtmlAssembler {
    public static final char OPEN_TAG = '<';
    public static final char CLOSE_TAG = '>';
    public static final char SLASH = '/';
    public static final char OPEN_BRACE = '{';
    public static final char CLOSE_BRACE = '}';
    public static final char OPEN_SQUARE = '[';
    public static final char CLOSE_SQUARE = ']';
    public static final char OPEN_BRACKET = '(';
    public static final char CLOSE_BRACKET = ')';
    public static final String DOT = ".";
    public static final String PERCENTAGE = "%";
    public static final String HASH = "#";
    public static final String EMPTY_STRING = "";
    public static final String SHOWFUNC = ".show();";
    public static final String RENDERFUNC = ".render();";
    public static final String OPENCALL = "(";
    public static final String ENDCALL = ");";
    public static final String VAR = "var ";
    public static final String EXT_READY_OPEN = "Ext.onReady(function(){";
    public static final String EXT_READY_CLOSE = "});";
    public static final String PROTOTYPE = ".prototype.";
    public static final String EQUALS = "=";
    public static final char COMMA = ',';
    public static final char COLON = ':';
    public static final String PLUS = " + ";
    public static final String UNDERSCORE = "_";
    public static final String SPACE = " ";
    public static final String HTML_SPACE = "&nbsp;";
    public static final String INIT = "init";
    public static final String NULL = "null";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String OPENSTYLE = "<style>";
    public static final String CLOSESTYLE = "</style>";
    public static final String CSS_COLOR = "color";
    public static final String CSS_BACKGROUND_COLOR = "background-color";
    public static final String CSS_IMPORTANT = "!important";
    public static final String CSS_OVERFLOW_HIDDEN = "overflow:hidden;";
    public static final String FONT_SIZE = "font-size";
    public static final String FONT_FAMILY = "font-family";
    public static final String FONT_WEIGHT = "font-weight";
    public static final String FONT_BOLD = "bold";
    public static final String FONT_STYLE = "font-style";
    public static final String FONT_ITALIC = "italic";
    public static final String TEXT_DECORATION = "text-decoration";
    public static final String UNDERLINE = "underline";
    public static final String CFCONTAINERID = "_cf_containerid";
    public static final String TEXT_ALIGN = "text-align:";
    public static final String VISIBLE = "visible";
    public static final String HIDDEN = "hidden";
    public static final String AUTO = "auto";
    public static final String SCROLL = "scroll";
    public static final String OVERFLOWPROP = "overflow:";
    public static final String DIV_OPEN = "<div ";
    public static final String DIV_CLOSE = " </div>";
    public static final String SPAN_OPEN = "<span ";
    public static final String SPAN_CLOSE = " </span>";
    public static final String ID = " id=\"";
    public static final String CLASS = " class=\"";
    public static final String DOUBLEQUOTE = "\"";
    public static final String SINGLEQUOTE = "'";
    public static final String JS_ESCAPE = "\\";
    public static final String ANCHOROPEN = "<a ";
    public static final String ANCHORCLOSE = "</a>";
    public static final String HREFINIT = "href=\"";
    public static final String TARGET = "target=\"";
    public static final String IMGTAG = "<img src=\"";
    public static final String CF_PREFIX = "_cf_";
    public static final String GET_TOOLTIP = "ColdFusion.Tooltip.getToolTip";
    public static final String FUNC_REPLACEHTML = "ColdFusion.Ajax.replaceHTML(";
    public static final String IMPORTED_JS_PUSH = "ColdFusion.importedJSPaths.push(";
    public static final String JAVSCRIPTCOLON = "javascript:";
    public static final String CF_NAVIGATE_FUNC = "ColdFusion.navigate(";
    public static final String REQUEST_AJAXCALL = "_cf_ajaxcall";
    public static final String EVENT_MOUSEOVER = "mouseover";
    public static final String YAHOO_DOM_EVENT_MIN_JS = "/yui/yahoo-dom-event/yahoo-dom-event.js";
    public static final String CONTAINER_MIN_JS = "/yui/container/container-min.js";
    public static final String CONTAINER_MIN_CORE_JS = "/yui/container/container_core-min.js";
    public static final String ANIMATION_MIN_JS = "/yui/animation/animation-min.js";
    public static final String MENU_MIN_JS = "/yui/menu/menu-min.js";
    public static final String DRAGDROP_MIN_JS = "/yui/dragdrop/dragdrop-min.js";
    public static final String TREEVIEW_MIN_JS = "/yui/treeview/treeview-min.js";
    public static final String LOGGER_MIN_JS = "/yui/logger/logger-min.js";
    public static final String DUMP_JS = "/dump/dump.js";
    public static final String LOGGER_CSS = "/yui/logger/assets/logger.css";
    public static final String CF_CSS = "/resources/cf/cf.css";
    public static final String UPLOAD_FILE_CSS = "/resources/cf/uploadfile.css";
    public static final String YUI_CSS = "/resources/yui/yui.css";
    public static final String EXT_ALL_CSS = "/resources/ext/css/ext-all.css";
    public static final String LAYOUT_CSS = "/resources/ext/css/layout.css";
    public static final String FANCYBOX_CSS = "/fancybox/jquery.fancybox-1.3.4.css";
    public static final String JQUERY_CSS = "/resources/cf/smp/jquery-ui.css";
    public static final String SMP_DESK_CSS = "/resources/cf/smp/jquery.strobemediaplaybackhtml5-desk.css";
    public static final String SMP_MOBILE_CSS = "/resources/cf/smp/jquery.strobemediaplaybackhtml5.css";
    public static final String CFAJAX_JS = "/package/cfajax.js";
    public static final String CFTOOLTIP_JS = "/package/cftooltip.js";
    public static final String CFLAYOUT_JS = "/package/cflayout.js";
    public static final String CFWINDOW_JS = "/package/cfwindow.js";
    public static final String CFRICHTEXTEDITOR_JS = "/package/cfrichtexteditor.js";
    public static final String CFFILEUPLOAD_JS = "/package/cffileupload.js";
    public static final String CFFILEUPLOAD_SWF_JS = "/package/cffileupload_swf.js";
    public static final String CFPROGRESSBAR_JS = "/package/cfprogressbar.js";
    public static final String CFMESSAGEBOX_JS = "/package/cfmessagebox.js";
    public static final String STROBEMEDIAPLAYER_JS = "/smp/StrobeMediaPlayer.js";
    public static final String STROBEMEDIAPLAYER_CUSTOM_JS = "/smp/jquery.strobemediaplaybackhtml5.js";
    public static final String STROBEMEDIAPLAYER_PROFILE_JS = "/smp/profiles.js";
    public static final String STROBEMEDIAPLAYER_PARSEQUERY_JS = "/smp/ParsedQueryString.js";
    public static final String STROBEMEDIAPLAYER_DEVICEDETECTION_JS = "/smp/devicedetection.js";
    public static final String STROBEMEDIAPLAYER_JQUERYUI_JS = "/smp/jquery-ui-1.8.14.custom.min.js";
    public static final String STROBEMEDIAPLAYER_JQUERYUI_CORE_JS = "/smp/jquery.ui.core.js";
    public static final String STROBEMEDIAPLAYER_JQUERYUI_MOUSE_JS = "/smp/jquery.ui.mouse.js";
    public static final String STROBEMEDIAPLAYER_JQUERYUI_WIDGET_JS = "/smp/jquery.ui.widget.js";
    public static final String STROBEMEDIAPLAYER_JQUERYUI_SLIDER_JS = "/smp/jquery.ui.slider.js";
    public static final String JQUERY_JS = "/jquery/jquery.js";
    public static final String STROBEMEDIAPLAYER_SWFOBJ_JS = "/smp/swfobject.js";
    public static final String CFMAP_JS = "/package/cfmap.js";
    public static final String CFSLIDER_JS = "/package/cfslider.js";
    public static final String CFBUTTON_JS = "/package/cfbutton.js";
    public static final String CKEDITOR_JS = "/ckeditor/ckeditor.js";
    public static final String FANCYBOX_JS = "/fancybox/jquery.fancybox-1.3.4.pack.js";
    public static final String FANCYBOX_JQUERY_EASING_JS = "/fancybox/jquery.easing-1.3.pack.js";
    public static final String FANCYBOX_JQUERY_MOUSEWHEEL_JS = "/fancybox/jquery.mousewheel-3.0.4.pack.js";
    public static final String EXT_YUI_ADAPTER_JS = "/ext/adapter/yui/ext-yui-adapter.js";
    public static final String EXT_CORE_JS = "/ext/ext-all.js";
    public static final String EXT_ALL_JS = "/ext/ext-all.js";
    public static final String EXT_TASKMANAGER_MIN_JS = "/ext/source/util/core/TaskMgr.js";
    public static final String EXT_MENU_BUTTON_JS = "/ext/source/widgets/SplitButton.js";
    public static final String EXT_VIEW_JS = "/ext/source/widgets/DataView.js";
    public static final String PIXEL = "px";
    public static final String CSS_HEIGHT = "height:";
    public static final String CSS_WIDTH = "width:";
    public static final String OPEN_CF_APPLY_STYLES = "ColdFusion.DOM.applyStyles(";
    private static final String IMPORTS_PREFIX = "<script type=\"text/javascript\" src=\"";
    private static final String IMPORTS_PATH = "/cf_scripts/scripts";
    private static final String IMPORTS_AJAX_PATH = "/ajax";
    private static final String IMPORTS_SUFFIX = "></script>";
    public static final String FUNCTION_OPEN = "function(";
    private static final String FUNCTION = "function ";
    private static final String FUNCTION_CLOSE = "};";
    private static final String OPEN_SCRIPT_1 = "<script type=\"text/javascript\" ";
    private static final String OPEN_SCRIPT_2 = ">";
    private static final String CLOSE_SCRIPT = "</script>";
    private static final String OPEN_CDATA = "/* <![CDATA[ */";
    private static final String CLOSE_CDATA = "/* ]]> */";
    private static final String LINK_STYLESHEET = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
    private static final String CLOSE_LINK_STYLESHEET = " />";
    public static final String STYLE = " style=\"";
    public static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    public static final char SEMICOLON = ';';
    private static final String CF_REGISTER_ONLOAD = "ColdFusion.Event.registerOnLoad(";
    private static final String YAHOO_ADD_EVENT = "YAHOO.util.Event.addListener(";
    private static final String CONTAINERID = "_cf_containerId:";
    public static final String PATH_LOADING_GIF = "/resources/cf/images/loading.gif";
    private static boolean whiteSpaceEnabled = true;
    private StringBuffer currentIndentSpace;
    private StringBuffer htmlcontent = new StringBuffer();
    private StringBuffer jscontent = new StringBuffer();
    private StringBuffer styleBuffer = new StringBuffer();
    private StringBuffer outputBuffer = this.htmlcontent;
    private StringBuffer configContent = null;
    private String cssSrc = null;
    private ArrayList stylesheets = new ArrayList();
    private ArrayList stylesheetsHistory = new ArrayList();
    private boolean debugProcessed = false;
    private boolean messagesImported = false;
    private ArrayList imports = new ArrayList();
    private ArrayList importsHistory = new ArrayList();
    private String importPath;
    private ArrayList importedTags = new ArrayList();
    private boolean isScriptSrcSet;
    private boolean configScriptWritten = false;
    private int scriptCounter = 0;
    private int indent = 0;
    private boolean isSpryInitGenerated = false;
    public static final String PAGECONTEXT_HTML_ASSEMBLER = "_cf_htmlassembler";
    private static final String CFLOADING_TEXTHTML = "_cf_loadingtexthtml";
    private static final String CFCONTEXTPATH = "_cf_contextpath";
    private static final String CFAJAXSCRIPTSRC = "_cf_ajaxscriptsrc";
    private static final String CFJSONPREFIX = "_cf_jsonprefix";
    public static final String CFCLIENTID = "_cf_clientid";
    public static final String CFENCRYPTED_APPNAME = "_cf_ajaxproxytoken";
    public static final String CFWEBSOCKETPORT = "_cf_websocket_port";
    public static final String CF_WEBSOCKET_SSL_PORT = "_cf_websocket_ssl_port";
    public static final String CF_FLASH_POLICY_PORT = "_cf_flash_policy_port";
    private static CFLocaleMgr cfLocaleMgr = null;
    private Locale locale;
    private static final String CFDEBUG = "cfdebug";
    private static final String LOGGER_DEBUG_STYLE = ".yui-log .debug {background-color:brown}";
    private static final String EXTDEFJS = "<script type=\"text/javascript\">if(!window.Ext){ Ext = {};}if(!Ext.util){Ext.util = {};}</script>";
    private long randomId = -1L;
    private String contextPath = null;
    private PageContext pageContext = null;
    private String jsonPrefix = null;
    private String clientId = null;
    private boolean isAjaxComponent = false;
    private boolean topPage = true;
    private LinkedList containerIdStack = new LinkedList();
    private LinkedList scriptSrcStack = new LinkedList();
    private String usedScriptSrc;

    private HtmlAssembler(PageContext ctx) {
        this.pageContext = ctx;
        this.contextPath = ((HttpServletRequest)ctx.getRequest()).getContextPath();
        this.setScriptSrc(this.contextPath + IMPORTS_PATH);
        String scriptSrc = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getCFFormScriptSrc();
        this.setScriptSrc(scriptSrc);
        this.isScriptSrcSet = false;
        this.setIndentSpace();
        FusionContext fc = ((NeoPageContext)ctx).getFusionContext();
        Map urlScope = (Map)fc.hiddenScope.get("URL");
        Map formScope = (Map)fc.hiddenScope.get("FORM");
        String containerId = (String)urlScope.get(CFCONTAINERID);
        if (formScope != null && containerId == null) {
            containerId = (String)formScope.get(CFCONTAINERID);
        }
        this.jsonPrefix = fc.getSecureJSONPrefix() == null ? EMPTY_STRING : fc.getSecureJSONPrefix();
        this.clientId = AjaxUtils.constructClientId(fc);
        if (containerId != null) {
            this.setContainerId(containerId);
            this.topPage = false;
        }
        this.randomId = System.nanoTime();
        boolean isResponseLocaleSet = cfLocaleMgr.isResponseLocaleSet(this.pageContext);
        if (isResponseLocaleSet) {
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            this.locale = response.getLocale();
        } else {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            this.locale = request.getLocale();
        }
    }

    public static HtmlAssembler getInstance(PageContext ctx, boolean isAjaxComponent) {
        FusionContext fusCtx = ((NeoPageContext)ctx).getFusionContext();
        HtmlAssembler instance = fusCtx.getHtmlAssembler();
        if (instance == null) {
            cfLocaleMgr = CFLocaleMgr.getMgr();
            instance = new HtmlAssembler(ctx);
            fusCtx.setHtmlAssembler(instance);
        }
        if (isAjaxComponent && !instance.isAjaxComponent) {
            instance.setAjaxComponent(isAjaxComponent);
        }
        return instance;
    }

    public void setScriptSrc(String scriptSrc) {
        if (scriptSrc != null) {
            if (scriptSrc.length() == 0) {
                return;
            }
            if (scriptSrc.endsWith("/")) {
                scriptSrc = scriptSrc.substring(0, scriptSrc.length() - 1);
            }
        }
        if (this.importPath != null) {
            this.scriptSrcStack.add(this.importPath);
        }
        this.importPath = scriptSrc;
        this.isScriptSrcSet = true;
    }

    public void resetScriptSrc() {
        this.importPath = (String)this.scriptSrcStack.getLast();
        this.scriptSrcStack.removeLast();
    }

    public boolean isScriptSrcSet() {
        return this.isScriptSrcSet;
    }

    public String getImportAjaxPath() {
        return this.importPath + IMPORTS_AJAX_PATH;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public void markTagImported(String tagName) {
        this.importedTags.add(tagName);
    }

    public void resetHTMLAssembler() {
        this.importedTags.clear();
        this.stylesheetsHistory.clear();
        this.importsHistory.clear();
        this.messagesImported = false;
        this.configScriptWritten = false;
    }

    public boolean isTagImported(String tagName) {
        return this.importedTags.contains(tagName);
    }

    public void setCssSrc(String newCssSrc) {
        if ((newCssSrc = newCssSrc.trim()).endsWith("/")) {
            newCssSrc = newCssSrc.substring(0, newCssSrc.length() - 1);
        }
        this.cssSrc = newCssSrc;
    }

    public void setAjaxComponent(boolean isAjaxComponent) {
        this.isAjaxComponent = isAjaxComponent;
    }

    public String getContainerId() {
        if (this.containerIdStack.isEmpty()) {
            return null;
        }
        return (String)this.containerIdStack.getLast();
    }

    public String getRequestContainerId() {
        if (this.topPage) {
            return null;
        }
        return (String)this.containerIdStack.getFirst();
    }

    public void setContainerId(String containerId) {
        String conId = ESAPIUtils.getValidateInput(containerId, "CFContainerID", 100);
        this.containerIdStack.addLast(conId);
    }

    public void resetContainerId() {
        if (!this.containerIdStack.isEmpty()) {
            this.containerIdStack.removeLast();
        }
    }

    public boolean isTopPage() {
        return this.topPage;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        HtmlAssembler htmlAssembler = this;
        synchronized (htmlAssembler) {
            ++this.randomId;
            return new Long(this.randomId).toString();
        }
    }

    public void setId(long initVal) {
        this.randomId = initVal;
    }

    public static boolean isEnableWhiteSpace() {
        return whiteSpaceEnabled;
    }

    public static void setWhiteSpaceEnabled(boolean enableWhiteSpace) {
        whiteSpaceEnabled = enableWhiteSpace;
    }

    public void incrementIndent() {
        this.currentIndentSpace.append('\t');
    }

    public void decrementIndent() {
        if (this.currentIndentSpace.length() > 0) {
            this.currentIndentSpace.deleteCharAt(0);
        }
    }

    public void newLine() {
        if (whiteSpaceEnabled) {
            this.appendContent('\n');
            this.appendContent(this.currentIndentSpace);
        }
    }

    private void setIndentSpace() {
        StringBuffer buf = new StringBuffer();
        for (int tempIndentCount = this.indent; tempIndentCount > 0; --tempIndentCount) {
            buf.append('\t');
        }
        if (this.currentIndentSpace == null) {
            this.currentIndentSpace = new StringBuffer();
        }
        this.currentIndentSpace.append(buf.toString());
    }

    public void openDivTag(String id, String classname, String style) {
        this.openDivTag(id, classname, style, null);
    }

    public void openDivTag(String id, String classname, String style, Map additionalAttributes) {
        this.appendContent(DIV_OPEN);
        if (id != null) {
            this.appendContent(ID).appendContent(id).appendContent(DOUBLEQUOTE);
        }
        if (classname != null) {
            this.appendContent(CLASS).appendContent(classname).appendContent(DOUBLEQUOTE);
        }
        if (style != null) {
            if (((String)style).length() - 1 >= 0 && ((String)style).charAt(((String)style).length() - 1) != ';') {
                style = (String)style + ";";
            }
            this.appendContent(STYLE).appendContent((String)style).appendContent(DOUBLEQUOTE);
        }
        if (additionalAttributes != null) {
            for (String key : additionalAttributes.keySet()) {
                this.appendContent(SPACE).appendContent(key).appendContent(EQUALS);
                if (additionalAttributes.get(key) instanceof Boolean) {
                    this.appendContent(((Boolean)additionalAttributes.get(key)).toString());
                    continue;
                }
                this.appendContent(HtmlAssembler.doubleQuote((String)additionalAttributes.get(key)));
            }
        }
        this.appendContent('>');
        this.incrementIndent();
        this.newLine();
    }

    public void closeDivTag() {
        this.decrementIndent();
        this.newLine();
        this.appendContent(DIV_CLOSE);
    }

    public void openSpanTag(String id, String classname, String style) {
        this.openSpanTag(id, classname, style, null);
    }

    public void openSpanTag(String id, String classname, String style, Map additionalAttributes) {
        this.appendContent(SPAN_OPEN);
        if (id != null) {
            this.appendContent(ID).appendContent(id).appendContent(DOUBLEQUOTE);
        }
        if (classname != null) {
            this.appendContent(CLASS).appendContent(classname).appendContent(DOUBLEQUOTE);
        }
        if (style != null) {
            if (((String)style).length() - 1 >= 0 && ((String)style).charAt(((String)style).length() - 1) != ';') {
                style = (String)style + ";";
            }
            this.appendContent(STYLE).appendContent((String)style).appendContent(DOUBLEQUOTE);
        }
        if (additionalAttributes != null) {
            for (String key : additionalAttributes.keySet()) {
                this.appendContent(SPACE).appendContent(key).appendContent(EQUALS);
                if (additionalAttributes.get(key) instanceof Boolean) {
                    this.appendContent(((Boolean)additionalAttributes.get(key)).toString());
                    continue;
                }
                this.appendContent(HtmlAssembler.doubleQuote((String)additionalAttributes.get(key)));
            }
        }
        this.appendContent('>');
        this.incrementIndent();
        this.newLine();
    }

    public void closeSpanTag() {
        this.decrementIndent();
        this.newLine();
        this.appendContent(SPAN_CLOSE);
    }

    public void importJS(String src) {
        this.importJS(src, this.importPath, true);
    }

    public void importStylesheet(String src) {
        if (!this.stylesheets.contains(src) && !this.stylesheetsHistory.contains(src)) {
            this.stylesheets.add(src);
        }
    }

    public void checkIfScriptSrcModified(String tagName) {
        if (!(this.usedScriptSrc == null || this.usedScriptSrc.equalsIgnoreCase(this.importPath) || this.usedScriptSrc.equalsIgnoreCase("/cf_scripts/cfclient") || tagName.equalsIgnoreCase("CFFORM"))) {
            throw new InvalidAjaxTagUsageException();
        }
    }

    public void importJS(String src, String scriptSrc, boolean ajaxImport) {
        this.importJS(src, scriptSrc, ajaxImport, false);
    }

    public void importJS(String src, String scriptSrc, boolean ajaxImport, boolean ignoreScriptSrc) {
        if (!this.isTopPage()) {
            return;
        }
        if (scriptSrc == null) {
            scriptSrc = this.importPath;
        }
        if (ajaxImport) {
            src = scriptSrc + IMPORTS_AJAX_PATH + (String)src;
        } else if (!ignoreScriptSrc) {
            src = scriptSrc + (String)src;
        } else if (!((String)src).startsWith("http")) {
            src = this.contextPath + (String)src;
        }
        if (!this.imports.contains(src) && !this.importsHistory.contains(src)) {
            if (!this.configScriptWritten && ((String)src).endsWith(CFAJAX_JS)) {
                this.configContent = new StringBuffer();
                this.configContent.append(OPEN_SCRIPT_1);
                this.configContent.append(Utils.getCSPNonceString());
                this.configContent.append(OPEN_SCRIPT_2);
                this.configContent.append(OPEN_CDATA);
                StringBuffer htmlText = new StringBuffer();
                htmlText.append("<img alt=' ' src=").append(SINGLEQUOTE).append(this.importPath).append(IMPORTS_AJAX_PATH).append(PATH_LOADING_GIF).append(SINGLEQUOTE).append("/>");
                this.configContent.append(CFLOADING_TEXTHTML).append(EQUALS).append(HtmlAssembler.doubleQuote(htmlText.toString())).append(';');
                this.configContent.append('\n');
                this.configContent.append(CFCONTEXTPATH).append(EQUALS).append(HtmlAssembler.doubleQuote(this.contextPath)).append(';');
                this.configContent.append('\n');
                this.configContent.append(CFAJAXSCRIPTSRC).append(EQUALS).append(HtmlAssembler.doubleQuote(this.importPath + IMPORTS_AJAX_PATH)).append(';');
                this.configContent.append('\n');
                this.configContent.append(CFJSONPREFIX).append(EQUALS);
                HtmlAssembler.singleQuote(this.jsonPrefix, false, this.configContent);
                this.configContent.append(';');
                this.configContent.append('\n');
                if (ServiceFactory.getWebsocketService() != null) {
                    WebSocketService webSocketService = ServiceFactory.getWebsocketService();
                    this.configContent.append(CFWEBSOCKETPORT).append(EQUALS);
                    this.configContent.append(webSocketService.getPort());
                    this.configContent.append(';');
                    this.configContent.append('\n');
                    this.configContent.append(CF_FLASH_POLICY_PORT).append(EQUALS);
                    this.configContent.append(webSocketService.getFlashPolicyPort());
                    this.configContent.append(';');
                    this.configContent.append('\n');
                    if (webSocketService.isSSLEnabled()) {
                        this.configContent.append(CF_WEBSOCKET_SSL_PORT).append(EQUALS);
                        this.configContent.append(webSocketService.getSSLPort());
                        this.configContent.append(';');
                        this.configContent.append('\n');
                    }
                }
                if (this.clientId != null) {
                    this.configContent.append(CFCLIENTID).append(EQUALS);
                    HtmlAssembler.singleQuote(this.clientId, false, this.configContent);
                    this.configContent.append(';');
                }
                this.configContent.append(CLOSE_CDATA);
                this.configContent.append(CLOSE_SCRIPT);
            }
            if (!this.messagesImported && ((String)src).endsWith(CFAJAX_JS)) {
                AjaxRBFileMap.importResourceBundleJS(this.locale, this);
                this.messagesImported = true;
            }
            this.imports.add(src);
            if (!ignoreScriptSrc) {
                this.usedScriptSrc = scriptSrc;
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void openScriptTag() {
        ++this.scriptCounter;
        this.outputBuffer = this.jscontent;
        if (this.scriptCounter == 1) {
            this.newLine();
            this.appendContent(OPEN_SCRIPT_1);
            this.appendContent(Utils.getCSPNonceString());
            this.appendContent(OPEN_SCRIPT_2);
            this.appendContent(OPEN_CDATA);
            this.incrementIndent();
            this.newLine();
        }
    }

    public void closeScriptTag() {
        if (this.scriptCounter == 1) {
            this.decrementIndent();
            this.newLine();
            this.appendContent(CLOSE_CDATA);
            this.appendContent(CLOSE_SCRIPT);
            this.newLine();
        }
        --this.scriptCounter;
        if (this.scriptCounter <= 0) {
            this.outputBuffer = this.htmlcontent;
        }
    }

    public String openFunction(String tagName, String functionName, boolean randomize, boolean objectSyntax, String[] parameters) {
        StringBuffer funcName = new StringBuffer();
        funcName.append(CF_PREFIX).append(tagName).append(UNDERSCORE).append(functionName);
        if (randomize) {
            funcName.append(UNDERSCORE).append(this.getId());
        }
        if (objectSyntax) {
            this.appendContent(funcName).appendContent(EQUALS).appendContent(FUNCTION_OPEN);
        } else {
            this.newLine();
            this.appendContent(FUNCTION).appendContent(funcName).appendContent('(');
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (i < parameters.length - 1) {
                    this.appendContent(SPACE);
                }
                this.appendContent(parameters[i]);
                if (i >= parameters.length - 1) continue;
                this.appendContent(",");
            }
        }
        this.appendContent(")");
        this.newLine();
        this.appendContent("{");
        this.incrementIndent();
        this.newLine();
        return funcName.toString();
    }

    public String openFunction(String functionName, boolean objectSyntax, String[] parameters) {
        if (objectSyntax) {
            this.appendContent(functionName).appendContent(EQUALS).appendContent(FUNCTION_OPEN);
        } else {
            this.newLine();
            this.appendContent(FUNCTION).appendContent(functionName).appendContent('(');
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (i < parameters.length - 1) {
                    this.appendContent(SPACE);
                }
                this.appendContent(parameters[i]);
                if (i >= parameters.length - 1) continue;
                this.appendContent(",");
            }
        }
        this.appendContent(")");
        this.newLine();
        this.appendContent("{");
        this.incrementIndent();
        this.newLine();
        return functionName.toString();
    }

    public void closeFunction() {
        this.decrementIndent();
        this.newLine();
        this.appendContent(FUNCTION_CLOSE);
    }

    public void setEventOnLoad(String functionName) {
        this.setEventOnLoad(functionName, false);
    }

    public void setEventOnLoad(String functionName, boolean isUserFn) {
        this.appendContent(CF_REGISTER_ONLOAD).appendContent(functionName);
        String containerId = this.getRequestContainerId();
        if (containerId != null) {
            this.appendContent(',');
            this.appendContent('{').appendContent(CONTAINERID);
            this.appendContent(SINGLEQUOTE).appendContent(containerId);
            this.appendContent(SINGLEQUOTE).appendContent('}');
        }
        if (isUserFn) {
            if (containerId == null) {
                this.appendContent(',').appendContent(NULL);
            }
            this.appendContent(',').appendContent(FALSE);
            this.appendContent(',').appendContent(TRUE);
        }
        this.appendContent(ENDCALL);
    }

    public void setEvent(String target, boolean isTargetId, String event, String functionName, String params) {
        this.newLine();
        this.appendContent(YAHOO_ADD_EVENT);
        if (isTargetId) {
            this.appendContent(DOUBLEQUOTE);
        }
        this.appendContent(target);
        if (isTargetId) {
            this.appendContent(DOUBLEQUOTE);
        }
        this.appendContent(',').appendContent(DOUBLEQUOTE).appendContent(event).appendContent(DOUBLEQUOTE).appendContent(',').appendContent(functionName);
        if (params != null) {
            this.appendContent(',').appendContent(params);
        }
        this.appendContent(ENDCALL);
    }

    public void setEvent(String target, boolean isTargetId, String event, String functionName, String[] paramNames, String[] params) {
        StringBuffer paramBuf = new StringBuffer();
        if (params != null && paramNames != null) {
            paramBuf.append('{');
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    paramBuf.append(',');
                }
                paramBuf.append(HtmlAssembler.doubleQuote(paramNames[i]));
                paramBuf.append(':');
                paramBuf.append(params[i]);
            }
            paramBuf.append('}');
        }
        this.setEvent(target, isTargetId, event, functionName, paramBuf.toString());
    }

    public void setEventOnAvailable(String name, String functionName) {
        this.newLine();
        this.appendContent("YAHOO.util.Event.onAvailable(\"").appendContent(name).appendContent("\",").appendContent(functionName).appendContent(")").appendContent(";");
    }

    public void setAnchorTag(String href, String display, String target, String style) {
        this.setAnchorTag(href, display, target, style, null);
    }

    public void setAnchorTag(String href, String display, String target, String style, String cssclass) {
        this.appendContent(ANCHOROPEN);
        if (href != null) {
            this.appendContent(HREFINIT).appendContent(href).appendContent(DOUBLEQUOTE);
        }
        if (target != null) {
            this.appendContent(SPACE).appendContent(TARGET).appendContent(target).appendContent(DOUBLEQUOTE);
        }
        if (cssclass != null) {
            this.appendContent(SPACE).appendContent(CLASS).appendContent(cssclass).appendContent(DOUBLEQUOTE);
        }
        if (style != null) {
            if (((String)(style = ((String)style).trim())).length() - 1 >= 0 && ((String)style).charAt(((String)style).length() - 1) != ';') {
                style = (String)style + ";";
            }
            this.appendContent(SPACE).appendContent(STYLE).appendContent((String)style).appendContent(DOUBLEQUOTE);
        }
        this.appendContent('>');
        this.appendContent(display).appendContent(ANCHORCLOSE);
    }

    public HtmlAssembler appendContent(StringBuffer buf) {
        this.outputBuffer.append(buf);
        return this;
    }

    public HtmlAssembler appendContent(String buf) {
        this.outputBuffer.append(buf);
        return this;
    }

    public HtmlAssembler appendContent(String buf, boolean singleQuote) {
        if (singleQuote) {
            HtmlAssembler.singleQuote(buf, false, this.outputBuffer);
        } else {
            this.appendContent(buf);
        }
        return this;
    }

    public HtmlAssembler appendContent(char buf) {
        this.outputBuffer.append(buf);
        return this;
    }

    public HtmlAssembler appendContent(boolean b) {
        this.outputBuffer.append(b);
        return this;
    }

    public HtmlAssembler appendContent(long i) {
        this.outputBuffer.append(i);
        return this;
    }

    public void imageTag(String src) {
        StringBuffer temp = new StringBuffer();
        temp.append(IMGTAG).append(src).append(DOUBLEQUOTE).append("/").append('>');
        this.appendContent(temp);
    }

    public void openStyle() {
        this.openStyle(null);
    }

    public void openStyle(String stylecontent) {
        this.outputBuffer = this.styleBuffer;
        this.newLine();
        this.outputBuffer.append(OPENSTYLE);
        this.incrementIndent();
        if (stylecontent != null) {
            this.outputBuffer.append(stylecontent);
        }
    }

    public void closeStyle() {
        this.decrementIndent();
        this.newLine();
        this.outputBuffer.append(CLOSESTYLE);
        this.outputBuffer = this.htmlcontent;
    }

    public HtmlAssembler appendHeadContent(String buf) {
        this.jscontent.append(buf);
        return this;
    }

    public void writeHtml(JspWriter out) throws IOException {
        if (out instanceof CFOutput) {
            ((CFOutput)out).cfoutput(true);
        }
        out.write(this.htmlcontent.toString());
        if (out instanceof CFOutput) {
            ((CFOutput)out).cfoutput(false);
        }
        this.htmlcontent.setLength(0);
    }

    public void writeHead(JspWriter out) {
        this.writeHead(out, false);
    }

    public void writeHead(JspWriter out, boolean prepend) {
        int i;
        this.initialize();
        StringBuffer jsImportBuffer = new StringBuffer();
        StringBuffer allStylesBuffer = new StringBuffer();
        if (this.getRequestContainerId() == null) {
            if (this.stylesheets.contains(LOGGER_CSS)) {
                allStylesBuffer.append(LINK_STYLESHEET).append(this.importPath).append(IMPORTS_AJAX_PATH).append(LOGGER_CSS).append(DOUBLEQUOTE).append(CLOSE_LINK_STYLESHEET).append('\n');
                this.stylesheets.remove(LOGGER_CSS);
            }
            Object cssImportPath = this.cssSrc == null ? this.importPath + IMPORTS_AJAX_PATH : this.cssSrc;
            for (i = 0; i < this.stylesheets.size(); ++i) {
                allStylesBuffer.append(LINK_STYLESHEET).append((String)cssImportPath).append(this.stylesheets.get(i)).append(DOUBLEQUOTE).append(CLOSE_LINK_STYLESHEET).append('\n');
            }
            this.stylesheetsHistory.addAll(this.stylesheets);
            this.stylesheets.clear();
        }
        allStylesBuffer.append(this.styleBuffer);
        this.styleBuffer.setLength(0);
        StringBuffer headBuffer = new StringBuffer();
        for (i = 0; i < this.imports.size(); ++i) {
            String importJS = (String)this.imports.get(i);
            jsImportBuffer.append(IMPORTS_PREFIX).append(importJS).append(DOUBLEQUOTE).append(SPACE).append(Utils.getCSPNonceString()).append(IMPORTS_SUFFIX).append('\n');
        }
        headBuffer.append(this.jscontent);
        this.importsHistory.addAll(this.imports);
        this.imports.clear();
        if (!this.configScriptWritten && this.configContent != null) {
            HtmlheadTag.writeToHead(this.configContent.toString(), out, true);
            this.configScriptWritten = true;
            this.configContent = null;
        }
        try {
            HtmlheadTag.writeToHead(jsImportBuffer.toString(), out, true);
            HtmlheadTag.writeToHead(allStylesBuffer.toString(), out, true);
            HtmlheadTag.writeToHead(headBuffer.toString(), out, prepend);
        }
        catch (HtmlheadTag.InvalidHtmlHeadException ex) {
            try {
                if (out instanceof CFOutput) {
                    ((CFOutput)out).cfoutput(true);
                }
                out.write(jsImportBuffer.toString());
                out.write(headBuffer.toString());
                if (out instanceof CFOutput) {
                    ((CFOutput)out).cfoutput(false);
                }
            }
            catch (IOException ioEx) {
                throw new OutputWriterException((Throwable)ioEx);
            }
        }
        this.jscontent.setLength(0);
    }

    private void initialize() {
        DebuggingService ds = ServiceFactory.getDebuggingService();
        if (ds != null && !this.debugProcessed && ds.isAjaxDebugEnabled() && ds.isValidIP(this.pageContext.getRequest().getRemoteAddr())) {
            FusionContext fc = ((NeoPageContext)this.pageContext).getFusionContext();
            Map urlScope = (Map)fc.hiddenScope.get("URL");
            Map formScope = (Map)fc.hiddenScope.get("FORM");
            String debug = (String)urlScope.get(CFDEBUG);
            if (formScope != null && debug == null) {
                debug = (String)formScope.get(CFDEBUG);
            }
            if (debug != null) {
                this.importJS(YAHOO_DOM_EVENT_MIN_JS);
                this.importJS(DRAGDROP_MIN_JS);
                this.importJS(LOGGER_MIN_JS);
                this.importJS(DUMP_JS);
                this.importJS(CFAJAX_JS);
                this.stylesheets.add(LOGGER_CSS);
                this.openStyle(LOGGER_DEBUG_STYLE);
                this.closeStyle();
            }
            this.debugProcessed = true;
        }
    }

    public static String doubleQuote(String text) {
        return DOUBLEQUOTE + text + DOUBLEQUOTE;
    }

    public static String singleQuote(String text) {
        StringBuffer buffer = new StringBuffer();
        HtmlAssembler.singleQuote(text, false, buffer);
        return buffer.toString();
    }

    public static void singleQuote(String argument, boolean comma, StringBuffer buffer) {
        buffer.append(SINGLEQUOTE);
        if (argument != null) {
            argument = argument.replace('\n', ' ');
            argument = argument.replace('\r', ' ');
            int quoteIndex = 0;
            int pos = 0;
            while (quoteIndex < argument.length() && (quoteIndex = argument.indexOf(SINGLEQUOTE, pos)) != -1) {
                buffer.append(argument.substring(pos, quoteIndex));
                buffer.append(JS_ESCAPE).append(SINGLEQUOTE);
                pos = quoteIndex + 1;
            }
            if (pos < argument.length()) {
                buffer.append(argument.substring(pos));
            }
        }
        buffer.append(SINGLEQUOTE);
        if (comma) {
            buffer.append(',');
        }
    }

    public void replaceHTML(String id, String url, String httpMethod, String query) {
        this.newLine();
        this.appendContent(FUNC_REPLACEHTML).appendContent(HtmlAssembler.doubleQuote(id)).appendContent(',').appendContent(HtmlAssembler.doubleQuote(url)).appendContent(',').appendContent(HtmlAssembler.doubleQuote(httpMethod)).appendContent(',').appendContent(HtmlAssembler.doubleQuote(query)).appendContent(ENDCALL);
    }

    public void addToObjectCache(String key, String value) {
        this.appendContent("ColdFusion.objectCache[").appendContent(HtmlAssembler.doubleQuote(key)).appendContent("] = ").appendContent(value).appendContent(';');
    }

    public void getFromObjectCache(String key, String value) {
        this.newLine();
        this.appendContent(VAR).appendContent(value).appendContent(" = ColdFusion.objectCache[").appendContent(HtmlAssembler.doubleQuote(key)).appendContent("]").appendContent(';');
    }

    public boolean isSpryInitGenerated() {
        return this.isSpryInitGenerated;
    }

    public void setSpryInitGenerated() {
        this.isSpryInitGenerated = true;
    }

    public class InvalidAjaxTagUsageException
    extends TagValidationException {
    }

    public class OutputWriterException
    extends ApplicationException {
        public OutputWriterException(Throwable e) {
            super(e);
        }
    }
}

