/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.tagext.html.ajax.JavaScriptCacheObject;
import coldfusion.util.Utils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;

public class JsServlet
extends HttpServlet {
    private Hashtable filepathVsCacheObject = new Hashtable();
    private final String IF_MODIFIED_SINCE = "If-Modified-Since";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        String contextRoot = request.getContextPath();
        String contextPath = this.getServletContext().getRealPath("/");
        int index = uri.indexOf(contextRoot);
        if (contextRoot.length() > 1 && index > 0) {
            uri = uri.substring(uri.indexOf(47, 1));
        }
        String path = contextPath + File.separatorChar + uri;
        File file = new File(path);
        File canonicalFile = Utils.getCanonicalFile(file);
        String canonicalPath = canonicalFile.getCanonicalPath();
        JavaScriptCacheObject cacheObj = (JavaScriptCacheObject)this.filepathVsCacheObject.get(canonicalFile.getCanonicalPath());
        if (cacheObj != null) {
            long modifiedSince = -1L;
            try {
                modifiedSince = request.getDateHeader("If-Modified-Since");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                if (modifiedSince >= 0L && !cacheObj.isModifiedSince(modifiedSince)) {
                    response.setStatus(304);
                } else {
                    this.writeResponse(response, cacheObj.getData());
                }
            }
            catch (FileNotFoundException e) {
                response.sendError(404);
                this.filepathVsCacheObject.remove(canonicalPath);
            }
            return;
        }
        try {
            cacheObj = new JavaScriptCacheObject(canonicalFile);
            this.writeResponse(response, cacheObj.getData());
            this.filepathVsCacheObject.put(canonicalPath, cacheObj);
        }
        catch (FileNotFoundException e) {
            response.sendError(404);
        }
    }

    private void writeResponse(HttpServletResponse response, byte[] data) {
        try {
            response.setHeader("Content-Encoding", "gzip");
            response.setContentType("application/javascript");
            response.getOutputStream().write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

