/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.NeoException;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxContainer;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.LayoutTag;
import coldfusion.tagext.validation.RequiredAttributesException;
import coldfusion.util.CaseInsensitiveMap;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutAreaTag
extends ChildTag
implements BodyTag,
AjaxContainer {
    private String name;
    private String title;
    private boolean selected;
    private String source;
    private String position;
    private boolean splitter = false;
    private String size = null;
    private int sizeNum = -1;
    private int maxsize = -1;
    private int minsize = -1;
    private boolean show = true;
    private boolean inithide = false;
    private boolean closable = false;
    private boolean collapsible = false;
    private boolean disabled = false;
    private boolean initCollapsed = false;
    private String style;
    private String overflow = null;
    private String DEFAULT_OVERFLOW = "auto";
    private String onBindError;
    private boolean refreshOnActivate = false;
    private String titleIcon = null;
    private String tabTip = null;
    private boolean bindOnLoad = true;
    private String divId = null;
    private int typeCode = -1;
    private String type;
    private String padding;
    private String align;
    private String[] validOverFlowValues = new String[]{"auto", "hidden"};
    private String content;
    private String childId = null;
    private boolean childLayout = false;
    private boolean selectedPresent = false;
    private boolean disabledPresent = false;
    private boolean closablePresent = false;
    private boolean initCollapsedPresent = false;
    private boolean inithidePresent = false;
    private boolean refreshOnActivatePresent = false;
    private LayoutTag layoutTag;
    private static final String TABCONTENTCLASS = "x-hide-display";
    private static final String LAYOUT_INACTIVE_CONTENT = "x-layout-inactive-content";
    public static final String LAYOUTAREANAME_PREFIX = "cf_layoutarea";
    public static final String HIDDEN_CLASS = "x-hidden";
    public static final String[] positions = new String[]{"top", "bottom", "center", "left", "right"};
    public static final String[] directions = new String[]{"north", "south", "center", "west", "east"};
    public static final int TOP_DIRECTION_CODE = 0;
    public static final int BOTTOM_DIRECTION_CODE = 1;
    public static final int CENTER_DIRECTION_CODE = 2;
    public static final int LEFT_DIRECTION_CODE = 3;
    public static final int RIGHT_DIRECTION_CODE = 4;
    private static final int DEFAULT_TOP_BOTTOM_SIZE = 100;
    private static final int DEFAULT_LEFT_RIGHT_SIZE = 200;
    private static List tabAllowedAttributes = new ArrayList();
    private static List tabNotAllowedAttributes = new ArrayList();
    private static List boxAllowedAttributes;
    private static List boxNotAllowedAttributes;
    private static List accordianAllowedAttributes;
    private static List accordianNotAllowedAttributes;
    private boolean collapsiblePresent = false;
    private boolean showPresent = false;
    private boolean splitterPresent = false;
    private static List borderAllowedAttributes;
    private static List borderNotAllowedAttributes;
    private static List centerLayoutareaAllowedAttributes;
    private static List centerLayoutareaNotAllowedAttributes;
    HtmlAssembler htmlAssembler;

    public LayoutAreaTag() {
        super(LayoutTag.class);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setTitleIcon(String titleIcon) {
        this.titleIcon = titleIcon;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.selectedPresent = true;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setOnBindError(String onBindError) {
        this.onBindError = onBindError;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setMaxsize(int maxsize) {
        this.maxsize = maxsize;
    }

    public void setMinsize(int minsize) {
        this.minsize = minsize;
    }

    public void setSplitter(boolean splitter) {
        this.splitter = splitter;
        this.splitterPresent = true;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
        this.closablePresent = true;
    }

    public void setInithide(boolean inithide) {
        this.inithide = inithide;
        this.inithidePresent = true;
    }

    public void setShow(boolean show) {
        this.show = show;
        this.showPresent = true;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
        this.collapsiblePresent = true;
    }

    public void setRefreshOnActivate(boolean refreshOnActivate) {
        this.refreshOnActivate = refreshOnActivate;
        this.refreshOnActivatePresent = true;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setInitCollapsed(boolean initCollapsed) {
        this.initCollapsed = initCollapsed;
        this.initCollapsedPresent = true;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.disabledPresent = true;
    }

    public void setOverflow(String overflow) {
        this.overflow = overflow;
    }

    public void setTabTip(String tabTip) {
        this.tabTip = tabTip;
        if (tabTip.trim().length() == 0) {
            this.tabTip = null;
        }
    }

    public void setBindOnLoad(boolean bindOnLoad) {
        this.bindOnLoad = bindOnLoad;
    }

    public int getTypeCode() {
        Tag t;
        if (this.typeCode != -1) {
            return this.typeCode;
        }
        boolean valid = false;
        for (t = this.getParent(); t != null; t = t.getParent()) {
            if (!(t instanceof LayoutTag)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new LayoutInvalidParentTagException("CFLAYOUTAREA");
        }
        this.layoutTag = (LayoutTag)t;
        this.typeCode = this.layoutTag.getTypeCode();
        this.type = this.layoutTag.getType();
        this.padding = this.layoutTag.getPadding();
        if (this.align == null) {
            this.align = this.layoutTag.getAlign();
        }
        return this.typeCode;
    }

    private void validateParentTags() {
        for (Tag t = this.getParent(); t != null && !(t instanceof LayoutTag); t = t.getParent()) {
            if (!(t instanceof LayoutAreaTag)) continue;
            throw new InvalidLayoutAreaNestingException();
        }
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateParentTags();
        this.typeCode = this.getTypeCode();
        if (this.name == null) {
            this.name = LAYOUTAREANAME_PREFIX + this.htmlAssembler.getId();
        }
        this.divId = this.typeCode == 4 || this.typeCode == 3 ? this.name : LAYOUTAREANAME_PREFIX + this.name;
        this.htmlAssembler.setContainerId(this.divId);
        if (this.overflow == null || this.overflow.trim().length() == 0) {
            this.overflow = this.typeCode == 5 && !this.layoutTag.isFillHeight() ? "hidden" : this.DEFAULT_OVERFLOW;
        }
        this.validateAttributes();
        String classname = null;
        switch (this.typeCode) {
            case 4: {
                this.divId = this.name;
                StringBuffer hboxStyle = new StringBuffer();
                hboxStyle.append("overflow:").append(this.overflow).append(';');
                hboxStyle.append("float:left;");
                if (this.size != null) {
                    hboxStyle.append("width:").append(this.size).append(";");
                }
                if (this.padding != null) {
                    hboxStyle.append("padding-right:").append(this.padding).append(";");
                }
                this.style = this.style == null ? hboxStyle.toString() : hboxStyle.toString() + this.style + ";";
                break;
            }
            case 3: {
                this.divId = this.name;
                StringBuffer vboxStyle = new StringBuffer();
                vboxStyle.append("overflow:").append(this.overflow).append(';');
                if (this.size != null) {
                    vboxStyle.append("height:").append(this.size).append(";");
                }
                if (this.padding != null) {
                    vboxStyle.append("padding-bottom:").append(this.padding).append(";");
                }
                this.style = this.style == null ? vboxStyle.toString() : vboxStyle.toString() + this.style + ";";
                this.style = this.style.trim();
                if (this.style.charAt(this.style.length() - 1) == ';') break;
                this.style = this.style + ";";
                break;
            }
            case 1: {
                classname = HIDDEN_CLASS;
                StringBuffer tabStyle = new StringBuffer();
                tabStyle.append("overflow:").append(this.overflow).append(';');
                this.style = this.style == null ? tabStyle.toString() : tabStyle.toString() + this.style;
                this.style = this.style.trim();
                this.addDefaultWidth();
                if (this.style.charAt(this.style.length() - 1) == ';') break;
                this.style = this.style + ";";
                break;
            }
            case 5: {
                classname = HIDDEN_CLASS;
                StringBuffer tabStyle = new StringBuffer();
                tabStyle.append("overflow:").append(this.overflow).append(';');
                this.style = this.style == null ? tabStyle.toString() : tabStyle.toString() + this.style;
                this.style = this.style.trim();
                if (this.style.charAt(this.style.length() - 1) == ';') break;
                this.style = this.style + ";";
                break;
            }
            case 2: {
                classname = HIDDEN_CLASS;
                this.addDefaultWidth();
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.align != null) {
            map.put("align", this.align);
        }
        this.mergeStyles();
        if (!this.childLayout) {
            if (this.divId.indexOf("cf_layoutareacf_layoutarea") != -1 && this.style != null) {
                this.style = this.style + "overflow:hidden;";
            }
            this.htmlAssembler.openDivTag(this.divId, classname, this.style, map);
        } else {
            this.htmlAssembler.closeDivTag();
        }
        this.htmlAssembler.newLine();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        if (this.source != null) {
            return 0;
        }
        return 2;
    }

    private void addDefaultWidth() {
        if (null == this.style) {
            this.style = "";
        }
        if (this.style != null && !this.style.toLowerCase().contains("width")) {
            this.style = this.style + ";width:100%";
        }
    }

    private void mergeStyles() {
        Tag t = this.getParent();
        if (t instanceof LayoutTag) {
            String pstyle = ((LayoutTag)t).getStyle();
            CaseInsensitiveMap styleMap = new CaseInsensitiveMap();
            if (null != pstyle && pstyle.length() != 0) {
                this.cssstyleToMap(pstyle, styleMap);
                styleMap.remove("height");
                styleMap.remove("width");
            }
            if (this.style != null) {
                this.cssstyleToMap(this.style, styleMap);
            }
            if ("tab".equals(((LayoutTag)t).getType())) {
                String pheight = ((LayoutTag)t).getHeight();
                String pwidth = ((LayoutTag)t).getWidth();
                if (!styleMap.containsKey("height") && pheight != null) {
                    styleMap.put("height", pheight);
                }
                if (!styleMap.containsKey("width") && pwidth != null) {
                    styleMap.put("width", pwidth);
                }
            }
            this.style = this.mapToCssstyle(styleMap);
        }
    }

    private String mapToCssstyle(Map<String, String> styleMap) {
        Object styletemp = "";
        for (Map.Entry<String, String> e : styleMap.entrySet()) {
            styletemp = (String)styletemp + e.getKey() + ":" + e.getValue() + ";";
        }
        return styletemp;
    }

    private void cssstyleToMap(String style, Map<String, String> styleMap) {
        for (String split : style.split(";")) {
            String[] isplit = split.split(":");
            if (isplit.length != 2) continue;
            styleMap.put(isplit[0].trim(), isplit[1]);
        }
    }

    public void validateAttributes() {
        if (this.source != null && this.source.trim().equals("")) {
            throw new AjaxUtils.AjaxTagInvalidAttributeException("SOURCE", "CFLAYOUTAREA");
        }
        switch (this.getTypeCode()) {
            case 3: 
            case 4: {
                if (this.maxsize >= 0 || this.minsize >= 0) {
                    throw new InvalidAttributeLayoutAreaException(this.type, boxNotAllowedAttributes, boxAllowedAttributes);
                }
                if (this.position != null) {
                    throw new InvalidAttributeLayoutAreaException(this.type, boxNotAllowedAttributes, boxAllowedAttributes);
                }
                if (this.collapsiblePresent || this.showPresent || this.splitterPresent || this.refreshOnActivatePresent) {
                    throw new InvalidAttributeLayoutAreaException(this.type, boxNotAllowedAttributes, boxAllowedAttributes);
                }
                if (this.tabTip != null) {
                    throw new InvalidAttributeLayoutAreaException(this.type, boxNotAllowedAttributes, boxAllowedAttributes);
                }
                AjaxUtils.validateOverFlowValues(this.overflow, "cflayoutarea");
                break;
            }
            case 1: {
                if (this.size != null || this.maxsize >= 0 || this.minsize >= 0) {
                    throw new InvalidAttributeLayoutAreaException("TAB", tabNotAllowedAttributes, tabAllowedAttributes);
                }
                if (this.position != null) {
                    throw new InvalidAttributeLayoutAreaException("TAB", tabNotAllowedAttributes, tabAllowedAttributes);
                }
                if (this.collapsiblePresent || this.showPresent || this.splitterPresent) {
                    throw new InvalidAttributeLayoutAreaException("TAB", tabNotAllowedAttributes, tabAllowedAttributes);
                }
                if (this.title == null) {
                    throw new LayoutAreaRequiredAttributesException("title");
                }
                if (this.refreshOnActivate && this.source == null) {
                    throw new InvalidRefreshOnActivateException();
                }
                if (!this.bindOnLoad && this.selected) {
                    throw new InvalidBindOnLoadException();
                }
                AjaxUtils.validateOverFlowValues(this.overflow, "cflayoutarea");
                break;
            }
            case 2: {
                if (this.position == null) {
                    throw new RequiredAttributesException("CFLAYOUTAREA", "POSITION");
                }
                if (this.selectedPresent) {
                    throw new InvalidAttributeLayoutAreaException("BORDER", borderNotAllowedAttributes, borderAllowedAttributes);
                }
                if (this.disabledPresent || this.refreshOnActivatePresent) {
                    throw new InvalidAttributeLayoutAreaException("BORDER", borderNotAllowedAttributes, borderAllowedAttributes);
                }
                if (this.position.trim().equals("") || !this.position.equalsIgnoreCase(positions[2]) && !this.position.equalsIgnoreCase(positions[0]) && !this.position.equalsIgnoreCase(positions[1]) && !this.position.equalsIgnoreCase(positions[3]) && !this.position.equalsIgnoreCase(positions[4])) {
                    throw new InvalidPositionAttributeValueException();
                }
                if (this.position.equalsIgnoreCase(positions[2])) {
                    if (this.title != null) {
                        throw new CenterLayoutAreaAllowedAttributesException("TITLE", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.closablePresent) {
                        throw new CenterLayoutAreaAllowedAttributesException("CLOSABLE", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.collapsiblePresent) {
                        throw new CenterLayoutAreaAllowedAttributesException("COLLAPSIBLE", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.size != null) {
                        throw new CenterLayoutAreaAllowedAttributesException("SIZE", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.maxsize != -1) {
                        throw new CenterLayoutAreaAllowedAttributesException("MAXSIZE", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.minsize != -1) {
                        throw new CenterLayoutAreaAllowedAttributesException("MINSIZE", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.splitterPresent) {
                        throw new CenterLayoutAreaAllowedAttributesException("SPLITTER", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.inithidePresent) {
                        throw new CenterLayoutAreaAllowedAttributesException("INITHIDE", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                    if (this.initCollapsedPresent) {
                        throw new CenterLayoutAreaAllowedAttributesException("INITCOLLAPSED", centerLayoutareaNotAllowedAttributes, centerLayoutareaAllowedAttributes);
                    }
                }
                if (this.tabTip != null) {
                    throw new InvalidAttributeLayoutAreaException("BORDER", borderNotAllowedAttributes, borderAllowedAttributes);
                }
                this.validateBorderOverFlowValues();
                break;
            }
            case 5: {
                if (this.refreshOnActivate && this.source == null) {
                    throw new InvalidRefreshOnActivateException();
                }
                if (this.tabTip != null) {
                    throw new InvalidAttributeLayoutAreaException("ACCORDION", accordianNotAllowedAttributes, accordianAllowedAttributes);
                }
                if (this.bindOnLoad || !this.selected) break;
                throw new InvalidBindOnLoadException();
            }
        }
        if (this.size != null) {
            this.size = this.size.trim();
            if (this.getTypeCode() == 2) {
                try {
                    this.sizeNum = Integer.parseInt(this.size);
                }
                catch (NumberFormatException nEx) {
                    throw new InvalidBorderSizeAttributeException();
                }
                if (this.sizeNum <= 0) {
                    throw new InvalidBorderSizeAttributeException();
                }
            } else {
                this.size = AjaxUtils.checkValidCSSUnits(this.size);
                if (this.size == null) {
                    throw new InvalidBoxSizeAttributeException();
                }
            }
        } else if (this.getTypeCode() == 2 && !this.position.equalsIgnoreCase(positions[2])) {
            this.sizeNum = 200;
        }
        if (this.align != null) {
            this.align = this.align.toLowerCase();
            if (!(this.align.equals("left") || this.align.equals("right") || this.align.equals("center") || this.align.equals("justify"))) {
                throw new InvalidBoxAlignAttributeException();
            }
        }
    }

    public static int getDirectionCode(String direction) {
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i].equalsIgnoreCase(direction)) continue;
            return i;
        }
        return -1;
    }

    private void validateBorderOverFlowValues() {
        boolean valid = false;
        if (this.overflow != null) {
            for (int i = 0; i < this.validOverFlowValues.length; ++i) {
                if (!this.overflow.equalsIgnoreCase(this.validOverFlowValues[i])) continue;
                valid = true;
                break;
            }
        }
        if (!valid) {
            throw new LayoutAreaOverflowInvalidUsageException();
        }
    }

    public void appendMetaData() {
        LayoutMetaData metaData = new LayoutMetaData();
        metaData.name = this.name;
        metaData.selected = this.selected;
        metaData.source = this.source;
        metaData.onBindError = this.onBindError;
        metaData.title = this.title;
        metaData.directionCode = LayoutAreaTag.getDirectionCode(this.position);
        metaData.size = this.size;
        metaData.sizeNum = this.sizeNum;
        metaData.maxsize = this.maxsize;
        metaData.minsize = this.minsize;
        metaData.splitter = this.splitter;
        metaData.collapsible = this.collapsible;
        metaData.closable = this.closable;
        metaData.show = this.show;
        metaData.hide = this.inithide;
        metaData.overflow = this.overflow;
        metaData.refreshOnActivate = this.refreshOnActivate;
        metaData.style = this.style;
        metaData.titleIcon = this.titleIcon;
        metaData.divId = this.divId;
        metaData.tabTip = this.tabTip;
        metaData.bindOnLoad = this.bindOnLoad;
        metaData.disabled = metaData.selected ? false : this.disabled;
        metaData.childId = this.childId;
        metaData.childLayout = this.childLayout;
        metaData.initcollapsed = metaData.directionCode == 2 || !metaData.collapsible ? false : this.initCollapsed;
        metaData.disabled = this.disabled;
        this.layoutTag.appendMetaData(metaData);
    }

    @Override
    public int doAfterBody() throws JspException {
        if (this.source == null) {
            this.content = this.bodyContent.getString();
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.appendMetaData();
        if (this.source == null && this.content != null) {
            this.htmlAssembler.appendContent(this.content);
        }
        if (!this.childLayout) {
            this.htmlAssembler.closeDivTag();
        }
        if (this.source != null && (this.typeCode == 4 || this.typeCode == 3)) {
            this.htmlAssembler.openScriptTag();
            String functionName = this.htmlAssembler.openFunction("layout", "init", true, true, null);
            BindProcessor bp = new BindProcessor();
            bp.setErrorHandler(this.onBindError);
            bp.processBind(this.divId, null, null, this.source, true, this.htmlAssembler, 3, this.pageContext);
            this.htmlAssembler.closeFunction();
            this.htmlAssembler.setEventOnLoad(functionName);
            this.htmlAssembler.closeScriptTag();
        }
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.htmlAssembler.resetContainerId();
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.name = null;
        this.title = null;
        this.selected = false;
        this.source = null;
        this.position = null;
        this.splitter = false;
        this.size = null;
        this.sizeNum = -1;
        this.maxsize = -1;
        this.minsize = -1;
        this.show = true;
        this.inithide = false;
        this.closable = false;
        this.collapsible = false;
        this.disabled = false;
        this.initCollapsed = false;
        this.style = null;
        this.overflow = null;
        this.onBindError = null;
        this.refreshOnActivate = false;
        this.typeCode = -1;
        this.type = null;
        this.padding = null;
        this.align = null;
        this.content = null;
        this.childId = null;
        this.childLayout = false;
        this.selectedPresent = false;
        this.disabledPresent = false;
        this.closablePresent = false;
        this.initCollapsedPresent = false;
        this.inithidePresent = false;
        this.layoutTag = null;
        this.titleIcon = null;
        this.tabTip = null;
        this.bindOnLoad = true;
        super.release();
    }

    @Override
    protected void setAncestor(Tag ancestor) {
    }

    public void setChildId(String childId) {
        this.childId = childId;
    }

    public void setChildLayout(boolean childLayout) {
        this.childLayout = childLayout;
    }

    @Override
    public String getBodyId() {
        return this.divId;
    }

    static {
        tabAllowedAttributes.add("ALIGN");
        tabAllowedAttributes.add("CLOSABLE");
        tabAllowedAttributes.add("DISABLED");
        tabAllowedAttributes.add("INITHIDE");
        tabAllowedAttributes.add("NAME");
        tabAllowedAttributes.add("OVERFLOW");
        tabAllowedAttributes.add("SELECTED");
        tabAllowedAttributes.add("SOURCE");
        tabAllowedAttributes.add("STYLE");
        tabAllowedAttributes.add("TITLE");
        tabAllowedAttributes.add("ONBINDERROR");
        tabAllowedAttributes.add("REFRESHONACTIVATE");
        tabAllowedAttributes.add("TABTIP");
        tabAllowedAttributes.add("BINDONLOAD");
        tabNotAllowedAttributes.add("COLLAPSIBLE");
        tabNotAllowedAttributes.add("POSITION");
        tabNotAllowedAttributes.add("INITCOLLAPSED");
        tabNotAllowedAttributes.add("SIZE");
        tabNotAllowedAttributes.add("MAXSIZE");
        tabNotAllowedAttributes.add("MINSIZE");
        tabNotAllowedAttributes.add("SHOW");
        tabNotAllowedAttributes.add("SPLITTER");
        tabNotAllowedAttributes.add("TITLEICON");
        boxAllowedAttributes = new ArrayList();
        boxNotAllowedAttributes = new ArrayList();
        boxAllowedAttributes.add("ALIGN");
        boxAllowedAttributes.add("NAME");
        boxAllowedAttributes.add("OVERFLOW");
        boxAllowedAttributes.add("SIZE");
        boxAllowedAttributes.add("SOURCE");
        boxAllowedAttributes.add("STYLE");
        boxAllowedAttributes.add("ONBINDERROR");
        boxNotAllowedAttributes.add("CLOSABLE");
        boxNotAllowedAttributes.add("COLLAPSIBLE");
        boxNotAllowedAttributes.add("POSITION");
        boxNotAllowedAttributes.add("DISABLED");
        boxNotAllowedAttributes.add("INITCOLLAPSED");
        boxNotAllowedAttributes.add("INITHIDE");
        boxNotAllowedAttributes.add("MAXSIZE");
        boxNotAllowedAttributes.add("MINSIZE");
        boxNotAllowedAttributes.add("REFRESHONACTIVATE");
        boxNotAllowedAttributes.add("SELECTED");
        boxNotAllowedAttributes.add("SPLITTER");
        boxNotAllowedAttributes.add("TITLE");
        boxNotAllowedAttributes.add("TITLEICON");
        boxNotAllowedAttributes.add("TABTIP");
        boxNotAllowedAttributes.add("BINDONLOAD");
        accordianAllowedAttributes = new ArrayList();
        accordianNotAllowedAttributes = new ArrayList();
        accordianNotAllowedAttributes.add("DISABLED");
        accordianNotAllowedAttributes.add("ALIGN");
        accordianNotAllowedAttributes.add("TABTIP");
        accordianAllowedAttributes.add("COLLAPSIBLE");
        accordianAllowedAttributes.add("CLOSABLE");
        accordianAllowedAttributes.add("INITCOLLAPSED");
        accordianAllowedAttributes.add("SIZE");
        accordianAllowedAttributes.add("SELECTED");
        accordianAllowedAttributes.add("MAXSIZE");
        accordianAllowedAttributes.add("MINSIZE");
        accordianAllowedAttributes.add("NAME");
        accordianAllowedAttributes.add("OVERFLOW");
        accordianAllowedAttributes.add("SOURCE");
        accordianAllowedAttributes.add("STYLE");
        accordianAllowedAttributes.add("TITLE");
        accordianAllowedAttributes.add("ONBINDERROR");
        accordianAllowedAttributes.add("TITLEICON");
        accordianAllowedAttributes.add("REFRESHONACTIVATE");
        accordianAllowedAttributes.add("BINDONLOAD");
        borderAllowedAttributes = new ArrayList();
        borderNotAllowedAttributes = new ArrayList();
        borderNotAllowedAttributes.add("SELECTED");
        borderNotAllowedAttributes.add("DISABLED");
        borderNotAllowedAttributes.add("REFRESHONACTIVATE");
        borderNotAllowedAttributes.add("TITLEICON");
        borderNotAllowedAttributes.add("TABTIP");
        borderNotAllowedAttributes.add("BINDONLOAD");
        borderAllowedAttributes.add("ALIGN");
        borderAllowedAttributes.add("COLLAPSIBLE");
        borderAllowedAttributes.add("CLOSABLE");
        borderAllowedAttributes.add("POSITION");
        borderAllowedAttributes.add("HIDE");
        borderAllowedAttributes.add("INITCOLLAPSED");
        borderAllowedAttributes.add("SIZE");
        borderAllowedAttributes.add("MAXSIZE");
        borderAllowedAttributes.add("MINSIZE");
        borderAllowedAttributes.add("NAME");
        borderAllowedAttributes.add("OVERFLOW");
        borderAllowedAttributes.add("SOURCE");
        borderAllowedAttributes.add("STYLE");
        borderAllowedAttributes.add("TITLE");
        borderAllowedAttributes.add("SHOW");
        borderAllowedAttributes.add("SPLITTER");
        borderAllowedAttributes.add("ONBINDERROR");
        centerLayoutareaAllowedAttributes = new ArrayList();
        centerLayoutareaNotAllowedAttributes = new ArrayList();
        centerLayoutareaNotAllowedAttributes.add("CLOSABLE");
        centerLayoutareaNotAllowedAttributes.add("COLLAPSIBLE");
        centerLayoutareaNotAllowedAttributes.add("INITCOLLAPSED");
        centerLayoutareaNotAllowedAttributes.add("INITHIDE");
        centerLayoutareaNotAllowedAttributes.add("SIZE");
        centerLayoutareaNotAllowedAttributes.add("MAXSIZE");
        centerLayoutareaNotAllowedAttributes.add("MINSIZE");
        centerLayoutareaNotAllowedAttributes.add("SPLITTER");
        centerLayoutareaNotAllowedAttributes.add("TITLE");
        centerLayoutareaNotAllowedAttributes.add("REFRESHONACTIVATE");
        centerLayoutareaNotAllowedAttributes.add("TITLEICON");
        centerLayoutareaAllowedAttributes.add("ALIGN");
        centerLayoutareaAllowedAttributes.add("NAME");
        centerLayoutareaAllowedAttributes.add("SOURCE");
        centerLayoutareaAllowedAttributes.add("STYLE");
        centerLayoutareaAllowedAttributes.add("ONBINDERROR");
        centerLayoutareaAllowedAttributes.add("OVERFLOW");
    }

    public class LayoutInvalidParentTagException
    extends TagValidationException {
        public String childtag;

        public LayoutInvalidParentTagException(String childtag) {
            this.childtag = childtag;
        }
    }

    public class InvalidLayoutAreaNestingException
    extends NeoException {
    }

    public class InvalidAttributeLayoutAreaException
    extends TagValidationException {
        public String type;
        public String allowed;
        public String notAllowed;

        public InvalidAttributeLayoutAreaException(String type, Collection notAllowed, Collection allowed) {
            this.type = type;
            this.notAllowed = ArrayUtil.ArrayToList(new ArrayList(notAllowed), ",").toUpperCase();
            this.allowed = ArrayUtil.ArrayToList(new ArrayList(allowed), ",").toUpperCase();
        }
    }

    public class LayoutAreaRequiredAttributesException
    extends TagValidationException {
        public String attribute;

        public LayoutAreaRequiredAttributesException(String attribute) {
            this.attribute = attribute.toUpperCase();
        }
    }

    public class InvalidRefreshOnActivateException
    extends TagValidationException {
        InvalidRefreshOnActivateException() {
        }
    }

    public class InvalidBindOnLoadException
    extends TagValidationException {
        InvalidBindOnLoadException() {
        }
    }

    public class InvalidPositionAttributeValueException
    extends TagValidationException {
        InvalidPositionAttributeValueException() {
        }
    }

    public class CenterLayoutAreaAllowedAttributesException
    extends TagValidationException {
        public String allowed;
        public String attribute;
        public String notAllowed;

        public CenterLayoutAreaAllowedAttributesException(String attribute, Collection notAllowed, Collection allowed) {
            this.attribute = attribute.toUpperCase();
            this.notAllowed = ArrayUtil.ArrayToList(new ArrayList(notAllowed), ",").toUpperCase();
            this.allowed = ArrayUtil.ArrayToList(new ArrayList(allowed), ",").toUpperCase();
        }
    }

    public class InvalidBorderSizeAttributeException
    extends TagValidationException {
    }

    public class InvalidBoxSizeAttributeException
    extends TagValidationException {
    }

    public class InvalidBoxAlignAttributeException
    extends TagValidationException {
    }

    public class LayoutAreaOverflowInvalidUsageException
    extends TagValidationException {
        LayoutAreaOverflowInvalidUsageException() {
        }
    }

    public class LayoutMetaData {
        private String source;
        private boolean selected = false;
        private String name;
        private String title;
        private int directionCode;
        private boolean splitter;
        private String size;
        private int sizeNum;
        private int minsize;
        private int maxsize;
        private boolean collapsible;
        private boolean closable;
        private boolean show;
        private boolean hide;
        private boolean disabled;
        private boolean childLayout;
        private String childId;
        private boolean initcollapsed;
        private String onBindError;
        private String overflow;
        private boolean refreshOnActivate;
        private String style;
        private String titleIcon;
        private String divId;
        private String tabTip;
        private boolean bindOnLoad;

        public String getSource() {
            return this.source;
        }

        public String getName() {
            return this.name;
        }

        public String getDivId() {
            return this.divId;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public String getTitle() {
            return this.title;
        }

        public int getDirectionCode() {
            return this.directionCode;
        }

        public String getSize() {
            return this.size;
        }

        public int getSizeNum() {
            return this.sizeNum;
        }

        public int getMaxsize() {
            return this.maxsize;
        }

        public int getMinsize() {
            return this.minsize;
        }

        public String getOverflow() {
            return this.overflow;
        }

        public boolean isSplitter() {
            return this.splitter;
        }

        public boolean isCollapsible() {
            return this.collapsible;
        }

        public boolean isClosable() {
            return this.closable;
        }

        public boolean isHide() {
            return this.hide;
        }

        public boolean isShow() {
            return this.show;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isChildLayout() {
            return this.childLayout;
        }

        public String getChildId() {
            return this.childId;
        }

        public boolean isInitcollapsed() {
            return this.initcollapsed;
        }

        public String getOnBindError() {
            return this.onBindError;
        }

        public boolean isRefreshOnActivate() {
            return this.refreshOnActivate;
        }

        public String getStyle() {
            return this.style;
        }

        public String getTitleIcon() {
            return this.titleIcon;
        }

        public String getTabTip() {
            return this.tabTip;
        }

        public boolean isBindOnLoad() {
            return this.bindOnLoad;
        }
    }

    public class AttributeNotAllowedWithCenterException
    extends TagValidationException {
        public String attribute;

        public AttributeNotAllowedWithCenterException(String attribute) {
            this.attribute = attribute;
        }
    }
}

