/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ArrayUtil;
import coldfusion.server.ServiceFactory;
import coldfusion.server.felix.FelixUtil;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.LayoutAreaTag;
import coldfusion.tagext.html.ajax.MapItemData;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapTag
extends GenericTag
implements AjaxImport {
    public static final String IMPORT_TAGNAME = "CFMAP";
    private static final String GMAP_JS = "/ext/map/GMapPanel3.js";
    private static final String MAP = "map";
    private static final String CFMAP = "cf_map";
    private static final String GOOGLE_MAP_KEY = "GOOGLEMAPKEY";
    private static final String MAPINIT = "ColdFusion.Map.init(";
    private static final String _MAPINIT = "ColdFusion.Map._init(";
    private HtmlAssembler htmlAssembler;
    private List mapMarkerList = new ArrayList();
    private static final String LOAD_STATUS_FN = "ColdFusion.Map.loadMarkerWindowInfo";
    private static final String MAP_IN_ACCORDION_MAPPING_FN = "ColdFusion.Layout.addMapInAccordionMapping";
    private static final String BIND_ERROR_HANDLER = "ColdFusion.Map.bindOnErrorHandler";
    private static final String STATUS_FN = "getMarkerDesc";
    private static final String DATA_FN_PARAM_NAME = "cfmapname";
    private static final String DATA_FN_PARAM_LATITUDE = "cfmaplatitude";
    private static final String DATA_FN_PARAM_LONGITUDE = "cfmaplongitude";
    private static final String DATA_FN_PARAM_ADDRESS = "cfmapaddress";
    private static final String[] DATA_FN_PARAMS = new String[]{"cfmapname", "cfmaplatitude", "cfmaplongitude", "cfmapaddress"};
    private String type = "map";
    private String height = null;
    private String name = null;
    private String zoomLevel = null;
    private String title = null;
    private boolean collapsible = false;
    private String width = null;
    private boolean hideBorder = true;
    private boolean scrollWheelZoom = true;
    private boolean doubleClickZoom = true;
    private boolean clickZoom = true;
    private String centerAddress = null;
    private String centerLatitude = null;
    private String centerLongitude = null;
    private String onLoad = null;
    private boolean showScale = false;
    private boolean continuousZoom = true;
    private boolean overview = false;
    private String typeControl = "basic";
    private String zoomControl = "small";
    private String key = null;
    private String tip = null;
    private String onError = null;
    private boolean showAllMarkers = true;
    private boolean showCenterMarker = true;
    private String markerColor = null;
    private String markerIcon = null;
    private String markerBind = null;
    private String markerWindowContent = null;
    private boolean showMarkerWindow = false;
    private boolean showmarkerWindowHasSet = false;
    private String generatedBindFunctionName = null;
    private boolean initShow = true;
    private boolean showUser = false;
    private int index = 0;
    private boolean childShowUserSet = false;
    private static final ArrayList MAP_TYPES = new ArrayList(5);
    private static final ArrayList ZOOM_CONTROL_TYPES;
    private static final ArrayList MAP_CONTROL_TYPES;
    private static String GMAP_API_JS;
    private static String GOOGLEMAP_UTILY_JS;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type.trim();
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        name = name.replaceAll(" ", "");
        this.name = name = name.replaceAll("'", "");
    }

    public String getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(String zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean getHideBorder() {
        return this.hideBorder;
    }

    public void setHideBorder(boolean hideBorder) {
        this.hideBorder = hideBorder;
    }

    public boolean getScrollWheelZoom() {
        return this.scrollWheelZoom;
    }

    public void setScrollWheelZoom(boolean scrollWheelZoom) {
        this.scrollWheelZoom = scrollWheelZoom;
    }

    public boolean getDoubleClickZoom() {
        return this.doubleClickZoom;
    }

    public void setDoubleClickZoom(boolean doubleClickZoom) {
        this.doubleClickZoom = doubleClickZoom;
    }

    public String getCenterAddress() {
        return this.centerAddress;
    }

    public void setCenterAddress(String centerAddress) {
        this.centerAddress = centerAddress;
    }

    public String isZoomControl() {
        return this.zoomControl;
    }

    public void setZoomControl(String zoomControl) {
        this.zoomControl = zoomControl.trim();
    }

    public String getTypeControl() {
        return this.typeControl;
    }

    public void setTypeControl(String typeControl) {
        this.typeControl = typeControl;
    }

    public boolean isOverview() {
        return this.overview;
    }

    public void setOverview(boolean overview) {
        this.overview = overview;
    }

    public boolean isContinuousZoom() {
        return this.continuousZoom;
    }

    public void setContinuousZoom(boolean continuousZoom) {
        this.continuousZoom = continuousZoom;
    }

    public boolean isShowScale() {
        return this.showScale;
    }

    public void setShowScale(boolean showScale) {
        this.showScale = showScale;
    }

    public String getOnLoad() {
        return this.onLoad;
    }

    public void setOnLoad(String onLoad) {
        this.onLoad = onLoad;
    }

    public String getCenterLongitude() {
        return this.centerLongitude;
    }

    public void setCenterLongitude(String centerLongitude) {
        this.centerLongitude = centerLongitude;
    }

    public String getCenterLatitude() {
        return this.centerLatitude;
    }

    public void setCenterLatitude(String centerLatitude) {
        this.centerLatitude = centerLatitude;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        this.onError = onError;
    }

    public boolean getShowAllMarkers() {
        return this.showAllMarkers;
    }

    public void setShowAllMarkers(boolean showAllMarkers) {
        this.showAllMarkers = showAllMarkers;
    }

    public boolean getShowCenterMarker() {
        return this.showCenterMarker;
    }

    public void setShowCenterMarker(boolean showCenterMarker) {
        this.showCenterMarker = showCenterMarker;
    }

    public String getMarkerIcon() {
        return this.markerIcon;
    }

    public void setMarkerIcon(String markerIcon) {
        this.markerIcon = markerIcon;
    }

    public String getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(String markerColor) {
        this.markerColor = markerColor;
    }

    public String getMarkerBind() {
        return this.markerBind;
    }

    public void setMarkerBind(String markerBind) {
        this.markerBind = markerBind;
    }

    public String getMarkerWindowContent() {
        return this.markerWindowContent;
    }

    public void setMarkerWindowContent(String markerWindowContent) {
        this.markerWindowContent = markerWindowContent;
    }

    public boolean isShowMarkerWindow() {
        return this.showMarkerWindow;
    }

    public void setShowMarkerWindow(boolean showMarkerWindow) {
        this.showmarkerWindowHasSet = true;
        this.showMarkerWindow = showMarkerWindow;
    }

    public boolean isInitShow() {
        return this.initShow;
    }

    public void setInitShow(boolean initShow) {
        this.initShow = initShow;
    }

    public void setShowUser(boolean showUser) {
        this.showUser = showUser;
    }

    public void setChildShowUserSet(boolean showUser) {
        this.childShowUserSet = showUser;
    }

    protected void addMapMarker(MapItemData marker) {
        this.mapMarkerList.add(marker);
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        this.getGoogleMapLicenceKey();
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS(GMAP_API_JS + this.key, "", false, true);
        htmlAssembler.importJS(GOOGLEMAP_UTILY_JS);
        htmlAssembler.importJS(GMAP_JS);
        htmlAssembler.importJS("/package/cfmap.js");
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        FelixUtil.checkAjaxEnabled();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateAttribute();
        if (this.name == null || this.name.trim().length() == 0) {
            this.name = CFMAP + this.htmlAssembler.getId();
        }
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        String styleStr = "";
        this.htmlAssembler.openDivTag(this.name, null, styleStr);
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        this.htmlAssembler.closeDivTag();
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("var ");
        this.generatedBindFunctionName = this.generateBindFunction();
        boolean showParentMapMarkerWinodw = this.showMarkerWindow;
        if (!this.showmarkerWindowHasSet && this.markerWindowContent != null) {
            showParentMapMarkerWinodw = true;
        }
        String functionName = this.htmlAssembler.openFunction(MAP, "init", true, true, null);
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(MAP);
        this.htmlAssembler.appendContent("=");
        if (this.showUser || this.childShowUserSet) {
            this.htmlAssembler.appendContent(_MAPINIT);
        } else {
            this.htmlAssembler.appendContent(MAPINIT);
        }
        this.htmlAssembler.appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(this.height == null ? "null" : this.height).appendContent(',').appendContent(this.width == null ? "null" : this.width).appendContent(',').appendContent(this.type, true).appendContent(',').appendContent(this.zoomLevel == null ? "null" : this.zoomLevel).appendContent(',').appendContent(this.title == null ? "null" : HtmlAssembler.singleQuote(this.title)).appendContent(',').appendContent(this.hideBorder ? "true" : "false").appendContent(',').appendContent(this.initShow ? "true" : "false").appendContent(',').appendContent(this.collapsible ? "true" : "false").appendContent(',').appendContent(this.scrollWheelZoom ? "true" : "false").appendContent(',').appendContent(this.doubleClickZoom ? "true" : "false").appendContent(',').appendContent(this.continuousZoom ? "true" : "false").appendContent(',').appendContent(this.showScale ? "true" : "false").appendContent(',').appendContent(this.showCenterMarker ? "true" : "false").appendContent(',').appendContent(this.showAllMarkers ? "true" : "false").appendContent(',').appendContent(this.overview ? "true" : "false").appendContent(',').appendContent(this.typeControl == null ? "null" : HtmlAssembler.singleQuote(this.typeControl)).appendContent(',').appendContent(this.zoomControl == null ? "null" : HtmlAssembler.singleQuote(this.zoomControl)).appendContent(',').appendContent(this.centerAddress == null ? "null" : HtmlAssembler.singleQuote(this.centerAddress)).appendContent(',').appendContent(this.centerLatitude == null ? "null" : HtmlAssembler.singleQuote(this.centerLatitude)).appendContent(',').appendContent(this.centerLongitude == null ? "null" : HtmlAssembler.singleQuote(this.centerLongitude)).appendContent(',').appendContent(this.tip == null ? "null" : HtmlAssembler.singleQuote(this.tip)).appendContent(',').appendContent(this.markerColor == null ? "null" : HtmlAssembler.singleQuote(this.markerColor)).appendContent(',').appendContent(this.markerIcon == null ? "null" : HtmlAssembler.singleQuote(this.markerIcon)).appendContent(',').appendContent(this.constructMarker()).appendContent(',').appendContent(this.onLoad == null ? "null" : this.onLoad).appendContent(',').appendContent(this.onError == null ? "null" : this.onError).appendContent(',').appendContent(showParentMapMarkerWinodw ? "true" : "false").appendContent(',').appendContent(this.generatedBindFunctionName == null ? "null" : this.generatedBindFunctionName).appendContent(',').appendContent(this.markerWindowContent == null ? "null" : HtmlAssembler.singleQuote(this.markerWindowContent));
        if (this.showUser || this.childShowUserSet) {
            if (this.showUser) {
                this.index = -this.index;
            }
            this.htmlAssembler.appendContent(',').appendContent(String.valueOf(this.index));
        }
        this.htmlAssembler.appendContent(");");
        this.appendMapAccordionMapping();
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.closeScriptTag();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    private void appendMapAccordionMapping() {
        Tag parent = this.getParent();
        String parentid = null;
        if (parent instanceof LayoutAreaTag && ((LayoutAreaTag)parent).getTypeCode() == 5) {
            parentid = ((LayoutAreaTag)parent).getBodyId();
        }
        if (parentid != null) {
            this.htmlAssembler.appendContent(MAP_IN_ACCORDION_MAPPING_FN).appendContent("(").appendContent(HtmlAssembler.singleQuote(parentid)).appendContent(',').appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(");");
        }
    }

    private String constructMarker() {
        Object info = "[";
        Iterator itr = this.mapMarkerList.iterator();
        boolean isFirstMarker = true;
        int indexCtr = 0;
        while (itr.hasNext()) {
            ++indexCtr;
            MapItemData marker = (MapItemData)itr.next();
            Object markerInfo = "{";
            if (marker == null) continue;
            markerInfo = (String)markerInfo + "name: " + HtmlAssembler.singleQuote((String)(marker.getName() == null ? "cf_mapitem" + this.htmlAssembler.getId() : marker.getName())) + ",";
            if (marker.getAddress() != null) {
                markerInfo = (String)markerInfo + "address: " + HtmlAssembler.singleQuote(marker.getAddress()) + ",";
            }
            if (marker.getLatitude() != null && marker.getLongitude() != null) {
                markerInfo = (String)markerInfo + "latitude: " + marker.getLatitude() + ",";
                markerInfo = (String)markerInfo + "longitude: " + marker.getLongitude() + ",";
            }
            if (marker.showUser) {
                this.index = indexCtr;
            }
            if (marker.getMarkerColor() != null) {
                markerInfo = (String)markerInfo + "markercolor:" + HtmlAssembler.singleQuote(marker.getMarkerColor()) + ",";
            } else if (marker.getMarkerIcon() != null) {
                markerInfo = (String)markerInfo + "markericon:" + HtmlAssembler.singleQuote(marker.getMarkerIcon()) + ",";
            }
            Object bindListener = null;
            String markerWindowContent = marker.getMarkerWindowContent();
            if (marker.isShowMarkerWindow()) {
                markerInfo = (String)markerInfo + "showmarkerwindow:true,";
                if (markerWindowContent != null && markerWindowContent.trim().length() > 0) {
                    markerInfo = (String)markerInfo + "markerwindowcontent:" + HtmlAssembler.singleQuote(markerWindowContent) + ",";
                }
            } else {
                markerInfo = (String)markerInfo + "showmarkerwindow:false,";
            }
            markerInfo = (String)markerInfo + "tip: " + (marker.getTip() == null ? HtmlAssembler.singleQuote("") : HtmlAssembler.singleQuote(marker.getTip()));
            markerInfo = (String)markerInfo + "}";
            if (isFirstMarker) {
                isFirstMarker = false;
            } else {
                info = (String)info + ",";
            }
            info = (String)info + (String)markerInfo;
        }
        info = (String)info + "]";
        return info;
    }

    private void validateAttribute() {
        if (this.centerAddress == null && (this.centerLatitude == null || this.centerLongitude == null)) {
            throw new RequiredAttributeException();
        }
        if (this.centerAddress != null && (this.centerLatitude != null || this.centerLongitude != null)) {
            throw new InvalidAttributeCombinationException();
        }
        if (this.centerAddress != null && this.centerAddress.trim().length() == 0) {
            throw new EmptyCenterAddressException(this.centerAddress);
        }
        if (!MAP_TYPES.contains(this.type.toUpperCase())) {
            throw new InvalidMapTypeException(this.type, MAP_TYPES);
        }
        if (!ZOOM_CONTROL_TYPES.contains(this.zoomControl.toUpperCase())) {
            throw new InvalidZoomControlTypeException(this.zoomControl, ZOOM_CONTROL_TYPES);
        }
        if (!MAP_CONTROL_TYPES.contains(this.typeControl.toUpperCase())) {
            throw new InvalidTypeControlException(this.typeControl, MAP_CONTROL_TYPES);
        }
        if (this.height != null) {
            this.height = this.checkHeightAndWidth(this.height);
        }
        if (this.width != null) {
            this.width = this.checkHeightAndWidth(this.width);
        }
        if (this.hideBorder && (this.collapsible || this.title != null)) {
            throw new InvalidHideBorderException(this.collapsible, this.title);
        }
        if (this.markerColor != null && this.markerIcon != null) {
            throw new InvalidMarkerColorAndIconException();
        }
        if (this.markerColor != null) {
            if (AjaxUtils.checkHexaColorFormat(this.markerColor)) {
                this.markerColor = "#" + this.markerColor;
            } else {
                throw new InvalidMarkerColorFormatException();
            }
        }
        if (this.markerBind != null && this.markerWindowContent != null) {
            throw new InvalidMarkerBindAndTextException();
        }
        if (this.markerBind != null && this.name == null) {
            throw new NameAttributeRequiredForBind();
        }
        if (this.centerLatitude != null || this.centerLongitude != null) {
            float latitude = Float.parseFloat(this.centerLatitude);
            float longitude = Float.parseFloat(this.centerLongitude);
            if ((double)latitude < -90.0 || (double)latitude > 90.0) {
                throw new LatitudeOutOfRangeException(this.centerLatitude);
            }
            if ((double)longitude < -180.0 || (double)longitude > 180.0) {
                throw new LongitudeOutOfRangeException(this.centerLongitude);
            }
        }
    }

    public String checkHeightAndWidth(String size) {
        String sizeStr = size = size.trim();
        String sizeUnits = "px";
        double sizeDouble = 0.0;
        if (size.endsWith("pt") || size.endsWith("px")) {
            size = size.substring(0, size.length() - 2);
        }
        try {
            sizeDouble = Double.parseDouble(sizeStr);
        }
        catch (NumberFormatException nEx) {
            throw new InvalidHeightAndWidthException(size);
        }
        return "" + sizeDouble;
    }

    private void getGoogleMapLicenceKey() {
        String appName;
        ApplicationScope appScope;
        Map keyMap = AjaxImportTag.getParams();
        if (keyMap != null && keyMap.get(GOOGLE_MAP_KEY) != null) {
            this.key = (String)keyMap.get(GOOGLE_MAP_KEY);
            if (this.key != null) {
                return;
            }
        }
        if ((appScope = ApplicationScopeTracker.getApplicationScope(appName = FusionContext.getCurrent().getApplicationName())) != null) {
            Map settings = appScope.getApplicationSettingsMap();
            this.key = (String)settings.get(GOOGLE_MAP_KEY);
            if (this.key != null) {
                return;
            }
        }
        this.key = ServiceFactory.getRuntimeService().getGoogleMapKey();
        if (this.key == null || this.key.trim().length() == 0) {
            this.key = "";
        }
    }

    private String generateBindFunction() throws JspException {
        if (this.markerBind == null) {
            return null;
        }
        BindProcessor bindProcessor = new BindProcessor();
        bindProcessor.addBindToParam("_cf_marker_name", DATA_FN_PARAM_NAME);
        bindProcessor.addReservedWord(DATA_FN_PARAM_NAME);
        bindProcessor.addReservedWord(DATA_FN_PARAM_LATITUDE);
        bindProcessor.addReservedWord(DATA_FN_PARAM_LONGITUDE);
        bindProcessor.addReservedWord(DATA_FN_PARAM_ADDRESS);
        bindProcessor.setOutput(false);
        bindProcessor.setBindToFunction(true);
        bindProcessor.setErrorHandler(BIND_ERROR_HANDLER);
        bindProcessor.processBind(LOAD_STATUS_FN, "true", null, this.markerBind, false, this.htmlAssembler, -1, this.pageContext);
        if (bindProcessor.getBindType() != 2 && bindProcessor.getBindType() != 1 && bindProcessor.getBindType() != 3) {
            throw new InvalidBindTypeException();
        }
        bindProcessor.assembleImports(this.htmlAssembler);
        String bindFunction = this.htmlAssembler.openFunction(IMPORT_TAGNAME, STATUS_FN, true, true, DATA_FN_PARAMS);
        bindProcessor.generateDirectCall(this.htmlAssembler);
        this.htmlAssembler.closeFunction();
        this.htmlAssembler.newLine();
        return bindFunction;
    }

    @Override
    public void release() {
        this.type = MAP;
        this.height = null;
        this.name = null;
        this.zoomLevel = null;
        this.title = null;
        this.collapsible = false;
        this.width = null;
        this.hideBorder = true;
        this.scrollWheelZoom = true;
        this.doubleClickZoom = true;
        this.clickZoom = true;
        this.centerAddress = null;
        this.centerLatitude = null;
        this.centerLongitude = null;
        this.onLoad = null;
        this.showScale = false;
        this.continuousZoom = true;
        this.overview = false;
        this.typeControl = "basic";
        this.zoomControl = "small";
        this.key = null;
        this.tip = null;
        this.showAllMarkers = true;
        this.showCenterMarker = true;
        this.onError = null;
        this.markerColor = null;
        this.markerIcon = null;
        this.markerBind = null;
        this.markerWindowContent = null;
        this.showMarkerWindow = false;
        this.generatedBindFunctionName = null;
        this.showmarkerWindowHasSet = false;
        this.initShow = true;
        this.showUser = false;
        this.childShowUserSet = false;
    }

    static {
        MAP_TYPES.add("MAP");
        MAP_TYPES.add("SATELLITE");
        MAP_TYPES.add("HYBRID");
        MAP_TYPES.add("TERRAIN");
        MAP_TYPES.add("EARTH");
        ZOOM_CONTROL_TYPES = new ArrayList(5);
        ZOOM_CONTROL_TYPES.add("NONE");
        ZOOM_CONTROL_TYPES.add("SMALL");
        ZOOM_CONTROL_TYPES.add("LARGE");
        ZOOM_CONTROL_TYPES.add("LARGE3D");
        ZOOM_CONTROL_TYPES.add("SMALL3D");
        MAP_CONTROL_TYPES = new ArrayList(3);
        MAP_CONTROL_TYPES.add("NONE");
        MAP_CONTROL_TYPES.add("BASIC");
        MAP_CONTROL_TYPES.add("ADVANCED");
        GMAP_API_JS = "https://maps.googleapis.com/maps/api/js?sensor=false&key=";
        GOOGLEMAP_UTILY_JS = "/ext/map/mapiconmaker.js";
    }

    public class RequiredAttributeException
    extends TagValidationException {
    }

    public class InvalidAttributeCombinationException
    extends TagValidationException {
    }

    public class EmptyCenterAddressException
    extends TagValidationException {
        public String centerAddress;

        public EmptyCenterAddressException(String centerAddtress) {
            this.centerAddress = centerAddtress;
        }
    }

    public class InvalidMapTypeException
    extends TagValidationException {
        public String mapType;
        public String allowed;

        public InvalidMapTypeException(String mapType, List allowedList) {
            this.mapType = mapType;
            this.allowed = ArrayUtil.ArrayToList(allowedList, ",").toUpperCase();
        }
    }

    public class InvalidZoomControlTypeException
    extends TagValidationException {
        public String zoomControlType;
        public String allowed;

        public InvalidZoomControlTypeException(String zoomControlType, List allowedList) {
            this.zoomControlType = zoomControlType;
            this.allowed = ArrayUtil.ArrayToList(allowedList, ",").toUpperCase();
        }
    }

    public class InvalidTypeControlException
    extends TagValidationException {
        public String typeControl;
        public String allowed;

        public InvalidTypeControlException(String typeControl, List allowedList) {
            this.typeControl = typeControl;
            this.allowed = ArrayUtil.ArrayToList(allowedList, ",").toUpperCase();
        }
    }

    public class InvalidHideBorderException
    extends TagValidationException {
        public String title;
        public boolean collapsible;

        public InvalidHideBorderException(boolean collapsible, String title) {
            this.title = title;
            this.collapsible = collapsible;
        }
    }

    public class InvalidMarkerColorAndIconException
    extends TagValidationException {
    }

    public class InvalidMarkerColorFormatException
    extends TagValidationException {
    }

    public class InvalidMarkerBindAndTextException
    extends TagValidationException {
    }

    public class NameAttributeRequiredForBind
    extends TagValidationException {
    }

    public class LatitudeOutOfRangeException
    extends TagValidationException {
        public String latitude;

        public LatitudeOutOfRangeException(String latitude) {
            this.latitude = latitude;
        }
    }

    public class LongitudeOutOfRangeException
    extends TagValidationException {
        public String longitude;

        public LongitudeOutOfRangeException(String longitude) {
            this.longitude = longitude;
        }
    }

    public class InvalidHeightAndWidthException
    extends TagValidationException {
        public String size;

        public InvalidHeightAndWidthException(String size) {
            this.size = size;
        }
    }

    public static class InvalidBindTypeException
    extends ApplicationException {
    }

    public static class GoogleMapKeyException
    extends TagValidationException {
    }
}

