/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MessageBoxTag
extends GenericTag
implements AjaxImport {
    public static final String IMPORT_TAGNAME = "CFMESSAGEBOX";
    private String callbackHandler = null;
    private String labelOk = null;
    private String labelNo = null;
    private String labelCancel = null;
    private String labelYes = null;
    private String message = null;
    private boolean multiline = false;
    private String name = null;
    private String title = null;
    private String type = null;
    private String buttonType = null;
    private boolean modal = true;
    private String icon = null;
    private int width = 0;
    private int x = -1;
    private int y = -1;
    private String bodyStyle = null;
    private static List buttonTypetAllowedValues = new ArrayList();
    private static List messageboxTypetAllowedValues = new ArrayList();
    private static List messageIconAllowedValues = new ArrayList();
    private HtmlAssembler htmlAssembler;
    private static final String MESSAGEBOX = "messagebox";
    private static final String CFMESSAGEBOX = "cf_messagebox";
    private static final String MESSAGEBOXINIT = "ColdFusion.MessageBox.init(";

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(String callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public String getLabelOk() {
        return this.labelOk;
    }

    public void setLabelOk(String labelOk) {
        this.labelOk = labelOk;
    }

    public String getLabelNo() {
        return this.labelNo;
    }

    public void setLabelNo(String labelNO) {
        this.labelNo = labelNO;
    }

    public String getLabelYes() {
        return this.labelYes;
    }

    public void setLabelYes(String labelYes) {
        this.labelYes = labelYes;
    }

    public String getLabelCancel() {
        return this.labelCancel;
    }

    public void setLabelCancel(String labelCancel) {
        this.labelCancel = labelCancel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type.trim();
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(String buttonType) {
        this.buttonType = buttonType.trim();
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon.trim();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getBodyStyle() {
        return this.bodyStyle;
    }

    public void setBodyStyle(String bodyStyle) {
        this.bodyStyle = bodyStyle;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/yui/yahoo-dom-event/yahoo-dom-event.js");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/yui/animation/animation-min.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/package/cfmessagebox.js");
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.validateAttribute();
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("var ");
        String functionName = this.htmlAssembler.openFunction(MESSAGEBOX, "init", true, true, null);
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(MESSAGEBOX);
        this.htmlAssembler.appendContent("=");
        this.htmlAssembler.appendContent(MESSAGEBOXINIT).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(this.type, true).appendContent(',').appendContent(this.message, true).appendContent(',').appendContent(this.title == null ? "null" : HtmlAssembler.singleQuote(this.title)).appendContent(',').appendContent(this.labelOk == null ? "null" : HtmlAssembler.singleQuote(this.labelOk)).appendContent(',').appendContent(this.labelNo == null ? "null" : HtmlAssembler.singleQuote(this.labelNo)).appendContent(',').appendContent(this.labelCancel == null ? "null" : HtmlAssembler.singleQuote(this.labelCancel)).appendContent(',').appendContent(this.labelYes == null ? "null" : HtmlAssembler.singleQuote(this.labelYes)).appendContent(',').appendContent(this.multiline ? "true" : "false").appendContent(',').appendContent(this.modal ? "true" : "false").appendContent(',').appendContent(this.callbackHandler == null ? "null" : this.callbackHandler).appendContent(',').appendContent(this.icon == null ? "null" : HtmlAssembler.singleQuote(this.icon)).appendContent(',').appendContent((String)(this.width <= 0 ? "null" : "" + this.width)).appendContent(',').appendContent((String)(this.x < 0 ? "null" : "" + this.x)).appendContent(',').appendContent((String)(this.y < 0 ? "null" : "" + this.y)).appendContent(',').appendContent(this.buttonType == null ? "null" : HtmlAssembler.singleQuote(this.buttonType)).appendContent(',').appendContent(this.bodyStyle == null ? "null" : HtmlAssembler.singleQuote(this.bodyStyle)).appendContent(");");
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.closeScriptTag();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    private void validateAttribute() {
        if (!this.type.equalsIgnoreCase("CONFIRM") && this.buttonType != null) {
            throw new InvalidButtonTypeAttributeException(this.type);
        }
        if (this.buttonType != null && !buttonTypetAllowedValues.contains(this.buttonType.toUpperCase())) {
            throw new InvalidButtonTypeValueException(this.buttonType, buttonTypetAllowedValues);
        }
        if (this.type == null || this.type.trim().length() == 0) {
            throw new EmptyTypeAndNameException("type");
        }
        if (this.name == null || this.name.trim().length() == 0) {
            throw new EmptyTypeAndNameException("name");
        }
        if (!messageboxTypetAllowedValues.contains(this.type.toUpperCase())) {
            throw new InvalidMessageTypeException(this.type, messageboxTypetAllowedValues);
        }
        if (this.icon != null && !messageIconAllowedValues.contains(this.icon.toUpperCase())) {
            throw new InvalidMessageIconException(this.icon, messageIconAllowedValues);
        }
        if (this.callbackHandler != null && this.callbackHandler.trim().length() == 0) {
            throw new InvalidCallbackHandlerException();
        }
    }

    @Override
    public void release() {
        this.name = null;
        this.multiline = true;
        this.callbackHandler = null;
        this.labelOk = null;
        this.labelNo = null;
        this.labelCancel = null;
        this.labelYes = null;
        this.message = null;
        this.type = null;
        this.title = null;
        this.modal = true;
        this.buttonType = null;
        this.icon = null;
        this.width = 0;
        this.x = -1;
        this.y = -1;
        this.bodyStyle = null;
    }

    static {
        buttonTypetAllowedValues.add("YESNO");
        buttonTypetAllowedValues.add("YESNOCANCEL");
        messageboxTypetAllowedValues.add("ALERT");
        messageboxTypetAllowedValues.add("CONFIRM");
        messageboxTypetAllowedValues.add("PROMPT");
        messageIconAllowedValues.add("ERROR");
        messageIconAllowedValues.add("INFO");
        messageIconAllowedValues.add("QUESTION");
        messageIconAllowedValues.add("WARNING");
    }

    public class InvalidButtonTypeAttributeException
    extends TagValidationException {
        public String type;

        public InvalidButtonTypeAttributeException(String buttonType) {
            this.type = buttonType;
        }
    }

    public class InvalidButtonTypeValueException
    extends TagValidationException {
        public String type;
        public String allowed;

        public InvalidButtonTypeValueException(String buttonType, Collection allowedCollection) {
            this.type = buttonType;
            this.allowed = ArrayUtil.ArrayToList(new ArrayList(allowedCollection), ",").toUpperCase();
        }
    }

    public class EmptyTypeAndNameException
    extends TagValidationException {
        public String attributeName;

        public EmptyTypeAndNameException(String attributeName) {
            this.attributeName = attributeName;
        }
    }

    public class InvalidMessageTypeException
    extends TagValidationException {
        public String type;
        public String allowed;

        public InvalidMessageTypeException(String type, Collection allowedCollection) {
            this.type = type;
            this.allowed = ArrayUtil.ArrayToList(new ArrayList(allowedCollection), ",").toUpperCase();
        }
    }

    public class InvalidMessageIconException
    extends TagValidationException {
        public String type;
        public String allowed;

        public InvalidMessageIconException(String type, Collection allowedCollection) {
            this.type = type;
            this.allowed = ArrayUtil.ArrayToList(new ArrayList(allowedCollection), ",").toUpperCase();
        }
    }

    public class InvalidCallbackHandlerException
    extends TagValidationException {
    }
}

