/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.form.TextareaTag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RichTextEditorHelper
implements AjaxImport {
    public static final String IMPORT_TAGNAME = "CFTEXTAREA";
    private static final String RICHTEXT_TYPE = "richtext";
    private static final String INIT_RICHTEXT_FUNC = "ColdFusion.RichText.initialize(";
    private static final String BASE_CKEDITOR_PATH = "/ckeditor/";
    private static String CUSTOM_BASEPATH = null;

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importJS("/package/cfajax.js");
        if (CUSTOM_BASEPATH == null) {
            htmlAssembler.importJS("/ckeditor/ckeditor.js");
        } else {
            htmlAssembler.importJS(CUSTOM_BASEPATH + "ckeditor.js", null, false, true);
        }
        htmlAssembler.importJS("/package/cfrichtexteditor.js");
    }

    public static void setUpRichTextEditor(String id, String name, TextareaTag textareatag, PageContext pageContext, Map props) throws IOException {
        String fontformats;
        String fontSizes;
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(pageContext, true);
        Object basePath = textareatag.getBasePath();
        if (basePath != null) {
            if (((String)basePath).charAt(((String)basePath).length() - 1) != '/') {
                basePath = (String)basePath + "/";
            }
            CUSTOM_BASEPATH = basePath;
        } else {
            CUSTOM_BASEPATH = null;
            basePath = htmlAssembler.getImportAjaxPath() + BASE_CKEDITOR_PATH;
        }
        AjaxImportTag.generateImports(IMPORT_TAGNAME, htmlAssembler);
        htmlAssembler.openScriptTag();
        String initFunction = htmlAssembler.openFunction(RICHTEXT_TYPE, "init", true, true, null);
        String value = "";
        if (textareatag.getValue() != null) {
            value = textareatag.getValue();
            Pattern pattern = Pattern.compile("(\r\n|\r|\n|\n\r)");
            Matcher m = pattern.matcher(value);
            if (m.find()) {
                value = m.replaceAll("<br>");
            }
        }
        String width = (String)props.get("width");
        String height = (String)props.get("height");
        String fontNames = textareatag.getFontnames();
        if (fontNames != null) {
            fontNames = fontNames.replaceAll(",", ";");
        }
        if ((fontSizes = textareatag.getFontsizes()) != null) {
            fontSizes = fontSizes.replaceAll(",", ";");
        }
        if ((fontformats = textareatag.getFontformats()) != null) {
            fontformats = fontformats.replaceAll(",", ";");
        }
        String skin = textareatag.getSkin();
        boolean toolbaronfocus = textareatag.getToolbaronfocus();
        String toolbar = textareatag.getToolbar();
        if (toolbar != null) {
            htmlAssembler.newLine();
            toolbar = toolbar.trim();
        }
        String stylesXml = textareatag.getStylesxml();
        String templatesXml = textareatag.getTemplatesxml();
        CFLocaleMgr cflocaleMgr = CFLocaleMgr.getMgr();
        boolean isResponseLocaleSet = cflocaleMgr.isResponseLocaleSet(pageContext);
        Locale locale = null;
        if (isResponseLocaleSet) {
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            locale = response.getLocale();
        } else {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            locale = request.getLocale();
        }
        htmlAssembler.newLine();
        htmlAssembler.appendContent(INIT_RICHTEXT_FUNC).appendContent(HtmlAssembler.singleQuote(id)).appendContent(',').appendContent(" ").appendContent(HtmlAssembler.singleQuote(name)).appendContent(',').appendContent(" ").appendContent(HtmlAssembler.singleQuote(value)).appendContent(',').appendContent(" ").appendContent(HtmlAssembler.singleQuote((String)basePath)).appendContent(',').appendContent(" ");
        if (width != null) {
            htmlAssembler.appendContent(width);
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        if (height != null) {
            htmlAssembler.appendContent(height);
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        if (fontNames != null && !fontNames.trim().equals("")) {
            htmlAssembler.appendContent(HtmlAssembler.singleQuote(fontNames));
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        if (fontSizes != null && !fontSizes.trim().equals("")) {
            htmlAssembler.appendContent(HtmlAssembler.singleQuote(fontSizes));
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        if (fontformats != null && !fontformats.trim().equals("")) {
            htmlAssembler.appendContent(HtmlAssembler.singleQuote(fontformats));
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        if (skin != null) {
            htmlAssembler.appendContent(HtmlAssembler.singleQuote(skin));
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        htmlAssembler.appendContent(toolbaronfocus);
        htmlAssembler.appendContent(',').appendContent(" ");
        if (toolbar != null) {
            htmlAssembler.appendContent(HtmlAssembler.singleQuote(toolbar));
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        if (stylesXml != null) {
            htmlAssembler.appendContent(HtmlAssembler.singleQuote(htmlAssembler.getContextPath() + stylesXml));
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        if (templatesXml != null) {
            htmlAssembler.appendContent(HtmlAssembler.singleQuote(htmlAssembler.getContextPath() + templatesXml));
        } else {
            htmlAssembler.appendContent("null");
        }
        htmlAssembler.appendContent(',').appendContent(" ");
        htmlAssembler.appendContent(HtmlAssembler.singleQuote(locale.getLanguage()));
        htmlAssembler.appendContent(");");
        htmlAssembler.closeFunction();
        htmlAssembler.setEventOnLoad(initFunction);
        htmlAssembler.closeScriptTag();
        JspWriter out = pageContext.getOut();
        htmlAssembler.writeHead(out);
        htmlAssembler.writeHtml(out);
    }
}

