/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.RetirementUtils;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.io.IOException;
import java.util.ArrayList;

public class TooltipTag
extends GenericTag
implements BodyTag,
AjaxImport {
    public static final String IMPORT_TAGNAME = "CFTOOLTIP";
    String tooltip;
    String sourcefortooltip;
    int autodismissdelay = 5000;
    int showdelay = 200;
    int hidedelay = 250;
    boolean preventoverlap = true;
    HtmlAssembler htmlAssembler = null;
    String style = null;
    private static final int DEFAULT_SHOWDELAY = 200;
    private static final int DEFAULT_HIDEDELAY = 250;
    private static final int DEFAULT_AUTODISMISSDELAY = 5000;
    private static final String TOOLTIPNAME_PREFIX = "cf_tooltip_";

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void setSourcefortooltip(String tooltipsource) {
        this.sourcefortooltip = tooltipsource;
    }

    public void setAutodismissdelay(int autodismissdelay) {
        this.autodismissdelay = autodismissdelay;
    }

    public void setHidedelay(int hidedelay) {
        this.hidedelay = hidedelay;
    }

    public void setPreventoverlap(boolean preventoverlap) {
        this.preventoverlap = preventoverlap;
    }

    public void setShowdelay(int showdelay) {
        this.showdelay = showdelay;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/yui/yui.css");
        htmlAssembler.importJS("/yui/yahoo-dom-event/yahoo-dom-event.js");
        htmlAssembler.importJS("/yui/container/container-min.js");
        htmlAssembler.importJS("/yui/animation/animation-min.js");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/package/cftooltip.js");
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        if (RetirementUtils.isYUISupported()) {
            String name = TOOLTIPNAME_PREFIX + this.htmlAssembler.getId();
            if (this.tooltip != null || this.sourcefortooltip != null) {
                TooltipTag.setUpTooltip(this.htmlAssembler, name, this.tooltip, this.sourcefortooltip, this.out, this.hidedelay, this.showdelay, this.autodismissdelay, this.preventoverlap, this.style);
            }
            this.htmlAssembler.openSpanTag(name, null, null);
            this.htmlAssembler.newLine();
        }
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1;
    }

    public static void setUpTooltip(HtmlAssembler htmlAssembler, String id, String tooltip, String tooltipsource, JspWriter out, int hidedelay, int showdelay, int autodismissdelay, boolean preventoverlap) {
        TooltipTag.setUpTooltip(htmlAssembler, id, tooltip, tooltipsource, out, hidedelay, showdelay, autodismissdelay, preventoverlap, null);
    }

    public static void setUpTooltip(HtmlAssembler htmlAssembler, String id, String tooltip, String tooltipsource, JspWriter out, int hidedelay, int showdelay, int autodismissdelay, boolean preventoverlap, String style) {
        AjaxImportTag.generateImports(IMPORT_TAGNAME, htmlAssembler);
        htmlAssembler.openScriptTag();
        htmlAssembler.newLine();
        int hidedelayvalue = 250;
        int showdelayvalue = 200;
        int autodismissdelayvalue = 5000;
        boolean preventoverlapvalue = true;
        if (hidedelay != -1) {
            hidedelayvalue = hidedelay;
        }
        if (showdelay != -1) {
            showdelayvalue = showdelay;
        }
        if (autodismissdelay != -1) {
            autodismissdelayvalue = autodismissdelay;
        }
        preventoverlapvalue = preventoverlap;
        ArrayList<String> paramsList = new ArrayList<String>();
        ArrayList<String> paramsNamesList = new ArrayList<String>();
        if (tooltipsource != null) {
            paramsList.add(HtmlAssembler.doubleQuote(tooltipsource.toString()));
            paramsNamesList.add("_cf_url");
        }
        paramsList.add(HtmlAssembler.doubleQuote(""));
        paramsNamesList.add("_cf_query");
        paramsList.add(HtmlAssembler.doubleQuote(id));
        paramsNamesList.add("context");
        paramsList.add(new Integer(hidedelayvalue).toString());
        paramsNamesList.add("hidedelay");
        paramsList.add(new Integer(showdelayvalue).toString());
        paramsNamesList.add("showdelay");
        paramsList.add(new Integer(autodismissdelayvalue).toString());
        paramsNamesList.add("autodismissdelay");
        paramsList.add(HtmlAssembler.doubleQuote(new Boolean(preventoverlapvalue).toString()));
        paramsNamesList.add("preventoverlap");
        if (tooltipsource == null && tooltip != null) {
            paramsList.add(HtmlAssembler.singleQuote(tooltip));
            paramsNamesList.add("text");
        }
        if (style != null) {
            paramsList.add(HtmlAssembler.doubleQuote(style));
            paramsNamesList.add("style");
        }
        String[] params = paramsList.toArray(new String[0]);
        String[] paramsNames = paramsNamesList.toArray(new String[0]);
        htmlAssembler.setEvent(id, true, "mouseover", "ColdFusion.Tooltip.getToolTip", paramsNames, params);
        htmlAssembler.closeScriptTag();
        htmlAssembler.writeHead(out);
    }

    @Override
    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        if (RetirementUtils.isYUISupported()) {
            this.htmlAssembler.closeSpanTag();
        }
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.tooltip = null;
        this.sourcefortooltip = null;
        this.autodismissdelay = 5000;
        this.showdelay = 200;
        this.hidedelay = 250;
        this.preventoverlap = true;
        this.htmlAssembler = null;
        this.style = null;
        super.release();
    }
}

