/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.ajax;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.server.felix.FelixUtil;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.OutputException;
import coldfusion.tagext.html.ajax.AjaxContainer;
import coldfusion.tagext.html.ajax.AjaxImport;
import coldfusion.tagext.html.ajax.AjaxImportTag;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.LayoutAreaTag;
import coldfusion.tagext.html.ajax.LayoutTag;
import coldfusion.tagext.html.form.FormTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.IOException;

public class WindowTag
extends GenericTag
implements BodyTag,
AjaxContainer,
AjaxImport {
    public static final String IMPORT_TAGNAME = "CFWINDOW";
    private String name;
    private int height = 300;
    private int width = 500;
    private boolean initshow = false;
    private int minheight = 0;
    private int minwidth = 0;
    private String source;
    private String onBindError;
    private String bodystyle;
    private String headerstyle;
    private String title;
    private boolean modal = false;
    private boolean closable = true;
    private boolean draggable = true;
    private boolean resizable = true;
    private boolean center = false;
    private int x = -1;
    private int y = -1;
    private boolean refreshOnShow = false;
    private String windowId;
    private boolean minwidthpresent = false;
    private boolean minheightpresent = false;
    private String bodyname;
    private boolean childLayoutPresent = false;
    private String childLayoutId;
    private boolean destroyOnClose = false;
    HtmlAssembler htmlAssembler;
    public static final String CFYUIDLGCLASS = "x-hidden";
    public static final String CFYUIDLGHEADER = "x-window-header";
    public static final String CFYUIDLGBODY = "x-window-body";
    public static final String WINDOW = "window";
    public static final String TITLE_SUFFIX = "_title";
    public static final String BODY_SUFFIX = "-body";
    private static final String WINDOWCREATEFUNC = "ColdFusion.Window.create(";
    private static final String WINDOWNAME_PREFIX = "cf_window";
    private static final String CENTERLAYOUTDLG = ", center:{ autoscroll:true }";
    private static final String REFRESHONSHOW = "_cf_refreshOnShow";

    public void setName(String name) {
        this.name = name;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setInitshow(boolean initshow) {
        this.initshow = initshow;
    }

    public void setMinheight(int minheight) {
        this.minheight = minheight;
        this.minheightpresent = true;
    }

    public void setMinwidth(int minwidth) {
        this.minwidth = minwidth;
        this.minwidthpresent = true;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setOnBindError(String onBindError) {
        this.onBindError = onBindError;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setBodystyle(String bodystyle) {
        this.bodystyle = bodystyle;
    }

    public void setHeaderstyle(String headerstyle) {
        this.headerstyle = headerstyle;
    }

    public void setRefreshOnShow(boolean refreshOnShow) {
        this.refreshOnShow = refreshOnShow;
    }

    public boolean isDestroyOnClose() {
        return this.destroyOnClose;
    }

    public void setDestroyOnClose(boolean destroyOnClose) {
        this.destroyOnClose = destroyOnClose;
    }

    public void setChildLayoutId(String childLayoutId) {
        this.childLayoutId = childLayoutId;
    }

    public void setChildLayoutPresent(boolean childLayoutPresent) {
        this.childLayoutPresent = childLayoutPresent;
    }

    private void checkIfChild() {
        for (Tag t = this.getParent(); t != null; t = t.getParent()) {
            if (t instanceof FormTag) {
                throw new LayoutTag.InvalidParentTagException(IMPORT_TAGNAME, "CFFORM");
            }
            if (t instanceof LayoutAreaTag) {
                throw new LayoutTag.InvalidParentTagException(IMPORT_TAGNAME, "CFLAYOUTAREA");
            }
            if (!(t instanceof LayoutTag)) continue;
            throw new LayoutTag.InvalidParentTagException(IMPORT_TAGNAME, "CFLAYOUT");
        }
    }

    private void validateAttributes() {
        if (!this.resizable && (this.minheightpresent || this.minwidthpresent)) {
            throw new WindowTagInvalidAttributesException();
        }
        if (this.minheightpresent && this.minheight > this.height) {
            throw new WindowTagInvalidHeightException();
        }
        if (this.minwidthpresent && this.minwidth > this.width) {
            throw new WindowTagInvalidWidthException();
        }
        if (this.refreshOnShow && this.source == null) {
            throw new WindowTagInvalidRefreshOnShowException();
        }
    }

    @Override
    public void generateImports(String tagName, HtmlAssembler htmlAssembler) {
        htmlAssembler.setAjaxComponent(true);
        htmlAssembler.importStylesheet("/resources/ext/css/ext-all.css");
        htmlAssembler.importStylesheet("/resources/cf/cf.css");
        htmlAssembler.importJS("/package/cfajax.js");
        htmlAssembler.importJS("/ext/ext-all.js");
        htmlAssembler.importJS("/package/cfwindow.js");
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        FelixUtil.checkAjaxEnabled();
        this.htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
        this.windowId = WINDOWNAME_PREFIX + this.htmlAssembler.getId();
        if (this.name == null) {
            this.name = this.windowId;
        }
        this.htmlAssembler.setContainerId(this.name + BODY_SUFFIX);
        AjaxImportTag.generateImports(IMPORT_TAGNAME, this.htmlAssembler);
        this.checkIfChild();
        this.validateAttributes();
        String classname = null;
        classname = CFYUIDLGCLASS;
        this.htmlAssembler.openDivTag(this.windowId, classname, null);
        this.htmlAssembler.newLine();
        classname = CFYUIDLGHEADER;
        this.bodyname = this.name + BODY_SUFFIX;
        this.htmlAssembler.newLine();
        classname = "";
        this.htmlAssembler.openDivTag(this.bodyname, classname, this.bodystyle + ";height:100%");
        this.htmlAssembler.newLine();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1;
    }

    @Override
    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        this.htmlAssembler.closeDivTag();
        this.htmlAssembler.closeDivTag();
        this.htmlAssembler.openScriptTag();
        this.htmlAssembler.appendContent("Ext.onReady(function(){");
        this.htmlAssembler.appendContent("var ");
        String functionName = this.htmlAssembler.openFunction(WINDOW, "init", true, true, null);
        if (this.childLayoutPresent && this.source != null) {
            this.childLayoutPresent = false;
        }
        if (this.source != null) {
            BindProcessor bp = new BindProcessor();
            bp.setErrorHandler(this.onBindError);
            bp.processBind(this.bodyname, null, null, this.source, false, this.htmlAssembler, 3, this.pageContext);
        }
        this.htmlAssembler.appendContent("var ").appendContent("_cf_").appendContent(WINDOW);
        this.htmlAssembler.appendContent("=");
        this.htmlAssembler.appendContent(WINDOWCREATEFUNC).appendContent(HtmlAssembler.singleQuote(this.name)).appendContent(',').appendContent(HtmlAssembler.singleQuote(this.title)).appendContent(',').appendContent(HtmlAssembler.singleQuote(this.source));
        this.htmlAssembler.appendContent(',');
        this.htmlAssembler.appendContent('{');
        this.htmlAssembler.appendContent(" ").appendContent("modal").appendContent(":").appendContent(new Boolean(this.modal).toString());
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("closable").appendContent(":").appendContent(new Boolean(this.closable).toString());
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("divid").appendContent(":").appendContent(HtmlAssembler.singleQuote(this.windowId));
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("draggable").appendContent(":").appendContent(new Boolean(this.draggable).toString());
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("resizable").appendContent(":").appendContent(new Boolean(this.resizable).toString());
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("fixedcenter").appendContent(":").appendContent(new Boolean(this.center).toString());
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("width").appendContent(":").appendContent(new Integer(this.width).toString());
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("height").appendContent(":").appendContent(new Integer(this.height).toString());
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("shadow").appendContent(":").appendContent("true");
        if (this.bodystyle != null) {
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("bodystyle").appendContent(":").appendContent(HtmlAssembler.singleQuote(this.bodystyle));
        }
        if (this.headerstyle != null) {
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("headerstyle").appendContent(":").appendContent(HtmlAssembler.singleQuote(this.headerstyle));
        }
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("callfromtag").appendContent(":").appendContent(true);
        if (this.resizable) {
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("minwidth").appendContent(":").appendContent(new Integer(this.minwidth).toString());
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("minheight").appendContent(":").appendContent(new Integer(this.minheight).toString());
        }
        if (this.initshow) {
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("initshow").appendContent(":").appendContent(true);
        } else {
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("initshow").appendContent(":").appendContent(false);
        }
        this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("destroyonclose").appendContent(":").appendContent(this.destroyOnClose ? "true" : "false");
        if (!this.center && this.x >= 0 && this.y >= 0) {
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("x").appendContent(":").appendContent(new Integer(this.x).toString());
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("y").appendContent(":").appendContent(new Integer(this.y).toString());
        }
        if (this.childLayoutPresent) {
            this.htmlAssembler.appendContent(CENTERLAYOUTDLG);
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent("childlayoutid").appendContent(":").appendContent(HtmlAssembler.singleQuote(this.childLayoutId));
        }
        if (this.refreshOnShow) {
            this.htmlAssembler.appendContent(',').appendContent(" ").appendContent(REFRESHONSHOW).appendContent(':').appendContent(true);
        }
        this.htmlAssembler.appendContent('}');
        this.htmlAssembler.appendContent(");");
        this.htmlAssembler.closeFunction();
        if (functionName != null) {
            this.htmlAssembler.setEventOnLoad(functionName);
        }
        this.htmlAssembler.appendContent("});");
        this.htmlAssembler.closeScriptTag();
        JspWriter out = this.pageContext.getOut();
        try {
            this.htmlAssembler.writeHead(out);
            this.htmlAssembler.writeHtml(out);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
        finally {
            this.htmlAssembler.resetContainerId();
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        this.name = null;
        this.height = 300;
        this.width = 500;
        this.initshow = false;
        this.minheight = 0;
        this.minwidth = 0;
        this.source = null;
        this.onBindError = null;
        this.bodystyle = null;
        this.headerstyle = null;
        this.title = null;
        this.modal = false;
        this.closable = true;
        this.draggable = true;
        this.resizable = true;
        this.center = false;
        this.x = -1;
        this.y = -1;
        this.refreshOnShow = false;
        this.windowId = null;
        this.minwidthpresent = false;
        this.minheightpresent = false;
        this.bodyname = null;
        this.childLayoutPresent = false;
        this.childLayoutId = null;
        this.destroyOnClose = false;
        this.htmlAssembler = null;
        super.release();
    }

    @Override
    public String getBodyId() {
        return this.bodyname;
    }

    public class WindowTagInvalidAttributesException
    extends TagValidationException {
        WindowTagInvalidAttributesException() {
        }
    }

    public class WindowTagInvalidHeightException
    extends TagValidationException {
        WindowTagInvalidHeightException() {
        }
    }

    public class WindowTagInvalidWidthException
    extends TagValidationException {
        WindowTagInvalidWidthException() {
        }
    }

    public class WindowTagInvalidRefreshOnShowException
    extends TagValidationException {
        WindowTagInvalidRefreshOnShowException() {
        }
    }
}

