/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.html.form;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Scope;
import coldfusion.tagext.html.ajax.AjaxUtils;
import coldfusion.tagext.html.ajax.BindProcessor;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import coldfusion.tagext.html.ajax.RichTextEditorHelper;
import coldfusion.tagext.html.ajax.TooltipTag;
import coldfusion.tagext.html.form.FormChildTag;
import coldfusion.tagext.html.form.FormTag;
import coldfusion.tagext.html.form.JavascriptHelper;
import coldfusion.tagext.html.form.TextareaTagData;
import coldfusion.tagext.validation.IllegalDuplicateAttributeException;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TextareaTag
extends FormChildTag
implements BodyTag {
    protected String onBlur;
    protected String onKeyPress;
    protected TextareaTagData tagData;
    protected String body;
    protected String tooltip;
    protected String sourcefortooltip;
    protected String fontnames;
    protected String fontformats;
    protected String fontsizes;
    protected boolean richtext = false;
    protected String basepath;
    protected String skin;
    protected String stylesxml;
    protected String templatesxml;
    protected String toolbar;
    protected boolean toolbaronfocus = false;
    protected String tagId;
    private boolean toolbaronfocusPresent = false;
    private static List textAreaNotAllowedAttributes = new ArrayList();
    private static List<String> PRE_DEFINED_SKINS = Arrays.asList("DEFAULT", "OFFICE2003", "SILVER", "MOONO");

    public TextareaTag() {
        super(FormTag.class);
        this.setType("textarea");
    }

    @Override
    public void setName(String s) {
        super.setName(s.trim());
    }

    @Override
    public void setLabel(String s) {
        super.setLabel(s);
    }

    @Override
    public void setValue(String s) {
        super.setValue(s);
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void setSourcefortooltip(String tooltipsource) {
        this.sourcefortooltip = tooltipsource;
    }

    @Override
    public void setRequired(boolean b) {
        super.setRequired(b);
    }

    @Override
    public void setMessage(String s) {
        super.setMessage(s);
    }

    @Override
    public void setPattern(String s) {
        super.setPattern(s);
    }

    @Override
    public void setRange(String s) {
        super.setRange(s);
    }

    @Override
    public void setValidate(String s) {
        super.setValidate(s);
    }

    @Override
    public void setValidateat(String s) {
        super.setValidateat(s);
    }

    @Override
    public void setOnError(String s) {
        super.setOnError(s);
    }

    @Override
    public void setOnValidate(String s) {
        super.setOnValidate(s);
    }

    @Override
    public void setMaxLength(int i) {
        super.setMaxLength(i);
    }

    public void setOnkeypress(String s) {
        this.onKeyPress = s;
    }

    @Override
    public void setBind(String s) {
        super.setBind(s);
    }

    @Override
    public void setOnBindError(String onBindError) {
        super.setOnBindError(onBindError);
    }

    @Override
    public void setBindOnLoad(boolean b) {
        super.setBindOnLoad(b);
    }

    @Override
    public void setBindAttribute(String a) {
        super.setBindAttribute(a);
    }

    public String getFontformats() {
        return this.fontformats;
    }

    public void setFontformats(String fontformats) {
        this.fontformats = fontformats;
    }

    public String getFontnames() {
        return this.fontnames;
    }

    public void setFontnames(String fontnames) {
        this.fontnames = fontnames;
    }

    public String getFontsizes() {
        return this.fontsizes;
    }

    public void setFontsizes(String fontsizes) {
        this.fontsizes = fontsizes;
    }

    public boolean isRichtext() {
        return this.richtext;
    }

    public void setRichtext(boolean richtext) {
        this.richtext = richtext;
        if (this.richtext) {
            this.setType("richtext");
        }
    }

    public String getBasePath() {
        return this.basepath;
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        if (skin != null && !PRE_DEFINED_SKINS.contains(skin.toUpperCase())) {
            this.skin = skin;
        }
    }

    public String getStylesxml() {
        return this.stylesxml;
    }

    public void setStylesxml(String stylesxml) {
        this.stylesxml = stylesxml;
    }

    public String getTemplatesxml() {
        return this.templatesxml;
    }

    public void setTemplatesxml(String templatesxml) {
        this.templatesxml = templatesxml;
    }

    public String getToolbar() {
        return this.toolbar;
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public boolean getToolbaronfocus() {
        return this.toolbaronfocus;
    }

    public void setToolbaronfocus(boolean toolbaronfocus) {
        this.toolbaronfocus = toolbaronfocus;
        this.toolbaronfocusPresent = true;
    }

    @Override
    public void setAttributecollection(Map o) {
        if (o.containsKey("ONBLUR")) {
            this.onBlur = o.get("ONBLUR").toString();
            o.remove("ONBLUR");
        }
        super.setAttributecollection(o);
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this._parent = this.findFormParent();
        this.tagData = new TextareaTagData(this);
        this._parent.addChild(this.tagData);
        this.validateAttributes();
        return 2;
    }

    private void validateAttributes() {
        if (!this.richtext) {
            if (this.fontnames != null) {
                throw new InvalidAttributeTextAreaException("FONTNAMES", textAreaNotAllowedAttributes);
            }
            if (this.fontsizes != null) {
                throw new InvalidAttributeTextAreaException("FONTSIZES", textAreaNotAllowedAttributes);
            }
            if (this.fontformats != null) {
                throw new InvalidAttributeTextAreaException("FONTFORMATS", textAreaNotAllowedAttributes);
            }
            if (this.skin != null) {
                throw new InvalidAttributeTextAreaException("SKIN", textAreaNotAllowedAttributes);
            }
            if (this.stylesxml != null) {
                throw new InvalidAttributeTextAreaException("SYLESXML", textAreaNotAllowedAttributes);
            }
            if (this.templatesxml != null) {
                throw new InvalidAttributeTextAreaException("TEMPLATESXML", textAreaNotAllowedAttributes);
            }
            if (this.toolbar != null) {
                throw new InvalidAttributeTextAreaException("TOOLBAR", textAreaNotAllowedAttributes);
            }
            if (this.toolbaronfocusPresent) {
                throw new InvalidAttributeTextAreaException("TOOLBARONFOCUS", textAreaNotAllowedAttributes);
            }
        } else {
            if (this.stylesxml != null && this.stylesxml.trim().equals("")) {
                throw new AjaxUtils.AjaxTagInvalidAttributeException("stylesxml", "CFTEXTAREA");
            }
            if (this.templatesxml != null && this.templatesxml.trim().equals("")) {
                throw new AjaxUtils.AjaxTagInvalidAttributeException("templatesxml", "CFTEXTAREA");
            }
            if (this.skin != null && this.skin.trim().equals("")) {
                throw new AjaxUtils.AjaxTagInvalidAttributeException("skin", "CFTEXTAREA");
            }
            if (this.basepath != null && this.basepath.trim().equals("")) {
                throw new AjaxUtils.AjaxTagInvalidAttributeException("basepath", "CFTEXTAREA");
            }
        }
    }

    @Override
    public int doAfterBody() throws JspException {
        Scope scope;
        BodyContent body = this.bodyContent;
        if (this.value != null && this.value.length() > 0 && body.getString().length() > 0) {
            throw new IllegalDuplicateAttributeException("CFTextArea", "Value", "");
        }
        if (body.getString().length() > 0) {
            String thisBody = body.getString();
            this.setValue(thisBody);
            this.tagData.value = thisBody;
            body.clearBody();
        }
        if (this._parentFormTag.preserveData && this._parentFormTag.preserveData && (scope = (Scope)((NeoPageContext)this.pageContext).SymTab_findBuiltinScope("FORM")).containsKey(this.name)) {
            String val = scope.get(this.name).toString();
            this.setValue(val);
            this.tagData.value = val;
        }
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        if (this._parentFormTag.format.equals("HTML")) {
            HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(this.pageContext, false);
            try {
                htmlAssembler.appendContent("<textarea name=\"" + this.name + "\" ");
                String richtextid = null;
                if (this.richtext) {
                    richtextid = "cf_textarea" + htmlAssembler.getId();
                    htmlAssembler.appendContent(" id=\"" + richtextid + "\" ");
                    this.props.remove("id");
                    this.tagId = richtextid;
                } else if (!this.props.containsKey("id")) {
                    htmlAssembler.appendContent(" id=\"" + this.name + "\" ");
                    this.tagId = this.name;
                } else {
                    this.tagId = Cast._String(this.props.get("id"));
                }
                Iterator keys = this.props.keySet().iterator();
                while (keys.hasNext()) {
                    String thisKey = String.valueOf(keys.next());
                    String thisValue = String.valueOf(this.props.get(thisKey));
                    if (thisValue.length() <= 0 || this.richtext && textAreaNotAllowedAttributes.contains(thisKey)) continue;
                    htmlAssembler.appendContent(thisKey.toLowerCase() + "=\"" + thisValue + "\" ");
                }
                if (this.validateAt_onBlur && this.maxLength > 0 && this.validate.indexOf("MAXLENGTH") != -1) {
                    String userOnKeyPress = this.onKeyPress != null ? this.onKeyPress : "";
                    htmlAssembler.appendContent("onKeyPress=\"return (window.event.keyCode != 8 && this.value.length >= " + this.maxLength + ") ? false : true; " + userOnKeyPress + "\" ");
                }
                String usersOnBlur = this.onBlur != null ? this.onBlur : "";
                if (this.validate != null && this.validateAt_onBlur && this.pattern != null && (this.min != null || this.max != null)) {
                    htmlAssembler.appendContent(" onBlur=\"" + usersOnBlur + JavascriptHelper.getOnBlur(this, this.validate, this.message, this.pattern, this.min.toString(), this.max.toString(), String.valueOf(this.maxLength), this.required) + "\"");
                } else if (this.validate != null && this.validateAt_onBlur && this.pattern != null) {
                    htmlAssembler.appendContent(" onBlur=\"" + usersOnBlur + JavascriptHelper.getOnBlur(this, this.validate, this.message, this.pattern, null, null, String.valueOf(this.maxLength), this.required) + "\"");
                } else if (this.validate != null && this.validateAt_onBlur && (this.min != null || this.max != null)) {
                    String thisMin = this.min == null ? "null" : this.min.toString();
                    String thisMax = this.max == null ? "null" : this.max.toString();
                    htmlAssembler.appendContent(" onBlur=\"" + usersOnBlur + JavascriptHelper.getOnBlur(this, this.validate, this.message, null, thisMin, thisMax, String.valueOf(this.maxLength), this.required) + "\"");
                } else if (this.validate != null && this.validateAt_onBlur) {
                    htmlAssembler.appendContent(" onBlur=\"" + usersOnBlur + JavascriptHelper.getOnBlur(this, this.validate, this.message, null, null, null, String.valueOf(this.maxLength), this.required) + "\"");
                } else if (this.onBlur != null) {
                    htmlAssembler.appendContent("onBlur=\"" + this.onBlur + "\" ");
                }
                htmlAssembler.appendContent(">");
                htmlAssembler.appendContent(this.value + "</textarea>");
                if (this.required) {
                    htmlAssembler.openScriptTag();
                    htmlAssembler.appendContent("if (window.ColdFusion) ColdFusion.required['" + this.tagId + "']=true;");
                    htmlAssembler.closeScriptTag();
                    htmlAssembler.writeHead(this.out);
                }
                String tagId = null;
                if (this.props.containsKey("id")) {
                    tagId = this.props.get("id").toString();
                }
                if (tagId == null) {
                    tagId = this.name;
                }
                if (this.tooltip != null || this.sourcefortooltip != null) {
                    htmlAssembler = HtmlAssembler.getInstance(this.pageContext, true);
                    JspWriter out = this.pageContext.getOut();
                    TooltipTag.setUpTooltip(htmlAssembler, tagId, this.tooltip, this.sourcefortooltip, out, -1, -1, -1, true);
                }
                if (this.bind != null) {
                    String parentId = this._parentFormTag.getIdAttribute();
                    if (parentId == null) {
                        parentId = this._parentFormTag.name;
                    }
                    BindProcessor bp = new BindProcessor();
                    bp.setErrorHandler(this.onBindError);
                    bp.processBind(tagId, this.bindAttribute, parentId, this.bind, this.bindOnLoad, htmlAssembler, -1, this.pageContext);
                }
                if (this.richtext) {
                    RichTextEditorHelper.setUpRichTextEditor(richtextid, this.name, this, this.pageContext, this.props);
                }
                htmlAssembler.writeHtml(this.out);
                htmlAssembler.writeHead(this.out);
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        super.doEndTag();
        this.setType("textarea");
        this.onBlur = null;
        this.onKeyPress = null;
        this.tagData = null;
        this.body = null;
        this.message = null;
        this.tooltip = null;
        this.sourcefortooltip = null;
        this.fontnames = null;
        this.fontformats = null;
        this.fontsizes = null;
        this.richtext = false;
        this.basepath = null;
        this.skin = null;
        this.stylesxml = null;
        this.templatesxml = null;
        this.toolbar = null;
        this.toolbaronfocus = false;
        this.toolbaronfocusPresent = false;
        this.tagId = null;
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        super.release();
    }

    static {
        textAreaNotAllowedAttributes.add("FONTNAMES");
        textAreaNotAllowedAttributes.add("FONTFORMATS");
        textAreaNotAllowedAttributes.add("FONTSIZES");
        textAreaNotAllowedAttributes.add("SKIN");
        textAreaNotAllowedAttributes.add("STYLESXML");
        textAreaNotAllowedAttributes.add("TEMPLATESXML");
        textAreaNotAllowedAttributes.add("TOOLBAR");
        textAreaNotAllowedAttributes.add("TOOLBARONFOCUS");
        textAreaNotAllowedAttributes.add("WIDTH");
        textAreaNotAllowedAttributes.add("HEIGHT");
    }

    public class InvalidAttributeTextAreaException
    extends TagValidationException {
        public String attrName;
        public String notAllowed;

        public InvalidAttributeTextAreaException(String attrName, List notAllowed) {
            this.attrName = attrName;
            this.notAllowed = ArrayUtil.ArrayToList(notAllowed, ",").toUpperCase();
        }
    }
}

