/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io;

import coldfusion.filter.FusionContext;
import coldfusion.graph.GraphException;
import coldfusion.graph.IChartSet;
import coldfusion.graph.InteractiveChartSet;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.html.ajax.HtmlAssembler;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ChartsetTag
extends GenericTag
implements BodyTag {
    private IChartSet iChartSet;
    private String layout;
    private String _format = "PNG";
    private String renderer;
    private boolean clientChart = false;
    private boolean _retIS = false;
    private String _name;
    private static volatile int serialID = 0;
    private static int MAX_COUNTER = 999999;
    public static final boolean systemIsBase64 = Boolean.valueOf(System.getProperty("coldfusion.chart.base64", "false"));
    private boolean isBase64 = systemIsBase64;
    private boolean isBase64AttrPresent = false;
    private String height = "-1";
    private String width = "-1";
    private String theme;
    private static List validChartFormatList = Arrays.asList("jpg", "png", "svg", "html");

    public ChartsetTag() {
        this.reset();
    }

    InteractiveChartSet getInteractiveChartSet() {
        if (this.iChartSet == null) {
            this.iChartSet = new InteractiveChartSet(++serialID);
        }
        return (InteractiveChartSet)this.iChartSet;
    }

    boolean isClientChart() {
        return this.clientChart;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public String getFormat() {
        return this._format;
    }

    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    public void setName(String name) {
        this._name = name;
    }

    private String getName() {
        return this._name;
    }

    public void setBase64(boolean isBase64) {
        this.isBase64AttrPresent = true;
        this.isBase64 = isBase64;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public int doStartTag() {
        this.onTagStart();
        this.validateFormat();
        ServiceFactory.getNewGraphingService(true);
        if (serialID >= MAX_COUNTER) {
            serialID = 1;
        }
        this.iChartSet = new InteractiveChartSet(++serialID);
        this.iChartSet.setServerSideChart(!this.clientChart);
        if (this._format != null) {
            this.iChartSet.setImageFormat(this._format);
        }
        if (this.layout != null) {
            this.iChartSet.setLayout(this.layout);
        }
        if (this.renderer != null) {
            this.iChartSet.setRenderer(this.renderer);
        }
        if (this.height != "-1") {
            this.iChartSet.setHeight(this.height);
        }
        if (this.width != "-1") {
            this.iChartSet.setWidth(this.width);
        }
        if (this.theme != null) {
            this.iChartSet.setTheme(this.theme);
        }
        HtmlAssembler htmlAssembler = HtmlAssembler.getInstance(this.pageContext, false);
        htmlAssembler.importJS("/package/cfajax.js");
        return 2;
    }

    public void validateFormat() {
        if (!validChartFormatList.contains(this._format.toLowerCase())) {
            throw new InvalidFormatException(this._format);
        }
        if (("png".equalsIgnoreCase(this._format) || "jpg".equalsIgnoreCase(this._format) || "svg".equalsIgnoreCase(this._format)) && this.renderer != null) {
            throw new InvalidFormatNRendererException(this._format, this.renderer);
        }
        if ("html".equalsIgnoreCase(this._format) && this.renderer != null && "flash".equalsIgnoreCase(this.renderer)) {
            throw new InvalidFormatNRendererException(this._format, this.renderer);
        }
        if ("html".equalsIgnoreCase(this._format) && this.isBase64AttrPresent) {
            throw new InvalidFormatAndIsBase64Exception(this._format);
        }
        if ("html".equalsIgnoreCase(this._format) || "flash".equalsIgnoreCase(this.renderer) || "flash".equalsIgnoreCase(this._format)) {
            this.clientChart = true;
        }
    }

    public int doEndTag() {
        if (this.out instanceof CFOutput) {
            ((CFOutput)this.out).cfoutput(true);
        }
        try {
            if (this.clientChart) {
                try {
                    String chartRenderer = ((InteractiveChartSet)this.iChartSet).chartRenderer();
                    this.out.print(chartRenderer);
                }
                catch (ApplicationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this.reset();
                this.onTagEnd();
                int ex = 6;
                return ex;
            }
            FusionContext fusionContext = this.getfContext();
            Object serverChartRenderer = ((InteractiveChartSet)this.iChartSet).serverChartRenderer(this.isBase64, this.getName(), this._retIS, (NeoPageContext)this.pageContext, this.request, this.getParent(), fusionContext);
            if (serverChartRenderer != null && serverChartRenderer != "") {
                this.out.print(serverChartRenderer);
            }
            this.reset();
            this.onTagEnd();
            int n = 6;
            return n;
        }
        catch (IOException e) {
            throw new GraphIOException((Throwable)e);
        }
        finally {
            if (this.out instanceof CFOutput) {
                ((CFOutput)this.out).cfoutput(false);
            }
        }
    }

    @Override
    public void release() {
        this.reset();
        super.release();
    }

    public void reset() {
        this._name = null;
        this.iChartSet = null;
        this.clientChart = false;
        this.isBase64 = systemIsBase64;
        this.isBase64AttrPresent = false;
        this.renderer = null;
        this.layout = null;
        this.height = "-1";
        this.width = "-1";
        this.theme = null;
    }

    public static class InvalidFormatException
    extends GraphException {
        private String format;

        public InvalidFormatException(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class InvalidFormatNRendererException
    extends GraphException {
        private String format;
        private String renderer;

        public InvalidFormatNRendererException(String format, String renderer) {
            this.format = format;
            this.renderer = renderer;
        }

        public String getFormat() {
            return this.format;
        }

        public String getRenderer() {
            return this.renderer;
        }
    }

    public static class InvalidFormatAndIsBase64Exception
    extends GraphException {
        private String format;

        public InvalidFormatAndIsBase64Exception(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public class GraphIOException
    extends NeoException {
        GraphIOException(Throwable th) {
            super(th);
        }
    }
}

