/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.io;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.StoreService;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.io.FileListTable;
import coldfusion.tagext.io.FileTag;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import jakarta.servlet.jsp.JspException;
import java.io.File;
import java.io.IOException;
import java.security.Permission;
import org.apache.commons.vfs2.FileObject;

public class DirectoryTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfdirectory");
    protected static final int DEF_MODE = -1;
    protected static final int TYPE_ALL = 0;
    protected static final int TYPE_DIR = 1;
    protected static final int TYPE_FILE = 2;
    protected String action = "List";
    protected String directory;
    protected String destination;
    protected String name;
    protected Object filter;
    protected int mode = -1;
    protected String sort;
    protected String newdirectory;
    protected boolean recurse = false;
    protected String listinfo;
    protected int type = 0;
    private boolean modePresent = false;
    private String storeLocation;
    private Object storeACL;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setAction(String o) {
        this.action = o;
    }

    public void setRecurse(boolean o) {
        this.recurse = o;
    }

    public String getAction() {
        return this.action;
    }

    public void setDirectory(String o) {
        this.directory = o;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setName(String o) {
        this.name = o;
    }

    public String getName() {
        return this.name;
    }

    public void setFilter(Object o) {
        this.filter = o;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setSort(String o) {
        this.sort = o;
    }

    public String getSort() {
        return this.sort;
    }

    public void setNewdirectory(String o) {
        this.newdirectory = o;
    }

    public String getNewdirectory() {
        return this.newdirectory;
    }

    public void setMode(int o) {
        this.modePresent = true;
        this.mode = o;
    }

    public int getMode() {
        return this.mode;
    }

    public void setListinfo(String str) {
        this.listinfo = str;
    }

    public String getListinfo() {
        return this.listinfo;
    }

    public void setType(String type) {
        if ("dir".equalsIgnoreCase(type)) {
            this.type = 1;
        } else if ("file".equalsIgnoreCase(type)) {
            this.type = 2;
        } else if ("all".equalsIgnoreCase(type)) {
            this.type = 0;
        } else {
            throw new InvalidTypeAttributeException(type);
        }
    }

    public void setStoreLocation(String storeLocation) {
        this.storeLocation = storeLocation;
    }

    public void setStoreACL(Object storeAcl) {
        this.storeACL = storeAcl;
    }

    @Override
    public void release() {
        this.action = "List";
        this.directory = null;
        this.destination = null;
        this.name = null;
        this.filter = null;
        this.mode = -1;
        this.sort = null;
        this.newdirectory = null;
        this.recurse = false;
        this.listinfo = null;
        this.type = 0;
        this.storeLocation = null;
        this.storeACL = null;
        super.release();
        this.onTagEnd();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (this.directory.length() == 2 && this.directory.charAt(1) == ':' && File.separatorChar == '\\') {
            this.directory = this.directory.concat(File.separator);
        }
        this.checkTimeout();
        this.validateAttributes(this.directory);
        if ("list".equalsIgnoreCase(this.action)) {
            String dirpath;
            File[] files;
            try {
                files = FileUtils.listFiles(this.directory, this.recurse, this.filter, this.sort);
            }
            catch (FileUtils.InvalidDirectoryException e) {
                files = new File[]{};
            }
            File f = new File(this.directory);
            try {
                dirpath = f.getAbsolutePath();
            }
            catch (Exception ex) {
                dirpath = this.directory;
            }
            FileListTable table = new FileListTable(dirpath, this.recurse);
            boolean listNamesOnly = "name".equalsIgnoreCase(this.listinfo);
            table.populate(files, listNamesOnly, this.type);
            this.pageContext.setAttribute(this.name, (Object)table);
        } else if ("create".equalsIgnoreCase(this.action)) {
            File dir = VFSFileFactory.getFileObject(this.directory);
            if (dir instanceof VFile) {
                StoreService storeService = ServiceFactory.getStoreService(false);
                VFile vfile = (VFile)dir;
                FileObject fileObject = vfile.getFileObject();
                if (storeService != null && storeService.isInstanceOfS3FileObject(fileObject)) {
                    this.createS3Bucket(vfile);
                } else {
                    FileUtils.createDirectory(this.directory);
                }
            } else {
                FileUtils.createDirectory(this.directory);
                try {
                    FileUtils.setUnixModes(this.directory, this.mode);
                }
                catch (IOException iOException) {}
            }
        } else if ("delete".equalsIgnoreCase(this.action)) {
            FileUtils.deleteDirectory(this.directory, this.recurse);
        } else if ("rename".equalsIgnoreCase(this.action)) {
            FileUtils.renameDirectory(this.directory, this.newdirectory);
        } else if ("copy".equalsIgnoreCase(this.action)) {
            FileUtils.verifyFile(this.directory);
            FileUtils.createDestination(this.destination);
            FileUtils.copyDirectory(this.recurse, this.filter, Utils.getFileFullPath(this.destination, this.pageContext), Utils.getFileFullPath(this.directory, this.pageContext));
        } else {
            throw new InvalidCFFileActionException(this.action);
        }
        return 0;
    }

    private void createS3Bucket(VFile vfile) {
        StoreService storeService = ServiceFactory.getStoreService(true);
        storeService.createBucket(vfile, this.storeLocation, this.storeACL);
    }

    private void validateAttributes(String path) {
        if (path != null && VFSFileFactory.checkIfVFile(path) && this.modePresent) {
            throw new FileTag.ModeNotSupportedException();
        }
    }

    public void checkTimeout() throws RequestTimedOutException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException(this.tagNameFromClass());
        }
    }

    public static class InvalidTypeAttributeException
    extends ApplicationException {
        public String value;

        public InvalidTypeAttributeException(String value) {
            this.value = value;
        }
    }

    public static class InvalidCFFileActionException
    extends ApplicationException {
        private String action;

        InvalidCFFileActionException(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }
}

